/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_10;

import io.fabric8.kubernetes.api.builder.v6_10.BaseFluent;
import io.fabric8.kubernetes.api.model.v6_10.NamespaceCondition;
import io.fabric8.openshift.api.model.v6_10.ProjectStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ProjectStatusFluent<A extends ProjectStatusFluent<A>>
extends BaseFluent<A> {
    private List<NamespaceCondition> conditions = new ArrayList<NamespaceCondition>();
    private String phase;
    private Map<String, Object> additionalProperties;

    public ProjectStatusFluent() {
    }

    public ProjectStatusFluent(ProjectStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ProjectStatus instance) {
        ProjectStatus projectStatus = instance = instance != null ? instance : new ProjectStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withPhase(instance.getPhase());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, NamespaceCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<NamespaceCondition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    public A setToConditions(int index, NamespaceCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<NamespaceCondition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    public A addToConditions(NamespaceCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<NamespaceCondition>();
        }
        for (NamespaceCondition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<NamespaceCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<NamespaceCondition>();
        }
        for (NamespaceCondition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A removeFromConditions(NamespaceCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (NamespaceCondition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<NamespaceCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (NamespaceCondition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public List<NamespaceCondition> getConditions() {
        return this.conditions;
    }

    public NamespaceCondition getCondition(int index) {
        return this.conditions.get(index);
    }

    public NamespaceCondition getFirstCondition() {
        return this.conditions.get(0);
    }

    public NamespaceCondition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public NamespaceCondition getMatchingCondition(Predicate<NamespaceCondition> predicate) {
        for (NamespaceCondition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<NamespaceCondition> predicate) {
        for (NamespaceCondition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<NamespaceCondition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<NamespaceCondition>();
            for (NamespaceCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(NamespaceCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (NamespaceCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new NamespaceCondition(lastTransitionTime, message, reason, status, type));
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase = phase;
        return (A)this;
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProjectStatusFluent that = (ProjectStatusFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.phase, that.phase)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.phase, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.phase != null) {
            sb.append("phase:");
            sb.append(this.phase + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

