/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_10;

import io.fabric8.kubernetes.api.builder.v6_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_10.Nested;
import io.fabric8.kubernetes.api.model.v6_10.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.v6_10.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.v6_10.PodTemplateSpecFluent;
import io.fabric8.openshift.api.model.v6_10.PodSecurityPolicySubjectReviewSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PodSecurityPolicySubjectReviewSpecFluent<A extends PodSecurityPolicySubjectReviewSpecFluent<A>>
extends BaseFluent<A> {
    private List<String> groups = new ArrayList<String>();
    private PodTemplateSpecBuilder template;
    private String user;
    private Map<String, Object> additionalProperties;

    public PodSecurityPolicySubjectReviewSpecFluent() {
    }

    public PodSecurityPolicySubjectReviewSpecFluent(PodSecurityPolicySubjectReviewSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PodSecurityPolicySubjectReviewSpec instance) {
        PodSecurityPolicySubjectReviewSpec podSecurityPolicySubjectReviewSpec = instance = instance != null ? instance : new PodSecurityPolicySubjectReviewSpec();
        if (instance != null) {
            this.withGroups(instance.getGroups());
            this.withTemplate(instance.getTemplate());
            this.withUser(instance.getUser());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToGroups(int index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(index, item);
        return (A)this;
    }

    public A setToGroups(int index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.set(index, item);
        return (A)this;
    }

    public A addToGroups(String ... items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    public A addAllToGroups(Collection<String> items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    public A removeFromGroups(String ... items) {
        if (this.groups == null) {
            return (A)this;
        }
        for (String item : items) {
            this.groups.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromGroups(Collection<String> items) {
        if (this.groups == null) {
            return (A)this;
        }
        for (String item : items) {
            this.groups.remove(item);
        }
        return (A)this;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public String getGroup(int index) {
        return this.groups.get(index);
    }

    public String getFirstGroup() {
        return this.groups.get(0);
    }

    public String getLastGroup() {
        return this.groups.get(this.groups.size() - 1);
    }

    public String getMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withGroups(List<String> groups) {
        if (groups != null) {
            this.groups = new ArrayList<String>();
            for (String item : groups) {
                this.addToGroups(item);
            }
        } else {
            this.groups = null;
        }
        return (A)this;
    }

    public A withGroups(String ... groups) {
        if (this.groups != null) {
            this.groups.clear();
            this._visitables.remove("groups");
        }
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    public boolean hasGroups() {
        return this.groups != null && !this.groups.isEmpty();
    }

    public PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    public A withTemplate(PodTemplateSpec template) {
        this._visitables.remove("template");
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.get("template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get("template").remove(this.template);
        }
        return (A)this;
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNested(item);
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new PodTemplateSpecBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    public String getUser() {
        return this.user;
    }

    public A withUser(String user) {
        this.user = user;
        return (A)this;
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodSecurityPolicySubjectReviewSpecFluent that = (PodSecurityPolicySubjectReviewSpecFluent)o;
        if (!Objects.equals(this.groups, that.groups)) {
            return false;
        }
        if (!Objects.equals(this.template, that.template)) {
            return false;
        }
        if (!Objects.equals(this.user, that.user)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.groups, this.template, this.user, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.groups != null && !this.groups.isEmpty()) {
            sb.append("groups:");
            sb.append(this.groups + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template + ",");
        }
        if (this.user != null) {
            sb.append("user:");
            sb.append(this.user + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TemplateNested<N>
    extends PodTemplateSpecFluent<TemplateNested<N>>
    implements Nested<N> {
        PodTemplateSpecBuilder builder;

        TemplateNested(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSecurityPolicySubjectReviewSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }
}

