/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_10.server.mock.crud;

import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.kubernetes.api.model.v6_10.GenericKubernetesResource;
import io.fabric8.kubernetes.clnt.v6_10.server.mock.crud.KubernetesCrudDispatcherException;
import io.fabric8.kubernetes.clnt.v6_10.server.mock.crud.KubernetesCrudDispatcherHandler;
import io.fabric8.kubernetes.clnt.v6_10.server.mock.crud.KubernetesCrudPersistence;
import io.fabric8.kubernetes.clnt.v6_10.utils.Serialization;
import io.fabric8.mockwebserver.crud.AttributeSet;
import java.util.Map;
import okhttp3.mockwebserver.MockResponse;

public class PutHandler
implements KubernetesCrudDispatcherHandler {
    private final KubernetesCrudPersistence persistence;

    public PutHandler(KubernetesCrudPersistence persistence) {
        this.persistence = persistence;
    }

    @Override
    public MockResponse handle(String path, String contentType, String requestBody) throws KubernetesCrudDispatcherException {
        JsonNode updatedResource;
        GenericKubernetesResource resource = this.validateRequestBody(requestBody);
        AttributeSet attributes = this.persistence.getKey(path);
        Map.Entry<AttributeSet, String> currentResourceEntry = this.persistence.findResource(attributes);
        if (currentResourceEntry == null) {
            return new MockResponse().setResponseCode(404);
        }
        if (resource.isMarkedForDeletion() && resource.getFinalizers().isEmpty()) {
            this.persistence.processEvent(path, attributes, currentResourceEntry.getKey(), null, null);
            return new MockResponse().setResponseCode(200);
        }
        JsonNode currentResource = this.persistence.asNode(currentResourceEntry);
        if (KubernetesCrudDispatcherHandler.isStatusPath(path)) {
            updatedResource = currentResource.deepCopy();
            KubernetesCrudDispatcherHandler.setStatus(updatedResource, this.persistence.asNode(requestBody).get("status"));
        } else {
            updatedResource = this.persistence.asNode(requestBody);
            if (this.persistence.isStatusSubresourceEnabledForResource(path)) {
                KubernetesCrudDispatcherHandler.setStatus(updatedResource, currentResource.get("status"));
            }
        }
        this.validatePath(attributes, updatedResource);
        this.validateResourceVersion(currentResource, updatedResource);
        this.persistence.preserveMetadata(currentResource, updatedResource);
        if (!KubernetesCrudDispatcherHandler.isStatusPath(path)) {
            this.persistence.touchGeneration(currentResource, updatedResource);
        }
        this.persistence.touchResourceVersion(currentResource, updatedResource);
        String response = Serialization.asJson((Object)updatedResource);
        this.persistence.processEvent(path, attributes, currentResourceEntry.getKey(), null, response);
        return new MockResponse().setResponseCode(200).setBody(response);
    }
}

