/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_10.server.mock.crud;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.fabric8.kubernetes.api.model.v6_10.GenericKubernetesResource;
import io.fabric8.kubernetes.clnt.v6_10.server.mock.Resetable;
import io.fabric8.kubernetes.clnt.v6_10.server.mock.crud.KubernetesCrudDispatcherException;
import io.fabric8.kubernetes.clnt.v6_10.utils.Serialization;
import io.fabric8.mockwebserver.crud.AttributeSet;
import io.fabric8.zjsonpatch.JsonDiff;
import java.util.Map;
import java.util.Optional;
import java.util.stream.StreamSupport;

public interface KubernetesCrudPersistence
extends Resetable {
    public static final String METADATA = "metadata";
    public static final String UID = "uid";
    public static final String CREATION_TIMESTAMP = "creationTimestamp";
    public static final String RESOURCE_VERSION = "resourceVersion";
    public static final String GENERATION = "generation";

    public long requestResourceVersion();

    public AttributeSet getKey(String var1);

    public Map.Entry<AttributeSet, String> findResource(AttributeSet var1);

    public boolean isStatusSubresourceEnabledForResource(String var1);

    public void processEvent(String var1, AttributeSet var2, AttributeSet var3, GenericKubernetesResource var4, String var5);

    default public JsonNode asNode(Map.Entry<AttributeSet, String> resource) throws KubernetesCrudDispatcherException {
        return this.asNode(resource.getValue());
    }

    default public JsonNode asNode(String resourceBody) throws KubernetesCrudDispatcherException {
        try {
            return Serialization.jsonMapper().readTree(resourceBody);
        }
        catch (JsonProcessingException e) {
            throw new KubernetesCrudDispatcherException(e.getMessage(), 422);
        }
    }

    default public JsonNode merge(JsonNode baseResource, String updatedResource) throws KubernetesCrudDispatcherException {
        try {
            ObjectReader objectReader = Serialization.jsonMapper().readerForUpdating((Object)baseResource.deepCopy());
            return (JsonNode)objectReader.readValue(updatedResource);
        }
        catch (JsonProcessingException e) {
            throw new KubernetesCrudDispatcherException(e.getMessage(), 422);
        }
    }

    default public void preserveMetadata(JsonNode currentResource, JsonNode updatedResource) {
        ObjectNode currentMetadata = (ObjectNode)currentResource.get(METADATA);
        ObjectNode updatedMetadata = (ObjectNode)updatedResource.get(METADATA);
        updatedMetadata.put("namespace", currentMetadata.path("namespace").asText(null));
        updatedMetadata.put(UID, currentMetadata.get(UID).asText());
        updatedMetadata.put(CREATION_TIMESTAMP, currentMetadata.get(CREATION_TIMESTAMP).asText());
        updatedMetadata.put(RESOURCE_VERSION, currentMetadata.get(RESOURCE_VERSION).asText());
        updatedMetadata.set(GENERATION, currentMetadata.get(GENERATION).deepCopy());
    }

    default public void touchResourceVersion(JsonNode currentResource, JsonNode updatedResource) {
        if (!JsonDiff.asJson((JsonNode)currentResource, (JsonNode)updatedResource).isEmpty()) {
            ((ObjectNode)updatedResource.get(METADATA)).put(RESOURCE_VERSION, String.valueOf(this.requestResourceVersion()));
        }
    }

    default public void touchGeneration(JsonNode currentResource, JsonNode updatedResource) {
        JsonNode diff = JsonDiff.asJson((JsonNode)currentResource, (JsonNode)updatedResource);
        if (!diff.isEmpty() && KubernetesCrudPersistence.shouldIncreaseGeneration(diff)) {
            ((ObjectNode)updatedResource.get(METADATA)).put(GENERATION, currentResource.path(METADATA).path(GENERATION).asInt(0) + 1);
        }
    }

    public static boolean shouldIncreaseGeneration(JsonNode existing, JsonNode source) {
        JsonNode differences = Optional.ofNullable(existing).map(e -> JsonDiff.asJson((JsonNode)e, (JsonNode)source)).orElse(null);
        return KubernetesCrudPersistence.shouldIncreaseGeneration(differences);
    }

    public static boolean shouldIncreaseGeneration(JsonNode differences) {
        if (differences != null && !differences.isEmpty()) {
            return StreamSupport.stream(differences.spliterator(), false).filter(n -> !n.get("path").asText().matches("/metadata(/.*)?")).anyMatch(n -> !n.get("path").asText().matches("/status(/.*)?"));
        }
        return false;
    }
}

