/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_10.impl;

import io.fabric8.kubernetes.api.model.v6_10.APIGroup;
import io.fabric8.kubernetes.api.model.v6_10.APIGroupList;
import io.fabric8.kubernetes.api.model.v6_10.APIResourceList;
import io.fabric8.kubernetes.api.model.v6_10.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.v6_10.HasMetadata;
import io.fabric8.kubernetes.api.model.v6_10.KubernetesResource;
import io.fabric8.kubernetes.api.model.v6_10.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v6_10.RootPaths;
import io.fabric8.kubernetes.clnt.v6_10.Client;
import io.fabric8.kubernetes.clnt.v6_10.Config;
import io.fabric8.kubernetes.clnt.v6_10.KubernetesClientBuilder;
import io.fabric8.kubernetes.clnt.v6_10.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v6_10.VersionInfo;
import io.fabric8.kubernetes.clnt.v6_10.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v6_10.dsl.Resource;
import io.fabric8.kubernetes.clnt.v6_10.dsl.base.ResourceDefinitionContext;
import io.fabric8.kubernetes.clnt.v6_10.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.clnt.v6_10.dsl.internal.OperationContext;
import io.fabric8.kubernetes.clnt.v6_10.dsl.internal.OperationSupport;
import io.fabric8.kubernetes.clnt.v6_10.extension.ExtensionAdapter;
import io.fabric8.kubernetes.clnt.v6_10.extension.SupportTestingClient;
import io.fabric8.kubernetes.clnt.v6_10.http.HttpClient;
import io.fabric8.kubernetes.clnt.v6_10.impl.Adapters;
import io.fabric8.kubernetes.clnt.v6_10.impl.Handlers;
import io.fabric8.kubernetes.clnt.v6_10.utils.ApiVersionUtil;
import io.fabric8.kubernetes.clnt.v6_10.utils.KubernetesSerialization;
import io.fabric8.kubernetes.clnt.v6_10.utils.Utils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseClient
implements Client {
    public static final Logger logger = LoggerFactory.getLogger(BaseClient.class);
    public static final KubernetesClientBuilder.ExecutorSupplier DEFAULT_EXECUTOR_SUPPLIER = new KubernetesClientBuilder.ExecutorSupplier(){

        public Executor get() {
            return Executors.newCachedThreadPool(Utils.daemonThreadFactory((Object)this));
        }

        public void onClose(Executor executor) {
            ((ExecutorService)executor).shutdownNow();
        }
    };
    public static final String APIS = "/apis";
    private URL masterUrl;
    private String apiVersion;
    private String namespace;
    private Predicate<String> matchingGroupPredicate;
    private final Adapters adapters;
    private final Handlers handlers;
    protected Config config;
    protected HttpClient httpClient;
    private OperationSupport operationSupport;
    private KubernetesClientBuilder.ExecutorSupplier executorSupplier;
    private Executor executor;
    protected KubernetesSerialization kubernetesSerialization;
    private CompletableFuture<Void> closed;
    private Set<AutoCloseable> closable;
    private OperationContext operationContext;

    BaseClient(BaseClient baseClient) {
        this.closed = baseClient.closed;
        this.config = baseClient.config;
        this.httpClient = baseClient.httpClient;
        this.adapters = baseClient.adapters;
        this.handlers = baseClient.handlers;
        this.matchingGroupPredicate = baseClient.matchingGroupPredicate;
        this.executorSupplier = baseClient.executorSupplier;
        this.executor = baseClient.executor;
        this.kubernetesSerialization = baseClient.kubernetesSerialization;
        this.closable = baseClient.closable;
        this.setDerivedFields();
        if (baseClient.operationContext != null) {
            this.operationContext(baseClient.operationContext);
        }
    }

    BaseClient(HttpClient httpClient, Config config, KubernetesClientBuilder.ExecutorSupplier executorSupplier, KubernetesSerialization kubernetesSerialization) {
        this.closable = Collections.newSetFromMap(new WeakHashMap());
        this.closed = new CompletableFuture();
        this.config = config;
        this.httpClient = httpClient;
        this.handlers = new Handlers();
        this.adapters = new Adapters(this.handlers);
        this.setDerivedFields();
        if (executorSupplier == null) {
            executorSupplier = DEFAULT_EXECUTOR_SUPPLIER;
        }
        this.executorSupplier = executorSupplier;
        this.executor = (Executor)executorSupplier.get();
        this.kubernetesSerialization = kubernetesSerialization;
    }

    protected void setDerivedFields() {
        this.namespace = this.config.getNamespace();
        this.apiVersion = this.config.getApiVersion();
        if (this.config.getMasterUrl() == null) {
            throw new KubernetesClientException("Unknown Kubernetes master URL - please set with the builder, or set with either system property \"kubernetes.master\" or environment variable \"" + Utils.convertSystemPropertyNameToEnvVar((String)"kubernetes.master") + "\"");
        }
        try {
            this.masterUrl = new URL(this.config.getMasterUrl());
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public synchronized void close() {
        if (this.closed.complete(null) && logger.isDebugEnabled()) {
            logger.debug("The client and associated httpclient {} have been closed, the usage of this or any client using the httpclient will not work after this", (Object)this.httpClient.getClass().getName());
        }
        this.httpClient.close();
        this.closable.forEach(c -> {
            try {
                c.close();
            }
            catch (Exception e) {
                logger.warn("Error closing resource", (Throwable)e);
            }
        });
        this.closable.clear();
        if (this.executorSupplier != null) {
            this.executorSupplier.onClose(this.executor);
            this.executorSupplier = null;
        }
    }

    public CompletableFuture<Void> getClosed() {
        return this.closed;
    }

    public URL getMasterUrl() {
        return this.masterUrl;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setMatchingGroupPredicate(Predicate<String> unsupportedApiGroups) {
        this.matchingGroupPredicate = unsupportedApiGroups;
    }

    public boolean hasApiGroup(String apiGroup, boolean exact) {
        if (this.matchingGroupPredicate != null) {
            return this.matchingGroupPredicate.test(apiGroup);
        }
        if (exact) {
            return this.getApiGroup(apiGroup) != null;
        }
        APIGroupList apiGroups = this.getApiGroups();
        if (apiGroups == null) {
            return false;
        }
        return apiGroups.getGroups().stream().anyMatch(g -> g.getName().endsWith(apiGroup));
    }

    public <C extends Client> Boolean isAdaptable(Class<C> type) {
        C toTest = this.adapt(type);
        if (toTest instanceof SupportTestingClient) {
            return ((SupportTestingClient)toTest).isSupported();
        }
        return true;
    }

    public <R extends KubernetesResource> boolean supports(Class<R> type) {
        String typeApiVersion = HasMetadata.getApiVersion(type);
        if (this.matchingGroupPredicate != null) {
            return this.matchingGroupPredicate.test(typeApiVersion);
        }
        String typeKind = HasMetadata.getKind(type);
        if (Utils.isNullOrEmpty((String)typeApiVersion) || Utils.isNullOrEmpty((String)typeKind)) {
            return false;
        }
        return this.supports(ApiVersionUtil.joinApiGroupAndVersion((String)HasMetadata.getGroup(type), (String)HasMetadata.getVersion(type)), typeKind);
    }

    public boolean supports(String apiVersion, String kind) {
        Utils.checkNotNull((Object)kind, (String)"kind cannot be null");
        Utils.checkNotNull((Object)apiVersion, (String)"apiVersion cannot be null");
        APIResourceList apiResources = this.getApiResources(apiVersion);
        if (apiResources == null) {
            return false;
        }
        return apiResources.getResources().stream().anyMatch(r -> kind.equals(r.getKind()));
    }

    public <C extends Client> C adapt(Class<C> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return (C)this;
        }
        ExtensionAdapter<C> adapter = this.adapters.get(type);
        if (adapter == null) {
            throw new IllegalStateException("No adapter available for type:" + type);
        }
        return (C)adapter.adapt((Client)this);
    }

    public RootPaths rootPaths() {
        return this.getOperationSupport().restCall(RootPaths.class, new String[0]);
    }

    public boolean supportsApiPath(String apiPath) {
        List<String> paths;
        RootPaths rootPaths = this.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!path.equals(apiPath)) continue;
                return true;
            }
        }
        return false;
    }

    public APIGroupList getApiGroups() {
        return this.getOperationSupport().restCall(APIGroupList.class, APIS);
    }

    public APIGroup getApiGroup(String name) {
        return this.getOperationSupport().restCall(APIGroup.class, APIS, name);
    }

    private OperationSupport getOperationSupport() {
        if (this.operationSupport == null) {
            this.operationSupport = new OperationSupport(this);
        }
        return this.operationSupport;
    }

    public APIResourceList getApiResources(String groupVersion) {
        if ("v1".equals(groupVersion)) {
            return this.getOperationSupport().restCall(APIResourceList.class, "api", "v1");
        }
        return this.getOperationSupport().restCall(APIResourceList.class, APIS, groupVersion);
    }

    protected VersionInfo getVersionInfo(String path) {
        return this.getOperationSupport().restCall(VersionInfo.class, path);
    }

    public <T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>> MixedOperation<T, L, R> resources(Class<T> resourceType, Class<L> listClass, Class<R> resourceClass) {
        if (GenericKubernetesResource.class.equals(resourceType)) {
            throw new KubernetesClientException("resources cannot be called with a generic type");
        }
        if (resourceType.isInterface()) {
            throw new IllegalArgumentException("resources cannot be called with an interface");
        }
        try {
            return this.handlers.getOperation(resourceType, listClass, this);
        }
        catch (Exception e) {
            if (resourceClass == null || Resource.class.equals(resourceClass)) {
                return this.newHasMetadataOperation(ResourceDefinitionContext.fromResourceType(resourceType), resourceType, listClass);
            }
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public <T extends HasMetadata, L extends KubernetesResourceList<T>> HasMetadataOperationsImpl<T, L> newHasMetadataOperation(ResourceDefinitionContext rdContext, Class<T> resourceType, Class<L> listClass) {
        return new HasMetadataOperationsImpl<T, L>(this, rdContext, resourceType, listClass);
    }

    public Config getConfiguration() {
        return this.config;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public Adapters getAdapters() {
        return this.adapters;
    }

    public Handlers getHandlers() {
        return this.handlers;
    }

    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    public BaseClient operationContext(OperationContext operationContext) {
        this.operationContext = operationContext;
        this.namespace = operationContext.getNamespace();
        return this;
    }

    abstract BaseClient copy();

    public <C extends Client> C newClient(OperationContext newContext, Class<C> clazz) {
        BaseClient copy = this.copy();
        if (newContext.getRequestConfig() != null && newContext.getConfig().getRequestConfig() != newContext.getRequestConfig()) {
            copy.httpClient = copy.httpClient.newBuilder().tag((Object)newContext.getRequestConfig()).build();
        }
        newContext = newContext.withClient(copy);
        return copy.operationContext(newContext).adapt(clazz);
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public String raw(String uri) {
        try {
            return this.raw(uri, "GET", null);
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return null;
        }
    }

    public String raw(String uri, String method, Object payload) {
        return this.getOperationSupport().handleRaw(String.class, uri, method, payload);
    }

    public KubernetesSerialization getKubernetesSerialization() {
        return this.kubernetesSerialization;
    }

    public synchronized void addToCloseable(AutoCloseable closeable) {
        if (this.closed.isDone()) {
            throw new KubernetesClientException("Client is already closed");
        }
        this.closable.add(closeable);
    }

    public synchronized void removeFromCloseable(AutoCloseable closeable) {
        this.closable.remove(closeable);
    }
}

