/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_10.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.v6_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_10.Nested;
import io.fabric8.kubernetes.api.model.v6_10.networking.v1beta1.IngressClassParametersReference;
import io.fabric8.kubernetes.api.model.v6_10.networking.v1beta1.IngressClassParametersReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_10.networking.v1beta1.IngressClassParametersReferenceFluent;
import io.fabric8.kubernetes.api.model.v6_10.networking.v1beta1.IngressClassSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IngressClassSpecFluent<A extends IngressClassSpecFluent<A>>
extends BaseFluent<A> {
    private String controller;
    private IngressClassParametersReferenceBuilder parameters;
    private Map<String, Object> additionalProperties;

    public IngressClassSpecFluent() {
    }

    public IngressClassSpecFluent(IngressClassSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IngressClassSpec instance) {
        IngressClassSpec ingressClassSpec = instance = instance != null ? instance : new IngressClassSpec();
        if (instance != null) {
            this.withController(instance.getController());
            this.withParameters(instance.getParameters());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getController() {
        return this.controller;
    }

    public A withController(String controller) {
        this.controller = controller;
        return (A)this;
    }

    public boolean hasController() {
        return this.controller != null;
    }

    public IngressClassParametersReference buildParameters() {
        return this.parameters != null ? this.parameters.build() : null;
    }

    public A withParameters(IngressClassParametersReference parameters) {
        this._visitables.remove("parameters");
        if (parameters != null) {
            this.parameters = new IngressClassParametersReferenceBuilder(parameters);
            this._visitables.get("parameters").add(this.parameters);
        } else {
            this.parameters = null;
            this._visitables.get("parameters").remove(this.parameters);
        }
        return (A)this;
    }

    public boolean hasParameters() {
        return this.parameters != null;
    }

    public A withNewParameters(String apiGroup, String kind, String name, String namespace, String scope) {
        return this.withParameters(new IngressClassParametersReference(apiGroup, kind, name, namespace, scope));
    }

    public ParametersNested<A> withNewParameters() {
        return new ParametersNested(null);
    }

    public ParametersNested<A> withNewParametersLike(IngressClassParametersReference item) {
        return new ParametersNested(item);
    }

    public ParametersNested<A> editParameters() {
        return this.withNewParametersLike(Optional.ofNullable(this.buildParameters()).orElse(null));
    }

    public ParametersNested<A> editOrNewParameters() {
        return this.withNewParametersLike(Optional.ofNullable(this.buildParameters()).orElse(new IngressClassParametersReferenceBuilder().build()));
    }

    public ParametersNested<A> editOrNewParametersLike(IngressClassParametersReference item) {
        return this.withNewParametersLike(Optional.ofNullable(this.buildParameters()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressClassSpecFluent that = (IngressClassSpecFluent)o;
        if (!Objects.equals(this.controller, that.controller)) {
            return false;
        }
        if (!Objects.equals(this.parameters, that.parameters)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.controller, this.parameters, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.controller != null) {
            sb.append("controller:");
            sb.append(this.controller + ",");
        }
        if (this.parameters != null) {
            sb.append("parameters:");
            sb.append(this.parameters + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ParametersNested<N>
    extends IngressClassParametersReferenceFluent<ParametersNested<N>>
    implements Nested<N> {
        IngressClassParametersReferenceBuilder builder;

        ParametersNested(IngressClassParametersReference item) {
            this.builder = new IngressClassParametersReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IngressClassSpecFluent.this.withParameters(this.builder.build());
        }

        public N endParameters() {
            return this.and();
        }
    }
}

