/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_10.networking.v1;

import io.fabric8.kubernetes.api.builder.v6_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_10.Nested;
import io.fabric8.kubernetes.api.model.v6_10.networking.v1.IngressLoadBalancerIngress;
import io.fabric8.kubernetes.api.model.v6_10.networking.v1.IngressLoadBalancerIngressBuilder;
import io.fabric8.kubernetes.api.model.v6_10.networking.v1.IngressLoadBalancerIngressFluent;
import io.fabric8.kubernetes.api.model.v6_10.networking.v1.IngressLoadBalancerStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class IngressLoadBalancerStatusFluent<A extends IngressLoadBalancerStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<IngressLoadBalancerIngressBuilder> ingress = new ArrayList();
    private Map<String, Object> additionalProperties;

    public IngressLoadBalancerStatusFluent() {
    }

    public IngressLoadBalancerStatusFluent(IngressLoadBalancerStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IngressLoadBalancerStatus instance) {
        IngressLoadBalancerStatus ingressLoadBalancerStatus = instance = instance != null ? instance : new IngressLoadBalancerStatus();
        if (instance != null) {
            this.withIngress(instance.getIngress());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToIngress(int index, IngressLoadBalancerIngress item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        IngressLoadBalancerIngressBuilder builder = new IngressLoadBalancerIngressBuilder(item);
        if (index < 0 || index >= this.ingress.size()) {
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        } else {
            this._visitables.get("ingress").add(index, builder);
            this.ingress.add(index, builder);
        }
        return (A)this;
    }

    public A setToIngress(int index, IngressLoadBalancerIngress item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        IngressLoadBalancerIngressBuilder builder = new IngressLoadBalancerIngressBuilder(item);
        if (index < 0 || index >= this.ingress.size()) {
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        } else {
            this._visitables.get("ingress").set(index, builder);
            this.ingress.set(index, builder);
        }
        return (A)this;
    }

    public A addToIngress(IngressLoadBalancerIngress ... items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        for (IngressLoadBalancerIngress item : items) {
            IngressLoadBalancerIngressBuilder builder = new IngressLoadBalancerIngressBuilder(item);
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    public A addAllToIngress(Collection<IngressLoadBalancerIngress> items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        for (IngressLoadBalancerIngress item : items) {
            IngressLoadBalancerIngressBuilder builder = new IngressLoadBalancerIngressBuilder(item);
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    public A removeFromIngress(IngressLoadBalancerIngress ... items) {
        if (this.ingress == null) {
            return (A)this;
        }
        for (IngressLoadBalancerIngress item : items) {
            IngressLoadBalancerIngressBuilder builder = new IngressLoadBalancerIngressBuilder(item);
            this._visitables.get("ingress").remove(builder);
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromIngress(Collection<IngressLoadBalancerIngress> items) {
        if (this.ingress == null) {
            return (A)this;
        }
        for (IngressLoadBalancerIngress item : items) {
            IngressLoadBalancerIngressBuilder builder = new IngressLoadBalancerIngressBuilder(item);
            this._visitables.get("ingress").remove(builder);
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromIngress(Predicate<IngressLoadBalancerIngressBuilder> predicate) {
        if (this.ingress == null) {
            return (A)this;
        }
        Iterator<IngressLoadBalancerIngressBuilder> each = this.ingress.iterator();
        Object visitables = this._visitables.get("ingress");
        while (each.hasNext()) {
            IngressLoadBalancerIngressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<IngressLoadBalancerIngress> buildIngress() {
        return this.ingress != null ? IngressLoadBalancerStatusFluent.build(this.ingress) : null;
    }

    public IngressLoadBalancerIngress buildIngress(int index) {
        return this.ingress.get(index).build();
    }

    public IngressLoadBalancerIngress buildFirstIngress() {
        return this.ingress.get(0).build();
    }

    public IngressLoadBalancerIngress buildLastIngress() {
        return this.ingress.get(this.ingress.size() - 1).build();
    }

    public IngressLoadBalancerIngress buildMatchingIngress(Predicate<IngressLoadBalancerIngressBuilder> predicate) {
        for (IngressLoadBalancerIngressBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingIngress(Predicate<IngressLoadBalancerIngressBuilder> predicate) {
        for (IngressLoadBalancerIngressBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withIngress(List<IngressLoadBalancerIngress> ingress) {
        if (this.ingress != null) {
            this._visitables.get("ingress").clear();
        }
        if (ingress != null) {
            this.ingress = new ArrayList();
            for (IngressLoadBalancerIngress item : ingress) {
                this.addToIngress(item);
            }
        } else {
            this.ingress = null;
        }
        return (A)this;
    }

    public A withIngress(IngressLoadBalancerIngress ... ingress) {
        if (this.ingress != null) {
            this.ingress.clear();
            this._visitables.remove("ingress");
        }
        if (ingress != null) {
            for (IngressLoadBalancerIngress item : ingress) {
                this.addToIngress(item);
            }
        }
        return (A)this;
    }

    public boolean hasIngress() {
        return this.ingress != null && !this.ingress.isEmpty();
    }

    public IngressNested<A> addNewIngress() {
        return new IngressNested(-1, null);
    }

    public IngressNested<A> addNewIngressLike(IngressLoadBalancerIngress item) {
        return new IngressNested(-1, item);
    }

    public IngressNested<A> setNewIngressLike(int index, IngressLoadBalancerIngress item) {
        return new IngressNested(index, item);
    }

    public IngressNested<A> editIngress(int index) {
        if (this.ingress.size() <= index) {
            throw new RuntimeException("Can't edit ingress. Index exceeds size.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    public IngressNested<A> editFirstIngress() {
        if (this.ingress.size() == 0) {
            throw new RuntimeException("Can't edit first ingress. The list is empty.");
        }
        return this.setNewIngressLike(0, this.buildIngress(0));
    }

    public IngressNested<A> editLastIngress() {
        int index = this.ingress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ingress. The list is empty.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    public IngressNested<A> editMatchingIngress(Predicate<IngressLoadBalancerIngressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ingress.size(); ++i) {
            if (!predicate.test(this.ingress.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ingress. No match found.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressLoadBalancerStatusFluent that = (IngressLoadBalancerStatusFluent)o;
        if (!Objects.equals(this.ingress, that.ingress)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ingress, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ingress != null && !this.ingress.isEmpty()) {
            sb.append("ingress:");
            sb.append(this.ingress + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class IngressNested<N>
    extends IngressLoadBalancerIngressFluent<IngressNested<N>>
    implements Nested<N> {
        IngressLoadBalancerIngressBuilder builder;
        int index;

        IngressNested(int index, IngressLoadBalancerIngress item) {
            this.index = index;
            this.builder = new IngressLoadBalancerIngressBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IngressLoadBalancerStatusFluent.this.setToIngress(this.index, this.builder.build());
        }

        public N endIngress() {
            return this.and();
        }
    }
}

