/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_10.gatewayapi.v1;

import io.fabric8.kubernetes.api.builder.v6_10.BaseFluent;
import io.fabric8.kubernetes.api.model.v6_10.Condition;
import io.fabric8.kubernetes.api.model.v6_10.gatewayapi.v1.GatewayClassStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class GatewayClassStatusFluent<A extends GatewayClassStatusFluent<A>>
extends BaseFluent<A> {
    private List<Condition> conditions = new ArrayList<Condition>();
    private List<String> supportedFeatures = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public GatewayClassStatusFluent() {
    }

    public GatewayClassStatusFluent(GatewayClassStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(GatewayClassStatus instance) {
        GatewayClassStatus gatewayClassStatus = instance = instance != null ? instance : new GatewayClassStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withSupportedFeatures(instance.getSupportedFeatures());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public A addToSupportedFeatures(int index, String item) {
        if (this.supportedFeatures == null) {
            this.supportedFeatures = new ArrayList<String>();
        }
        this.supportedFeatures.add(index, item);
        return (A)this;
    }

    public A setToSupportedFeatures(int index, String item) {
        if (this.supportedFeatures == null) {
            this.supportedFeatures = new ArrayList<String>();
        }
        this.supportedFeatures.set(index, item);
        return (A)this;
    }

    public A addToSupportedFeatures(String ... items) {
        if (this.supportedFeatures == null) {
            this.supportedFeatures = new ArrayList<String>();
        }
        for (String item : items) {
            this.supportedFeatures.add(item);
        }
        return (A)this;
    }

    public A addAllToSupportedFeatures(Collection<String> items) {
        if (this.supportedFeatures == null) {
            this.supportedFeatures = new ArrayList<String>();
        }
        for (String item : items) {
            this.supportedFeatures.add(item);
        }
        return (A)this;
    }

    public A removeFromSupportedFeatures(String ... items) {
        if (this.supportedFeatures == null) {
            return (A)this;
        }
        for (String item : items) {
            this.supportedFeatures.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromSupportedFeatures(Collection<String> items) {
        if (this.supportedFeatures == null) {
            return (A)this;
        }
        for (String item : items) {
            this.supportedFeatures.remove(item);
        }
        return (A)this;
    }

    public List<String> getSupportedFeatures() {
        return this.supportedFeatures;
    }

    public String getSupportedFeature(int index) {
        return this.supportedFeatures.get(index);
    }

    public String getFirstSupportedFeature() {
        return this.supportedFeatures.get(0);
    }

    public String getLastSupportedFeature() {
        return this.supportedFeatures.get(this.supportedFeatures.size() - 1);
    }

    public String getMatchingSupportedFeature(Predicate<String> predicate) {
        for (String item : this.supportedFeatures) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSupportedFeature(Predicate<String> predicate) {
        for (String item : this.supportedFeatures) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSupportedFeatures(List<String> supportedFeatures) {
        if (supportedFeatures != null) {
            this.supportedFeatures = new ArrayList<String>();
            for (String item : supportedFeatures) {
                this.addToSupportedFeatures(item);
            }
        } else {
            this.supportedFeatures = null;
        }
        return (A)this;
    }

    public A withSupportedFeatures(String ... supportedFeatures) {
        if (this.supportedFeatures != null) {
            this.supportedFeatures.clear();
            this._visitables.remove("supportedFeatures");
        }
        if (supportedFeatures != null) {
            for (String item : supportedFeatures) {
                this.addToSupportedFeatures(item);
            }
        }
        return (A)this;
    }

    public boolean hasSupportedFeatures() {
        return this.supportedFeatures != null && !this.supportedFeatures.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GatewayClassStatusFluent that = (GatewayClassStatusFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.supportedFeatures, that.supportedFeatures)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.supportedFeatures, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.supportedFeatures != null && !this.supportedFeatures.isEmpty()) {
            sb.append("supportedFeatures:");
            sb.append(this.supportedFeatures + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

