/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_10.gatewayapi.v1;

import io.fabric8.kubernetes.api.builder.v6_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_10.Nested;
import io.fabric8.kubernetes.api.model.v6_10.gatewayapi.v1.AllowedRoutes;
import io.fabric8.kubernetes.api.model.v6_10.gatewayapi.v1.RouteGroupKind;
import io.fabric8.kubernetes.api.model.v6_10.gatewayapi.v1.RouteGroupKindBuilder;
import io.fabric8.kubernetes.api.model.v6_10.gatewayapi.v1.RouteGroupKindFluent;
import io.fabric8.kubernetes.api.model.v6_10.gatewayapi.v1.RouteNamespaces;
import io.fabric8.kubernetes.api.model.v6_10.gatewayapi.v1.RouteNamespacesBuilder;
import io.fabric8.kubernetes.api.model.v6_10.gatewayapi.v1.RouteNamespacesFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class AllowedRoutesFluent<A extends AllowedRoutesFluent<A>>
extends BaseFluent<A> {
    private ArrayList<RouteGroupKindBuilder> kinds = new ArrayList();
    private RouteNamespacesBuilder namespaces;
    private Map<String, Object> additionalProperties;

    public AllowedRoutesFluent() {
    }

    public AllowedRoutesFluent(AllowedRoutes instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AllowedRoutes instance) {
        AllowedRoutes allowedRoutes = instance = instance != null ? instance : new AllowedRoutes();
        if (instance != null) {
            this.withKinds(instance.getKinds());
            this.withNamespaces(instance.getNamespaces());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToKinds(int index, RouteGroupKind item) {
        if (this.kinds == null) {
            this.kinds = new ArrayList();
        }
        RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
        if (index < 0 || index >= this.kinds.size()) {
            this._visitables.get("kinds").add(builder);
            this.kinds.add(builder);
        } else {
            this._visitables.get("kinds").add(index, builder);
            this.kinds.add(index, builder);
        }
        return (A)this;
    }

    public A setToKinds(int index, RouteGroupKind item) {
        if (this.kinds == null) {
            this.kinds = new ArrayList();
        }
        RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
        if (index < 0 || index >= this.kinds.size()) {
            this._visitables.get("kinds").add(builder);
            this.kinds.add(builder);
        } else {
            this._visitables.get("kinds").set(index, builder);
            this.kinds.set(index, builder);
        }
        return (A)this;
    }

    public A addToKinds(RouteGroupKind ... items) {
        if (this.kinds == null) {
            this.kinds = new ArrayList();
        }
        for (RouteGroupKind item : items) {
            RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
            this._visitables.get("kinds").add(builder);
            this.kinds.add(builder);
        }
        return (A)this;
    }

    public A addAllToKinds(Collection<RouteGroupKind> items) {
        if (this.kinds == null) {
            this.kinds = new ArrayList();
        }
        for (RouteGroupKind item : items) {
            RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
            this._visitables.get("kinds").add(builder);
            this.kinds.add(builder);
        }
        return (A)this;
    }

    public A removeFromKinds(RouteGroupKind ... items) {
        if (this.kinds == null) {
            return (A)this;
        }
        for (RouteGroupKind item : items) {
            RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
            this._visitables.get("kinds").remove(builder);
            this.kinds.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromKinds(Collection<RouteGroupKind> items) {
        if (this.kinds == null) {
            return (A)this;
        }
        for (RouteGroupKind item : items) {
            RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
            this._visitables.get("kinds").remove(builder);
            this.kinds.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromKinds(Predicate<RouteGroupKindBuilder> predicate) {
        if (this.kinds == null) {
            return (A)this;
        }
        Iterator<RouteGroupKindBuilder> each = this.kinds.iterator();
        Object visitables = this._visitables.get("kinds");
        while (each.hasNext()) {
            RouteGroupKindBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<RouteGroupKind> buildKinds() {
        return this.kinds != null ? AllowedRoutesFluent.build(this.kinds) : null;
    }

    public RouteGroupKind buildKind(int index) {
        return this.kinds.get(index).build();
    }

    public RouteGroupKind buildFirstKind() {
        return this.kinds.get(0).build();
    }

    public RouteGroupKind buildLastKind() {
        return this.kinds.get(this.kinds.size() - 1).build();
    }

    public RouteGroupKind buildMatchingKind(Predicate<RouteGroupKindBuilder> predicate) {
        for (RouteGroupKindBuilder item : this.kinds) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingKind(Predicate<RouteGroupKindBuilder> predicate) {
        for (RouteGroupKindBuilder item : this.kinds) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withKinds(List<RouteGroupKind> kinds) {
        if (this.kinds != null) {
            this._visitables.get("kinds").clear();
        }
        if (kinds != null) {
            this.kinds = new ArrayList();
            for (RouteGroupKind item : kinds) {
                this.addToKinds(item);
            }
        } else {
            this.kinds = null;
        }
        return (A)this;
    }

    public A withKinds(RouteGroupKind ... kinds) {
        if (this.kinds != null) {
            this.kinds.clear();
            this._visitables.remove("kinds");
        }
        if (kinds != null) {
            for (RouteGroupKind item : kinds) {
                this.addToKinds(item);
            }
        }
        return (A)this;
    }

    public boolean hasKinds() {
        return this.kinds != null && !this.kinds.isEmpty();
    }

    public A addNewKind(String group, String kind) {
        return this.addToKinds(new RouteGroupKind(group, kind));
    }

    public KindsNested<A> addNewKind() {
        return new KindsNested(-1, null);
    }

    public KindsNested<A> addNewKindLike(RouteGroupKind item) {
        return new KindsNested(-1, item);
    }

    public KindsNested<A> setNewKindLike(int index, RouteGroupKind item) {
        return new KindsNested(index, item);
    }

    public KindsNested<A> editKind(int index) {
        if (this.kinds.size() <= index) {
            throw new RuntimeException("Can't edit kinds. Index exceeds size.");
        }
        return this.setNewKindLike(index, this.buildKind(index));
    }

    public KindsNested<A> editFirstKind() {
        if (this.kinds.size() == 0) {
            throw new RuntimeException("Can't edit first kinds. The list is empty.");
        }
        return this.setNewKindLike(0, this.buildKind(0));
    }

    public KindsNested<A> editLastKind() {
        int index = this.kinds.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last kinds. The list is empty.");
        }
        return this.setNewKindLike(index, this.buildKind(index));
    }

    public KindsNested<A> editMatchingKind(Predicate<RouteGroupKindBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.kinds.size(); ++i) {
            if (!predicate.test(this.kinds.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching kinds. No match found.");
        }
        return this.setNewKindLike(index, this.buildKind(index));
    }

    public RouteNamespaces buildNamespaces() {
        return this.namespaces != null ? this.namespaces.build() : null;
    }

    public A withNamespaces(RouteNamespaces namespaces) {
        this._visitables.remove("namespaces");
        if (namespaces != null) {
            this.namespaces = new RouteNamespacesBuilder(namespaces);
            this._visitables.get("namespaces").add(this.namespaces);
        } else {
            this.namespaces = null;
            this._visitables.get("namespaces").remove(this.namespaces);
        }
        return (A)this;
    }

    public boolean hasNamespaces() {
        return this.namespaces != null;
    }

    public NamespacesNested<A> withNewNamespaces() {
        return new NamespacesNested(null);
    }

    public NamespacesNested<A> withNewNamespacesLike(RouteNamespaces item) {
        return new NamespacesNested(item);
    }

    public NamespacesNested<A> editNamespaces() {
        return this.withNewNamespacesLike(Optional.ofNullable(this.buildNamespaces()).orElse(null));
    }

    public NamespacesNested<A> editOrNewNamespaces() {
        return this.withNewNamespacesLike(Optional.ofNullable(this.buildNamespaces()).orElse(new RouteNamespacesBuilder().build()));
    }

    public NamespacesNested<A> editOrNewNamespacesLike(RouteNamespaces item) {
        return this.withNewNamespacesLike(Optional.ofNullable(this.buildNamespaces()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AllowedRoutesFluent that = (AllowedRoutesFluent)o;
        if (!Objects.equals(this.kinds, that.kinds)) {
            return false;
        }
        if (!Objects.equals(this.namespaces, that.namespaces)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.kinds, this.namespaces, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.kinds != null && !this.kinds.isEmpty()) {
            sb.append("kinds:");
            sb.append(this.kinds + ",");
        }
        if (this.namespaces != null) {
            sb.append("namespaces:");
            sb.append(this.namespaces + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class NamespacesNested<N>
    extends RouteNamespacesFluent<NamespacesNested<N>>
    implements Nested<N> {
        RouteNamespacesBuilder builder;

        NamespacesNested(RouteNamespaces item) {
            this.builder = new RouteNamespacesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AllowedRoutesFluent.this.withNamespaces(this.builder.build());
        }

        public N endNamespaces() {
            return this.and();
        }
    }

    public class KindsNested<N>
    extends RouteGroupKindFluent<KindsNested<N>>
    implements Nested<N> {
        RouteGroupKindBuilder builder;
        int index;

        KindsNested(int index, RouteGroupKind item) {
            this.index = index;
            this.builder = new RouteGroupKindBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AllowedRoutesFluent.this.setToKinds(this.index, this.builder.build());
        }

        public N endKind() {
            return this.and();
        }
    }
}

