/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_10.discovery.v1;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.v6_10.Editable;
import io.fabric8.kubernetes.api.model.v6_10.HasMetadata;
import io.fabric8.kubernetes.api.model.v6_10.Namespaced;
import io.fabric8.kubernetes.api.model.v6_10.ObjectMeta;
import io.fabric8.kubernetes.api.model.v6_10.discovery.v1.Endpoint;
import io.fabric8.kubernetes.api.model.v6_10.discovery.v1.EndpointPort;
import io.fabric8.kubernetes.api.model.v6_10.discovery.v1.EndpointSliceBuilder;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonDeserialize(using=JsonDeserializer.None.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "addressType", "endpoints", "ports"})
@Version(value="v1")
@Group(value="discovery.k8s.io")
public class EndpointSlice
implements Editable<EndpointSliceBuilder>,
HasMetadata,
Namespaced {
    @JsonProperty(value="addressType")
    private String addressType;
    @JsonProperty(value="apiVersion")
    private String apiVersion = "discovery.k8s.io/v1";
    @JsonProperty(value="endpoints")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<Endpoint> endpoints = new ArrayList<Endpoint>();
    @JsonProperty(value="kind")
    private String kind = "EndpointSlice";
    @JsonProperty(value="metadata")
    private ObjectMeta metadata;
    @JsonProperty(value="ports")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<EndpointPort> ports = new ArrayList<EndpointPort>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    public EndpointSlice() {
    }

    public EndpointSlice(String addressType, String apiVersion, List<Endpoint> endpoints, String kind, ObjectMeta metadata, List<EndpointPort> ports) {
        this.addressType = addressType;
        this.apiVersion = apiVersion;
        this.endpoints = endpoints;
        this.kind = kind;
        this.metadata = metadata;
        this.ports = ports;
    }

    @JsonProperty(value="addressType")
    public String getAddressType() {
        return this.addressType;
    }

    @JsonProperty(value="addressType")
    public void setAddressType(String addressType) {
        this.addressType = addressType;
    }

    @Override
    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    @JsonProperty(value="apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="endpoints")
    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    @JsonProperty(value="endpoints")
    public void setEndpoints(List<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @Override
    @JsonProperty(value="metadata")
    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="metadata")
    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="ports")
    public List<EndpointPort> getPorts() {
        return this.ports;
    }

    @JsonProperty(value="ports")
    public void setPorts(List<EndpointPort> ports) {
        this.ports = ports;
    }

    @Override
    @JsonIgnore
    public EndpointSliceBuilder edit() {
        return new EndpointSliceBuilder(this);
    }

    @JsonIgnore
    public EndpointSliceBuilder toBuilder() {
        return this.edit();
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "EndpointSlice(addressType=" + this.getAddressType() + ", apiVersion=" + this.getApiVersion() + ", endpoints=" + this.getEndpoints() + ", kind=" + this.getKind() + ", metadata=" + this.getMetadata() + ", ports=" + this.getPorts() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EndpointSlice)) {
            return false;
        }
        EndpointSlice other = (EndpointSlice)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$addressType = this.getAddressType();
        String other$addressType = other.getAddressType();
        if (this$addressType == null ? other$addressType != null : !this$addressType.equals(other$addressType)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        List<Endpoint> this$endpoints = this.getEndpoints();
        List<Endpoint> other$endpoints = other.getEndpoints();
        if (this$endpoints == null ? other$endpoints != null : !((Object)this$endpoints).equals(other$endpoints)) {
            return false;
        }
        String this$kind = this.getKind();
        String other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        ObjectMeta this$metadata = this.getMetadata();
        ObjectMeta other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        List<EndpointPort> this$ports = this.getPorts();
        List<EndpointPort> other$ports = other.getPorts();
        if (this$ports == null ? other$ports != null : !((Object)this$ports).equals(other$ports)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EndpointSlice;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $addressType = this.getAddressType();
        result = result * 59 + ($addressType == null ? 43 : $addressType.hashCode());
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        List<Endpoint> $endpoints = this.getEndpoints();
        result = result * 59 + ($endpoints == null ? 43 : ((Object)$endpoints).hashCode());
        String $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        ObjectMeta $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        List<EndpointPort> $ports = this.getPorts();
        result = result * 59 + ($ports == null ? 43 : ((Object)$ports).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    @JsonIgnore
    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }
}

