/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_10.batch.v1;

import io.fabric8.kubernetes.api.builder.v6_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_10.Nested;
import io.fabric8.kubernetes.api.model.v6_10.batch.v1.JobCondition;
import io.fabric8.kubernetes.api.model.v6_10.batch.v1.JobConditionBuilder;
import io.fabric8.kubernetes.api.model.v6_10.batch.v1.JobConditionFluent;
import io.fabric8.kubernetes.api.model.v6_10.batch.v1.JobStatus;
import io.fabric8.kubernetes.api.model.v6_10.batch.v1.UncountedTerminatedPods;
import io.fabric8.kubernetes.api.model.v6_10.batch.v1.UncountedTerminatedPodsBuilder;
import io.fabric8.kubernetes.api.model.v6_10.batch.v1.UncountedTerminatedPodsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class JobStatusFluent<A extends JobStatusFluent<A>>
extends BaseFluent<A> {
    private Integer active;
    private String completedIndexes;
    private String completionTime;
    private ArrayList<JobConditionBuilder> conditions = new ArrayList();
    private Integer failed;
    private String failedIndexes;
    private Integer ready;
    private String startTime;
    private Integer succeeded;
    private Integer terminating;
    private UncountedTerminatedPodsBuilder uncountedTerminatedPods;
    private Map<String, Object> additionalProperties;

    public JobStatusFluent() {
    }

    public JobStatusFluent(JobStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(JobStatus instance) {
        JobStatus jobStatus = instance = instance != null ? instance : new JobStatus();
        if (instance != null) {
            this.withActive(instance.getActive());
            this.withCompletedIndexes(instance.getCompletedIndexes());
            this.withCompletionTime(instance.getCompletionTime());
            this.withConditions(instance.getConditions());
            this.withFailed(instance.getFailed());
            this.withFailedIndexes(instance.getFailedIndexes());
            this.withReady(instance.getReady());
            this.withStartTime(instance.getStartTime());
            this.withSucceeded(instance.getSucceeded());
            this.withTerminating(instance.getTerminating());
            this.withUncountedTerminatedPods(instance.getUncountedTerminatedPods());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getActive() {
        return this.active;
    }

    public A withActive(Integer active) {
        this.active = active;
        return (A)this;
    }

    public boolean hasActive() {
        return this.active != null;
    }

    public String getCompletedIndexes() {
        return this.completedIndexes;
    }

    public A withCompletedIndexes(String completedIndexes) {
        this.completedIndexes = completedIndexes;
        return (A)this;
    }

    public boolean hasCompletedIndexes() {
        return this.completedIndexes != null;
    }

    public String getCompletionTime() {
        return this.completionTime;
    }

    public A withCompletionTime(String completionTime) {
        this.completionTime = completionTime;
        return (A)this;
    }

    public boolean hasCompletionTime() {
        return this.completionTime != null;
    }

    public A addToConditions(int index, JobCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        JobConditionBuilder builder = new JobConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, JobCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        JobConditionBuilder builder = new JobConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(JobCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (JobCondition item : items) {
            JobConditionBuilder builder = new JobConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<JobCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (JobCondition item : items) {
            JobConditionBuilder builder = new JobConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(JobCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (JobCondition item : items) {
            JobConditionBuilder builder = new JobConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<JobCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (JobCondition item : items) {
            JobConditionBuilder builder = new JobConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<JobConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<JobConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            JobConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<JobCondition> buildConditions() {
        return this.conditions != null ? JobStatusFluent.build(this.conditions) : null;
    }

    public JobCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public JobCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public JobCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public JobCondition buildMatchingCondition(Predicate<JobConditionBuilder> predicate) {
        for (JobConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<JobConditionBuilder> predicate) {
        for (JobConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<JobCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (JobCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(JobCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (JobCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(JobCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, JobCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<JobConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public Integer getFailed() {
        return this.failed;
    }

    public A withFailed(Integer failed) {
        this.failed = failed;
        return (A)this;
    }

    public boolean hasFailed() {
        return this.failed != null;
    }

    public String getFailedIndexes() {
        return this.failedIndexes;
    }

    public A withFailedIndexes(String failedIndexes) {
        this.failedIndexes = failedIndexes;
        return (A)this;
    }

    public boolean hasFailedIndexes() {
        return this.failedIndexes != null;
    }

    public Integer getReady() {
        return this.ready;
    }

    public A withReady(Integer ready) {
        this.ready = ready;
        return (A)this;
    }

    public boolean hasReady() {
        return this.ready != null;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public A withStartTime(String startTime) {
        this.startTime = startTime;
        return (A)this;
    }

    public boolean hasStartTime() {
        return this.startTime != null;
    }

    public Integer getSucceeded() {
        return this.succeeded;
    }

    public A withSucceeded(Integer succeeded) {
        this.succeeded = succeeded;
        return (A)this;
    }

    public boolean hasSucceeded() {
        return this.succeeded != null;
    }

    public Integer getTerminating() {
        return this.terminating;
    }

    public A withTerminating(Integer terminating) {
        this.terminating = terminating;
        return (A)this;
    }

    public boolean hasTerminating() {
        return this.terminating != null;
    }

    public UncountedTerminatedPods buildUncountedTerminatedPods() {
        return this.uncountedTerminatedPods != null ? this.uncountedTerminatedPods.build() : null;
    }

    public A withUncountedTerminatedPods(UncountedTerminatedPods uncountedTerminatedPods) {
        this._visitables.remove("uncountedTerminatedPods");
        if (uncountedTerminatedPods != null) {
            this.uncountedTerminatedPods = new UncountedTerminatedPodsBuilder(uncountedTerminatedPods);
            this._visitables.get("uncountedTerminatedPods").add(this.uncountedTerminatedPods);
        } else {
            this.uncountedTerminatedPods = null;
            this._visitables.get("uncountedTerminatedPods").remove(this.uncountedTerminatedPods);
        }
        return (A)this;
    }

    public boolean hasUncountedTerminatedPods() {
        return this.uncountedTerminatedPods != null;
    }

    public UncountedTerminatedPodsNested<A> withNewUncountedTerminatedPods() {
        return new UncountedTerminatedPodsNested(null);
    }

    public UncountedTerminatedPodsNested<A> withNewUncountedTerminatedPodsLike(UncountedTerminatedPods item) {
        return new UncountedTerminatedPodsNested(item);
    }

    public UncountedTerminatedPodsNested<A> editUncountedTerminatedPods() {
        return this.withNewUncountedTerminatedPodsLike(Optional.ofNullable(this.buildUncountedTerminatedPods()).orElse(null));
    }

    public UncountedTerminatedPodsNested<A> editOrNewUncountedTerminatedPods() {
        return this.withNewUncountedTerminatedPodsLike(Optional.ofNullable(this.buildUncountedTerminatedPods()).orElse(new UncountedTerminatedPodsBuilder().build()));
    }

    public UncountedTerminatedPodsNested<A> editOrNewUncountedTerminatedPodsLike(UncountedTerminatedPods item) {
        return this.withNewUncountedTerminatedPodsLike(Optional.ofNullable(this.buildUncountedTerminatedPods()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JobStatusFluent that = (JobStatusFluent)o;
        if (!Objects.equals(this.active, that.active)) {
            return false;
        }
        if (!Objects.equals(this.completedIndexes, that.completedIndexes)) {
            return false;
        }
        if (!Objects.equals(this.completionTime, that.completionTime)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.failed, that.failed)) {
            return false;
        }
        if (!Objects.equals(this.failedIndexes, that.failedIndexes)) {
            return false;
        }
        if (!Objects.equals(this.ready, that.ready)) {
            return false;
        }
        if (!Objects.equals(this.startTime, that.startTime)) {
            return false;
        }
        if (!Objects.equals(this.succeeded, that.succeeded)) {
            return false;
        }
        if (!Objects.equals(this.terminating, that.terminating)) {
            return false;
        }
        if (!Objects.equals(this.uncountedTerminatedPods, that.uncountedTerminatedPods)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.active, this.completedIndexes, this.completionTime, this.conditions, this.failed, this.failedIndexes, this.ready, this.startTime, this.succeeded, this.terminating, this.uncountedTerminatedPods, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.active != null) {
            sb.append("active:");
            sb.append(this.active + ",");
        }
        if (this.completedIndexes != null) {
            sb.append("completedIndexes:");
            sb.append(this.completedIndexes + ",");
        }
        if (this.completionTime != null) {
            sb.append("completionTime:");
            sb.append(this.completionTime + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.failed != null) {
            sb.append("failed:");
            sb.append(this.failed + ",");
        }
        if (this.failedIndexes != null) {
            sb.append("failedIndexes:");
            sb.append(this.failedIndexes + ",");
        }
        if (this.ready != null) {
            sb.append("ready:");
            sb.append(this.ready + ",");
        }
        if (this.startTime != null) {
            sb.append("startTime:");
            sb.append(this.startTime + ",");
        }
        if (this.succeeded != null) {
            sb.append("succeeded:");
            sb.append(this.succeeded + ",");
        }
        if (this.terminating != null) {
            sb.append("terminating:");
            sb.append(this.terminating + ",");
        }
        if (this.uncountedTerminatedPods != null) {
            sb.append("uncountedTerminatedPods:");
            sb.append(this.uncountedTerminatedPods + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class UncountedTerminatedPodsNested<N>
    extends UncountedTerminatedPodsFluent<UncountedTerminatedPodsNested<N>>
    implements Nested<N> {
        UncountedTerminatedPodsBuilder builder;

        UncountedTerminatedPodsNested(UncountedTerminatedPods item) {
            this.builder = new UncountedTerminatedPodsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)JobStatusFluent.this.withUncountedTerminatedPods(this.builder.build());
        }

        public N endUncountedTerminatedPods() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends JobConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        JobConditionBuilder builder;
        int index;

        ConditionsNested(int index, JobCondition item) {
            this.index = index;
            this.builder = new JobConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)JobStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

