/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_10.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.v6_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_10.Nested;
import io.fabric8.kubernetes.api.model.v6_10.apiextensions.v1.CustomResourceColumnDefinition;
import io.fabric8.kubernetes.api.model.v6_10.apiextensions.v1.CustomResourceColumnDefinitionBuilder;
import io.fabric8.kubernetes.api.model.v6_10.apiextensions.v1.CustomResourceColumnDefinitionFluent;
import io.fabric8.kubernetes.api.model.v6_10.apiextensions.v1.CustomResourceDefinitionVersion;
import io.fabric8.kubernetes.api.model.v6_10.apiextensions.v1.CustomResourceSubresources;
import io.fabric8.kubernetes.api.model.v6_10.apiextensions.v1.CustomResourceSubresourcesBuilder;
import io.fabric8.kubernetes.api.model.v6_10.apiextensions.v1.CustomResourceSubresourcesFluent;
import io.fabric8.kubernetes.api.model.v6_10.apiextensions.v1.CustomResourceValidation;
import io.fabric8.kubernetes.api.model.v6_10.apiextensions.v1.CustomResourceValidationBuilder;
import io.fabric8.kubernetes.api.model.v6_10.apiextensions.v1.CustomResourceValidationFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class CustomResourceDefinitionVersionFluent<A extends CustomResourceDefinitionVersionFluent<A>>
extends BaseFluent<A> {
    private ArrayList<CustomResourceColumnDefinitionBuilder> additionalPrinterColumns = new ArrayList();
    private Boolean deprecated;
    private String deprecationWarning;
    private String name;
    private CustomResourceValidationBuilder schema;
    private Boolean served;
    private Boolean storage;
    private CustomResourceSubresourcesBuilder subresources;
    private Map<String, Object> additionalProperties;

    public CustomResourceDefinitionVersionFluent() {
    }

    public CustomResourceDefinitionVersionFluent(CustomResourceDefinitionVersion instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CustomResourceDefinitionVersion instance) {
        CustomResourceDefinitionVersion customResourceDefinitionVersion = instance = instance != null ? instance : new CustomResourceDefinitionVersion();
        if (instance != null) {
            this.withAdditionalPrinterColumns(instance.getAdditionalPrinterColumns());
            this.withDeprecated(instance.getDeprecated());
            this.withDeprecationWarning(instance.getDeprecationWarning());
            this.withName(instance.getName());
            this.withSchema(instance.getSchema());
            this.withServed(instance.getServed());
            this.withStorage(instance.getStorage());
            this.withSubresources(instance.getSubresources());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAdditionalPrinterColumns(int index, CustomResourceColumnDefinition item) {
        if (this.additionalPrinterColumns == null) {
            this.additionalPrinterColumns = new ArrayList();
        }
        CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);
        if (index < 0 || index >= this.additionalPrinterColumns.size()) {
            this._visitables.get("additionalPrinterColumns").add(builder);
            this.additionalPrinterColumns.add(builder);
        } else {
            this._visitables.get("additionalPrinterColumns").add(index, builder);
            this.additionalPrinterColumns.add(index, builder);
        }
        return (A)this;
    }

    public A setToAdditionalPrinterColumns(int index, CustomResourceColumnDefinition item) {
        if (this.additionalPrinterColumns == null) {
            this.additionalPrinterColumns = new ArrayList();
        }
        CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);
        if (index < 0 || index >= this.additionalPrinterColumns.size()) {
            this._visitables.get("additionalPrinterColumns").add(builder);
            this.additionalPrinterColumns.add(builder);
        } else {
            this._visitables.get("additionalPrinterColumns").set(index, builder);
            this.additionalPrinterColumns.set(index, builder);
        }
        return (A)this;
    }

    public A addToAdditionalPrinterColumns(CustomResourceColumnDefinition ... items) {
        if (this.additionalPrinterColumns == null) {
            this.additionalPrinterColumns = new ArrayList();
        }
        for (CustomResourceColumnDefinition item : items) {
            CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);
            this._visitables.get("additionalPrinterColumns").add(builder);
            this.additionalPrinterColumns.add(builder);
        }
        return (A)this;
    }

    public A addAllToAdditionalPrinterColumns(Collection<CustomResourceColumnDefinition> items) {
        if (this.additionalPrinterColumns == null) {
            this.additionalPrinterColumns = new ArrayList();
        }
        for (CustomResourceColumnDefinition item : items) {
            CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);
            this._visitables.get("additionalPrinterColumns").add(builder);
            this.additionalPrinterColumns.add(builder);
        }
        return (A)this;
    }

    public A removeFromAdditionalPrinterColumns(CustomResourceColumnDefinition ... items) {
        if (this.additionalPrinterColumns == null) {
            return (A)this;
        }
        for (CustomResourceColumnDefinition item : items) {
            CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);
            this._visitables.get("additionalPrinterColumns").remove(builder);
            this.additionalPrinterColumns.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromAdditionalPrinterColumns(Collection<CustomResourceColumnDefinition> items) {
        if (this.additionalPrinterColumns == null) {
            return (A)this;
        }
        for (CustomResourceColumnDefinition item : items) {
            CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);
            this._visitables.get("additionalPrinterColumns").remove(builder);
            this.additionalPrinterColumns.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromAdditionalPrinterColumns(Predicate<CustomResourceColumnDefinitionBuilder> predicate) {
        if (this.additionalPrinterColumns == null) {
            return (A)this;
        }
        Iterator<CustomResourceColumnDefinitionBuilder> each = this.additionalPrinterColumns.iterator();
        Object visitables = this._visitables.get("additionalPrinterColumns");
        while (each.hasNext()) {
            CustomResourceColumnDefinitionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<CustomResourceColumnDefinition> buildAdditionalPrinterColumns() {
        return this.additionalPrinterColumns != null ? CustomResourceDefinitionVersionFluent.build(this.additionalPrinterColumns) : null;
    }

    public CustomResourceColumnDefinition buildAdditionalPrinterColumn(int index) {
        return this.additionalPrinterColumns.get(index).build();
    }

    public CustomResourceColumnDefinition buildFirstAdditionalPrinterColumn() {
        return this.additionalPrinterColumns.get(0).build();
    }

    public CustomResourceColumnDefinition buildLastAdditionalPrinterColumn() {
        return this.additionalPrinterColumns.get(this.additionalPrinterColumns.size() - 1).build();
    }

    public CustomResourceColumnDefinition buildMatchingAdditionalPrinterColumn(Predicate<CustomResourceColumnDefinitionBuilder> predicate) {
        for (CustomResourceColumnDefinitionBuilder item : this.additionalPrinterColumns) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAdditionalPrinterColumn(Predicate<CustomResourceColumnDefinitionBuilder> predicate) {
        for (CustomResourceColumnDefinitionBuilder item : this.additionalPrinterColumns) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAdditionalPrinterColumns(List<CustomResourceColumnDefinition> additionalPrinterColumns) {
        if (this.additionalPrinterColumns != null) {
            this._visitables.get("additionalPrinterColumns").clear();
        }
        if (additionalPrinterColumns != null) {
            this.additionalPrinterColumns = new ArrayList();
            for (CustomResourceColumnDefinition item : additionalPrinterColumns) {
                this.addToAdditionalPrinterColumns(item);
            }
        } else {
            this.additionalPrinterColumns = null;
        }
        return (A)this;
    }

    public A withAdditionalPrinterColumns(CustomResourceColumnDefinition ... additionalPrinterColumns) {
        if (this.additionalPrinterColumns != null) {
            this.additionalPrinterColumns.clear();
            this._visitables.remove("additionalPrinterColumns");
        }
        if (additionalPrinterColumns != null) {
            for (CustomResourceColumnDefinition item : additionalPrinterColumns) {
                this.addToAdditionalPrinterColumns(item);
            }
        }
        return (A)this;
    }

    public boolean hasAdditionalPrinterColumns() {
        return this.additionalPrinterColumns != null && !this.additionalPrinterColumns.isEmpty();
    }

    public AdditionalPrinterColumnsNested<A> addNewAdditionalPrinterColumn() {
        return new AdditionalPrinterColumnsNested(-1, null);
    }

    public AdditionalPrinterColumnsNested<A> addNewAdditionalPrinterColumnLike(CustomResourceColumnDefinition item) {
        return new AdditionalPrinterColumnsNested(-1, item);
    }

    public AdditionalPrinterColumnsNested<A> setNewAdditionalPrinterColumnLike(int index, CustomResourceColumnDefinition item) {
        return new AdditionalPrinterColumnsNested(index, item);
    }

    public AdditionalPrinterColumnsNested<A> editAdditionalPrinterColumn(int index) {
        if (this.additionalPrinterColumns.size() <= index) {
            throw new RuntimeException("Can't edit additionalPrinterColumns. Index exceeds size.");
        }
        return this.setNewAdditionalPrinterColumnLike(index, this.buildAdditionalPrinterColumn(index));
    }

    public AdditionalPrinterColumnsNested<A> editFirstAdditionalPrinterColumn() {
        if (this.additionalPrinterColumns.size() == 0) {
            throw new RuntimeException("Can't edit first additionalPrinterColumns. The list is empty.");
        }
        return this.setNewAdditionalPrinterColumnLike(0, this.buildAdditionalPrinterColumn(0));
    }

    public AdditionalPrinterColumnsNested<A> editLastAdditionalPrinterColumn() {
        int index = this.additionalPrinterColumns.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last additionalPrinterColumns. The list is empty.");
        }
        return this.setNewAdditionalPrinterColumnLike(index, this.buildAdditionalPrinterColumn(index));
    }

    public AdditionalPrinterColumnsNested<A> editMatchingAdditionalPrinterColumn(Predicate<CustomResourceColumnDefinitionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.additionalPrinterColumns.size(); ++i) {
            if (!predicate.test(this.additionalPrinterColumns.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching additionalPrinterColumns. No match found.");
        }
        return this.setNewAdditionalPrinterColumnLike(index, this.buildAdditionalPrinterColumn(index));
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public A withDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
        return (A)this;
    }

    public boolean hasDeprecated() {
        return this.deprecated != null;
    }

    public String getDeprecationWarning() {
        return this.deprecationWarning;
    }

    public A withDeprecationWarning(String deprecationWarning) {
        this.deprecationWarning = deprecationWarning;
        return (A)this;
    }

    public boolean hasDeprecationWarning() {
        return this.deprecationWarning != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public CustomResourceValidation buildSchema() {
        return this.schema != null ? this.schema.build() : null;
    }

    public A withSchema(CustomResourceValidation schema) {
        this._visitables.remove("schema");
        if (schema != null) {
            this.schema = new CustomResourceValidationBuilder(schema);
            this._visitables.get("schema").add(this.schema);
        } else {
            this.schema = null;
            this._visitables.get("schema").remove(this.schema);
        }
        return (A)this;
    }

    public boolean hasSchema() {
        return this.schema != null;
    }

    public SchemaNested<A> withNewSchema() {
        return new SchemaNested(null);
    }

    public SchemaNested<A> withNewSchemaLike(CustomResourceValidation item) {
        return new SchemaNested(item);
    }

    public SchemaNested<A> editSchema() {
        return this.withNewSchemaLike(Optional.ofNullable(this.buildSchema()).orElse(null));
    }

    public SchemaNested<A> editOrNewSchema() {
        return this.withNewSchemaLike(Optional.ofNullable(this.buildSchema()).orElse(new CustomResourceValidationBuilder().build()));
    }

    public SchemaNested<A> editOrNewSchemaLike(CustomResourceValidation item) {
        return this.withNewSchemaLike(Optional.ofNullable(this.buildSchema()).orElse(item));
    }

    public Boolean getServed() {
        return this.served;
    }

    public A withServed(Boolean served) {
        this.served = served;
        return (A)this;
    }

    public boolean hasServed() {
        return this.served != null;
    }

    public Boolean getStorage() {
        return this.storage;
    }

    public A withStorage(Boolean storage) {
        this.storage = storage;
        return (A)this;
    }

    public boolean hasStorage() {
        return this.storage != null;
    }

    public CustomResourceSubresources buildSubresources() {
        return this.subresources != null ? this.subresources.build() : null;
    }

    public A withSubresources(CustomResourceSubresources subresources) {
        this._visitables.remove("subresources");
        if (subresources != null) {
            this.subresources = new CustomResourceSubresourcesBuilder(subresources);
            this._visitables.get("subresources").add(this.subresources);
        } else {
            this.subresources = null;
            this._visitables.get("subresources").remove(this.subresources);
        }
        return (A)this;
    }

    public boolean hasSubresources() {
        return this.subresources != null;
    }

    public SubresourcesNested<A> withNewSubresources() {
        return new SubresourcesNested(null);
    }

    public SubresourcesNested<A> withNewSubresourcesLike(CustomResourceSubresources item) {
        return new SubresourcesNested(item);
    }

    public SubresourcesNested<A> editSubresources() {
        return this.withNewSubresourcesLike(Optional.ofNullable(this.buildSubresources()).orElse(null));
    }

    public SubresourcesNested<A> editOrNewSubresources() {
        return this.withNewSubresourcesLike(Optional.ofNullable(this.buildSubresources()).orElse(new CustomResourceSubresourcesBuilder().build()));
    }

    public SubresourcesNested<A> editOrNewSubresourcesLike(CustomResourceSubresources item) {
        return this.withNewSubresourcesLike(Optional.ofNullable(this.buildSubresources()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomResourceDefinitionVersionFluent that = (CustomResourceDefinitionVersionFluent)o;
        if (!Objects.equals(this.additionalPrinterColumns, that.additionalPrinterColumns)) {
            return false;
        }
        if (!Objects.equals(this.deprecated, that.deprecated)) {
            return false;
        }
        if (!Objects.equals(this.deprecationWarning, that.deprecationWarning)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.schema, that.schema)) {
            return false;
        }
        if (!Objects.equals(this.served, that.served)) {
            return false;
        }
        if (!Objects.equals(this.storage, that.storage)) {
            return false;
        }
        if (!Objects.equals(this.subresources, that.subresources)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.additionalPrinterColumns, this.deprecated, this.deprecationWarning, this.name, this.schema, this.served, this.storage, this.subresources, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.additionalPrinterColumns != null && !this.additionalPrinterColumns.isEmpty()) {
            sb.append("additionalPrinterColumns:");
            sb.append(this.additionalPrinterColumns + ",");
        }
        if (this.deprecated != null) {
            sb.append("deprecated:");
            sb.append(this.deprecated + ",");
        }
        if (this.deprecationWarning != null) {
            sb.append("deprecationWarning:");
            sb.append(this.deprecationWarning + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.schema != null) {
            sb.append("schema:");
            sb.append(this.schema + ",");
        }
        if (this.served != null) {
            sb.append("served:");
            sb.append(this.served + ",");
        }
        if (this.storage != null) {
            sb.append("storage:");
            sb.append(this.storage + ",");
        }
        if (this.subresources != null) {
            sb.append("subresources:");
            sb.append(this.subresources + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withDeprecated() {
        return this.withDeprecated(true);
    }

    public A withServed() {
        return this.withServed(true);
    }

    public A withStorage() {
        return this.withStorage(true);
    }

    public class SubresourcesNested<N>
    extends CustomResourceSubresourcesFluent<SubresourcesNested<N>>
    implements Nested<N> {
        CustomResourceSubresourcesBuilder builder;

        SubresourcesNested(CustomResourceSubresources item) {
            this.builder = new CustomResourceSubresourcesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CustomResourceDefinitionVersionFluent.this.withSubresources(this.builder.build());
        }

        public N endSubresources() {
            return this.and();
        }
    }

    public class SchemaNested<N>
    extends CustomResourceValidationFluent<SchemaNested<N>>
    implements Nested<N> {
        CustomResourceValidationBuilder builder;

        SchemaNested(CustomResourceValidation item) {
            this.builder = new CustomResourceValidationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CustomResourceDefinitionVersionFluent.this.withSchema(this.builder.build());
        }

        public N endSchema() {
            return this.and();
        }
    }

    public class AdditionalPrinterColumnsNested<N>
    extends CustomResourceColumnDefinitionFluent<AdditionalPrinterColumnsNested<N>>
    implements Nested<N> {
        CustomResourceColumnDefinitionBuilder builder;
        int index;

        AdditionalPrinterColumnsNested(int index, CustomResourceColumnDefinition item) {
            this.index = index;
            this.builder = new CustomResourceColumnDefinitionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CustomResourceDefinitionVersionFluent.this.setToAdditionalPrinterColumns(this.index, this.builder.build());
        }

        public N endAdditionalPrinterColumn() {
            return this.and();
        }
    }
}

