/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_10;

import io.fabric8.kubernetes.api.builder.v6_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_10.Nested;
import io.fabric8.kubernetes.api.model.v6_10.Affinity;
import io.fabric8.kubernetes.api.model.v6_10.AffinityBuilder;
import io.fabric8.kubernetes.api.model.v6_10.AffinityFluent;
import io.fabric8.kubernetes.api.model.v6_10.Container;
import io.fabric8.kubernetes.api.model.v6_10.ContainerBuilder;
import io.fabric8.kubernetes.api.model.v6_10.ContainerFluent;
import io.fabric8.kubernetes.api.model.v6_10.EphemeralContainer;
import io.fabric8.kubernetes.api.model.v6_10.EphemeralContainerBuilder;
import io.fabric8.kubernetes.api.model.v6_10.EphemeralContainerFluent;
import io.fabric8.kubernetes.api.model.v6_10.HostAlias;
import io.fabric8.kubernetes.api.model.v6_10.HostAliasBuilder;
import io.fabric8.kubernetes.api.model.v6_10.HostAliasFluent;
import io.fabric8.kubernetes.api.model.v6_10.LocalObjectReference;
import io.fabric8.kubernetes.api.model.v6_10.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_10.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.v6_10.PodDNSConfig;
import io.fabric8.kubernetes.api.model.v6_10.PodDNSConfigBuilder;
import io.fabric8.kubernetes.api.model.v6_10.PodDNSConfigFluent;
import io.fabric8.kubernetes.api.model.v6_10.PodOS;
import io.fabric8.kubernetes.api.model.v6_10.PodOSBuilder;
import io.fabric8.kubernetes.api.model.v6_10.PodOSFluent;
import io.fabric8.kubernetes.api.model.v6_10.PodReadinessGate;
import io.fabric8.kubernetes.api.model.v6_10.PodReadinessGateBuilder;
import io.fabric8.kubernetes.api.model.v6_10.PodReadinessGateFluent;
import io.fabric8.kubernetes.api.model.v6_10.PodResourceClaim;
import io.fabric8.kubernetes.api.model.v6_10.PodResourceClaimBuilder;
import io.fabric8.kubernetes.api.model.v6_10.PodResourceClaimFluent;
import io.fabric8.kubernetes.api.model.v6_10.PodSchedulingGate;
import io.fabric8.kubernetes.api.model.v6_10.PodSchedulingGateBuilder;
import io.fabric8.kubernetes.api.model.v6_10.PodSchedulingGateFluent;
import io.fabric8.kubernetes.api.model.v6_10.PodSecurityContext;
import io.fabric8.kubernetes.api.model.v6_10.PodSecurityContextBuilder;
import io.fabric8.kubernetes.api.model.v6_10.PodSecurityContextFluent;
import io.fabric8.kubernetes.api.model.v6_10.PodSpec;
import io.fabric8.kubernetes.api.model.v6_10.Quantity;
import io.fabric8.kubernetes.api.model.v6_10.Toleration;
import io.fabric8.kubernetes.api.model.v6_10.TolerationBuilder;
import io.fabric8.kubernetes.api.model.v6_10.TolerationFluent;
import io.fabric8.kubernetes.api.model.v6_10.TopologySpreadConstraint;
import io.fabric8.kubernetes.api.model.v6_10.TopologySpreadConstraintBuilder;
import io.fabric8.kubernetes.api.model.v6_10.TopologySpreadConstraintFluent;
import io.fabric8.kubernetes.api.model.v6_10.Volume;
import io.fabric8.kubernetes.api.model.v6_10.VolumeBuilder;
import io.fabric8.kubernetes.api.model.v6_10.VolumeFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PodSpecFluent<A extends PodSpecFluent<A>>
extends BaseFluent<A> {
    private Long activeDeadlineSeconds;
    private AffinityBuilder affinity;
    private Boolean automountServiceAccountToken;
    private ArrayList<ContainerBuilder> containers = new ArrayList();
    private PodDNSConfigBuilder dnsConfig;
    private String dnsPolicy;
    private Boolean enableServiceLinks;
    private ArrayList<EphemeralContainerBuilder> ephemeralContainers = new ArrayList();
    private ArrayList<HostAliasBuilder> hostAliases = new ArrayList();
    private Boolean hostIPC;
    private Boolean hostNetwork;
    private Boolean hostPID;
    private Boolean hostUsers;
    private String hostname;
    private ArrayList<LocalObjectReferenceBuilder> imagePullSecrets = new ArrayList();
    private ArrayList<ContainerBuilder> initContainers = new ArrayList();
    private String nodeName;
    private Map<String, String> nodeSelector;
    private PodOSBuilder os;
    private Map<String, Quantity> overhead;
    private String preemptionPolicy;
    private Integer priority;
    private String priorityClassName;
    private ArrayList<PodReadinessGateBuilder> readinessGates = new ArrayList();
    private ArrayList<PodResourceClaimBuilder> resourceClaims = new ArrayList();
    private String restartPolicy;
    private String runtimeClassName;
    private String schedulerName;
    private ArrayList<PodSchedulingGateBuilder> schedulingGates = new ArrayList();
    private PodSecurityContextBuilder securityContext;
    private String serviceAccount;
    private String serviceAccountName;
    private Boolean setHostnameAsFQDN;
    private Boolean shareProcessNamespace;
    private String subdomain;
    private Long terminationGracePeriodSeconds;
    private ArrayList<TolerationBuilder> tolerations = new ArrayList();
    private ArrayList<TopologySpreadConstraintBuilder> topologySpreadConstraints = new ArrayList();
    private ArrayList<VolumeBuilder> volumes = new ArrayList();
    private Map<String, Object> additionalProperties;

    public PodSpecFluent() {
    }

    public PodSpecFluent(PodSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PodSpec instance) {
        PodSpec podSpec = instance = instance != null ? instance : new PodSpec();
        if (instance != null) {
            this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
            this.withAffinity(instance.getAffinity());
            this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
            this.withContainers(instance.getContainers());
            this.withDnsConfig(instance.getDnsConfig());
            this.withDnsPolicy(instance.getDnsPolicy());
            this.withEnableServiceLinks(instance.getEnableServiceLinks());
            this.withEphemeralContainers(instance.getEphemeralContainers());
            this.withHostAliases(instance.getHostAliases());
            this.withHostIPC(instance.getHostIPC());
            this.withHostNetwork(instance.getHostNetwork());
            this.withHostPID(instance.getHostPID());
            this.withHostUsers(instance.getHostUsers());
            this.withHostname(instance.getHostname());
            this.withImagePullSecrets(instance.getImagePullSecrets());
            this.withInitContainers(instance.getInitContainers());
            this.withNodeName(instance.getNodeName());
            this.withNodeSelector(instance.getNodeSelector());
            this.withOs(instance.getOs());
            this.withOverhead(instance.getOverhead());
            this.withPreemptionPolicy(instance.getPreemptionPolicy());
            this.withPriority(instance.getPriority());
            this.withPriorityClassName(instance.getPriorityClassName());
            this.withReadinessGates(instance.getReadinessGates());
            this.withResourceClaims(instance.getResourceClaims());
            this.withRestartPolicy(instance.getRestartPolicy());
            this.withRuntimeClassName(instance.getRuntimeClassName());
            this.withSchedulerName(instance.getSchedulerName());
            this.withSchedulingGates(instance.getSchedulingGates());
            this.withSecurityContext(instance.getSecurityContext());
            this.withServiceAccount(instance.getServiceAccount());
            this.withServiceAccountName(instance.getServiceAccountName());
            this.withSetHostnameAsFQDN(instance.getSetHostnameAsFQDN());
            this.withShareProcessNamespace(instance.getShareProcessNamespace());
            this.withSubdomain(instance.getSubdomain());
            this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
            this.withTolerations(instance.getTolerations());
            this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
            this.withVolumes(instance.getVolumes());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        return (A)this;
    }

    public boolean hasActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds != null;
    }

    public Affinity buildAffinity() {
        return this.affinity != null ? this.affinity.build() : null;
    }

    public A withAffinity(Affinity affinity) {
        this._visitables.remove("affinity");
        if (affinity != null) {
            this.affinity = new AffinityBuilder(affinity);
            this._visitables.get("affinity").add(this.affinity);
        } else {
            this.affinity = null;
            this._visitables.get("affinity").remove(this.affinity);
        }
        return (A)this;
    }

    public boolean hasAffinity() {
        return this.affinity != null;
    }

    public AffinityNested<A> withNewAffinity() {
        return new AffinityNested(null);
    }

    public AffinityNested<A> withNewAffinityLike(Affinity item) {
        return new AffinityNested(item);
    }

    public AffinityNested<A> editAffinity() {
        return this.withNewAffinityLike(Optional.ofNullable(this.buildAffinity()).orElse(null));
    }

    public AffinityNested<A> editOrNewAffinity() {
        return this.withNewAffinityLike(Optional.ofNullable(this.buildAffinity()).orElse(new AffinityBuilder().build()));
    }

    public AffinityNested<A> editOrNewAffinityLike(Affinity item) {
        return this.withNewAffinityLike(Optional.ofNullable(this.buildAffinity()).orElse(item));
    }

    public Boolean getAutomountServiceAccountToken() {
        return this.automountServiceAccountToken;
    }

    public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken) {
        this.automountServiceAccountToken = automountServiceAccountToken;
        return (A)this;
    }

    public boolean hasAutomountServiceAccountToken() {
        return this.automountServiceAccountToken != null;
    }

    public A addToContainers(int index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this.containers.size()) {
            this._visitables.get("containers").add(builder);
            this.containers.add(builder);
        } else {
            this._visitables.get("containers").add(index, builder);
            this.containers.add(index, builder);
        }
        return (A)this;
    }

    public A setToContainers(int index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this.containers.size()) {
            this._visitables.get("containers").add(builder);
            this.containers.add(builder);
        } else {
            this._visitables.get("containers").set(index, builder);
            this.containers.set(index, builder);
        }
        return (A)this;
    }

    public A addToContainers(Container ... items) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    public A addAllToContainers(Collection<Container> items) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    public A removeFromContainers(Container ... items) {
        if (this.containers == null) {
            return (A)this;
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("containers").remove(builder);
            this.containers.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromContainers(Collection<Container> items) {
        if (this.containers == null) {
            return (A)this;
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("containers").remove(builder);
            this.containers.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate) {
        if (this.containers == null) {
            return (A)this;
        }
        Iterator<ContainerBuilder> each = this.containers.iterator();
        Object visitables = this._visitables.get("containers");
        while (each.hasNext()) {
            ContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Container> buildContainers() {
        return this.containers != null ? PodSpecFluent.build(this.containers) : null;
    }

    public Container buildContainer(int index) {
        return this.containers.get(index).build();
    }

    public Container buildFirstContainer() {
        return this.containers.get(0).build();
    }

    public Container buildLastContainer() {
        return this.containers.get(this.containers.size() - 1).build();
    }

    public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withContainers(List<Container> containers) {
        if (this.containers != null) {
            this._visitables.get("containers").clear();
        }
        if (containers != null) {
            this.containers = new ArrayList();
            for (Container item : containers) {
                this.addToContainers(item);
            }
        } else {
            this.containers = null;
        }
        return (A)this;
    }

    public A withContainers(Container ... containers) {
        if (this.containers != null) {
            this.containers.clear();
            this._visitables.remove("containers");
        }
        if (containers != null) {
            for (Container item : containers) {
                this.addToContainers(item);
            }
        }
        return (A)this;
    }

    public boolean hasContainers() {
        return this.containers != null && !this.containers.isEmpty();
    }

    public ContainersNested<A> addNewContainer() {
        return new ContainersNested(-1, null);
    }

    public ContainersNested<A> addNewContainerLike(Container item) {
        return new ContainersNested(-1, item);
    }

    public ContainersNested<A> setNewContainerLike(int index, Container item) {
        return new ContainersNested(index, item);
    }

    public ContainersNested<A> editContainer(int index) {
        if (this.containers.size() <= index) {
            throw new RuntimeException("Can't edit containers. Index exceeds size.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    public ContainersNested<A> editFirstContainer() {
        if (this.containers.size() == 0) {
            throw new RuntimeException("Can't edit first containers. The list is empty.");
        }
        return this.setNewContainerLike(0, this.buildContainer(0));
    }

    public ContainersNested<A> editLastContainer() {
        int index = this.containers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containers. The list is empty.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    public ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containers.size(); ++i) {
            if (!predicate.test(this.containers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containers. No match found.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    public PodDNSConfig buildDnsConfig() {
        return this.dnsConfig != null ? this.dnsConfig.build() : null;
    }

    public A withDnsConfig(PodDNSConfig dnsConfig) {
        this._visitables.remove("dnsConfig");
        if (dnsConfig != null) {
            this.dnsConfig = new PodDNSConfigBuilder(dnsConfig);
            this._visitables.get("dnsConfig").add(this.dnsConfig);
        } else {
            this.dnsConfig = null;
            this._visitables.get("dnsConfig").remove(this.dnsConfig);
        }
        return (A)this;
    }

    public boolean hasDnsConfig() {
        return this.dnsConfig != null;
    }

    public DnsConfigNested<A> withNewDnsConfig() {
        return new DnsConfigNested(null);
    }

    public DnsConfigNested<A> withNewDnsConfigLike(PodDNSConfig item) {
        return new DnsConfigNested(item);
    }

    public DnsConfigNested<A> editDnsConfig() {
        return this.withNewDnsConfigLike(Optional.ofNullable(this.buildDnsConfig()).orElse(null));
    }

    public DnsConfigNested<A> editOrNewDnsConfig() {
        return this.withNewDnsConfigLike(Optional.ofNullable(this.buildDnsConfig()).orElse(new PodDNSConfigBuilder().build()));
    }

    public DnsConfigNested<A> editOrNewDnsConfigLike(PodDNSConfig item) {
        return this.withNewDnsConfigLike(Optional.ofNullable(this.buildDnsConfig()).orElse(item));
    }

    public String getDnsPolicy() {
        return this.dnsPolicy;
    }

    public A withDnsPolicy(String dnsPolicy) {
        this.dnsPolicy = dnsPolicy;
        return (A)this;
    }

    public boolean hasDnsPolicy() {
        return this.dnsPolicy != null;
    }

    public Boolean getEnableServiceLinks() {
        return this.enableServiceLinks;
    }

    public A withEnableServiceLinks(Boolean enableServiceLinks) {
        this.enableServiceLinks = enableServiceLinks;
        return (A)this;
    }

    public boolean hasEnableServiceLinks() {
        return this.enableServiceLinks != null;
    }

    public A addToEphemeralContainers(int index, EphemeralContainer item) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList();
        }
        EphemeralContainerBuilder builder = new EphemeralContainerBuilder(item);
        if (index < 0 || index >= this.ephemeralContainers.size()) {
            this._visitables.get("ephemeralContainers").add(builder);
            this.ephemeralContainers.add(builder);
        } else {
            this._visitables.get("ephemeralContainers").add(index, builder);
            this.ephemeralContainers.add(index, builder);
        }
        return (A)this;
    }

    public A setToEphemeralContainers(int index, EphemeralContainer item) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList();
        }
        EphemeralContainerBuilder builder = new EphemeralContainerBuilder(item);
        if (index < 0 || index >= this.ephemeralContainers.size()) {
            this._visitables.get("ephemeralContainers").add(builder);
            this.ephemeralContainers.add(builder);
        } else {
            this._visitables.get("ephemeralContainers").set(index, builder);
            this.ephemeralContainers.set(index, builder);
        }
        return (A)this;
    }

    public A addToEphemeralContainers(EphemeralContainer ... items) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList();
        }
        for (EphemeralContainer item : items) {
            EphemeralContainerBuilder builder = new EphemeralContainerBuilder(item);
            this._visitables.get("ephemeralContainers").add(builder);
            this.ephemeralContainers.add(builder);
        }
        return (A)this;
    }

    public A addAllToEphemeralContainers(Collection<EphemeralContainer> items) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList();
        }
        for (EphemeralContainer item : items) {
            EphemeralContainerBuilder builder = new EphemeralContainerBuilder(item);
            this._visitables.get("ephemeralContainers").add(builder);
            this.ephemeralContainers.add(builder);
        }
        return (A)this;
    }

    public A removeFromEphemeralContainers(EphemeralContainer ... items) {
        if (this.ephemeralContainers == null) {
            return (A)this;
        }
        for (EphemeralContainer item : items) {
            EphemeralContainerBuilder builder = new EphemeralContainerBuilder(item);
            this._visitables.get("ephemeralContainers").remove(builder);
            this.ephemeralContainers.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromEphemeralContainers(Collection<EphemeralContainer> items) {
        if (this.ephemeralContainers == null) {
            return (A)this;
        }
        for (EphemeralContainer item : items) {
            EphemeralContainerBuilder builder = new EphemeralContainerBuilder(item);
            this._visitables.get("ephemeralContainers").remove(builder);
            this.ephemeralContainers.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromEphemeralContainers(Predicate<EphemeralContainerBuilder> predicate) {
        if (this.ephemeralContainers == null) {
            return (A)this;
        }
        Iterator<EphemeralContainerBuilder> each = this.ephemeralContainers.iterator();
        Object visitables = this._visitables.get("ephemeralContainers");
        while (each.hasNext()) {
            EphemeralContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<EphemeralContainer> buildEphemeralContainers() {
        return this.ephemeralContainers != null ? PodSpecFluent.build(this.ephemeralContainers) : null;
    }

    public EphemeralContainer buildEphemeralContainer(int index) {
        return this.ephemeralContainers.get(index).build();
    }

    public EphemeralContainer buildFirstEphemeralContainer() {
        return this.ephemeralContainers.get(0).build();
    }

    public EphemeralContainer buildLastEphemeralContainer() {
        return this.ephemeralContainers.get(this.ephemeralContainers.size() - 1).build();
    }

    public EphemeralContainer buildMatchingEphemeralContainer(Predicate<EphemeralContainerBuilder> predicate) {
        for (EphemeralContainerBuilder item : this.ephemeralContainers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEphemeralContainer(Predicate<EphemeralContainerBuilder> predicate) {
        for (EphemeralContainerBuilder item : this.ephemeralContainers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEphemeralContainers(List<EphemeralContainer> ephemeralContainers) {
        if (this.ephemeralContainers != null) {
            this._visitables.get("ephemeralContainers").clear();
        }
        if (ephemeralContainers != null) {
            this.ephemeralContainers = new ArrayList();
            for (EphemeralContainer item : ephemeralContainers) {
                this.addToEphemeralContainers(item);
            }
        } else {
            this.ephemeralContainers = null;
        }
        return (A)this;
    }

    public A withEphemeralContainers(EphemeralContainer ... ephemeralContainers) {
        if (this.ephemeralContainers != null) {
            this.ephemeralContainers.clear();
            this._visitables.remove("ephemeralContainers");
        }
        if (ephemeralContainers != null) {
            for (EphemeralContainer item : ephemeralContainers) {
                this.addToEphemeralContainers(item);
            }
        }
        return (A)this;
    }

    public boolean hasEphemeralContainers() {
        return this.ephemeralContainers != null && !this.ephemeralContainers.isEmpty();
    }

    public EphemeralContainersNested<A> addNewEphemeralContainer() {
        return new EphemeralContainersNested(-1, null);
    }

    public EphemeralContainersNested<A> addNewEphemeralContainerLike(EphemeralContainer item) {
        return new EphemeralContainersNested(-1, item);
    }

    public EphemeralContainersNested<A> setNewEphemeralContainerLike(int index, EphemeralContainer item) {
        return new EphemeralContainersNested(index, item);
    }

    public EphemeralContainersNested<A> editEphemeralContainer(int index) {
        if (this.ephemeralContainers.size() <= index) {
            throw new RuntimeException("Can't edit ephemeralContainers. Index exceeds size.");
        }
        return this.setNewEphemeralContainerLike(index, this.buildEphemeralContainer(index));
    }

    public EphemeralContainersNested<A> editFirstEphemeralContainer() {
        if (this.ephemeralContainers.size() == 0) {
            throw new RuntimeException("Can't edit first ephemeralContainers. The list is empty.");
        }
        return this.setNewEphemeralContainerLike(0, this.buildEphemeralContainer(0));
    }

    public EphemeralContainersNested<A> editLastEphemeralContainer() {
        int index = this.ephemeralContainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ephemeralContainers. The list is empty.");
        }
        return this.setNewEphemeralContainerLike(index, this.buildEphemeralContainer(index));
    }

    public EphemeralContainersNested<A> editMatchingEphemeralContainer(Predicate<EphemeralContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ephemeralContainers.size(); ++i) {
            if (!predicate.test(this.ephemeralContainers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ephemeralContainers. No match found.");
        }
        return this.setNewEphemeralContainerLike(index, this.buildEphemeralContainer(index));
    }

    public A addToHostAliases(int index, HostAlias item) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList();
        }
        HostAliasBuilder builder = new HostAliasBuilder(item);
        if (index < 0 || index >= this.hostAliases.size()) {
            this._visitables.get("hostAliases").add(builder);
            this.hostAliases.add(builder);
        } else {
            this._visitables.get("hostAliases").add(index, builder);
            this.hostAliases.add(index, builder);
        }
        return (A)this;
    }

    public A setToHostAliases(int index, HostAlias item) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList();
        }
        HostAliasBuilder builder = new HostAliasBuilder(item);
        if (index < 0 || index >= this.hostAliases.size()) {
            this._visitables.get("hostAliases").add(builder);
            this.hostAliases.add(builder);
        } else {
            this._visitables.get("hostAliases").set(index, builder);
            this.hostAliases.set(index, builder);
        }
        return (A)this;
    }

    public A addToHostAliases(HostAlias ... items) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList();
        }
        for (HostAlias item : items) {
            HostAliasBuilder builder = new HostAliasBuilder(item);
            this._visitables.get("hostAliases").add(builder);
            this.hostAliases.add(builder);
        }
        return (A)this;
    }

    public A addAllToHostAliases(Collection<HostAlias> items) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList();
        }
        for (HostAlias item : items) {
            HostAliasBuilder builder = new HostAliasBuilder(item);
            this._visitables.get("hostAliases").add(builder);
            this.hostAliases.add(builder);
        }
        return (A)this;
    }

    public A removeFromHostAliases(HostAlias ... items) {
        if (this.hostAliases == null) {
            return (A)this;
        }
        for (HostAlias item : items) {
            HostAliasBuilder builder = new HostAliasBuilder(item);
            this._visitables.get("hostAliases").remove(builder);
            this.hostAliases.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromHostAliases(Collection<HostAlias> items) {
        if (this.hostAliases == null) {
            return (A)this;
        }
        for (HostAlias item : items) {
            HostAliasBuilder builder = new HostAliasBuilder(item);
            this._visitables.get("hostAliases").remove(builder);
            this.hostAliases.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromHostAliases(Predicate<HostAliasBuilder> predicate) {
        if (this.hostAliases == null) {
            return (A)this;
        }
        Iterator<HostAliasBuilder> each = this.hostAliases.iterator();
        Object visitables = this._visitables.get("hostAliases");
        while (each.hasNext()) {
            HostAliasBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<HostAlias> buildHostAliases() {
        return this.hostAliases != null ? PodSpecFluent.build(this.hostAliases) : null;
    }

    public HostAlias buildHostAlias(int index) {
        return this.hostAliases.get(index).build();
    }

    public HostAlias buildFirstHostAlias() {
        return this.hostAliases.get(0).build();
    }

    public HostAlias buildLastHostAlias() {
        return this.hostAliases.get(this.hostAliases.size() - 1).build();
    }

    public HostAlias buildMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
        for (HostAliasBuilder item : this.hostAliases) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
        for (HostAliasBuilder item : this.hostAliases) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHostAliases(List<HostAlias> hostAliases) {
        if (this.hostAliases != null) {
            this._visitables.get("hostAliases").clear();
        }
        if (hostAliases != null) {
            this.hostAliases = new ArrayList();
            for (HostAlias item : hostAliases) {
                this.addToHostAliases(item);
            }
        } else {
            this.hostAliases = null;
        }
        return (A)this;
    }

    public A withHostAliases(HostAlias ... hostAliases) {
        if (this.hostAliases != null) {
            this.hostAliases.clear();
            this._visitables.remove("hostAliases");
        }
        if (hostAliases != null) {
            for (HostAlias item : hostAliases) {
                this.addToHostAliases(item);
            }
        }
        return (A)this;
    }

    public boolean hasHostAliases() {
        return this.hostAliases != null && !this.hostAliases.isEmpty();
    }

    public HostAliasesNested<A> addNewHostAlias() {
        return new HostAliasesNested(-1, null);
    }

    public HostAliasesNested<A> addNewHostAliasLike(HostAlias item) {
        return new HostAliasesNested(-1, item);
    }

    public HostAliasesNested<A> setNewHostAliasLike(int index, HostAlias item) {
        return new HostAliasesNested(index, item);
    }

    public HostAliasesNested<A> editHostAlias(int index) {
        if (this.hostAliases.size() <= index) {
            throw new RuntimeException("Can't edit hostAliases. Index exceeds size.");
        }
        return this.setNewHostAliasLike(index, this.buildHostAlias(index));
    }

    public HostAliasesNested<A> editFirstHostAlias() {
        if (this.hostAliases.size() == 0) {
            throw new RuntimeException("Can't edit first hostAliases. The list is empty.");
        }
        return this.setNewHostAliasLike(0, this.buildHostAlias(0));
    }

    public HostAliasesNested<A> editLastHostAlias() {
        int index = this.hostAliases.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last hostAliases. The list is empty.");
        }
        return this.setNewHostAliasLike(index, this.buildHostAlias(index));
    }

    public HostAliasesNested<A> editMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.hostAliases.size(); ++i) {
            if (!predicate.test(this.hostAliases.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching hostAliases. No match found.");
        }
        return this.setNewHostAliasLike(index, this.buildHostAlias(index));
    }

    public Boolean getHostIPC() {
        return this.hostIPC;
    }

    public A withHostIPC(Boolean hostIPC) {
        this.hostIPC = hostIPC;
        return (A)this;
    }

    public boolean hasHostIPC() {
        return this.hostIPC != null;
    }

    public Boolean getHostNetwork() {
        return this.hostNetwork;
    }

    public A withHostNetwork(Boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
        return (A)this;
    }

    public boolean hasHostNetwork() {
        return this.hostNetwork != null;
    }

    public Boolean getHostPID() {
        return this.hostPID;
    }

    public A withHostPID(Boolean hostPID) {
        this.hostPID = hostPID;
        return (A)this;
    }

    public boolean hasHostPID() {
        return this.hostPID != null;
    }

    public Boolean getHostUsers() {
        return this.hostUsers;
    }

    public A withHostUsers(Boolean hostUsers) {
        this.hostUsers = hostUsers;
        return (A)this;
    }

    public boolean hasHostUsers() {
        return this.hostUsers != null;
    }

    public String getHostname() {
        return this.hostname;
    }

    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    public boolean hasHostname() {
        return this.hostname != null;
    }

    public A addToImagePullSecrets(int index, LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this.imagePullSecrets.size()) {
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        } else {
            this._visitables.get("imagePullSecrets").add(index, builder);
            this.imagePullSecrets.add(index, builder);
        }
        return (A)this;
    }

    public A setToImagePullSecrets(int index, LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this.imagePullSecrets.size()) {
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        } else {
            this._visitables.get("imagePullSecrets").set(index, builder);
            this.imagePullSecrets.set(index, builder);
        }
        return (A)this;
    }

    public A addToImagePullSecrets(LocalObjectReference ... items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)this;
    }

    public A addAllToImagePullSecrets(Collection<LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)this;
    }

    public A removeFromImagePullSecrets(LocalObjectReference ... items) {
        if (this.imagePullSecrets == null) {
            return (A)this;
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").remove(builder);
            this.imagePullSecrets.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {
            return (A)this;
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").remove(builder);
            this.imagePullSecrets.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromImagePullSecrets(Predicate<LocalObjectReferenceBuilder> predicate) {
        if (this.imagePullSecrets == null) {
            return (A)this;
        }
        Iterator<LocalObjectReferenceBuilder> each = this.imagePullSecrets.iterator();
        Object visitables = this._visitables.get("imagePullSecrets");
        while (each.hasNext()) {
            LocalObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<LocalObjectReference> buildImagePullSecrets() {
        return this.imagePullSecrets != null ? PodSpecFluent.build(this.imagePullSecrets) : null;
    }

    public LocalObjectReference buildImagePullSecret(int index) {
        return this.imagePullSecrets.get(index).build();
    }

    public LocalObjectReference buildFirstImagePullSecret() {
        return this.imagePullSecrets.get(0).build();
    }

    public LocalObjectReference buildLastImagePullSecret() {
        return this.imagePullSecrets.get(this.imagePullSecrets.size() - 1).build();
    }

    public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item : this.imagePullSecrets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item : this.imagePullSecrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this._visitables.get("imagePullSecrets").clear();
        }
        if (imagePullSecrets != null) {
            this.imagePullSecrets = new ArrayList();
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        } else {
            this.imagePullSecrets = null;
        }
        return (A)this;
    }

    public A withImagePullSecrets(LocalObjectReference ... imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this.imagePullSecrets.clear();
            this._visitables.remove("imagePullSecrets");
        }
        if (imagePullSecrets != null) {
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (A)this;
    }

    public boolean hasImagePullSecrets() {
        return this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty();
    }

    public A addNewImagePullSecret(String name) {
        return this.addToImagePullSecrets(new LocalObjectReference(name));
    }

    public ImagePullSecretsNested<A> addNewImagePullSecret() {
        return new ImagePullSecretsNested(-1, null);
    }

    public ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item) {
        return new ImagePullSecretsNested(-1, item);
    }

    public ImagePullSecretsNested<A> setNewImagePullSecretLike(int index, LocalObjectReference item) {
        return new ImagePullSecretsNested(index, item);
    }

    public ImagePullSecretsNested<A> editImagePullSecret(int index) {
        if (this.imagePullSecrets.size() <= index) {
            throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    public ImagePullSecretsNested<A> editFirstImagePullSecret() {
        if (this.imagePullSecrets.size() == 0) {
            throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
        }
        return this.setNewImagePullSecretLike(0, this.buildImagePullSecret(0));
    }

    public ImagePullSecretsNested<A> editLastImagePullSecret() {
        int index = this.imagePullSecrets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    public ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.imagePullSecrets.size(); ++i) {
            if (!predicate.test(this.imagePullSecrets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    public A addToInitContainers(int index, Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this.initContainers.size()) {
            this._visitables.get("initContainers").add(builder);
            this.initContainers.add(builder);
        } else {
            this._visitables.get("initContainers").add(index, builder);
            this.initContainers.add(index, builder);
        }
        return (A)this;
    }

    public A setToInitContainers(int index, Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this.initContainers.size()) {
            this._visitables.get("initContainers").add(builder);
            this.initContainers.add(builder);
        } else {
            this._visitables.get("initContainers").set(index, builder);
            this.initContainers.set(index, builder);
        }
        return (A)this;
    }

    public A addToInitContainers(Container ... items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)this;
    }

    public A addAllToInitContainers(Collection<Container> items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)this;
    }

    public A removeFromInitContainers(Container ... items) {
        if (this.initContainers == null) {
            return (A)this;
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("initContainers").remove(builder);
            this.initContainers.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromInitContainers(Collection<Container> items) {
        if (this.initContainers == null) {
            return (A)this;
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("initContainers").remove(builder);
            this.initContainers.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate) {
        if (this.initContainers == null) {
            return (A)this;
        }
        Iterator<ContainerBuilder> each = this.initContainers.iterator();
        Object visitables = this._visitables.get("initContainers");
        while (each.hasNext()) {
            ContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Container> buildInitContainers() {
        return this.initContainers != null ? PodSpecFluent.build(this.initContainers) : null;
    }

    public Container buildInitContainer(int index) {
        return this.initContainers.get(index).build();
    }

    public Container buildFirstInitContainer() {
        return this.initContainers.get(0).build();
    }

    public Container buildLastInitContainer() {
        return this.initContainers.get(this.initContainers.size() - 1).build();
    }

    public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.initContainers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.initContainers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withInitContainers(List<Container> initContainers) {
        if (this.initContainers != null) {
            this._visitables.get("initContainers").clear();
        }
        if (initContainers != null) {
            this.initContainers = new ArrayList();
            for (Container item : initContainers) {
                this.addToInitContainers(item);
            }
        } else {
            this.initContainers = null;
        }
        return (A)this;
    }

    public A withInitContainers(Container ... initContainers) {
        if (this.initContainers != null) {
            this.initContainers.clear();
            this._visitables.remove("initContainers");
        }
        if (initContainers != null) {
            for (Container item : initContainers) {
                this.addToInitContainers(item);
            }
        }
        return (A)this;
    }

    public boolean hasInitContainers() {
        return this.initContainers != null && !this.initContainers.isEmpty();
    }

    public InitContainersNested<A> addNewInitContainer() {
        return new InitContainersNested(-1, null);
    }

    public InitContainersNested<A> addNewInitContainerLike(Container item) {
        return new InitContainersNested(-1, item);
    }

    public InitContainersNested<A> setNewInitContainerLike(int index, Container item) {
        return new InitContainersNested(index, item);
    }

    public InitContainersNested<A> editInitContainer(int index) {
        if (this.initContainers.size() <= index) {
            throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    public InitContainersNested<A> editFirstInitContainer() {
        if (this.initContainers.size() == 0) {
            throw new RuntimeException("Can't edit first initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(0, this.buildInitContainer(0));
    }

    public InitContainersNested<A> editLastInitContainer() {
        int index = this.initContainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    public InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.initContainers.size(); ++i) {
            if (!predicate.test(this.initContainers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching initContainers. No match found.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)this;
    }

    public boolean hasNodeName() {
        return this.nodeName != null;
    }

    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)this;
    }

    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)this;
    }

    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)this;
    }

    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)this;
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public PodOS buildOs() {
        return this.os != null ? this.os.build() : null;
    }

    public A withOs(PodOS os) {
        this._visitables.remove("os");
        if (os != null) {
            this.os = new PodOSBuilder(os);
            this._visitables.get("os").add(this.os);
        } else {
            this.os = null;
            this._visitables.get("os").remove(this.os);
        }
        return (A)this;
    }

    public boolean hasOs() {
        return this.os != null;
    }

    public A withNewOs(String name) {
        return this.withOs(new PodOS(name));
    }

    public OsNested<A> withNewOs() {
        return new OsNested(null);
    }

    public OsNested<A> withNewOsLike(PodOS item) {
        return new OsNested(item);
    }

    public OsNested<A> editOs() {
        return this.withNewOsLike(Optional.ofNullable(this.buildOs()).orElse(null));
    }

    public OsNested<A> editOrNewOs() {
        return this.withNewOsLike(Optional.ofNullable(this.buildOs()).orElse(new PodOSBuilder().build()));
    }

    public OsNested<A> editOrNewOsLike(PodOS item) {
        return this.withNewOsLike(Optional.ofNullable(this.buildOs()).orElse(item));
    }

    public A addToOverhead(String key, Quantity value) {
        if (this.overhead == null && key != null && value != null) {
            this.overhead = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.overhead.put(key, value);
        }
        return (A)this;
    }

    public A addToOverhead(Map<String, Quantity> map) {
        if (this.overhead == null && map != null) {
            this.overhead = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.overhead.putAll(map);
        }
        return (A)this;
    }

    public A removeFromOverhead(String key) {
        if (this.overhead == null) {
            return (A)this;
        }
        if (key != null && this.overhead != null) {
            this.overhead.remove(key);
        }
        return (A)this;
    }

    public A removeFromOverhead(Map<String, Quantity> map) {
        if (this.overhead == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.overhead == null) continue;
                this.overhead.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Quantity> getOverhead() {
        return this.overhead;
    }

    public <K, V> A withOverhead(Map<String, Quantity> overhead) {
        this.overhead = overhead == null ? null : new LinkedHashMap<String, Quantity>(overhead);
        return (A)this;
    }

    public boolean hasOverhead() {
        return this.overhead != null;
    }

    public String getPreemptionPolicy() {
        return this.preemptionPolicy;
    }

    public A withPreemptionPolicy(String preemptionPolicy) {
        this.preemptionPolicy = preemptionPolicy;
        return (A)this;
    }

    public boolean hasPreemptionPolicy() {
        return this.preemptionPolicy != null;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public A withPriority(Integer priority) {
        this.priority = priority;
        return (A)this;
    }

    public boolean hasPriority() {
        return this.priority != null;
    }

    public String getPriorityClassName() {
        return this.priorityClassName;
    }

    public A withPriorityClassName(String priorityClassName) {
        this.priorityClassName = priorityClassName;
        return (A)this;
    }

    public boolean hasPriorityClassName() {
        return this.priorityClassName != null;
    }

    public A addToReadinessGates(int index, PodReadinessGate item) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList();
        }
        PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);
        if (index < 0 || index >= this.readinessGates.size()) {
            this._visitables.get("readinessGates").add(builder);
            this.readinessGates.add(builder);
        } else {
            this._visitables.get("readinessGates").add(index, builder);
            this.readinessGates.add(index, builder);
        }
        return (A)this;
    }

    public A setToReadinessGates(int index, PodReadinessGate item) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList();
        }
        PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);
        if (index < 0 || index >= this.readinessGates.size()) {
            this._visitables.get("readinessGates").add(builder);
            this.readinessGates.add(builder);
        } else {
            this._visitables.get("readinessGates").set(index, builder);
            this.readinessGates.set(index, builder);
        }
        return (A)this;
    }

    public A addToReadinessGates(PodReadinessGate ... items) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList();
        }
        for (PodReadinessGate item : items) {
            PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);
            this._visitables.get("readinessGates").add(builder);
            this.readinessGates.add(builder);
        }
        return (A)this;
    }

    public A addAllToReadinessGates(Collection<PodReadinessGate> items) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList();
        }
        for (PodReadinessGate item : items) {
            PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);
            this._visitables.get("readinessGates").add(builder);
            this.readinessGates.add(builder);
        }
        return (A)this;
    }

    public A removeFromReadinessGates(PodReadinessGate ... items) {
        if (this.readinessGates == null) {
            return (A)this;
        }
        for (PodReadinessGate item : items) {
            PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);
            this._visitables.get("readinessGates").remove(builder);
            this.readinessGates.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromReadinessGates(Collection<PodReadinessGate> items) {
        if (this.readinessGates == null) {
            return (A)this;
        }
        for (PodReadinessGate item : items) {
            PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);
            this._visitables.get("readinessGates").remove(builder);
            this.readinessGates.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromReadinessGates(Predicate<PodReadinessGateBuilder> predicate) {
        if (this.readinessGates == null) {
            return (A)this;
        }
        Iterator<PodReadinessGateBuilder> each = this.readinessGates.iterator();
        Object visitables = this._visitables.get("readinessGates");
        while (each.hasNext()) {
            PodReadinessGateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<PodReadinessGate> buildReadinessGates() {
        return this.readinessGates != null ? PodSpecFluent.build(this.readinessGates) : null;
    }

    public PodReadinessGate buildReadinessGate(int index) {
        return this.readinessGates.get(index).build();
    }

    public PodReadinessGate buildFirstReadinessGate() {
        return this.readinessGates.get(0).build();
    }

    public PodReadinessGate buildLastReadinessGate() {
        return this.readinessGates.get(this.readinessGates.size() - 1).build();
    }

    public PodReadinessGate buildMatchingReadinessGate(Predicate<PodReadinessGateBuilder> predicate) {
        for (PodReadinessGateBuilder item : this.readinessGates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingReadinessGate(Predicate<PodReadinessGateBuilder> predicate) {
        for (PodReadinessGateBuilder item : this.readinessGates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withReadinessGates(List<PodReadinessGate> readinessGates) {
        if (this.readinessGates != null) {
            this._visitables.get("readinessGates").clear();
        }
        if (readinessGates != null) {
            this.readinessGates = new ArrayList();
            for (PodReadinessGate item : readinessGates) {
                this.addToReadinessGates(item);
            }
        } else {
            this.readinessGates = null;
        }
        return (A)this;
    }

    public A withReadinessGates(PodReadinessGate ... readinessGates) {
        if (this.readinessGates != null) {
            this.readinessGates.clear();
            this._visitables.remove("readinessGates");
        }
        if (readinessGates != null) {
            for (PodReadinessGate item : readinessGates) {
                this.addToReadinessGates(item);
            }
        }
        return (A)this;
    }

    public boolean hasReadinessGates() {
        return this.readinessGates != null && !this.readinessGates.isEmpty();
    }

    public A addNewReadinessGate(String conditionType) {
        return this.addToReadinessGates(new PodReadinessGate(conditionType));
    }

    public ReadinessGatesNested<A> addNewReadinessGate() {
        return new ReadinessGatesNested(-1, null);
    }

    public ReadinessGatesNested<A> addNewReadinessGateLike(PodReadinessGate item) {
        return new ReadinessGatesNested(-1, item);
    }

    public ReadinessGatesNested<A> setNewReadinessGateLike(int index, PodReadinessGate item) {
        return new ReadinessGatesNested(index, item);
    }

    public ReadinessGatesNested<A> editReadinessGate(int index) {
        if (this.readinessGates.size() <= index) {
            throw new RuntimeException("Can't edit readinessGates. Index exceeds size.");
        }
        return this.setNewReadinessGateLike(index, this.buildReadinessGate(index));
    }

    public ReadinessGatesNested<A> editFirstReadinessGate() {
        if (this.readinessGates.size() == 0) {
            throw new RuntimeException("Can't edit first readinessGates. The list is empty.");
        }
        return this.setNewReadinessGateLike(0, this.buildReadinessGate(0));
    }

    public ReadinessGatesNested<A> editLastReadinessGate() {
        int index = this.readinessGates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last readinessGates. The list is empty.");
        }
        return this.setNewReadinessGateLike(index, this.buildReadinessGate(index));
    }

    public ReadinessGatesNested<A> editMatchingReadinessGate(Predicate<PodReadinessGateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.readinessGates.size(); ++i) {
            if (!predicate.test(this.readinessGates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching readinessGates. No match found.");
        }
        return this.setNewReadinessGateLike(index, this.buildReadinessGate(index));
    }

    public A addToResourceClaims(int index, PodResourceClaim item) {
        if (this.resourceClaims == null) {
            this.resourceClaims = new ArrayList();
        }
        PodResourceClaimBuilder builder = new PodResourceClaimBuilder(item);
        if (index < 0 || index >= this.resourceClaims.size()) {
            this._visitables.get("resourceClaims").add(builder);
            this.resourceClaims.add(builder);
        } else {
            this._visitables.get("resourceClaims").add(index, builder);
            this.resourceClaims.add(index, builder);
        }
        return (A)this;
    }

    public A setToResourceClaims(int index, PodResourceClaim item) {
        if (this.resourceClaims == null) {
            this.resourceClaims = new ArrayList();
        }
        PodResourceClaimBuilder builder = new PodResourceClaimBuilder(item);
        if (index < 0 || index >= this.resourceClaims.size()) {
            this._visitables.get("resourceClaims").add(builder);
            this.resourceClaims.add(builder);
        } else {
            this._visitables.get("resourceClaims").set(index, builder);
            this.resourceClaims.set(index, builder);
        }
        return (A)this;
    }

    public A addToResourceClaims(PodResourceClaim ... items) {
        if (this.resourceClaims == null) {
            this.resourceClaims = new ArrayList();
        }
        for (PodResourceClaim item : items) {
            PodResourceClaimBuilder builder = new PodResourceClaimBuilder(item);
            this._visitables.get("resourceClaims").add(builder);
            this.resourceClaims.add(builder);
        }
        return (A)this;
    }

    public A addAllToResourceClaims(Collection<PodResourceClaim> items) {
        if (this.resourceClaims == null) {
            this.resourceClaims = new ArrayList();
        }
        for (PodResourceClaim item : items) {
            PodResourceClaimBuilder builder = new PodResourceClaimBuilder(item);
            this._visitables.get("resourceClaims").add(builder);
            this.resourceClaims.add(builder);
        }
        return (A)this;
    }

    public A removeFromResourceClaims(PodResourceClaim ... items) {
        if (this.resourceClaims == null) {
            return (A)this;
        }
        for (PodResourceClaim item : items) {
            PodResourceClaimBuilder builder = new PodResourceClaimBuilder(item);
            this._visitables.get("resourceClaims").remove(builder);
            this.resourceClaims.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromResourceClaims(Collection<PodResourceClaim> items) {
        if (this.resourceClaims == null) {
            return (A)this;
        }
        for (PodResourceClaim item : items) {
            PodResourceClaimBuilder builder = new PodResourceClaimBuilder(item);
            this._visitables.get("resourceClaims").remove(builder);
            this.resourceClaims.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromResourceClaims(Predicate<PodResourceClaimBuilder> predicate) {
        if (this.resourceClaims == null) {
            return (A)this;
        }
        Iterator<PodResourceClaimBuilder> each = this.resourceClaims.iterator();
        Object visitables = this._visitables.get("resourceClaims");
        while (each.hasNext()) {
            PodResourceClaimBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<PodResourceClaim> buildResourceClaims() {
        return this.resourceClaims != null ? PodSpecFluent.build(this.resourceClaims) : null;
    }

    public PodResourceClaim buildResourceClaim(int index) {
        return this.resourceClaims.get(index).build();
    }

    public PodResourceClaim buildFirstResourceClaim() {
        return this.resourceClaims.get(0).build();
    }

    public PodResourceClaim buildLastResourceClaim() {
        return this.resourceClaims.get(this.resourceClaims.size() - 1).build();
    }

    public PodResourceClaim buildMatchingResourceClaim(Predicate<PodResourceClaimBuilder> predicate) {
        for (PodResourceClaimBuilder item : this.resourceClaims) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResourceClaim(Predicate<PodResourceClaimBuilder> predicate) {
        for (PodResourceClaimBuilder item : this.resourceClaims) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResourceClaims(List<PodResourceClaim> resourceClaims) {
        if (this.resourceClaims != null) {
            this._visitables.get("resourceClaims").clear();
        }
        if (resourceClaims != null) {
            this.resourceClaims = new ArrayList();
            for (PodResourceClaim item : resourceClaims) {
                this.addToResourceClaims(item);
            }
        } else {
            this.resourceClaims = null;
        }
        return (A)this;
    }

    public A withResourceClaims(PodResourceClaim ... resourceClaims) {
        if (this.resourceClaims != null) {
            this.resourceClaims.clear();
            this._visitables.remove("resourceClaims");
        }
        if (resourceClaims != null) {
            for (PodResourceClaim item : resourceClaims) {
                this.addToResourceClaims(item);
            }
        }
        return (A)this;
    }

    public boolean hasResourceClaims() {
        return this.resourceClaims != null && !this.resourceClaims.isEmpty();
    }

    public ResourceClaimsNested<A> addNewResourceClaim() {
        return new ResourceClaimsNested(-1, null);
    }

    public ResourceClaimsNested<A> addNewResourceClaimLike(PodResourceClaim item) {
        return new ResourceClaimsNested(-1, item);
    }

    public ResourceClaimsNested<A> setNewResourceClaimLike(int index, PodResourceClaim item) {
        return new ResourceClaimsNested(index, item);
    }

    public ResourceClaimsNested<A> editResourceClaim(int index) {
        if (this.resourceClaims.size() <= index) {
            throw new RuntimeException("Can't edit resourceClaims. Index exceeds size.");
        }
        return this.setNewResourceClaimLike(index, this.buildResourceClaim(index));
    }

    public ResourceClaimsNested<A> editFirstResourceClaim() {
        if (this.resourceClaims.size() == 0) {
            throw new RuntimeException("Can't edit first resourceClaims. The list is empty.");
        }
        return this.setNewResourceClaimLike(0, this.buildResourceClaim(0));
    }

    public ResourceClaimsNested<A> editLastResourceClaim() {
        int index = this.resourceClaims.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resourceClaims. The list is empty.");
        }
        return this.setNewResourceClaimLike(index, this.buildResourceClaim(index));
    }

    public ResourceClaimsNested<A> editMatchingResourceClaim(Predicate<PodResourceClaimBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resourceClaims.size(); ++i) {
            if (!predicate.test(this.resourceClaims.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resourceClaims. No match found.");
        }
        return this.setNewResourceClaimLike(index, this.buildResourceClaim(index));
    }

    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public A withRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return (A)this;
    }

    public boolean hasRestartPolicy() {
        return this.restartPolicy != null;
    }

    public String getRuntimeClassName() {
        return this.runtimeClassName;
    }

    public A withRuntimeClassName(String runtimeClassName) {
        this.runtimeClassName = runtimeClassName;
        return (A)this;
    }

    public boolean hasRuntimeClassName() {
        return this.runtimeClassName != null;
    }

    public String getSchedulerName() {
        return this.schedulerName;
    }

    public A withSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
        return (A)this;
    }

    public boolean hasSchedulerName() {
        return this.schedulerName != null;
    }

    public A addToSchedulingGates(int index, PodSchedulingGate item) {
        if (this.schedulingGates == null) {
            this.schedulingGates = new ArrayList();
        }
        PodSchedulingGateBuilder builder = new PodSchedulingGateBuilder(item);
        if (index < 0 || index >= this.schedulingGates.size()) {
            this._visitables.get("schedulingGates").add(builder);
            this.schedulingGates.add(builder);
        } else {
            this._visitables.get("schedulingGates").add(index, builder);
            this.schedulingGates.add(index, builder);
        }
        return (A)this;
    }

    public A setToSchedulingGates(int index, PodSchedulingGate item) {
        if (this.schedulingGates == null) {
            this.schedulingGates = new ArrayList();
        }
        PodSchedulingGateBuilder builder = new PodSchedulingGateBuilder(item);
        if (index < 0 || index >= this.schedulingGates.size()) {
            this._visitables.get("schedulingGates").add(builder);
            this.schedulingGates.add(builder);
        } else {
            this._visitables.get("schedulingGates").set(index, builder);
            this.schedulingGates.set(index, builder);
        }
        return (A)this;
    }

    public A addToSchedulingGates(PodSchedulingGate ... items) {
        if (this.schedulingGates == null) {
            this.schedulingGates = new ArrayList();
        }
        for (PodSchedulingGate item : items) {
            PodSchedulingGateBuilder builder = new PodSchedulingGateBuilder(item);
            this._visitables.get("schedulingGates").add(builder);
            this.schedulingGates.add(builder);
        }
        return (A)this;
    }

    public A addAllToSchedulingGates(Collection<PodSchedulingGate> items) {
        if (this.schedulingGates == null) {
            this.schedulingGates = new ArrayList();
        }
        for (PodSchedulingGate item : items) {
            PodSchedulingGateBuilder builder = new PodSchedulingGateBuilder(item);
            this._visitables.get("schedulingGates").add(builder);
            this.schedulingGates.add(builder);
        }
        return (A)this;
    }

    public A removeFromSchedulingGates(PodSchedulingGate ... items) {
        if (this.schedulingGates == null) {
            return (A)this;
        }
        for (PodSchedulingGate item : items) {
            PodSchedulingGateBuilder builder = new PodSchedulingGateBuilder(item);
            this._visitables.get("schedulingGates").remove(builder);
            this.schedulingGates.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSchedulingGates(Collection<PodSchedulingGate> items) {
        if (this.schedulingGates == null) {
            return (A)this;
        }
        for (PodSchedulingGate item : items) {
            PodSchedulingGateBuilder builder = new PodSchedulingGateBuilder(item);
            this._visitables.get("schedulingGates").remove(builder);
            this.schedulingGates.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSchedulingGates(Predicate<PodSchedulingGateBuilder> predicate) {
        if (this.schedulingGates == null) {
            return (A)this;
        }
        Iterator<PodSchedulingGateBuilder> each = this.schedulingGates.iterator();
        Object visitables = this._visitables.get("schedulingGates");
        while (each.hasNext()) {
            PodSchedulingGateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<PodSchedulingGate> buildSchedulingGates() {
        return this.schedulingGates != null ? PodSpecFluent.build(this.schedulingGates) : null;
    }

    public PodSchedulingGate buildSchedulingGate(int index) {
        return this.schedulingGates.get(index).build();
    }

    public PodSchedulingGate buildFirstSchedulingGate() {
        return this.schedulingGates.get(0).build();
    }

    public PodSchedulingGate buildLastSchedulingGate() {
        return this.schedulingGates.get(this.schedulingGates.size() - 1).build();
    }

    public PodSchedulingGate buildMatchingSchedulingGate(Predicate<PodSchedulingGateBuilder> predicate) {
        for (PodSchedulingGateBuilder item : this.schedulingGates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSchedulingGate(Predicate<PodSchedulingGateBuilder> predicate) {
        for (PodSchedulingGateBuilder item : this.schedulingGates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSchedulingGates(List<PodSchedulingGate> schedulingGates) {
        if (this.schedulingGates != null) {
            this._visitables.get("schedulingGates").clear();
        }
        if (schedulingGates != null) {
            this.schedulingGates = new ArrayList();
            for (PodSchedulingGate item : schedulingGates) {
                this.addToSchedulingGates(item);
            }
        } else {
            this.schedulingGates = null;
        }
        return (A)this;
    }

    public A withSchedulingGates(PodSchedulingGate ... schedulingGates) {
        if (this.schedulingGates != null) {
            this.schedulingGates.clear();
            this._visitables.remove("schedulingGates");
        }
        if (schedulingGates != null) {
            for (PodSchedulingGate item : schedulingGates) {
                this.addToSchedulingGates(item);
            }
        }
        return (A)this;
    }

    public boolean hasSchedulingGates() {
        return this.schedulingGates != null && !this.schedulingGates.isEmpty();
    }

    public A addNewSchedulingGate(String name) {
        return this.addToSchedulingGates(new PodSchedulingGate(name));
    }

    public SchedulingGatesNested<A> addNewSchedulingGate() {
        return new SchedulingGatesNested(-1, null);
    }

    public SchedulingGatesNested<A> addNewSchedulingGateLike(PodSchedulingGate item) {
        return new SchedulingGatesNested(-1, item);
    }

    public SchedulingGatesNested<A> setNewSchedulingGateLike(int index, PodSchedulingGate item) {
        return new SchedulingGatesNested(index, item);
    }

    public SchedulingGatesNested<A> editSchedulingGate(int index) {
        if (this.schedulingGates.size() <= index) {
            throw new RuntimeException("Can't edit schedulingGates. Index exceeds size.");
        }
        return this.setNewSchedulingGateLike(index, this.buildSchedulingGate(index));
    }

    public SchedulingGatesNested<A> editFirstSchedulingGate() {
        if (this.schedulingGates.size() == 0) {
            throw new RuntimeException("Can't edit first schedulingGates. The list is empty.");
        }
        return this.setNewSchedulingGateLike(0, this.buildSchedulingGate(0));
    }

    public SchedulingGatesNested<A> editLastSchedulingGate() {
        int index = this.schedulingGates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last schedulingGates. The list is empty.");
        }
        return this.setNewSchedulingGateLike(index, this.buildSchedulingGate(index));
    }

    public SchedulingGatesNested<A> editMatchingSchedulingGate(Predicate<PodSchedulingGateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.schedulingGates.size(); ++i) {
            if (!predicate.test(this.schedulingGates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching schedulingGates. No match found.");
        }
        return this.setNewSchedulingGateLike(index, this.buildSchedulingGate(index));
    }

    public PodSecurityContext buildSecurityContext() {
        return this.securityContext != null ? this.securityContext.build() : null;
    }

    public A withSecurityContext(PodSecurityContext securityContext) {
        this._visitables.remove("securityContext");
        if (securityContext != null) {
            this.securityContext = new PodSecurityContextBuilder(securityContext);
            this._visitables.get("securityContext").add(this.securityContext);
        } else {
            this.securityContext = null;
            this._visitables.get("securityContext").remove(this.securityContext);
        }
        return (A)this;
    }

    public boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    public SecurityContextNested<A> withNewSecurityContext() {
        return new SecurityContextNested(null);
    }

    public SecurityContextNested<A> withNewSecurityContextLike(PodSecurityContext item) {
        return new SecurityContextNested(item);
    }

    public SecurityContextNested<A> editSecurityContext() {
        return this.withNewSecurityContextLike(Optional.ofNullable(this.buildSecurityContext()).orElse(null));
    }

    public SecurityContextNested<A> editOrNewSecurityContext() {
        return this.withNewSecurityContextLike(Optional.ofNullable(this.buildSecurityContext()).orElse(new PodSecurityContextBuilder().build()));
    }

    public SecurityContextNested<A> editOrNewSecurityContextLike(PodSecurityContext item) {
        return this.withNewSecurityContextLike(Optional.ofNullable(this.buildSecurityContext()).orElse(item));
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public A withServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return (A)this;
    }

    public boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (A)this;
    }

    public boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public Boolean getSetHostnameAsFQDN() {
        return this.setHostnameAsFQDN;
    }

    public A withSetHostnameAsFQDN(Boolean setHostnameAsFQDN) {
        this.setHostnameAsFQDN = setHostnameAsFQDN;
        return (A)this;
    }

    public boolean hasSetHostnameAsFQDN() {
        return this.setHostnameAsFQDN != null;
    }

    public Boolean getShareProcessNamespace() {
        return this.shareProcessNamespace;
    }

    public A withShareProcessNamespace(Boolean shareProcessNamespace) {
        this.shareProcessNamespace = shareProcessNamespace;
        return (A)this;
    }

    public boolean hasShareProcessNamespace() {
        return this.shareProcessNamespace != null;
    }

    public String getSubdomain() {
        return this.subdomain;
    }

    public A withSubdomain(String subdomain) {
        this.subdomain = subdomain;
        return (A)this;
    }

    public boolean hasSubdomain() {
        return this.subdomain != null;
    }

    public Long getTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    public A withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
        return (A)this;
    }

    public boolean hasTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds != null;
    }

    public A addToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        TolerationBuilder builder = new TolerationBuilder(item);
        if (index < 0 || index >= this.tolerations.size()) {
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(builder);
        } else {
            this._visitables.get("tolerations").add(index, builder);
            this.tolerations.add(index, builder);
        }
        return (A)this;
    }

    public A setToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        TolerationBuilder builder = new TolerationBuilder(item);
        if (index < 0 || index >= this.tolerations.size()) {
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(builder);
        } else {
            this._visitables.get("tolerations").set(index, builder);
            this.tolerations.set(index, builder);
        }
        return (A)this;
    }

    public A addToTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        for (Toleration item : items) {
            TolerationBuilder builder = new TolerationBuilder(item);
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(builder);
        }
        return (A)this;
    }

    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        for (Toleration item : items) {
            TolerationBuilder builder = new TolerationBuilder(item);
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(builder);
        }
        return (A)this;
    }

    public A removeFromTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            return (A)this;
        }
        for (Toleration item : items) {
            TolerationBuilder builder = new TolerationBuilder(item);
            this._visitables.get("tolerations").remove(builder);
            this.tolerations.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            return (A)this;
        }
        for (Toleration item : items) {
            TolerationBuilder builder = new TolerationBuilder(item);
            this._visitables.get("tolerations").remove(builder);
            this.tolerations.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromTolerations(Predicate<TolerationBuilder> predicate) {
        if (this.tolerations == null) {
            return (A)this;
        }
        Iterator<TolerationBuilder> each = this.tolerations.iterator();
        Object visitables = this._visitables.get("tolerations");
        while (each.hasNext()) {
            TolerationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Toleration> buildTolerations() {
        return this.tolerations != null ? PodSpecFluent.build(this.tolerations) : null;
    }

    public Toleration buildToleration(int index) {
        return this.tolerations.get(index).build();
    }

    public Toleration buildFirstToleration() {
        return this.tolerations.get(0).build();
    }

    public Toleration buildLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1).build();
    }

    public Toleration buildMatchingToleration(Predicate<TolerationBuilder> predicate) {
        for (TolerationBuilder item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingToleration(Predicate<TolerationBuilder> predicate) {
        for (TolerationBuilder item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTolerations(List<Toleration> tolerations) {
        if (this.tolerations != null) {
            this._visitables.get("tolerations").clear();
        }
        if (tolerations != null) {
            this.tolerations = new ArrayList();
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)this;
    }

    public A withTolerations(Toleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
            this._visitables.remove("tolerations");
        }
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)this;
    }

    public boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    public A addNewToleration(String effect, String key, String operator, Long tolerationSeconds, String value) {
        return this.addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    public TolerationsNested<A> addNewToleration() {
        return new TolerationsNested(-1, null);
    }

    public TolerationsNested<A> addNewTolerationLike(Toleration item) {
        return new TolerationsNested(-1, item);
    }

    public TolerationsNested<A> setNewTolerationLike(int index, Toleration item) {
        return new TolerationsNested(index, item);
    }

    public TolerationsNested<A> editToleration(int index) {
        if (this.tolerations.size() <= index) {
            throw new RuntimeException("Can't edit tolerations. Index exceeds size.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    public TolerationsNested<A> editFirstToleration() {
        if (this.tolerations.size() == 0) {
            throw new RuntimeException("Can't edit first tolerations. The list is empty.");
        }
        return this.setNewTolerationLike(0, this.buildToleration(0));
    }

    public TolerationsNested<A> editLastToleration() {
        int index = this.tolerations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tolerations. The list is empty.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    public TolerationsNested<A> editMatchingToleration(Predicate<TolerationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tolerations.size(); ++i) {
            if (!predicate.test(this.tolerations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tolerations. No match found.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    public A addToTopologySpreadConstraints(int index, TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList();
        }
        TopologySpreadConstraintBuilder builder = new TopologySpreadConstraintBuilder(item);
        if (index < 0 || index >= this.topologySpreadConstraints.size()) {
            this._visitables.get("topologySpreadConstraints").add(builder);
            this.topologySpreadConstraints.add(builder);
        } else {
            this._visitables.get("topologySpreadConstraints").add(index, builder);
            this.topologySpreadConstraints.add(index, builder);
        }
        return (A)this;
    }

    public A setToTopologySpreadConstraints(int index, TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList();
        }
        TopologySpreadConstraintBuilder builder = new TopologySpreadConstraintBuilder(item);
        if (index < 0 || index >= this.topologySpreadConstraints.size()) {
            this._visitables.get("topologySpreadConstraints").add(builder);
            this.topologySpreadConstraints.add(builder);
        } else {
            this._visitables.get("topologySpreadConstraints").set(index, builder);
            this.topologySpreadConstraints.set(index, builder);
        }
        return (A)this;
    }

    public A addToTopologySpreadConstraints(TopologySpreadConstraint ... items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList();
        }
        for (TopologySpreadConstraint item : items) {
            TopologySpreadConstraintBuilder builder = new TopologySpreadConstraintBuilder(item);
            this._visitables.get("topologySpreadConstraints").add(builder);
            this.topologySpreadConstraints.add(builder);
        }
        return (A)this;
    }

    public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList();
        }
        for (TopologySpreadConstraint item : items) {
            TopologySpreadConstraintBuilder builder = new TopologySpreadConstraintBuilder(item);
            this._visitables.get("topologySpreadConstraints").add(builder);
            this.topologySpreadConstraints.add(builder);
        }
        return (A)this;
    }

    public A removeFromTopologySpreadConstraints(TopologySpreadConstraint ... items) {
        if (this.topologySpreadConstraints == null) {
            return (A)this;
        }
        for (TopologySpreadConstraint item : items) {
            TopologySpreadConstraintBuilder builder = new TopologySpreadConstraintBuilder(item);
            this._visitables.get("topologySpreadConstraints").remove(builder);
            this.topologySpreadConstraints.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
        if (this.topologySpreadConstraints == null) {
            return (A)this;
        }
        for (TopologySpreadConstraint item : items) {
            TopologySpreadConstraintBuilder builder = new TopologySpreadConstraintBuilder(item);
            this._visitables.get("topologySpreadConstraints").remove(builder);
            this.topologySpreadConstraints.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromTopologySpreadConstraints(Predicate<TopologySpreadConstraintBuilder> predicate) {
        if (this.topologySpreadConstraints == null) {
            return (A)this;
        }
        Iterator<TopologySpreadConstraintBuilder> each = this.topologySpreadConstraints.iterator();
        Object visitables = this._visitables.get("topologySpreadConstraints");
        while (each.hasNext()) {
            TopologySpreadConstraintBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<TopologySpreadConstraint> buildTopologySpreadConstraints() {
        return this.topologySpreadConstraints != null ? PodSpecFluent.build(this.topologySpreadConstraints) : null;
    }

    public TopologySpreadConstraint buildTopologySpreadConstraint(int index) {
        return this.topologySpreadConstraints.get(index).build();
    }

    public TopologySpreadConstraint buildFirstTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(0).build();
    }

    public TopologySpreadConstraint buildLastTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(this.topologySpreadConstraints.size() - 1).build();
    }

    public TopologySpreadConstraint buildMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraintBuilder> predicate) {
        for (TopologySpreadConstraintBuilder item : this.topologySpreadConstraints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraintBuilder> predicate) {
        for (TopologySpreadConstraintBuilder item : this.topologySpreadConstraints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints) {
        if (this.topologySpreadConstraints != null) {
            this._visitables.get("topologySpreadConstraints").clear();
        }
        if (topologySpreadConstraints != null) {
            this.topologySpreadConstraints = new ArrayList();
            for (TopologySpreadConstraint item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        } else {
            this.topologySpreadConstraints = null;
        }
        return (A)this;
    }

    public A withTopologySpreadConstraints(TopologySpreadConstraint ... topologySpreadConstraints) {
        if (this.topologySpreadConstraints != null) {
            this.topologySpreadConstraints.clear();
            this._visitables.remove("topologySpreadConstraints");
        }
        if (topologySpreadConstraints != null) {
            for (TopologySpreadConstraint item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        }
        return (A)this;
    }

    public boolean hasTopologySpreadConstraints() {
        return this.topologySpreadConstraints != null && !this.topologySpreadConstraints.isEmpty();
    }

    public TopologySpreadConstraintsNested<A> addNewTopologySpreadConstraint() {
        return new TopologySpreadConstraintsNested(-1, null);
    }

    public TopologySpreadConstraintsNested<A> addNewTopologySpreadConstraintLike(TopologySpreadConstraint item) {
        return new TopologySpreadConstraintsNested(-1, item);
    }

    public TopologySpreadConstraintsNested<A> setNewTopologySpreadConstraintLike(int index, TopologySpreadConstraint item) {
        return new TopologySpreadConstraintsNested(index, item);
    }

    public TopologySpreadConstraintsNested<A> editTopologySpreadConstraint(int index) {
        if (this.topologySpreadConstraints.size() <= index) {
            throw new RuntimeException("Can't edit topologySpreadConstraints. Index exceeds size.");
        }
        return this.setNewTopologySpreadConstraintLike(index, this.buildTopologySpreadConstraint(index));
    }

    public TopologySpreadConstraintsNested<A> editFirstTopologySpreadConstraint() {
        if (this.topologySpreadConstraints.size() == 0) {
            throw new RuntimeException("Can't edit first topologySpreadConstraints. The list is empty.");
        }
        return this.setNewTopologySpreadConstraintLike(0, this.buildTopologySpreadConstraint(0));
    }

    public TopologySpreadConstraintsNested<A> editLastTopologySpreadConstraint() {
        int index = this.topologySpreadConstraints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last topologySpreadConstraints. The list is empty.");
        }
        return this.setNewTopologySpreadConstraintLike(index, this.buildTopologySpreadConstraint(index));
    }

    public TopologySpreadConstraintsNested<A> editMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraintBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.topologySpreadConstraints.size(); ++i) {
            if (!predicate.test(this.topologySpreadConstraints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching topologySpreadConstraints. No match found.");
        }
        return this.setNewTopologySpreadConstraintLike(index, this.buildTopologySpreadConstraint(index));
    }

    public A addToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        if (index < 0 || index >= this.volumes.size()) {
            this._visitables.get("volumes").add(builder);
            this.volumes.add(builder);
        } else {
            this._visitables.get("volumes").add(index, builder);
            this.volumes.add(index, builder);
        }
        return (A)this;
    }

    public A setToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        if (index < 0 || index >= this.volumes.size()) {
            this._visitables.get("volumes").add(builder);
            this.volumes.add(builder);
        } else {
            this._visitables.get("volumes").set(index, builder);
            this.volumes.set(index, builder);
        }
        return (A)this;
    }

    public A addToVolumes(Volume ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get("volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get("volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    public A removeFromVolumes(Volume ... items) {
        if (this.volumes == null) {
            return (A)this;
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get("volumes").remove(builder);
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromVolumes(Collection<Volume> items) {
        if (this.volumes == null) {
            return (A)this;
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get("volumes").remove(builder);
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromVolumes(Predicate<VolumeBuilder> predicate) {
        if (this.volumes == null) {
            return (A)this;
        }
        Iterator<VolumeBuilder> each = this.volumes.iterator();
        Object visitables = this._visitables.get("volumes");
        while (each.hasNext()) {
            VolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Volume> buildVolumes() {
        return this.volumes != null ? PodSpecFluent.build(this.volumes) : null;
    }

    public Volume buildVolume(int index) {
        return this.volumes.get(index).build();
    }

    public Volume buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    public Volume buildLastVolume() {
        return this.volumes.get(this.volumes.size() - 1).build();
    }

    public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) {
            this._visitables.get("volumes").clear();
        }
        if (volumes != null) {
            this.volumes = new ArrayList();
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)this;
    }

    public A withVolumes(Volume ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
            this._visitables.remove("volumes");
        }
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    public boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    public VolumesNested<A> addNewVolume() {
        return new VolumesNested(-1, null);
    }

    public VolumesNested<A> addNewVolumeLike(Volume item) {
        return new VolumesNested(-1, item);
    }

    public VolumesNested<A> setNewVolumeLike(int index, Volume item) {
        return new VolumesNested(index, item);
    }

    public VolumesNested<A> editVolume(int index) {
        if (this.volumes.size() <= index) {
            throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public VolumesNested<A> editFirstVolume() {
        if (this.volumes.size() == 0) {
            throw new RuntimeException("Can't edit first volumes. The list is empty.");
        }
        return this.setNewVolumeLike(0, this.buildVolume(0));
    }

    public VolumesNested<A> editLastVolume() {
        int index = this.volumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumes. The list is empty.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumes.size(); ++i) {
            if (!predicate.test(this.volumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumes. No match found.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodSpecFluent that = (PodSpecFluent)o;
        if (!Objects.equals(this.activeDeadlineSeconds, that.activeDeadlineSeconds)) {
            return false;
        }
        if (!Objects.equals(this.affinity, that.affinity)) {
            return false;
        }
        if (!Objects.equals(this.automountServiceAccountToken, that.automountServiceAccountToken)) {
            return false;
        }
        if (!Objects.equals(this.containers, that.containers)) {
            return false;
        }
        if (!Objects.equals(this.dnsConfig, that.dnsConfig)) {
            return false;
        }
        if (!Objects.equals(this.dnsPolicy, that.dnsPolicy)) {
            return false;
        }
        if (!Objects.equals(this.enableServiceLinks, that.enableServiceLinks)) {
            return false;
        }
        if (!Objects.equals(this.ephemeralContainers, that.ephemeralContainers)) {
            return false;
        }
        if (!Objects.equals(this.hostAliases, that.hostAliases)) {
            return false;
        }
        if (!Objects.equals(this.hostIPC, that.hostIPC)) {
            return false;
        }
        if (!Objects.equals(this.hostNetwork, that.hostNetwork)) {
            return false;
        }
        if (!Objects.equals(this.hostPID, that.hostPID)) {
            return false;
        }
        if (!Objects.equals(this.hostUsers, that.hostUsers)) {
            return false;
        }
        if (!Objects.equals(this.hostname, that.hostname)) {
            return false;
        }
        if (!Objects.equals(this.imagePullSecrets, that.imagePullSecrets)) {
            return false;
        }
        if (!Objects.equals(this.initContainers, that.initContainers)) {
            return false;
        }
        if (!Objects.equals(this.nodeName, that.nodeName)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals(this.os, that.os)) {
            return false;
        }
        if (!Objects.equals(this.overhead, that.overhead)) {
            return false;
        }
        if (!Objects.equals(this.preemptionPolicy, that.preemptionPolicy)) {
            return false;
        }
        if (!Objects.equals(this.priority, that.priority)) {
            return false;
        }
        if (!Objects.equals(this.priorityClassName, that.priorityClassName)) {
            return false;
        }
        if (!Objects.equals(this.readinessGates, that.readinessGates)) {
            return false;
        }
        if (!Objects.equals(this.resourceClaims, that.resourceClaims)) {
            return false;
        }
        if (!Objects.equals(this.restartPolicy, that.restartPolicy)) {
            return false;
        }
        if (!Objects.equals(this.runtimeClassName, that.runtimeClassName)) {
            return false;
        }
        if (!Objects.equals(this.schedulerName, that.schedulerName)) {
            return false;
        }
        if (!Objects.equals(this.schedulingGates, that.schedulingGates)) {
            return false;
        }
        if (!Objects.equals(this.securityContext, that.securityContext)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccount, that.serviceAccount)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccountName, that.serviceAccountName)) {
            return false;
        }
        if (!Objects.equals(this.setHostnameAsFQDN, that.setHostnameAsFQDN)) {
            return false;
        }
        if (!Objects.equals(this.shareProcessNamespace, that.shareProcessNamespace)) {
            return false;
        }
        if (!Objects.equals(this.subdomain, that.subdomain)) {
            return false;
        }
        if (!Objects.equals(this.terminationGracePeriodSeconds, that.terminationGracePeriodSeconds)) {
            return false;
        }
        if (!Objects.equals(this.tolerations, that.tolerations)) {
            return false;
        }
        if (!Objects.equals(this.topologySpreadConstraints, that.topologySpreadConstraints)) {
            return false;
        }
        if (!Objects.equals(this.volumes, that.volumes)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.activeDeadlineSeconds, this.affinity, this.automountServiceAccountToken, this.containers, this.dnsConfig, this.dnsPolicy, this.enableServiceLinks, this.ephemeralContainers, this.hostAliases, this.hostIPC, this.hostNetwork, this.hostPID, this.hostUsers, this.hostname, this.imagePullSecrets, this.initContainers, this.nodeName, this.nodeSelector, this.os, this.overhead, this.preemptionPolicy, this.priority, this.priorityClassName, this.readinessGates, this.resourceClaims, this.restartPolicy, this.runtimeClassName, this.schedulerName, this.schedulingGates, this.securityContext, this.serviceAccount, this.serviceAccountName, this.setHostnameAsFQDN, this.shareProcessNamespace, this.subdomain, this.terminationGracePeriodSeconds, this.tolerations, this.topologySpreadConstraints, this.volumes, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.activeDeadlineSeconds != null) {
            sb.append("activeDeadlineSeconds:");
            sb.append(this.activeDeadlineSeconds + ",");
        }
        if (this.affinity != null) {
            sb.append("affinity:");
            sb.append(this.affinity + ",");
        }
        if (this.automountServiceAccountToken != null) {
            sb.append("automountServiceAccountToken:");
            sb.append(this.automountServiceAccountToken + ",");
        }
        if (this.containers != null && !this.containers.isEmpty()) {
            sb.append("containers:");
            sb.append(this.containers + ",");
        }
        if (this.dnsConfig != null) {
            sb.append("dnsConfig:");
            sb.append(this.dnsConfig + ",");
        }
        if (this.dnsPolicy != null) {
            sb.append("dnsPolicy:");
            sb.append(this.dnsPolicy + ",");
        }
        if (this.enableServiceLinks != null) {
            sb.append("enableServiceLinks:");
            sb.append(this.enableServiceLinks + ",");
        }
        if (this.ephemeralContainers != null && !this.ephemeralContainers.isEmpty()) {
            sb.append("ephemeralContainers:");
            sb.append(this.ephemeralContainers + ",");
        }
        if (this.hostAliases != null && !this.hostAliases.isEmpty()) {
            sb.append("hostAliases:");
            sb.append(this.hostAliases + ",");
        }
        if (this.hostIPC != null) {
            sb.append("hostIPC:");
            sb.append(this.hostIPC + ",");
        }
        if (this.hostNetwork != null) {
            sb.append("hostNetwork:");
            sb.append(this.hostNetwork + ",");
        }
        if (this.hostPID != null) {
            sb.append("hostPID:");
            sb.append(this.hostPID + ",");
        }
        if (this.hostUsers != null) {
            sb.append("hostUsers:");
            sb.append(this.hostUsers + ",");
        }
        if (this.hostname != null) {
            sb.append("hostname:");
            sb.append(this.hostname + ",");
        }
        if (this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty()) {
            sb.append("imagePullSecrets:");
            sb.append(this.imagePullSecrets + ",");
        }
        if (this.initContainers != null && !this.initContainers.isEmpty()) {
            sb.append("initContainers:");
            sb.append(this.initContainers + ",");
        }
        if (this.nodeName != null) {
            sb.append("nodeName:");
            sb.append(this.nodeName + ",");
        }
        if (this.nodeSelector != null && !this.nodeSelector.isEmpty()) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector + ",");
        }
        if (this.os != null) {
            sb.append("os:");
            sb.append(this.os + ",");
        }
        if (this.overhead != null && !this.overhead.isEmpty()) {
            sb.append("overhead:");
            sb.append(this.overhead + ",");
        }
        if (this.preemptionPolicy != null) {
            sb.append("preemptionPolicy:");
            sb.append(this.preemptionPolicy + ",");
        }
        if (this.priority != null) {
            sb.append("priority:");
            sb.append(this.priority + ",");
        }
        if (this.priorityClassName != null) {
            sb.append("priorityClassName:");
            sb.append(this.priorityClassName + ",");
        }
        if (this.readinessGates != null && !this.readinessGates.isEmpty()) {
            sb.append("readinessGates:");
            sb.append(this.readinessGates + ",");
        }
        if (this.resourceClaims != null && !this.resourceClaims.isEmpty()) {
            sb.append("resourceClaims:");
            sb.append(this.resourceClaims + ",");
        }
        if (this.restartPolicy != null) {
            sb.append("restartPolicy:");
            sb.append(this.restartPolicy + ",");
        }
        if (this.runtimeClassName != null) {
            sb.append("runtimeClassName:");
            sb.append(this.runtimeClassName + ",");
        }
        if (this.schedulerName != null) {
            sb.append("schedulerName:");
            sb.append(this.schedulerName + ",");
        }
        if (this.schedulingGates != null && !this.schedulingGates.isEmpty()) {
            sb.append("schedulingGates:");
            sb.append(this.schedulingGates + ",");
        }
        if (this.securityContext != null) {
            sb.append("securityContext:");
            sb.append(this.securityContext + ",");
        }
        if (this.serviceAccount != null) {
            sb.append("serviceAccount:");
            sb.append(this.serviceAccount + ",");
        }
        if (this.serviceAccountName != null) {
            sb.append("serviceAccountName:");
            sb.append(this.serviceAccountName + ",");
        }
        if (this.setHostnameAsFQDN != null) {
            sb.append("setHostnameAsFQDN:");
            sb.append(this.setHostnameAsFQDN + ",");
        }
        if (this.shareProcessNamespace != null) {
            sb.append("shareProcessNamespace:");
            sb.append(this.shareProcessNamespace + ",");
        }
        if (this.subdomain != null) {
            sb.append("subdomain:");
            sb.append(this.subdomain + ",");
        }
        if (this.terminationGracePeriodSeconds != null) {
            sb.append("terminationGracePeriodSeconds:");
            sb.append(this.terminationGracePeriodSeconds + ",");
        }
        if (this.tolerations != null && !this.tolerations.isEmpty()) {
            sb.append("tolerations:");
            sb.append(this.tolerations + ",");
        }
        if (this.topologySpreadConstraints != null && !this.topologySpreadConstraints.isEmpty()) {
            sb.append("topologySpreadConstraints:");
            sb.append(this.topologySpreadConstraints + ",");
        }
        if (this.volumes != null && !this.volumes.isEmpty()) {
            sb.append("volumes:");
            sb.append(this.volumes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAutomountServiceAccountToken() {
        return this.withAutomountServiceAccountToken(true);
    }

    public A withEnableServiceLinks() {
        return this.withEnableServiceLinks(true);
    }

    public A withHostIPC() {
        return this.withHostIPC(true);
    }

    public A withHostNetwork() {
        return this.withHostNetwork(true);
    }

    public A withHostPID() {
        return this.withHostPID(true);
    }

    public A withHostUsers() {
        return this.withHostUsers(true);
    }

    public A withSetHostnameAsFQDN() {
        return this.withSetHostnameAsFQDN(true);
    }

    public A withShareProcessNamespace() {
        return this.withShareProcessNamespace(true);
    }

    public class VolumesNested<N>
    extends VolumeFluent<VolumesNested<N>>
    implements Nested<N> {
        VolumeBuilder builder;
        int index;

        VolumesNested(int index, Volume item) {
            this.index = index;
            this.builder = new VolumeBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSpecFluent.this.setToVolumes(this.index, this.builder.build());
        }

        public N endVolume() {
            return this.and();
        }
    }

    public class TopologySpreadConstraintsNested<N>
    extends TopologySpreadConstraintFluent<TopologySpreadConstraintsNested<N>>
    implements Nested<N> {
        TopologySpreadConstraintBuilder builder;
        int index;

        TopologySpreadConstraintsNested(int index, TopologySpreadConstraint item) {
            this.index = index;
            this.builder = new TopologySpreadConstraintBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSpecFluent.this.setToTopologySpreadConstraints(this.index, this.builder.build());
        }

        public N endTopologySpreadConstraint() {
            return this.and();
        }
    }

    public class TolerationsNested<N>
    extends TolerationFluent<TolerationsNested<N>>
    implements Nested<N> {
        TolerationBuilder builder;
        int index;

        TolerationsNested(int index, Toleration item) {
            this.index = index;
            this.builder = new TolerationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSpecFluent.this.setToTolerations(this.index, this.builder.build());
        }

        public N endToleration() {
            return this.and();
        }
    }

    public class SecurityContextNested<N>
    extends PodSecurityContextFluent<SecurityContextNested<N>>
    implements Nested<N> {
        PodSecurityContextBuilder builder;

        SecurityContextNested(PodSecurityContext item) {
            this.builder = new PodSecurityContextBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSpecFluent.this.withSecurityContext(this.builder.build());
        }

        public N endSecurityContext() {
            return this.and();
        }
    }

    public class SchedulingGatesNested<N>
    extends PodSchedulingGateFluent<SchedulingGatesNested<N>>
    implements Nested<N> {
        PodSchedulingGateBuilder builder;
        int index;

        SchedulingGatesNested(int index, PodSchedulingGate item) {
            this.index = index;
            this.builder = new PodSchedulingGateBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSpecFluent.this.setToSchedulingGates(this.index, this.builder.build());
        }

        public N endSchedulingGate() {
            return this.and();
        }
    }

    public class ResourceClaimsNested<N>
    extends PodResourceClaimFluent<ResourceClaimsNested<N>>
    implements Nested<N> {
        PodResourceClaimBuilder builder;
        int index;

        ResourceClaimsNested(int index, PodResourceClaim item) {
            this.index = index;
            this.builder = new PodResourceClaimBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSpecFluent.this.setToResourceClaims(this.index, this.builder.build());
        }

        public N endResourceClaim() {
            return this.and();
        }
    }

    public class ReadinessGatesNested<N>
    extends PodReadinessGateFluent<ReadinessGatesNested<N>>
    implements Nested<N> {
        PodReadinessGateBuilder builder;
        int index;

        ReadinessGatesNested(int index, PodReadinessGate item) {
            this.index = index;
            this.builder = new PodReadinessGateBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSpecFluent.this.setToReadinessGates(this.index, this.builder.build());
        }

        public N endReadinessGate() {
            return this.and();
        }
    }

    public class OsNested<N>
    extends PodOSFluent<OsNested<N>>
    implements Nested<N> {
        PodOSBuilder builder;

        OsNested(PodOS item) {
            this.builder = new PodOSBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSpecFluent.this.withOs(this.builder.build());
        }

        public N endOs() {
            return this.and();
        }
    }

    public class InitContainersNested<N>
    extends ContainerFluent<InitContainersNested<N>>
    implements Nested<N> {
        ContainerBuilder builder;
        int index;

        InitContainersNested(int index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSpecFluent.this.setToInitContainers(this.index, this.builder.build());
        }

        public N endInitContainer() {
            return this.and();
        }
    }

    public class ImagePullSecretsNested<N>
    extends LocalObjectReferenceFluent<ImagePullSecretsNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;
        int index;

        ImagePullSecretsNested(int index, LocalObjectReference item) {
            this.index = index;
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSpecFluent.this.setToImagePullSecrets(this.index, this.builder.build());
        }

        public N endImagePullSecret() {
            return this.and();
        }
    }

    public class HostAliasesNested<N>
    extends HostAliasFluent<HostAliasesNested<N>>
    implements Nested<N> {
        HostAliasBuilder builder;
        int index;

        HostAliasesNested(int index, HostAlias item) {
            this.index = index;
            this.builder = new HostAliasBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSpecFluent.this.setToHostAliases(this.index, this.builder.build());
        }

        public N endHostAlias() {
            return this.and();
        }
    }

    public class EphemeralContainersNested<N>
    extends EphemeralContainerFluent<EphemeralContainersNested<N>>
    implements Nested<N> {
        EphemeralContainerBuilder builder;
        int index;

        EphemeralContainersNested(int index, EphemeralContainer item) {
            this.index = index;
            this.builder = new EphemeralContainerBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSpecFluent.this.setToEphemeralContainers(this.index, this.builder.build());
        }

        public N endEphemeralContainer() {
            return this.and();
        }
    }

    public class DnsConfigNested<N>
    extends PodDNSConfigFluent<DnsConfigNested<N>>
    implements Nested<N> {
        PodDNSConfigBuilder builder;

        DnsConfigNested(PodDNSConfig item) {
            this.builder = new PodDNSConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSpecFluent.this.withDnsConfig(this.builder.build());
        }

        public N endDnsConfig() {
            return this.and();
        }
    }

    public class ContainersNested<N>
    extends ContainerFluent<ContainersNested<N>>
    implements Nested<N> {
        ContainerBuilder builder;
        int index;

        ContainersNested(int index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSpecFluent.this.setToContainers(this.index, this.builder.build());
        }

        public N endContainer() {
            return this.and();
        }
    }

    public class AffinityNested<N>
    extends AffinityFluent<AffinityNested<N>>
    implements Nested<N> {
        AffinityBuilder builder;

        AffinityNested(Affinity item) {
            this.builder = new AffinityBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSpecFluent.this.withAffinity(this.builder.build());
        }

        public N endAffinity() {
            return this.and();
        }
    }
}

