/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_10;

import io.fabric8.kubernetes.api.builder.v6_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_10.Nested;
import io.fabric8.kubernetes.api.model.v6_10.APIResource;
import io.fabric8.kubernetes.api.model.v6_10.APIResourceBuilder;
import io.fabric8.kubernetes.api.model.v6_10.APIResourceFluent;
import io.fabric8.kubernetes.api.model.v6_10.APIResourceList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class APIResourceListFluent<A extends APIResourceListFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String groupVersion;
    private String kind;
    private ArrayList<APIResourceBuilder> resources = new ArrayList();
    private Map<String, Object> additionalProperties;

    public APIResourceListFluent() {
    }

    public APIResourceListFluent(APIResourceList instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(APIResourceList instance) {
        APIResourceList aPIResourceList = instance = instance != null ? instance : new APIResourceList();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withGroupVersion(instance.getGroupVersion());
            this.withKind(instance.getKind());
            this.withResources(instance.getResources());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getGroupVersion() {
        return this.groupVersion;
    }

    public A withGroupVersion(String groupVersion) {
        this.groupVersion = groupVersion;
        return (A)this;
    }

    public boolean hasGroupVersion() {
        return this.groupVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public A addToResources(int index, APIResource item) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        APIResourceBuilder builder = new APIResourceBuilder(item);
        if (index < 0 || index >= this.resources.size()) {
            this._visitables.get("resources").add(builder);
            this.resources.add(builder);
        } else {
            this._visitables.get("resources").add(index, builder);
            this.resources.add(index, builder);
        }
        return (A)this;
    }

    public A setToResources(int index, APIResource item) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        APIResourceBuilder builder = new APIResourceBuilder(item);
        if (index < 0 || index >= this.resources.size()) {
            this._visitables.get("resources").add(builder);
            this.resources.add(builder);
        } else {
            this._visitables.get("resources").set(index, builder);
            this.resources.set(index, builder);
        }
        return (A)this;
    }

    public A addToResources(APIResource ... items) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        for (APIResource item : items) {
            APIResourceBuilder builder = new APIResourceBuilder(item);
            this._visitables.get("resources").add(builder);
            this.resources.add(builder);
        }
        return (A)this;
    }

    public A addAllToResources(Collection<APIResource> items) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        for (APIResource item : items) {
            APIResourceBuilder builder = new APIResourceBuilder(item);
            this._visitables.get("resources").add(builder);
            this.resources.add(builder);
        }
        return (A)this;
    }

    public A removeFromResources(APIResource ... items) {
        if (this.resources == null) {
            return (A)this;
        }
        for (APIResource item : items) {
            APIResourceBuilder builder = new APIResourceBuilder(item);
            this._visitables.get("resources").remove(builder);
            this.resources.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromResources(Collection<APIResource> items) {
        if (this.resources == null) {
            return (A)this;
        }
        for (APIResource item : items) {
            APIResourceBuilder builder = new APIResourceBuilder(item);
            this._visitables.get("resources").remove(builder);
            this.resources.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromResources(Predicate<APIResourceBuilder> predicate) {
        if (this.resources == null) {
            return (A)this;
        }
        Iterator<APIResourceBuilder> each = this.resources.iterator();
        Object visitables = this._visitables.get("resources");
        while (each.hasNext()) {
            APIResourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<APIResource> buildResources() {
        return this.resources != null ? APIResourceListFluent.build(this.resources) : null;
    }

    public APIResource buildResource(int index) {
        return this.resources.get(index).build();
    }

    public APIResource buildFirstResource() {
        return this.resources.get(0).build();
    }

    public APIResource buildLastResource() {
        return this.resources.get(this.resources.size() - 1).build();
    }

    public APIResource buildMatchingResource(Predicate<APIResourceBuilder> predicate) {
        for (APIResourceBuilder item : this.resources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResource(Predicate<APIResourceBuilder> predicate) {
        for (APIResourceBuilder item : this.resources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResources(List<APIResource> resources) {
        if (this.resources != null) {
            this._visitables.get("resources").clear();
        }
        if (resources != null) {
            this.resources = new ArrayList();
            for (APIResource item : resources) {
                this.addToResources(item);
            }
        } else {
            this.resources = null;
        }
        return (A)this;
    }

    public A withResources(APIResource ... resources) {
        if (this.resources != null) {
            this.resources.clear();
            this._visitables.remove("resources");
        }
        if (resources != null) {
            for (APIResource item : resources) {
                this.addToResources(item);
            }
        }
        return (A)this;
    }

    public boolean hasResources() {
        return this.resources != null && !this.resources.isEmpty();
    }

    public ResourcesNested<A> addNewResource() {
        return new ResourcesNested(-1, null);
    }

    public ResourcesNested<A> addNewResourceLike(APIResource item) {
        return new ResourcesNested(-1, item);
    }

    public ResourcesNested<A> setNewResourceLike(int index, APIResource item) {
        return new ResourcesNested(index, item);
    }

    public ResourcesNested<A> editResource(int index) {
        if (this.resources.size() <= index) {
            throw new RuntimeException("Can't edit resources. Index exceeds size.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    public ResourcesNested<A> editFirstResource() {
        if (this.resources.size() == 0) {
            throw new RuntimeException("Can't edit first resources. The list is empty.");
        }
        return this.setNewResourceLike(0, this.buildResource(0));
    }

    public ResourcesNested<A> editLastResource() {
        int index = this.resources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resources. The list is empty.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    public ResourcesNested<A> editMatchingResource(Predicate<APIResourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resources.size(); ++i) {
            if (!predicate.test(this.resources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resources. No match found.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        APIResourceListFluent that = (APIResourceListFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.groupVersion, that.groupVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.groupVersion, this.kind, this.resources, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.groupVersion != null) {
            sb.append("groupVersion:");
            sb.append(this.groupVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.resources != null && !this.resources.isEmpty()) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ResourcesNested<N>
    extends APIResourceFluent<ResourcesNested<N>>
    implements Nested<N> {
        APIResourceBuilder builder;
        int index;

        ResourcesNested(int index, APIResource item) {
            this.index = index;
            this.builder = new APIResourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)APIResourceListFluent.this.setToResources(this.index, this.builder.build());
        }

        public N endResource() {
            return this.and();
        }
    }
}

