/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v6_1.osgi;

import io.fabric8.kubernetes.api.model.v6_1.ComponentStatus;
import io.fabric8.kubernetes.api.model.v6_1.ComponentStatusList;
import io.fabric8.kubernetes.api.model.v6_1.KubernetesList;
import io.fabric8.kubernetes.clnt.v6_1.Client;
import io.fabric8.kubernetes.clnt.v6_1.Config;
import io.fabric8.kubernetes.clnt.v6_1.KubernetesClientBuilder;
import io.fabric8.kubernetes.clnt.v6_1.RequestConfig;
import io.fabric8.kubernetes.clnt.v6_1.VersionInfo;
import io.fabric8.kubernetes.clnt.v6_1.dsl.FunctionCallable;
import io.fabric8.kubernetes.clnt.v6_1.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v6_1.dsl.InOutCreateable;
import io.fabric8.kubernetes.clnt.v6_1.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v6_1.dsl.Nameable;
import io.fabric8.kubernetes.clnt.v6_1.dsl.Namespaceable;
import io.fabric8.kubernetes.clnt.v6_1.dsl.NamespacedInOutCreateable;
import io.fabric8.kubernetes.clnt.v6_1.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v6_1.dsl.ParameterMixedOperation;
import io.fabric8.kubernetes.clnt.v6_1.dsl.Resource;
import io.fabric8.kubernetes.clnt.v6_1.osgi.NamespacedKubernetesClientAdapter;
import io.fabric8.kubernetes.clnt.v6_1.utils.URLUtils;
import io.fabric8.openshift.api.model.v6_1.BrokerTemplateInstance;
import io.fabric8.openshift.api.model.v6_1.BrokerTemplateInstanceList;
import io.fabric8.openshift.api.model.v6_1.Build;
import io.fabric8.openshift.api.model.v6_1.BuildConfig;
import io.fabric8.openshift.api.model.v6_1.BuildConfigList;
import io.fabric8.openshift.api.model.v6_1.BuildList;
import io.fabric8.openshift.api.model.v6_1.ClusterNetwork;
import io.fabric8.openshift.api.model.v6_1.ClusterNetworkList;
import io.fabric8.openshift.api.model.v6_1.ClusterRole;
import io.fabric8.openshift.api.model.v6_1.ClusterRoleBinding;
import io.fabric8.openshift.api.model.v6_1.ClusterRoleBindingList;
import io.fabric8.openshift.api.model.v6_1.ClusterRoleList;
import io.fabric8.openshift.api.model.v6_1.DeploymentConfig;
import io.fabric8.openshift.api.model.v6_1.DeploymentConfigList;
import io.fabric8.openshift.api.model.v6_1.EgressNetworkPolicy;
import io.fabric8.openshift.api.model.v6_1.EgressNetworkPolicyList;
import io.fabric8.openshift.api.model.v6_1.Group;
import io.fabric8.openshift.api.model.v6_1.GroupList;
import io.fabric8.openshift.api.model.v6_1.HelmChartRepository;
import io.fabric8.openshift.api.model.v6_1.HelmChartRepositoryList;
import io.fabric8.openshift.api.model.v6_1.HostSubnet;
import io.fabric8.openshift.api.model.v6_1.HostSubnetList;
import io.fabric8.openshift.api.model.v6_1.Identity;
import io.fabric8.openshift.api.model.v6_1.IdentityList;
import io.fabric8.openshift.api.model.v6_1.Image;
import io.fabric8.openshift.api.model.v6_1.ImageList;
import io.fabric8.openshift.api.model.v6_1.ImageStream;
import io.fabric8.openshift.api.model.v6_1.ImageStreamImage;
import io.fabric8.openshift.api.model.v6_1.ImageStreamImport;
import io.fabric8.openshift.api.model.v6_1.ImageStreamList;
import io.fabric8.openshift.api.model.v6_1.ImageStreamMapping;
import io.fabric8.openshift.api.model.v6_1.ImageStreamTag;
import io.fabric8.openshift.api.model.v6_1.ImageStreamTagList;
import io.fabric8.openshift.api.model.v6_1.ImageTag;
import io.fabric8.openshift.api.model.v6_1.ImageTagList;
import io.fabric8.openshift.api.model.v6_1.LocalResourceAccessReview;
import io.fabric8.openshift.api.model.v6_1.LocalSubjectAccessReview;
import io.fabric8.openshift.api.model.v6_1.NetNamespace;
import io.fabric8.openshift.api.model.v6_1.NetNamespaceList;
import io.fabric8.openshift.api.model.v6_1.OAuthAccessToken;
import io.fabric8.openshift.api.model.v6_1.OAuthAccessTokenList;
import io.fabric8.openshift.api.model.v6_1.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.v6_1.OAuthAuthorizeTokenList;
import io.fabric8.openshift.api.model.v6_1.OAuthClient;
import io.fabric8.openshift.api.model.v6_1.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.v6_1.OAuthClientAuthorizationList;
import io.fabric8.openshift.api.model.v6_1.OAuthClientList;
import io.fabric8.openshift.api.model.v6_1.PodSecurityPolicyReview;
import io.fabric8.openshift.api.model.v6_1.PodSecurityPolicySelfSubjectReview;
import io.fabric8.openshift.api.model.v6_1.PodSecurityPolicySubjectReview;
import io.fabric8.openshift.api.model.v6_1.RangeAllocation;
import io.fabric8.openshift.api.model.v6_1.RangeAllocationList;
import io.fabric8.openshift.api.model.v6_1.ResourceAccessReview;
import io.fabric8.openshift.api.model.v6_1.ResourceAccessReviewResponse;
import io.fabric8.openshift.api.model.v6_1.Role;
import io.fabric8.openshift.api.model.v6_1.RoleBinding;
import io.fabric8.openshift.api.model.v6_1.RoleBindingList;
import io.fabric8.openshift.api.model.v6_1.RoleBindingRestriction;
import io.fabric8.openshift.api.model.v6_1.RoleBindingRestrictionList;
import io.fabric8.openshift.api.model.v6_1.RoleList;
import io.fabric8.openshift.api.model.v6_1.Route;
import io.fabric8.openshift.api.model.v6_1.RouteList;
import io.fabric8.openshift.api.model.v6_1.SecurityContextConstraints;
import io.fabric8.openshift.api.model.v6_1.SecurityContextConstraintsList;
import io.fabric8.openshift.api.model.v6_1.SelfSubjectRulesReview;
import io.fabric8.openshift.api.model.v6_1.SubjectAccessReview;
import io.fabric8.openshift.api.model.v6_1.SubjectAccessReviewResponse;
import io.fabric8.openshift.api.model.v6_1.SubjectRulesReview;
import io.fabric8.openshift.api.model.v6_1.Template;
import io.fabric8.openshift.api.model.v6_1.TemplateInstance;
import io.fabric8.openshift.api.model.v6_1.TemplateInstanceList;
import io.fabric8.openshift.api.model.v6_1.TemplateList;
import io.fabric8.openshift.api.model.v6_1.User;
import io.fabric8.openshift.api.model.v6_1.UserIdentityMapping;
import io.fabric8.openshift.api.model.v6_1.UserList;
import io.fabric8.openshift.api.model.v6_1.UserOAuthAccessToken;
import io.fabric8.openshift.api.model.v6_1.UserOAuthAccessTokenList;
import io.fabric8.openshift.api.model.v6_1.miscellaneous.apiserver.v1.APIRequestCount;
import io.fabric8.openshift.api.model.v6_1.miscellaneous.apiserver.v1.APIRequestCountList;
import io.fabric8.openshift.api.model.v6_1.miscellaneous.cloudcredential.v1.CredentialsRequest;
import io.fabric8.openshift.api.model.v6_1.miscellaneous.cloudcredential.v1.CredentialsRequestList;
import io.fabric8.openshift.api.model.v6_1.miscellaneous.cncf.cni.v1.NetworkAttachmentDefinition;
import io.fabric8.openshift.api.model.v6_1.miscellaneous.cncf.cni.v1.NetworkAttachmentDefinitionList;
import io.fabric8.openshift.api.model.v6_1.miscellaneous.imageregistry.operator.v1.ConfigList;
import io.fabric8.openshift.api.model.v6_1.miscellaneous.metal3.v1alpha1.BareMetalHost;
import io.fabric8.openshift.api.model.v6_1.miscellaneous.metal3.v1alpha1.BareMetalHostList;
import io.fabric8.openshift.api.model.v6_1.miscellaneous.network.operator.v1.EgressRouter;
import io.fabric8.openshift.api.model.v6_1.miscellaneous.network.operator.v1.EgressRouterList;
import io.fabric8.openshift.api.model.v6_1.miscellaneous.network.operator.v1.OperatorPKI;
import io.fabric8.openshift.api.model.v6_1.miscellaneous.network.operator.v1.OperatorPKIList;
import io.fabric8.openshift.clnt.v6_1.NamespacedOpenShiftClient;
import io.fabric8.openshift.clnt.v6_1.OpenShiftClient;
import io.fabric8.openshift.clnt.v6_1.OpenShiftConfig;
import io.fabric8.openshift.clnt.v6_1.OpenShiftConfigBuilder;
import io.fabric8.openshift.clnt.v6_1.dsl.BuildConfigResource;
import io.fabric8.openshift.clnt.v6_1.dsl.BuildResource;
import io.fabric8.openshift.clnt.v6_1.dsl.DeployableScalableResource;
import io.fabric8.openshift.clnt.v6_1.dsl.MachineConfigurationAPIGroupDSL;
import io.fabric8.openshift.clnt.v6_1.dsl.NameableCreateOrDeleteable;
import io.fabric8.openshift.clnt.v6_1.dsl.OpenShiftClusterAutoscalingAPIGroupDSL;
import io.fabric8.openshift.clnt.v6_1.dsl.OpenShiftConfigAPIGroupDSL;
import io.fabric8.openshift.clnt.v6_1.dsl.OpenShiftConsoleAPIGroupDSL;
import io.fabric8.openshift.clnt.v6_1.dsl.OpenShiftHiveAPIGroupDSL;
import io.fabric8.openshift.clnt.v6_1.dsl.OpenShiftMachineAPIGroupDSL;
import io.fabric8.openshift.clnt.v6_1.dsl.OpenShiftMonitoringAPIGroupDSL;
import io.fabric8.openshift.clnt.v6_1.dsl.OpenShiftOperatorAPIGroupDSL;
import io.fabric8.openshift.clnt.v6_1.dsl.OpenShiftOperatorHubAPIGroupDSL;
import io.fabric8.openshift.clnt.v6_1.dsl.OpenShiftQuotaAPIGroupDSL;
import io.fabric8.openshift.clnt.v6_1.dsl.OpenShiftStorageVersionMigratorApiGroupDSL;
import io.fabric8.openshift.clnt.v6_1.dsl.OpenShiftTunedAPIGroupDSL;
import io.fabric8.openshift.clnt.v6_1.dsl.OpenShiftWhereaboutsAPIGroupDSL;
import io.fabric8.openshift.clnt.v6_1.dsl.ProjectOperation;
import io.fabric8.openshift.clnt.v6_1.dsl.ProjectRequestOperation;
import io.fabric8.openshift.clnt.v6_1.dsl.TemplateResource;
import java.net.URL;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;

@Component(configurationPid="io.fabric8.openshift.clnt.v6_1", policy=ConfigurationPolicy.OPTIONAL)
@Service(value={OpenShiftClient.class, NamespacedOpenShiftClient.class})
public class ManagedOpenShiftClient
extends NamespacedKubernetesClientAdapter<NamespacedOpenShiftClient>
implements NamespacedOpenShiftClient {
    public ManagedOpenShiftClient() {
        super(NamespacedOpenShiftClient.class);
    }

    @Activate
    public void activate(Map<String, Object> properties) {
        OpenShiftConfigBuilder builder = new OpenShiftConfigBuilder();
        if (properties.containsKey("kubernetes.master")) {
            builder.withMasterUrl((String)properties.get("kubernetes.master"));
        }
        if (properties.containsKey("kubernetes.api.version")) {
            builder.withApiVersion((String)properties.get("kubernetes.api.version"));
        }
        if (properties.containsKey("kubernetes.namespace")) {
            builder.withNamespace((String)properties.get("kubernetes.namespace"));
        }
        if (properties.containsKey("kubernetes.certs.ca.file")) {
            builder.withCaCertFile((String)properties.get("kubernetes.certs.ca.file"));
        }
        if (properties.containsKey("kubernetes.certs.ca.data")) {
            builder.withCaCertData((String)properties.get("kubernetes.certs.ca.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.file")) {
            builder.withClientCertFile((String)properties.get("kubernetes.certs.client.file"));
        }
        if (properties.containsKey("kubernetes.certs.client.data")) {
            builder.withClientCertData((String)properties.get("kubernetes.certs.client.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.file")) {
            builder.withClientKeyFile((String)properties.get("kubernetes.certs.client.key.file"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.data")) {
            builder.withClientKeyData((String)properties.get("kubernetes.certs.client.key.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.algo")) {
            builder.withClientKeyAlgo((String)properties.get("kubernetes.certs.client.key.algo"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.passphrase")) {
            builder.withClientKeyPassphrase((String)properties.get("kubernetes.certs.client.key.passphrase"));
        }
        if (properties.containsKey("kubernetes.auth.basic.username")) {
            builder.withUsername((String)properties.get("kubernetes.auth.basic.username"));
        }
        if (properties.containsKey("kubernetes.auth.basic.password")) {
            builder.withPassword((String)properties.get("kubernetes.auth.basic.password"));
        }
        if (properties.containsKey("kubernetes.auth.token")) {
            builder.withOauthToken((String)properties.get("kubernetes.auth.token"));
        }
        if (properties.containsKey("kubernetes.watch.reconnectInterval")) {
            builder.withWatchReconnectInterval(Integer.parseInt((String)properties.get("kubernetes.watch.reconnectInterval")));
        }
        if (properties.containsKey("kubernetes.watch.reconnectLimit")) {
            builder.withWatchReconnectLimit(Integer.parseInt((String)properties.get("kubernetes.watch.reconnectLimit")));
        }
        if (properties.containsKey("kubernetes.request.timeout")) {
            builder.withRequestTimeout(Integer.parseInt((String)properties.get("kubernetes.request.timeout")));
        }
        if (properties.containsKey("http.proxy")) {
            builder.withHttpProxy((String)properties.get("http.proxy"));
        }
        if (properties.containsKey("https.proxy")) {
            builder.withHttpsProxy((String)properties.get("https.proxy"));
        }
        if (properties.containsKey("no.proxy")) {
            String noProxyProperty = (String)properties.get("no.proxy");
            builder.withNoProxy(noProxyProperty.split(","));
        }
        if (properties.containsKey("openshift.url")) {
            builder.withOpenShiftUrl((String)properties.get("openshift.url"));
        } else {
            builder.withOpenShiftUrl(URLUtils.join((String[])new String[]{builder.getMasterUrl(), "oapi", builder.getOapiVersion()}));
        }
        if (properties.containsKey("openshift.build.timeout")) {
            builder.withBuildTimeout((long)Integer.parseInt((String)properties.get("openshift.build.timeout")));
        } else {
            builder.withBuildTimeout(OpenShiftConfig.DEFAULT_BUILD_TIMEOUT.longValue());
        }
        if (properties.containsKey("kubernetes.websocket.timeout")) {
            builder.withWebsocketTimeout(Long.parseLong((String)properties.get("kubernetes.websocket.timeout")));
        }
        if (properties.containsKey("kubernetes.websocket.ping.interval")) {
            builder.withWebsocketPingInterval(Long.parseLong((String)properties.get("kubernetes.websocket.ping.interval")));
        }
        NamespacedOpenShiftClient delegate = (NamespacedOpenShiftClient)new KubernetesClientBuilder().withConfig((Config)builder.build()).build().adapt(NamespacedOpenShiftClient.class);
        this.init((Client)delegate);
    }

    @Deactivate
    public void deactivate() {
        ((NamespacedOpenShiftClient)this.getClient()).close();
    }

    public URL getOpenshiftUrl() {
        return ((NamespacedOpenShiftClient)this.getClient()).getOpenshiftUrl();
    }

    public OpenShiftConfigAPIGroupDSL config() {
        return ((NamespacedOpenShiftClient)this.getClient()).config();
    }

    public OpenShiftConsoleAPIGroupDSL console() {
        return ((NamespacedOpenShiftClient)this.getClient()).console();
    }

    public OpenShiftClusterAutoscalingAPIGroupDSL clusterAutoscaling() {
        return ((NamespacedOpenShiftClient)this.getClient()).clusterAutoscaling();
    }

    public OpenShiftHiveAPIGroupDSL hive() {
        return ((NamespacedOpenShiftClient)this.getClient()).hive();
    }

    public OpenShiftOperatorAPIGroupDSL operator() {
        return ((NamespacedOpenShiftClient)this.getClient()).operator();
    }

    public OpenShiftOperatorHubAPIGroupDSL operatorHub() {
        return ((NamespacedOpenShiftClient)this.getClient()).operatorHub();
    }

    public MixedOperation<Build, BuildList, BuildResource> builds() {
        return ((NamespacedOpenShiftClient)this.getClient()).builds();
    }

    @Override
    public NonNamespaceOperation<ComponentStatus, ComponentStatusList, Resource<ComponentStatus>> componentstatuses() {
        return ((NamespacedOpenShiftClient)this.getClient()).componentstatuses();
    }

    public MixedOperation<BuildConfig, BuildConfigList, BuildConfigResource<BuildConfig, Void, Build>> buildConfigs() {
        return ((NamespacedOpenShiftClient)this.getClient()).buildConfigs();
    }

    public MixedOperation<CredentialsRequest, CredentialsRequestList, Resource<CredentialsRequest>> credentialsRequests() {
        return ((NamespacedOpenShiftClient)this.getClient()).credentialsRequests();
    }

    public MixedOperation<DeploymentConfig, DeploymentConfigList, DeployableScalableResource<DeploymentConfig>> deploymentConfigs() {
        return ((NamespacedOpenShiftClient)this.getClient()).deploymentConfigs();
    }

    public NonNamespaceOperation<Group, GroupList, Resource<Group>> groups() {
        return ((NamespacedOpenShiftClient)this.getClient()).groups();
    }

    public NonNamespaceOperation<HelmChartRepository, HelmChartRepositoryList, Resource<HelmChartRepository>> helmChartRepositories() {
        return ((NamespacedOpenShiftClient)this.getClient()).helmChartRepositories();
    }

    public NonNamespaceOperation<Image, ImageList, Resource<Image>> images() {
        return ((NamespacedOpenShiftClient)this.getClient()).images();
    }

    public MixedOperation<ImageTag, ImageTagList, Resource<ImageTag>> imageTags() {
        return ((NamespacedOpenShiftClient)this.getClient()).imageTags();
    }

    public MixedOperation<ImageStream, ImageStreamList, Resource<ImageStream>> imageStreams() {
        return ((NamespacedOpenShiftClient)this.getClient()).imageStreams();
    }

    public MixedOperation<ImageStreamTag, ImageStreamTagList, Resource<ImageStreamTag>> imageStreamTags() {
        return ((NamespacedOpenShiftClient)this.getClient()).imageStreamTags();
    }

    public NamespacedInOutCreateable<ImageStreamImport, ImageStreamImport> imageStreamImports() {
        return ((NamespacedOpenShiftClient)this.getClient()).imageStreamImports();
    }

    public NamespacedInOutCreateable<ImageStreamMapping, ImageStreamMapping> imageStreamMappings() {
        return ((NamespacedOpenShiftClient)this.getClient()).imageStreamMappings();
    }

    public Namespaceable<Nameable<? extends Gettable<ImageStreamImage>>> imageStreamImages() {
        return ((NamespacedOpenShiftClient)this.getClient()).imageStreamImages();
    }

    public NameableCreateOrDeleteable imageSignatures() {
        return ((NamespacedOpenShiftClient)this.getClient()).imageSignatures();
    }

    public NonNamespaceOperation<io.fabric8.openshift.api.model.v6_1.miscellaneous.imageregistry.operator.v1.Config, ConfigList, Resource<io.fabric8.openshift.api.model.v6_1.miscellaneous.imageregistry.operator.v1.Config>> imageRegistryOperatorConfigs() {
        return ((NamespacedOpenShiftClient)this.getClient()).imageRegistryOperatorConfigs();
    }

    public MixedOperation<NetworkAttachmentDefinition, NetworkAttachmentDefinitionList, Resource<NetworkAttachmentDefinition>> networkAttachmentDefinitions() {
        return ((NamespacedOpenShiftClient)this.getClient()).networkAttachmentDefinitions();
    }

    public NonNamespaceOperation<OAuthAccessToken, OAuthAccessTokenList, Resource<OAuthAccessToken>> oAuthAccessTokens() {
        return ((NamespacedOpenShiftClient)this.getClient()).oAuthAccessTokens();
    }

    public NonNamespaceOperation<OAuthAuthorizeToken, OAuthAuthorizeTokenList, Resource<OAuthAuthorizeToken>> oAuthAuthorizeTokens() {
        return ((NamespacedOpenShiftClient)this.getClient()).oAuthAuthorizeTokens();
    }

    public NonNamespaceOperation<OAuthClient, OAuthClientList, Resource<OAuthClient>> oAuthClients() {
        return ((NamespacedOpenShiftClient)this.getClient()).oAuthClients();
    }

    public NamespacedInOutCreateable<PodSecurityPolicyReview, PodSecurityPolicyReview> podSecurityPolicyReviews() {
        return ((NamespacedOpenShiftClient)this.getClient()).podSecurityPolicyReviews();
    }

    public NonNamespaceOperation<OAuthClientAuthorization, OAuthClientAuthorizationList, Resource<OAuthClientAuthorization>> oAuthClientAuthorizations() {
        return ((NamespacedOpenShiftClient)this.getClient()).oAuthClientAuthorizations();
    }

    public MixedOperation<OperatorPKI, OperatorPKIList, Resource<OperatorPKI>> operatorPKIs() {
        return ((NamespacedOpenShiftClient)this.getClient()).operatorPKIs();
    }

    public MixedOperation<EgressRouter, EgressRouterList, Resource<EgressRouter>> egressRouters() {
        return ((NamespacedOpenShiftClient)this.getClient()).egressRouters();
    }

    public NamespacedInOutCreateable<PodSecurityPolicySelfSubjectReview, PodSecurityPolicySelfSubjectReview> podSecurityPolicySelfSubjectReviews() {
        return ((NamespacedOpenShiftClient)this.getClient()).podSecurityPolicySelfSubjectReviews();
    }

    public NamespacedInOutCreateable<PodSecurityPolicySubjectReview, PodSecurityPolicySubjectReview> podSecurityPolicySubjectReviews() {
        return ((NamespacedOpenShiftClient)this.getClient()).podSecurityPolicySubjectReviews();
    }

    public OpenShiftQuotaAPIGroupDSL quotas() {
        return ((NamespacedOpenShiftClient)this.getClient()).quotas();
    }

    public ProjectOperation projects() {
        return ((NamespacedOpenShiftClient)this.getClient()).projects();
    }

    public ProjectRequestOperation projectrequests() {
        return ((NamespacedOpenShiftClient)this.getClient()).projectrequests();
    }

    public MixedOperation<Role, RoleList, Resource<Role>> roles() {
        return ((NamespacedOpenShiftClient)this.getClient()).roles();
    }

    public MixedOperation<RoleBinding, RoleBindingList, Resource<RoleBinding>> roleBindings() {
        return ((NamespacedOpenShiftClient)this.getClient()).roleBindings();
    }

    public MixedOperation<Route, RouteList, Resource<Route>> routes() {
        return ((NamespacedOpenShiftClient)this.getClient()).routes();
    }

    public ParameterMixedOperation<Template, TemplateList, TemplateResource<Template, KubernetesList>> templates() {
        return ((NamespacedOpenShiftClient)this.getClient()).templates();
    }

    public MixedOperation<TemplateInstance, TemplateInstanceList, Resource<TemplateInstance>> templateInstances() {
        return ((NamespacedOpenShiftClient)this.getClient()).templateInstances();
    }

    public OpenShiftTunedAPIGroupDSL tuned() {
        return ((NamespacedOpenShiftClient)this.getClient()).tuned();
    }

    public NonNamespaceOperation<BrokerTemplateInstance, BrokerTemplateInstanceList, Resource<BrokerTemplateInstance>> brokerTemplateInstances() {
        return ((NamespacedOpenShiftClient)this.getClient()).brokerTemplateInstances();
    }

    public NonNamespaceOperation<User, UserList, Resource<User>> users() {
        return ((NamespacedOpenShiftClient)this.getClient()).users();
    }

    public MixedOperation<ClusterRoleBinding, ClusterRoleBindingList, Resource<ClusterRoleBinding>> clusterRoleBindings() {
        return ((NamespacedOpenShiftClient)this.getClient()).clusterRoleBindings();
    }

    public MixedOperation<RoleBindingRestriction, RoleBindingRestrictionList, Resource<RoleBindingRestriction>> roleBindingRestrictions() {
        return ((NamespacedOpenShiftClient)this.getClient()).roleBindingRestrictions();
    }

    public VersionInfo getOpenShiftV3Version() {
        return ((NamespacedOpenShiftClient)this.getClient()).getOpenShiftV3Version();
    }

    public String getOpenShiftV4Version() {
        return ((NamespacedOpenShiftClient)this.getClient()).getOpenShiftV4Version();
    }

    public MachineConfigurationAPIGroupDSL machineConfigurations() {
        return ((NamespacedOpenShiftClient)this.getClient()).machineConfigurations();
    }

    public OpenShiftMachineAPIGroupDSL machine() {
        return ((NamespacedOpenShiftClient)this.getClient()).machine();
    }

    public OpenShiftMonitoringAPIGroupDSL monitoring() {
        return ((NamespacedOpenShiftClient)this.getClient()).monitoring();
    }

    public NonNamespaceOperation<NetNamespace, NetNamespaceList, Resource<NetNamespace>> netNamespaces() {
        return ((NamespacedOpenShiftClient)this.getClient()).netNamespaces();
    }

    public NonNamespaceOperation<ClusterNetwork, ClusterNetworkList, Resource<ClusterNetwork>> clusterNetworks() {
        return ((NamespacedOpenShiftClient)this.getClient()).clusterNetworks();
    }

    public MixedOperation<EgressNetworkPolicy, EgressNetworkPolicyList, Resource<EgressNetworkPolicy>> egressNetworkPolicies() {
        return ((NamespacedOpenShiftClient)this.getClient()).egressNetworkPolicies();
    }

    public NonNamespaceOperation<HostSubnet, HostSubnetList, Resource<HostSubnet>> hostSubnets() {
        return ((NamespacedOpenShiftClient)this.getClient()).hostSubnets();
    }

    public NonNamespaceOperation<APIRequestCount, APIRequestCountList, Resource<APIRequestCount>> apiRequestCounts() {
        return ((NamespacedOpenShiftClient)this.getClient()).apiRequestCounts();
    }

    public MixedOperation<BareMetalHost, BareMetalHostList, Resource<BareMetalHost>> bareMetalHosts() {
        return ((NamespacedOpenShiftClient)this.getClient()).bareMetalHosts();
    }

    public InOutCreateable<SubjectAccessReview, SubjectAccessReviewResponse> subjectAccessReviews() {
        return ((NamespacedOpenShiftClient)this.getClient()).subjectAccessReviews();
    }

    public InOutCreateable<ResourceAccessReview, ResourceAccessReviewResponse> resourceAccessReviews() {
        return ((NamespacedOpenShiftClient)this.getClient()).resourceAccessReviews();
    }

    public NamespacedInOutCreateable<LocalSubjectAccessReview, SubjectAccessReviewResponse> localSubjectAccessReviews() {
        return ((NamespacedOpenShiftClient)this.getClient()).localSubjectAccessReviews();
    }

    public NamespacedInOutCreateable<LocalResourceAccessReview, ResourceAccessReviewResponse> localResourceAccessReviews() {
        return ((NamespacedOpenShiftClient)this.getClient()).localResourceAccessReviews();
    }

    public NamespacedInOutCreateable<SelfSubjectRulesReview, SelfSubjectRulesReview> selfSubjectRulesReviews() {
        return ((NamespacedOpenShiftClient)this.getClient()).selfSubjectRulesReviews();
    }

    public NamespacedInOutCreateable<SubjectRulesReview, SubjectRulesReview> subjectRulesReviews() {
        return ((NamespacedOpenShiftClient)this.getClient()).subjectRulesReviews();
    }

    public OpenShiftStorageVersionMigratorApiGroupDSL kubeStorageVersionMigrator() {
        return ((NamespacedOpenShiftClient)this.getClient()).kubeStorageVersionMigrator();
    }

    public NonNamespaceOperation<ClusterRole, ClusterRoleList, Resource<ClusterRole>> clusterRoles() {
        return ((NamespacedOpenShiftClient)this.getClient()).clusterRoles();
    }

    @Override
    public FunctionCallable<NamespacedOpenShiftClient> withRequestConfig(RequestConfig requestConfig) {
        return ((NamespacedOpenShiftClient)this.getClient()).withRequestConfig(requestConfig);
    }

    public User currentUser() {
        return ((NamespacedOpenShiftClient)this.getClient()).currentUser();
    }

    public NonNamespaceOperation<Identity, IdentityList, Resource<Identity>> identities() {
        return ((NamespacedOpenShiftClient)this.getClient()).identities();
    }

    public InOutCreateable<UserIdentityMapping, UserIdentityMapping> userIdentityMappings() {
        return null;
    }

    public OpenShiftWhereaboutsAPIGroupDSL whereabouts() {
        return ((NamespacedOpenShiftClient)this.getClient()).whereabouts();
    }

    public boolean supportsOpenShiftAPIGroup(String apiGroup) {
        return ((NamespacedOpenShiftClient)this.getClient()).supportsOpenShiftAPIGroup(apiGroup);
    }

    public NonNamespaceOperation<RangeAllocation, RangeAllocationList, Resource<RangeAllocation>> rangeAllocations() {
        return ((NamespacedOpenShiftClient)this.getClient()).rangeAllocations();
    }

    public NonNamespaceOperation<SecurityContextConstraints, SecurityContextConstraintsList, Resource<SecurityContextConstraints>> securityContextConstraints() {
        return ((NamespacedOpenShiftClient)this.getClient()).securityContextConstraints();
    }

    public NonNamespaceOperation<UserOAuthAccessToken, UserOAuthAccessTokenList, Resource<UserOAuthAccessToken>> userOAuthAccessTokens() {
        return ((NamespacedOpenShiftClient)this.getClient()).userOAuthAccessTokens();
    }

    public boolean isSupported() {
        return ((NamespacedOpenShiftClient)this.getClient()).isSupported();
    }

    @Override
    public ManagedOpenShiftClient newInstance() {
        return new ManagedOpenShiftClient();
    }

    @Override
    public ManagedOpenShiftClient inAnyNamespace() {
        ManagedOpenShiftClient result = this.newInstance();
        result.init((Client)((NamespacedOpenShiftClient)this.getClient()).inAnyNamespace());
        return result;
    }

    @Override
    public ManagedOpenShiftClient inNamespace(String namespace) {
        ManagedOpenShiftClient result = this.newInstance();
        result.init((Client)((NamespacedOpenShiftClient)this.getClient()).inNamespace(namespace));
        return result;
    }
}

