/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_1.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.v6_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_1.Nested;
import io.fabric8.kubernetes.api.model.v6_1.SecretKeySelector;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1alpha1.HTTPConfig;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1alpha1.HTTPConfigBuilder;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1alpha1.HTTPConfigFluentImpl;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1alpha1.KeyValue;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1alpha1.KeyValueBuilder;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1alpha1.KeyValueFluentImpl;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1alpha1.VictorOpsConfig;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1alpha1.VictorOpsConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class VictorOpsConfigFluentImpl<A extends VictorOpsConfigFluent<A>>
extends BaseFluent<A>
implements VictorOpsConfigFluent<A> {
    private SecretKeySelector apiKey;
    private String apiUrl;
    private ArrayList<KeyValueBuilder> customFields = new ArrayList();
    private String entityDisplayName;
    private HTTPConfigBuilder httpConfig;
    private String messageType;
    private String monitoringTool;
    private String routingKey;
    private Boolean sendResolved;
    private String stateMessage;
    private Map<String, Object> additionalProperties;

    public VictorOpsConfigFluentImpl() {
    }

    public VictorOpsConfigFluentImpl(VictorOpsConfig instance) {
        this.withApiKey(instance.getApiKey());
        this.withApiUrl(instance.getApiUrl());
        this.withCustomFields(instance.getCustomFields());
        this.withEntityDisplayName(instance.getEntityDisplayName());
        this.withHttpConfig(instance.getHttpConfig());
        this.withMessageType(instance.getMessageType());
        this.withMonitoringTool(instance.getMonitoringTool());
        this.withRoutingKey(instance.getRoutingKey());
        this.withSendResolved(instance.getSendResolved());
        this.withStateMessage(instance.getStateMessage());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public SecretKeySelector getApiKey() {
        return this.apiKey;
    }

    @Override
    public A withApiKey(SecretKeySelector apiKey) {
        this.apiKey = apiKey;
        return (A)this;
    }

    @Override
    public Boolean hasApiKey() {
        return this.apiKey != null;
    }

    @Override
    public A withNewApiKey(String key, String name, Boolean optional) {
        return this.withApiKey(new SecretKeySelector(key, name, optional));
    }

    @Override
    public String getApiUrl() {
        return this.apiUrl;
    }

    @Override
    public A withApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
        return (A)this;
    }

    @Override
    public Boolean hasApiUrl() {
        return this.apiUrl != null;
    }

    @Override
    public A addToCustomFields(Integer index, KeyValue item) {
        if (this.customFields == null) {
            this.customFields = new ArrayList();
        }
        KeyValueBuilder builder = new KeyValueBuilder(item);
        this._visitables.get("customFields").add(index >= 0 ? index.intValue() : this._visitables.get("customFields").size(), builder);
        this.customFields.add(index >= 0 ? index.intValue() : this.customFields.size(), builder);
        return (A)this;
    }

    @Override
    public A setToCustomFields(Integer index, KeyValue item) {
        if (this.customFields == null) {
            this.customFields = new ArrayList();
        }
        KeyValueBuilder builder = new KeyValueBuilder(item);
        if (index < 0 || index >= this._visitables.get("customFields").size()) {
            this._visitables.get("customFields").add(builder);
        } else {
            this._visitables.get("customFields").set(index, builder);
        }
        if (index < 0 || index >= this.customFields.size()) {
            this.customFields.add(builder);
        } else {
            this.customFields.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToCustomFields(KeyValue ... items) {
        if (this.customFields == null) {
            this.customFields = new ArrayList();
        }
        for (KeyValue item : items) {
            KeyValueBuilder builder = new KeyValueBuilder(item);
            this._visitables.get("customFields").add(builder);
            this.customFields.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToCustomFields(Collection<KeyValue> items) {
        if (this.customFields == null) {
            this.customFields = new ArrayList();
        }
        for (KeyValue item : items) {
            KeyValueBuilder builder = new KeyValueBuilder(item);
            this._visitables.get("customFields").add(builder);
            this.customFields.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromCustomFields(KeyValue ... items) {
        for (KeyValue item : items) {
            KeyValueBuilder builder = new KeyValueBuilder(item);
            this._visitables.get("customFields").remove(builder);
            if (this.customFields == null) continue;
            this.customFields.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCustomFields(Collection<KeyValue> items) {
        for (KeyValue item : items) {
            KeyValueBuilder builder = new KeyValueBuilder(item);
            this._visitables.get("customFields").remove(builder);
            if (this.customFields == null) continue;
            this.customFields.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromCustomFields(Predicate<KeyValueBuilder> predicate) {
        if (this.customFields == null) {
            return (A)this;
        }
        Iterator<KeyValueBuilder> each = this.customFields.iterator();
        Object visitables = this._visitables.get("customFields");
        while (each.hasNext()) {
            KeyValueBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<KeyValue> getCustomFields() {
        return this.customFields != null ? VictorOpsConfigFluentImpl.build(this.customFields) : null;
    }

    @Override
    public List<KeyValue> buildCustomFields() {
        return this.customFields != null ? VictorOpsConfigFluentImpl.build(this.customFields) : null;
    }

    @Override
    public KeyValue buildCustomField(Integer index) {
        return this.customFields.get(index).build();
    }

    @Override
    public KeyValue buildFirstCustomField() {
        return this.customFields.get(0).build();
    }

    @Override
    public KeyValue buildLastCustomField() {
        return this.customFields.get(this.customFields.size() - 1).build();
    }

    @Override
    public KeyValue buildMatchingCustomField(Predicate<KeyValueBuilder> predicate) {
        for (KeyValueBuilder item : this.customFields) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCustomField(Predicate<KeyValueBuilder> predicate) {
        for (KeyValueBuilder item : this.customFields) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCustomFields(List<KeyValue> customFields) {
        if (this.customFields != null) {
            this._visitables.get("customFields").removeAll(this.customFields);
        }
        if (customFields != null) {
            this.customFields = new ArrayList();
            for (KeyValue item : customFields) {
                this.addToCustomFields(item);
            }
        } else {
            this.customFields = null;
        }
        return (A)this;
    }

    @Override
    public A withCustomFields(KeyValue ... customFields) {
        if (this.customFields != null) {
            this.customFields.clear();
        }
        if (customFields != null) {
            for (KeyValue item : customFields) {
                this.addToCustomFields(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCustomFields() {
        return this.customFields != null && !this.customFields.isEmpty();
    }

    @Override
    public A addNewCustomField(String key, String value) {
        return this.addToCustomFields(new KeyValue(key, value));
    }

    @Override
    public VictorOpsConfigFluent.CustomFieldsNested<A> addNewCustomField() {
        return new CustomFieldsNestedImpl();
    }

    @Override
    public VictorOpsConfigFluent.CustomFieldsNested<A> addNewCustomFieldLike(KeyValue item) {
        return new CustomFieldsNestedImpl(-1, item);
    }

    @Override
    public VictorOpsConfigFluent.CustomFieldsNested<A> setNewCustomFieldLike(Integer index, KeyValue item) {
        return new CustomFieldsNestedImpl(index, item);
    }

    @Override
    public VictorOpsConfigFluent.CustomFieldsNested<A> editCustomField(Integer index) {
        if (this.customFields.size() <= index) {
            throw new RuntimeException("Can't edit customFields. Index exceeds size.");
        }
        return this.setNewCustomFieldLike(index, this.buildCustomField(index));
    }

    @Override
    public VictorOpsConfigFluent.CustomFieldsNested<A> editFirstCustomField() {
        if (this.customFields.size() == 0) {
            throw new RuntimeException("Can't edit first customFields. The list is empty.");
        }
        return this.setNewCustomFieldLike(0, this.buildCustomField(0));
    }

    @Override
    public VictorOpsConfigFluent.CustomFieldsNested<A> editLastCustomField() {
        int index = this.customFields.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last customFields. The list is empty.");
        }
        return this.setNewCustomFieldLike(index, this.buildCustomField(index));
    }

    @Override
    public VictorOpsConfigFluent.CustomFieldsNested<A> editMatchingCustomField(Predicate<KeyValueBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.customFields.size(); ++i) {
            if (!predicate.test(this.customFields.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching customFields. No match found.");
        }
        return this.setNewCustomFieldLike(index, this.buildCustomField(index));
    }

    @Override
    public String getEntityDisplayName() {
        return this.entityDisplayName;
    }

    @Override
    public A withEntityDisplayName(String entityDisplayName) {
        this.entityDisplayName = entityDisplayName;
        return (A)this;
    }

    @Override
    public Boolean hasEntityDisplayName() {
        return this.entityDisplayName != null;
    }

    @Override
    @Deprecated
    public HTTPConfig getHttpConfig() {
        return this.httpConfig != null ? this.httpConfig.build() : null;
    }

    @Override
    public HTTPConfig buildHttpConfig() {
        return this.httpConfig != null ? this.httpConfig.build() : null;
    }

    @Override
    public A withHttpConfig(HTTPConfig httpConfig) {
        this._visitables.get("httpConfig").remove(this.httpConfig);
        if (httpConfig != null) {
            this.httpConfig = new HTTPConfigBuilder(httpConfig);
            this._visitables.get("httpConfig").add(this.httpConfig);
        } else {
            this.httpConfig = null;
            this._visitables.get("httpConfig").remove(this.httpConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasHttpConfig() {
        return this.httpConfig != null;
    }

    @Override
    public VictorOpsConfigFluent.HttpConfigNested<A> withNewHttpConfig() {
        return new HttpConfigNestedImpl();
    }

    @Override
    public VictorOpsConfigFluent.HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
        return new HttpConfigNestedImpl(item);
    }

    @Override
    public VictorOpsConfigFluent.HttpConfigNested<A> editHttpConfig() {
        return this.withNewHttpConfigLike(this.getHttpConfig());
    }

    @Override
    public VictorOpsConfigFluent.HttpConfigNested<A> editOrNewHttpConfig() {
        return this.withNewHttpConfigLike(this.getHttpConfig() != null ? this.getHttpConfig() : new HTTPConfigBuilder().build());
    }

    @Override
    public VictorOpsConfigFluent.HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
        return this.withNewHttpConfigLike(this.getHttpConfig() != null ? this.getHttpConfig() : item);
    }

    @Override
    public String getMessageType() {
        return this.messageType;
    }

    @Override
    public A withMessageType(String messageType) {
        this.messageType = messageType;
        return (A)this;
    }

    @Override
    public Boolean hasMessageType() {
        return this.messageType != null;
    }

    @Override
    public String getMonitoringTool() {
        return this.monitoringTool;
    }

    @Override
    public A withMonitoringTool(String monitoringTool) {
        this.monitoringTool = monitoringTool;
        return (A)this;
    }

    @Override
    public Boolean hasMonitoringTool() {
        return this.monitoringTool != null;
    }

    @Override
    public String getRoutingKey() {
        return this.routingKey;
    }

    @Override
    public A withRoutingKey(String routingKey) {
        this.routingKey = routingKey;
        return (A)this;
    }

    @Override
    public Boolean hasRoutingKey() {
        return this.routingKey != null;
    }

    @Override
    public Boolean getSendResolved() {
        return this.sendResolved;
    }

    @Override
    public A withSendResolved(Boolean sendResolved) {
        this.sendResolved = sendResolved;
        return (A)this;
    }

    @Override
    public Boolean hasSendResolved() {
        return this.sendResolved != null;
    }

    @Override
    public String getStateMessage() {
        return this.stateMessage;
    }

    @Override
    public A withStateMessage(String stateMessage) {
        this.stateMessage = stateMessage;
        return (A)this;
    }

    @Override
    public Boolean hasStateMessage() {
        return this.stateMessage != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VictorOpsConfigFluentImpl that = (VictorOpsConfigFluentImpl)o;
        if (this.apiKey != null ? !this.apiKey.equals(that.apiKey) : that.apiKey != null) {
            return false;
        }
        if (this.apiUrl != null ? !this.apiUrl.equals(that.apiUrl) : that.apiUrl != null) {
            return false;
        }
        if (this.customFields != null ? !this.customFields.equals(that.customFields) : that.customFields != null) {
            return false;
        }
        if (this.entityDisplayName != null ? !this.entityDisplayName.equals(that.entityDisplayName) : that.entityDisplayName != null) {
            return false;
        }
        if (this.httpConfig != null ? !this.httpConfig.equals(that.httpConfig) : that.httpConfig != null) {
            return false;
        }
        if (this.messageType != null ? !this.messageType.equals(that.messageType) : that.messageType != null) {
            return false;
        }
        if (this.monitoringTool != null ? !this.monitoringTool.equals(that.monitoringTool) : that.monitoringTool != null) {
            return false;
        }
        if (this.routingKey != null ? !this.routingKey.equals(that.routingKey) : that.routingKey != null) {
            return false;
        }
        if (this.sendResolved != null ? !this.sendResolved.equals(that.sendResolved) : that.sendResolved != null) {
            return false;
        }
        if (this.stateMessage != null ? !this.stateMessage.equals(that.stateMessage) : that.stateMessage != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiKey, this.apiUrl, this.customFields, this.entityDisplayName, this.httpConfig, this.messageType, this.monitoringTool, this.routingKey, this.sendResolved, this.stateMessage, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiKey != null) {
            sb.append("apiKey:");
            sb.append(this.apiKey + ",");
        }
        if (this.apiUrl != null) {
            sb.append("apiUrl:");
            sb.append(this.apiUrl + ",");
        }
        if (this.customFields != null && !this.customFields.isEmpty()) {
            sb.append("customFields:");
            sb.append(this.customFields + ",");
        }
        if (this.entityDisplayName != null) {
            sb.append("entityDisplayName:");
            sb.append(this.entityDisplayName + ",");
        }
        if (this.httpConfig != null) {
            sb.append("httpConfig:");
            sb.append(this.httpConfig + ",");
        }
        if (this.messageType != null) {
            sb.append("messageType:");
            sb.append(this.messageType + ",");
        }
        if (this.monitoringTool != null) {
            sb.append("monitoringTool:");
            sb.append(this.monitoringTool + ",");
        }
        if (this.routingKey != null) {
            sb.append("routingKey:");
            sb.append(this.routingKey + ",");
        }
        if (this.sendResolved != null) {
            sb.append("sendResolved:");
            sb.append(this.sendResolved + ",");
        }
        if (this.stateMessage != null) {
            sb.append("stateMessage:");
            sb.append(this.stateMessage + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withSendResolved() {
        return this.withSendResolved(true);
    }

    class HttpConfigNestedImpl<N>
    extends HTTPConfigFluentImpl<VictorOpsConfigFluent.HttpConfigNested<N>>
    implements VictorOpsConfigFluent.HttpConfigNested<N>,
    Nested<N> {
        HTTPConfigBuilder builder;

        HttpConfigNestedImpl(HTTPConfig item) {
            this.builder = new HTTPConfigBuilder(this, item);
        }

        HttpConfigNestedImpl() {
            this.builder = new HTTPConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)VictorOpsConfigFluentImpl.this.withHttpConfig(this.builder.build());
        }

        @Override
        public N endHttpConfig() {
            return this.and();
        }
    }

    class CustomFieldsNestedImpl<N>
    extends KeyValueFluentImpl<VictorOpsConfigFluent.CustomFieldsNested<N>>
    implements VictorOpsConfigFluent.CustomFieldsNested<N>,
    Nested<N> {
        KeyValueBuilder builder;
        Integer index;

        CustomFieldsNestedImpl(Integer index, KeyValue item) {
            this.index = index;
            this.builder = new KeyValueBuilder(this, item);
        }

        CustomFieldsNestedImpl() {
            this.index = -1;
            this.builder = new KeyValueBuilder(this);
        }

        @Override
        public N and() {
            return (N)VictorOpsConfigFluentImpl.this.setToCustomFields(this.index, this.builder.build());
        }

        @Override
        public N endCustomField() {
            return this.and();
        }
    }
}

