/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_1.monitoring.v1alpha1;

import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.kubernetes.api.builder.v6_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_1.Nested;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1alpha1.Matcher;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1alpha1.MatcherBuilder;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1alpha1.MatcherFluentImpl;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1alpha1.Route;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1alpha1.RouteFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RouteFluentImpl<A extends RouteFluent<A>>
extends BaseFluent<A>
implements RouteFluent<A> {
    private Boolean _continue;
    private List<String> groupBy = new ArrayList<String>();
    private String groupInterval;
    private String groupWait;
    private ArrayList<MatcherBuilder> matchers = new ArrayList();
    private String receiver;
    private String repeatInterval;
    private List<JsonNode> routes = new ArrayList<JsonNode>();
    private Map<String, Object> additionalProperties;

    public RouteFluentImpl() {
    }

    public RouteFluentImpl(Route instance) {
        this.withContinue(instance.getContinue());
        this.withGroupBy(instance.getGroupBy());
        this.withGroupInterval(instance.getGroupInterval());
        this.withGroupWait(instance.getGroupWait());
        this.withMatchers(instance.getMatchers());
        this.withReceiver(instance.getReceiver());
        this.withRepeatInterval(instance.getRepeatInterval());
        this.withRoutes(instance.getRoutes());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Boolean getContinue() {
        return this._continue;
    }

    @Override
    public A withContinue(Boolean _continue) {
        this._continue = _continue;
        return (A)this;
    }

    @Override
    public Boolean hasContinue() {
        return this._continue != null;
    }

    @Override
    public A addToGroupBy(Integer index, String item) {
        if (this.groupBy == null) {
            this.groupBy = new ArrayList<String>();
        }
        this.groupBy.add(index, item);
        return (A)this;
    }

    @Override
    public A setToGroupBy(Integer index, String item) {
        if (this.groupBy == null) {
            this.groupBy = new ArrayList<String>();
        }
        this.groupBy.set(index, item);
        return (A)this;
    }

    @Override
    public A addToGroupBy(String ... items) {
        if (this.groupBy == null) {
            this.groupBy = new ArrayList<String>();
        }
        for (String item : items) {
            this.groupBy.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToGroupBy(Collection<String> items) {
        if (this.groupBy == null) {
            this.groupBy = new ArrayList<String>();
        }
        for (String item : items) {
            this.groupBy.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromGroupBy(String ... items) {
        for (String item : items) {
            if (this.groupBy == null) continue;
            this.groupBy.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGroupBy(Collection<String> items) {
        for (String item : items) {
            if (this.groupBy == null) continue;
            this.groupBy.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getGroupBy() {
        return this.groupBy;
    }

    @Override
    public String getGroupBy(Integer index) {
        return this.groupBy.get(index);
    }

    @Override
    public String getFirstGroupBy() {
        return this.groupBy.get(0);
    }

    @Override
    public String getLastGroupBy() {
        return this.groupBy.get(this.groupBy.size() - 1);
    }

    @Override
    public String getMatchingGroupBy(Predicate<String> predicate) {
        for (String item : this.groupBy) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingGroupBy(Predicate<String> predicate) {
        for (String item : this.groupBy) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withGroupBy(List<String> groupBy) {
        if (groupBy != null) {
            this.groupBy = new ArrayList<String>();
            for (String item : groupBy) {
                this.addToGroupBy(item);
            }
        } else {
            this.groupBy = null;
        }
        return (A)this;
    }

    @Override
    public A withGroupBy(String ... groupBy) {
        if (this.groupBy != null) {
            this.groupBy.clear();
        }
        if (groupBy != null) {
            for (String item : groupBy) {
                this.addToGroupBy(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGroupBy() {
        return this.groupBy != null && !this.groupBy.isEmpty();
    }

    @Override
    public String getGroupInterval() {
        return this.groupInterval;
    }

    @Override
    public A withGroupInterval(String groupInterval) {
        this.groupInterval = groupInterval;
        return (A)this;
    }

    @Override
    public Boolean hasGroupInterval() {
        return this.groupInterval != null;
    }

    @Override
    public String getGroupWait() {
        return this.groupWait;
    }

    @Override
    public A withGroupWait(String groupWait) {
        this.groupWait = groupWait;
        return (A)this;
    }

    @Override
    public Boolean hasGroupWait() {
        return this.groupWait != null;
    }

    @Override
    public A addToMatchers(Integer index, Matcher item) {
        if (this.matchers == null) {
            this.matchers = new ArrayList();
        }
        MatcherBuilder builder = new MatcherBuilder(item);
        this._visitables.get("matchers").add(index >= 0 ? index.intValue() : this._visitables.get("matchers").size(), builder);
        this.matchers.add(index >= 0 ? index.intValue() : this.matchers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToMatchers(Integer index, Matcher item) {
        if (this.matchers == null) {
            this.matchers = new ArrayList();
        }
        MatcherBuilder builder = new MatcherBuilder(item);
        if (index < 0 || index >= this._visitables.get("matchers").size()) {
            this._visitables.get("matchers").add(builder);
        } else {
            this._visitables.get("matchers").set(index, builder);
        }
        if (index < 0 || index >= this.matchers.size()) {
            this.matchers.add(builder);
        } else {
            this.matchers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToMatchers(Matcher ... items) {
        if (this.matchers == null) {
            this.matchers = new ArrayList();
        }
        for (Matcher item : items) {
            MatcherBuilder builder = new MatcherBuilder(item);
            this._visitables.get("matchers").add(builder);
            this.matchers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToMatchers(Collection<Matcher> items) {
        if (this.matchers == null) {
            this.matchers = new ArrayList();
        }
        for (Matcher item : items) {
            MatcherBuilder builder = new MatcherBuilder(item);
            this._visitables.get("matchers").add(builder);
            this.matchers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromMatchers(Matcher ... items) {
        for (Matcher item : items) {
            MatcherBuilder builder = new MatcherBuilder(item);
            this._visitables.get("matchers").remove(builder);
            if (this.matchers == null) continue;
            this.matchers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMatchers(Collection<Matcher> items) {
        for (Matcher item : items) {
            MatcherBuilder builder = new MatcherBuilder(item);
            this._visitables.get("matchers").remove(builder);
            if (this.matchers == null) continue;
            this.matchers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromMatchers(Predicate<MatcherBuilder> predicate) {
        if (this.matchers == null) {
            return (A)this;
        }
        Iterator<MatcherBuilder> each = this.matchers.iterator();
        Object visitables = this._visitables.get("matchers");
        while (each.hasNext()) {
            MatcherBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Matcher> getMatchers() {
        return this.matchers != null ? RouteFluentImpl.build(this.matchers) : null;
    }

    @Override
    public List<Matcher> buildMatchers() {
        return this.matchers != null ? RouteFluentImpl.build(this.matchers) : null;
    }

    @Override
    public Matcher buildMatcher(Integer index) {
        return this.matchers.get(index).build();
    }

    @Override
    public Matcher buildFirstMatcher() {
        return this.matchers.get(0).build();
    }

    @Override
    public Matcher buildLastMatcher() {
        return this.matchers.get(this.matchers.size() - 1).build();
    }

    @Override
    public Matcher buildMatchingMatcher(Predicate<MatcherBuilder> predicate) {
        for (MatcherBuilder item : this.matchers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMatcher(Predicate<MatcherBuilder> predicate) {
        for (MatcherBuilder item : this.matchers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMatchers(List<Matcher> matchers) {
        if (this.matchers != null) {
            this._visitables.get("matchers").removeAll(this.matchers);
        }
        if (matchers != null) {
            this.matchers = new ArrayList();
            for (Matcher item : matchers) {
                this.addToMatchers(item);
            }
        } else {
            this.matchers = null;
        }
        return (A)this;
    }

    @Override
    public A withMatchers(Matcher ... matchers) {
        if (this.matchers != null) {
            this.matchers.clear();
        }
        if (matchers != null) {
            for (Matcher item : matchers) {
                this.addToMatchers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMatchers() {
        return this.matchers != null && !this.matchers.isEmpty();
    }

    @Override
    public A addNewMatcher(String name, Boolean regex, String value) {
        return this.addToMatchers(new Matcher(name, regex, value));
    }

    @Override
    public RouteFluent.MatchersNested<A> addNewMatcher() {
        return new MatchersNestedImpl();
    }

    @Override
    public RouteFluent.MatchersNested<A> addNewMatcherLike(Matcher item) {
        return new MatchersNestedImpl(-1, item);
    }

    @Override
    public RouteFluent.MatchersNested<A> setNewMatcherLike(Integer index, Matcher item) {
        return new MatchersNestedImpl(index, item);
    }

    @Override
    public RouteFluent.MatchersNested<A> editMatcher(Integer index) {
        if (this.matchers.size() <= index) {
            throw new RuntimeException("Can't edit matchers. Index exceeds size.");
        }
        return this.setNewMatcherLike(index, this.buildMatcher(index));
    }

    @Override
    public RouteFluent.MatchersNested<A> editFirstMatcher() {
        if (this.matchers.size() == 0) {
            throw new RuntimeException("Can't edit first matchers. The list is empty.");
        }
        return this.setNewMatcherLike(0, this.buildMatcher(0));
    }

    @Override
    public RouteFluent.MatchersNested<A> editLastMatcher() {
        int index = this.matchers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last matchers. The list is empty.");
        }
        return this.setNewMatcherLike(index, this.buildMatcher(index));
    }

    @Override
    public RouteFluent.MatchersNested<A> editMatchingMatcher(Predicate<MatcherBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.matchers.size(); ++i) {
            if (!predicate.test(this.matchers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching matchers. No match found.");
        }
        return this.setNewMatcherLike(index, this.buildMatcher(index));
    }

    @Override
    public String getReceiver() {
        return this.receiver;
    }

    @Override
    public A withReceiver(String receiver) {
        this.receiver = receiver;
        return (A)this;
    }

    @Override
    public Boolean hasReceiver() {
        return this.receiver != null;
    }

    @Override
    public String getRepeatInterval() {
        return this.repeatInterval;
    }

    @Override
    public A withRepeatInterval(String repeatInterval) {
        this.repeatInterval = repeatInterval;
        return (A)this;
    }

    @Override
    public Boolean hasRepeatInterval() {
        return this.repeatInterval != null;
    }

    @Override
    public A addToRoutes(Integer index, JsonNode item) {
        if (this.routes == null) {
            this.routes = new ArrayList<JsonNode>();
        }
        this.routes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToRoutes(Integer index, JsonNode item) {
        if (this.routes == null) {
            this.routes = new ArrayList<JsonNode>();
        }
        this.routes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToRoutes(JsonNode ... items) {
        if (this.routes == null) {
            this.routes = new ArrayList<JsonNode>();
        }
        for (JsonNode item : items) {
            this.routes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToRoutes(Collection<JsonNode> items) {
        if (this.routes == null) {
            this.routes = new ArrayList<JsonNode>();
        }
        for (JsonNode item : items) {
            this.routes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromRoutes(JsonNode ... items) {
        for (JsonNode item : items) {
            if (this.routes == null) continue;
            this.routes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRoutes(Collection<JsonNode> items) {
        for (JsonNode item : items) {
            if (this.routes == null) continue;
            this.routes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<JsonNode> getRoutes() {
        return this.routes;
    }

    @Override
    public JsonNode getRoute(Integer index) {
        return this.routes.get(index);
    }

    @Override
    public JsonNode getFirstRoute() {
        return this.routes.get(0);
    }

    @Override
    public JsonNode getLastRoute() {
        return this.routes.get(this.routes.size() - 1);
    }

    @Override
    public JsonNode getMatchingRoute(Predicate<JsonNode> predicate) {
        for (JsonNode item : this.routes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRoute(Predicate<JsonNode> predicate) {
        for (JsonNode item : this.routes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRoutes(List<JsonNode> routes) {
        if (routes != null) {
            this.routes = new ArrayList<JsonNode>();
            for (JsonNode item : routes) {
                this.addToRoutes(item);
            }
        } else {
            this.routes = null;
        }
        return (A)this;
    }

    @Override
    public A withRoutes(JsonNode ... routes) {
        if (this.routes != null) {
            this.routes.clear();
        }
        if (routes != null) {
            for (JsonNode item : routes) {
                this.addToRoutes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRoutes() {
        return this.routes != null && !this.routes.isEmpty();
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteFluentImpl that = (RouteFluentImpl)o;
        if (this._continue != null ? !this._continue.equals(that._continue) : that._continue != null) {
            return false;
        }
        if (this.groupBy != null ? !this.groupBy.equals(that.groupBy) : that.groupBy != null) {
            return false;
        }
        if (this.groupInterval != null ? !this.groupInterval.equals(that.groupInterval) : that.groupInterval != null) {
            return false;
        }
        if (this.groupWait != null ? !this.groupWait.equals(that.groupWait) : that.groupWait != null) {
            return false;
        }
        if (this.matchers != null ? !this.matchers.equals(that.matchers) : that.matchers != null) {
            return false;
        }
        if (this.receiver != null ? !this.receiver.equals(that.receiver) : that.receiver != null) {
            return false;
        }
        if (this.repeatInterval != null ? !this.repeatInterval.equals(that.repeatInterval) : that.repeatInterval != null) {
            return false;
        }
        if (this.routes != null ? !this.routes.equals(that.routes) : that.routes != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this._continue, this.groupBy, this.groupInterval, this.groupWait, this.matchers, this.receiver, this.repeatInterval, this.routes, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this._continue != null) {
            sb.append("_continue:");
            sb.append(this._continue + ",");
        }
        if (this.groupBy != null && !this.groupBy.isEmpty()) {
            sb.append("groupBy:");
            sb.append(this.groupBy + ",");
        }
        if (this.groupInterval != null) {
            sb.append("groupInterval:");
            sb.append(this.groupInterval + ",");
        }
        if (this.groupWait != null) {
            sb.append("groupWait:");
            sb.append(this.groupWait + ",");
        }
        if (this.matchers != null && !this.matchers.isEmpty()) {
            sb.append("matchers:");
            sb.append(this.matchers + ",");
        }
        if (this.receiver != null) {
            sb.append("receiver:");
            sb.append(this.receiver + ",");
        }
        if (this.repeatInterval != null) {
            sb.append("repeatInterval:");
            sb.append(this.repeatInterval + ",");
        }
        if (this.routes != null && !this.routes.isEmpty()) {
            sb.append("routes:");
            sb.append(this.routes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withContinue() {
        return this.withContinue(true);
    }

    class MatchersNestedImpl<N>
    extends MatcherFluentImpl<RouteFluent.MatchersNested<N>>
    implements RouteFluent.MatchersNested<N>,
    Nested<N> {
        MatcherBuilder builder;
        Integer index;

        MatchersNestedImpl(Integer index, Matcher item) {
            this.index = index;
            this.builder = new MatcherBuilder(this, item);
        }

        MatchersNestedImpl() {
            this.index = -1;
            this.builder = new MatcherBuilder(this);
        }

        @Override
        public N and() {
            return (N)RouteFluentImpl.this.setToMatchers(this.index, this.builder.build());
        }

        @Override
        public N endMatcher() {
            return this.and();
        }
    }
}

