/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_1.monitoring.v1;

import io.fabric8.kubernetes.api.builder.v6_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_1.Nested;
import io.fabric8.kubernetes.api.model.v6_1.ResourceRequirements;
import io.fabric8.kubernetes.api.model.v6_1.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.v6_1.ResourceRequirementsFluentImpl;
import io.fabric8.kubernetes.api.model.v6_1.SecretKeySelector;
import io.fabric8.kubernetes.api.model.v6_1.VolumeMount;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1.TLSConfig;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1.TLSConfigBuilder;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1.TLSConfigFluentImpl;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1.ThanosSpec;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1.ThanosSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ThanosSpecFluentImpl<A extends ThanosSpecFluent<A>>
extends BaseFluent<A>
implements ThanosSpecFluent<A> {
    private String baseImage;
    private TLSConfigBuilder grpcServerTlsConfig;
    private String image;
    private Boolean listenLocal;
    private String logFormat;
    private String logLevel;
    private String minTime;
    private SecretKeySelector objectStorageConfig;
    private String objectStorageConfigFile;
    private String readyTimeout;
    private ResourceRequirementsBuilder resources;
    private String sha;
    private String tag;
    private SecretKeySelector tracingConfig;
    private String tracingConfigFile;
    private String version;
    private List<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
    private Map<String, Object> additionalProperties;

    public ThanosSpecFluentImpl() {
    }

    public ThanosSpecFluentImpl(ThanosSpec instance) {
        this.withBaseImage(instance.getBaseImage());
        this.withGrpcServerTlsConfig(instance.getGrpcServerTlsConfig());
        this.withImage(instance.getImage());
        this.withListenLocal(instance.getListenLocal());
        this.withLogFormat(instance.getLogFormat());
        this.withLogLevel(instance.getLogLevel());
        this.withMinTime(instance.getMinTime());
        this.withObjectStorageConfig(instance.getObjectStorageConfig());
        this.withObjectStorageConfigFile(instance.getObjectStorageConfigFile());
        this.withReadyTimeout(instance.getReadyTimeout());
        this.withResources(instance.getResources());
        this.withSha(instance.getSha());
        this.withTag(instance.getTag());
        this.withTracingConfig(instance.getTracingConfig());
        this.withTracingConfigFile(instance.getTracingConfigFile());
        this.withVersion(instance.getVersion());
        this.withVolumeMounts(instance.getVolumeMounts());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getBaseImage() {
        return this.baseImage;
    }

    @Override
    public A withBaseImage(String baseImage) {
        this.baseImage = baseImage;
        return (A)this;
    }

    @Override
    public Boolean hasBaseImage() {
        return this.baseImage != null;
    }

    @Override
    @Deprecated
    public TLSConfig getGrpcServerTlsConfig() {
        return this.grpcServerTlsConfig != null ? this.grpcServerTlsConfig.build() : null;
    }

    @Override
    public TLSConfig buildGrpcServerTlsConfig() {
        return this.grpcServerTlsConfig != null ? this.grpcServerTlsConfig.build() : null;
    }

    @Override
    public A withGrpcServerTlsConfig(TLSConfig grpcServerTlsConfig) {
        this._visitables.get("grpcServerTlsConfig").remove(this.grpcServerTlsConfig);
        if (grpcServerTlsConfig != null) {
            this.grpcServerTlsConfig = new TLSConfigBuilder(grpcServerTlsConfig);
            this._visitables.get("grpcServerTlsConfig").add(this.grpcServerTlsConfig);
        } else {
            this.grpcServerTlsConfig = null;
            this._visitables.get("grpcServerTlsConfig").remove(this.grpcServerTlsConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasGrpcServerTlsConfig() {
        return this.grpcServerTlsConfig != null;
    }

    @Override
    public ThanosSpecFluent.GrpcServerTlsConfigNested<A> withNewGrpcServerTlsConfig() {
        return new GrpcServerTlsConfigNestedImpl();
    }

    @Override
    public ThanosSpecFluent.GrpcServerTlsConfigNested<A> withNewGrpcServerTlsConfigLike(TLSConfig item) {
        return new GrpcServerTlsConfigNestedImpl(item);
    }

    @Override
    public ThanosSpecFluent.GrpcServerTlsConfigNested<A> editGrpcServerTlsConfig() {
        return this.withNewGrpcServerTlsConfigLike(this.getGrpcServerTlsConfig());
    }

    @Override
    public ThanosSpecFluent.GrpcServerTlsConfigNested<A> editOrNewGrpcServerTlsConfig() {
        return this.withNewGrpcServerTlsConfigLike(this.getGrpcServerTlsConfig() != null ? this.getGrpcServerTlsConfig() : new TLSConfigBuilder().build());
    }

    @Override
    public ThanosSpecFluent.GrpcServerTlsConfigNested<A> editOrNewGrpcServerTlsConfigLike(TLSConfig item) {
        return this.withNewGrpcServerTlsConfigLike(this.getGrpcServerTlsConfig() != null ? this.getGrpcServerTlsConfig() : item);
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public Boolean getListenLocal() {
        return this.listenLocal;
    }

    @Override
    public A withListenLocal(Boolean listenLocal) {
        this.listenLocal = listenLocal;
        return (A)this;
    }

    @Override
    public Boolean hasListenLocal() {
        return this.listenLocal != null;
    }

    @Override
    public String getLogFormat() {
        return this.logFormat;
    }

    @Override
    public A withLogFormat(String logFormat) {
        this.logFormat = logFormat;
        return (A)this;
    }

    @Override
    public Boolean hasLogFormat() {
        return this.logFormat != null;
    }

    @Override
    public String getLogLevel() {
        return this.logLevel;
    }

    @Override
    public A withLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return (A)this;
    }

    @Override
    public Boolean hasLogLevel() {
        return this.logLevel != null;
    }

    @Override
    public String getMinTime() {
        return this.minTime;
    }

    @Override
    public A withMinTime(String minTime) {
        this.minTime = minTime;
        return (A)this;
    }

    @Override
    public Boolean hasMinTime() {
        return this.minTime != null;
    }

    @Override
    public SecretKeySelector getObjectStorageConfig() {
        return this.objectStorageConfig;
    }

    @Override
    public A withObjectStorageConfig(SecretKeySelector objectStorageConfig) {
        this.objectStorageConfig = objectStorageConfig;
        return (A)this;
    }

    @Override
    public Boolean hasObjectStorageConfig() {
        return this.objectStorageConfig != null;
    }

    @Override
    public A withNewObjectStorageConfig(String key, String name, Boolean optional) {
        return this.withObjectStorageConfig(new SecretKeySelector(key, name, optional));
    }

    @Override
    public String getObjectStorageConfigFile() {
        return this.objectStorageConfigFile;
    }

    @Override
    public A withObjectStorageConfigFile(String objectStorageConfigFile) {
        this.objectStorageConfigFile = objectStorageConfigFile;
        return (A)this;
    }

    @Override
    public Boolean hasObjectStorageConfigFile() {
        return this.objectStorageConfigFile != null;
    }

    @Override
    public String getReadyTimeout() {
        return this.readyTimeout;
    }

    @Override
    public A withReadyTimeout(String readyTimeout) {
        this.readyTimeout = readyTimeout;
        return (A)this;
    }

    @Override
    public Boolean hasReadyTimeout() {
        return this.readyTimeout != null;
    }

    @Override
    @Deprecated
    public ResourceRequirements getResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public A withResources(ResourceRequirements resources) {
        this._visitables.get("resources").remove(this.resources);
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.get("resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get("resources").remove(this.resources);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    public ThanosSpecFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public ThanosSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public ThanosSpecFluent.ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public ThanosSpecFluent.ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : new ResourceRequirementsBuilder().build());
    }

    @Override
    public ThanosSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : item);
    }

    @Override
    public String getSha() {
        return this.sha;
    }

    @Override
    public A withSha(String sha) {
        this.sha = sha;
        return (A)this;
    }

    @Override
    public Boolean hasSha() {
        return this.sha != null;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public A withTag(String tag) {
        this.tag = tag;
        return (A)this;
    }

    @Override
    public Boolean hasTag() {
        return this.tag != null;
    }

    @Override
    public SecretKeySelector getTracingConfig() {
        return this.tracingConfig;
    }

    @Override
    public A withTracingConfig(SecretKeySelector tracingConfig) {
        this.tracingConfig = tracingConfig;
        return (A)this;
    }

    @Override
    public Boolean hasTracingConfig() {
        return this.tracingConfig != null;
    }

    @Override
    public A withNewTracingConfig(String key, String name, Boolean optional) {
        return this.withTracingConfig(new SecretKeySelector(key, name, optional));
    }

    @Override
    public String getTracingConfigFile() {
        return this.tracingConfigFile;
    }

    @Override
    public A withTracingConfigFile(String tracingConfigFile) {
        this.tracingConfigFile = tracingConfigFile;
        return (A)this;
    }

    @Override
    public Boolean hasTracingConfigFile() {
        return this.tracingConfigFile != null;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    @Override
    public Boolean hasVersion() {
        return this.version != null;
    }

    @Override
    public A addToVolumeMounts(Integer index, VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMount>();
        }
        this.volumeMounts.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVolumeMounts(Integer index, VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMount>();
        }
        this.volumeMounts.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVolumeMounts(VolumeMount ... items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMount>();
        }
        for (VolumeMount item : items) {
            this.volumeMounts.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumeMounts(Collection<VolumeMount> items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMount>();
        }
        for (VolumeMount item : items) {
            this.volumeMounts.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumeMounts(VolumeMount ... items) {
        for (VolumeMount item : items) {
            if (this.volumeMounts == null) continue;
            this.volumeMounts.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumeMounts(Collection<VolumeMount> items) {
        for (VolumeMount item : items) {
            if (this.volumeMounts == null) continue;
            this.volumeMounts.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<VolumeMount> getVolumeMounts() {
        return this.volumeMounts;
    }

    @Override
    public VolumeMount getVolumeMount(Integer index) {
        return this.volumeMounts.get(index);
    }

    @Override
    public VolumeMount getFirstVolumeMount() {
        return this.volumeMounts.get(0);
    }

    @Override
    public VolumeMount getLastVolumeMount() {
        return this.volumeMounts.get(this.volumeMounts.size() - 1);
    }

    @Override
    public VolumeMount getMatchingVolumeMount(Predicate<VolumeMount> predicate) {
        for (VolumeMount item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolumeMount(Predicate<VolumeMount> predicate) {
        for (VolumeMount item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumeMounts(List<VolumeMount> volumeMounts) {
        if (volumeMounts != null) {
            this.volumeMounts = new ArrayList<VolumeMount>();
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        } else {
            this.volumeMounts = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumeMounts(VolumeMount ... volumeMounts) {
        if (this.volumeMounts != null) {
            this.volumeMounts.clear();
        }
        if (volumeMounts != null) {
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumeMounts() {
        return this.volumeMounts != null && !this.volumeMounts.isEmpty();
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThanosSpecFluentImpl that = (ThanosSpecFluentImpl)o;
        if (this.baseImage != null ? !this.baseImage.equals(that.baseImage) : that.baseImage != null) {
            return false;
        }
        if (this.grpcServerTlsConfig != null ? !this.grpcServerTlsConfig.equals(that.grpcServerTlsConfig) : that.grpcServerTlsConfig != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.listenLocal != null ? !this.listenLocal.equals(that.listenLocal) : that.listenLocal != null) {
            return false;
        }
        if (this.logFormat != null ? !this.logFormat.equals(that.logFormat) : that.logFormat != null) {
            return false;
        }
        if (this.logLevel != null ? !this.logLevel.equals(that.logLevel) : that.logLevel != null) {
            return false;
        }
        if (this.minTime != null ? !this.minTime.equals(that.minTime) : that.minTime != null) {
            return false;
        }
        if (this.objectStorageConfig != null ? !this.objectStorageConfig.equals(that.objectStorageConfig) : that.objectStorageConfig != null) {
            return false;
        }
        if (this.objectStorageConfigFile != null ? !this.objectStorageConfigFile.equals(that.objectStorageConfigFile) : that.objectStorageConfigFile != null) {
            return false;
        }
        if (this.readyTimeout != null ? !this.readyTimeout.equals(that.readyTimeout) : that.readyTimeout != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.sha != null ? !this.sha.equals(that.sha) : that.sha != null) {
            return false;
        }
        if (this.tag != null ? !this.tag.equals(that.tag) : that.tag != null) {
            return false;
        }
        if (this.tracingConfig != null ? !this.tracingConfig.equals(that.tracingConfig) : that.tracingConfig != null) {
            return false;
        }
        if (this.tracingConfigFile != null ? !this.tracingConfigFile.equals(that.tracingConfigFile) : that.tracingConfigFile != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        if (this.volumeMounts != null ? !this.volumeMounts.equals(that.volumeMounts) : that.volumeMounts != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.baseImage, this.grpcServerTlsConfig, this.image, this.listenLocal, this.logFormat, this.logLevel, this.minTime, this.objectStorageConfig, this.objectStorageConfigFile, this.readyTimeout, this.resources, this.sha, this.tag, this.tracingConfig, this.tracingConfigFile, this.version, this.volumeMounts, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.baseImage != null) {
            sb.append("baseImage:");
            sb.append(this.baseImage + ",");
        }
        if (this.grpcServerTlsConfig != null) {
            sb.append("grpcServerTlsConfig:");
            sb.append(this.grpcServerTlsConfig + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.listenLocal != null) {
            sb.append("listenLocal:");
            sb.append(this.listenLocal + ",");
        }
        if (this.logFormat != null) {
            sb.append("logFormat:");
            sb.append(this.logFormat + ",");
        }
        if (this.logLevel != null) {
            sb.append("logLevel:");
            sb.append(this.logLevel + ",");
        }
        if (this.minTime != null) {
            sb.append("minTime:");
            sb.append(this.minTime + ",");
        }
        if (this.objectStorageConfig != null) {
            sb.append("objectStorageConfig:");
            sb.append(this.objectStorageConfig + ",");
        }
        if (this.objectStorageConfigFile != null) {
            sb.append("objectStorageConfigFile:");
            sb.append(this.objectStorageConfigFile + ",");
        }
        if (this.readyTimeout != null) {
            sb.append("readyTimeout:");
            sb.append(this.readyTimeout + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.sha != null) {
            sb.append("sha:");
            sb.append(this.sha + ",");
        }
        if (this.tag != null) {
            sb.append("tag:");
            sb.append(this.tag + ",");
        }
        if (this.tracingConfig != null) {
            sb.append("tracingConfig:");
            sb.append(this.tracingConfig + ",");
        }
        if (this.tracingConfigFile != null) {
            sb.append("tracingConfigFile:");
            sb.append(this.tracingConfigFile + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.volumeMounts != null && !this.volumeMounts.isEmpty()) {
            sb.append("volumeMounts:");
            sb.append(this.volumeMounts + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withListenLocal() {
        return this.withListenLocal(true);
    }

    class ResourcesNestedImpl<N>
    extends ResourceRequirementsFluentImpl<ThanosSpecFluent.ResourcesNested<N>>
    implements ThanosSpecFluent.ResourcesNested<N>,
    Nested<N> {
        ResourceRequirementsBuilder builder;

        ResourcesNestedImpl(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.builder = new ResourceRequirementsBuilder(this);
        }

        @Override
        public N and() {
            return (N)ThanosSpecFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }

    class GrpcServerTlsConfigNestedImpl<N>
    extends TLSConfigFluentImpl<ThanosSpecFluent.GrpcServerTlsConfigNested<N>>
    implements ThanosSpecFluent.GrpcServerTlsConfigNested<N>,
    Nested<N> {
        TLSConfigBuilder builder;

        GrpcServerTlsConfigNestedImpl(TLSConfig item) {
            this.builder = new TLSConfigBuilder(this, item);
        }

        GrpcServerTlsConfigNestedImpl() {
            this.builder = new TLSConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)ThanosSpecFluentImpl.this.withGrpcServerTlsConfig(this.builder.build());
        }

        @Override
        public N endGrpcServerTlsConfig() {
            return this.and();
        }
    }
}

