/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_1.monitoring.v1;

import io.fabric8.kubernetes.api.builder.v6_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_1.Nested;
import io.fabric8.kubernetes.api.model.v6_1.SecretKeySelector;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1.BasicAuth;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1.BasicAuthBuilder;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1.BasicAuthFluentImpl;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1.OAuth2;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1.OAuth2Builder;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1.OAuth2FluentImpl;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1.ProbeSpec;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1.ProbeSpecFluent;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1.ProbeTLSConfig;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1.ProbeTLSConfigBuilder;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1.ProbeTLSConfigFluentImpl;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1.ProbeTargets;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1.ProbeTargetsBuilder;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1.ProbeTargetsFluentImpl;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1.ProberSpec;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1.ProberSpecBuilder;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1.ProberSpecFluentImpl;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1.RelabelConfig;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1.RelabelConfigBuilder;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1.RelabelConfigFluentImpl;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1.SafeAuthorization;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1.SafeAuthorizationBuilder;
import io.fabric8.openshift.api.model.v6_1.monitoring.v1.SafeAuthorizationFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ProbeSpecFluentImpl<A extends ProbeSpecFluent<A>>
extends BaseFluent<A>
implements ProbeSpecFluent<A> {
    private SafeAuthorizationBuilder authorization;
    private BasicAuthBuilder basicAuth;
    private SecretKeySelector bearerTokenSecret;
    private String interval;
    private String jobName;
    private Long labelLimit;
    private Long labelNameLengthLimit;
    private Long labelValueLengthLimit;
    private ArrayList<RelabelConfigBuilder> metricRelabelings = new ArrayList();
    private String module;
    private OAuth2Builder oauth2;
    private ProberSpecBuilder prober;
    private Long sampleLimit;
    private String scrapeTimeout;
    private Long targetLimit;
    private ProbeTargetsBuilder targets;
    private ProbeTLSConfigBuilder tlsConfig;
    private Map<String, Object> additionalProperties;

    public ProbeSpecFluentImpl() {
    }

    public ProbeSpecFluentImpl(ProbeSpec instance) {
        this.withAuthorization(instance.getAuthorization());
        this.withBasicAuth(instance.getBasicAuth());
        this.withBearerTokenSecret(instance.getBearerTokenSecret());
        this.withInterval(instance.getInterval());
        this.withJobName(instance.getJobName());
        this.withLabelLimit(instance.getLabelLimit());
        this.withLabelNameLengthLimit(instance.getLabelNameLengthLimit());
        this.withLabelValueLengthLimit(instance.getLabelValueLengthLimit());
        this.withMetricRelabelings(instance.getMetricRelabelings());
        this.withModule(instance.getModule());
        this.withOauth2(instance.getOauth2());
        this.withProber(instance.getProber());
        this.withSampleLimit(instance.getSampleLimit());
        this.withScrapeTimeout(instance.getScrapeTimeout());
        this.withTargetLimit(instance.getTargetLimit());
        this.withTargets(instance.getTargets());
        this.withTlsConfig(instance.getTlsConfig());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public SafeAuthorization getAuthorization() {
        return this.authorization != null ? this.authorization.build() : null;
    }

    @Override
    public SafeAuthorization buildAuthorization() {
        return this.authorization != null ? this.authorization.build() : null;
    }

    @Override
    public A withAuthorization(SafeAuthorization authorization) {
        this._visitables.get("authorization").remove(this.authorization);
        if (authorization != null) {
            this.authorization = new SafeAuthorizationBuilder(authorization);
            this._visitables.get("authorization").add(this.authorization);
        } else {
            this.authorization = null;
            this._visitables.get("authorization").remove(this.authorization);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAuthorization() {
        return this.authorization != null;
    }

    @Override
    public ProbeSpecFluent.AuthorizationNested<A> withNewAuthorization() {
        return new AuthorizationNestedImpl();
    }

    @Override
    public ProbeSpecFluent.AuthorizationNested<A> withNewAuthorizationLike(SafeAuthorization item) {
        return new AuthorizationNestedImpl(item);
    }

    @Override
    public ProbeSpecFluent.AuthorizationNested<A> editAuthorization() {
        return this.withNewAuthorizationLike(this.getAuthorization());
    }

    @Override
    public ProbeSpecFluent.AuthorizationNested<A> editOrNewAuthorization() {
        return this.withNewAuthorizationLike(this.getAuthorization() != null ? this.getAuthorization() : new SafeAuthorizationBuilder().build());
    }

    @Override
    public ProbeSpecFluent.AuthorizationNested<A> editOrNewAuthorizationLike(SafeAuthorization item) {
        return this.withNewAuthorizationLike(this.getAuthorization() != null ? this.getAuthorization() : item);
    }

    @Override
    @Deprecated
    public BasicAuth getBasicAuth() {
        return this.basicAuth != null ? this.basicAuth.build() : null;
    }

    @Override
    public BasicAuth buildBasicAuth() {
        return this.basicAuth != null ? this.basicAuth.build() : null;
    }

    @Override
    public A withBasicAuth(BasicAuth basicAuth) {
        this._visitables.get("basicAuth").remove(this.basicAuth);
        if (basicAuth != null) {
            this.basicAuth = new BasicAuthBuilder(basicAuth);
            this._visitables.get("basicAuth").add(this.basicAuth);
        } else {
            this.basicAuth = null;
            this._visitables.get("basicAuth").remove(this.basicAuth);
        }
        return (A)this;
    }

    @Override
    public Boolean hasBasicAuth() {
        return this.basicAuth != null;
    }

    @Override
    public ProbeSpecFluent.BasicAuthNested<A> withNewBasicAuth() {
        return new BasicAuthNestedImpl();
    }

    @Override
    public ProbeSpecFluent.BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item) {
        return new BasicAuthNestedImpl(item);
    }

    @Override
    public ProbeSpecFluent.BasicAuthNested<A> editBasicAuth() {
        return this.withNewBasicAuthLike(this.getBasicAuth());
    }

    @Override
    public ProbeSpecFluent.BasicAuthNested<A> editOrNewBasicAuth() {
        return this.withNewBasicAuthLike(this.getBasicAuth() != null ? this.getBasicAuth() : new BasicAuthBuilder().build());
    }

    @Override
    public ProbeSpecFluent.BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item) {
        return this.withNewBasicAuthLike(this.getBasicAuth() != null ? this.getBasicAuth() : item);
    }

    @Override
    public SecretKeySelector getBearerTokenSecret() {
        return this.bearerTokenSecret;
    }

    @Override
    public A withBearerTokenSecret(SecretKeySelector bearerTokenSecret) {
        this.bearerTokenSecret = bearerTokenSecret;
        return (A)this;
    }

    @Override
    public Boolean hasBearerTokenSecret() {
        return this.bearerTokenSecret != null;
    }

    @Override
    public A withNewBearerTokenSecret(String key, String name, Boolean optional) {
        return this.withBearerTokenSecret(new SecretKeySelector(key, name, optional));
    }

    @Override
    public String getInterval() {
        return this.interval;
    }

    @Override
    public A withInterval(String interval) {
        this.interval = interval;
        return (A)this;
    }

    @Override
    public Boolean hasInterval() {
        return this.interval != null;
    }

    @Override
    public String getJobName() {
        return this.jobName;
    }

    @Override
    public A withJobName(String jobName) {
        this.jobName = jobName;
        return (A)this;
    }

    @Override
    public Boolean hasJobName() {
        return this.jobName != null;
    }

    @Override
    public Long getLabelLimit() {
        return this.labelLimit;
    }

    @Override
    public A withLabelLimit(Long labelLimit) {
        this.labelLimit = labelLimit;
        return (A)this;
    }

    @Override
    public Boolean hasLabelLimit() {
        return this.labelLimit != null;
    }

    @Override
    public Long getLabelNameLengthLimit() {
        return this.labelNameLengthLimit;
    }

    @Override
    public A withLabelNameLengthLimit(Long labelNameLengthLimit) {
        this.labelNameLengthLimit = labelNameLengthLimit;
        return (A)this;
    }

    @Override
    public Boolean hasLabelNameLengthLimit() {
        return this.labelNameLengthLimit != null;
    }

    @Override
    public Long getLabelValueLengthLimit() {
        return this.labelValueLengthLimit;
    }

    @Override
    public A withLabelValueLengthLimit(Long labelValueLengthLimit) {
        this.labelValueLengthLimit = labelValueLengthLimit;
        return (A)this;
    }

    @Override
    public Boolean hasLabelValueLengthLimit() {
        return this.labelValueLengthLimit != null;
    }

    @Override
    public A addToMetricRelabelings(Integer index, RelabelConfig item) {
        if (this.metricRelabelings == null) {
            this.metricRelabelings = new ArrayList();
        }
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        this._visitables.get("metricRelabelings").add(index >= 0 ? index.intValue() : this._visitables.get("metricRelabelings").size(), builder);
        this.metricRelabelings.add(index >= 0 ? index.intValue() : this.metricRelabelings.size(), builder);
        return (A)this;
    }

    @Override
    public A setToMetricRelabelings(Integer index, RelabelConfig item) {
        if (this.metricRelabelings == null) {
            this.metricRelabelings = new ArrayList();
        }
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        if (index < 0 || index >= this._visitables.get("metricRelabelings").size()) {
            this._visitables.get("metricRelabelings").add(builder);
        } else {
            this._visitables.get("metricRelabelings").set(index, builder);
        }
        if (index < 0 || index >= this.metricRelabelings.size()) {
            this.metricRelabelings.add(builder);
        } else {
            this.metricRelabelings.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToMetricRelabelings(RelabelConfig ... items) {
        if (this.metricRelabelings == null) {
            this.metricRelabelings = new ArrayList();
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get("metricRelabelings").add(builder);
            this.metricRelabelings.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToMetricRelabelings(Collection<RelabelConfig> items) {
        if (this.metricRelabelings == null) {
            this.metricRelabelings = new ArrayList();
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get("metricRelabelings").add(builder);
            this.metricRelabelings.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromMetricRelabelings(RelabelConfig ... items) {
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get("metricRelabelings").remove(builder);
            if (this.metricRelabelings == null) continue;
            this.metricRelabelings.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMetricRelabelings(Collection<RelabelConfig> items) {
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get("metricRelabelings").remove(builder);
            if (this.metricRelabelings == null) continue;
            this.metricRelabelings.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromMetricRelabelings(Predicate<RelabelConfigBuilder> predicate) {
        if (this.metricRelabelings == null) {
            return (A)this;
        }
        Iterator<RelabelConfigBuilder> each = this.metricRelabelings.iterator();
        Object visitables = this._visitables.get("metricRelabelings");
        while (each.hasNext()) {
            RelabelConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<RelabelConfig> getMetricRelabelings() {
        return this.metricRelabelings != null ? ProbeSpecFluentImpl.build(this.metricRelabelings) : null;
    }

    @Override
    public List<RelabelConfig> buildMetricRelabelings() {
        return this.metricRelabelings != null ? ProbeSpecFluentImpl.build(this.metricRelabelings) : null;
    }

    @Override
    public RelabelConfig buildMetricRelabeling(Integer index) {
        return this.metricRelabelings.get(index).build();
    }

    @Override
    public RelabelConfig buildFirstMetricRelabeling() {
        return this.metricRelabelings.get(0).build();
    }

    @Override
    public RelabelConfig buildLastMetricRelabeling() {
        return this.metricRelabelings.get(this.metricRelabelings.size() - 1).build();
    }

    @Override
    public RelabelConfig buildMatchingMetricRelabeling(Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item : this.metricRelabelings) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMetricRelabeling(Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item : this.metricRelabelings) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMetricRelabelings(List<RelabelConfig> metricRelabelings) {
        if (this.metricRelabelings != null) {
            this._visitables.get("metricRelabelings").removeAll(this.metricRelabelings);
        }
        if (metricRelabelings != null) {
            this.metricRelabelings = new ArrayList();
            for (RelabelConfig item : metricRelabelings) {
                this.addToMetricRelabelings(item);
            }
        } else {
            this.metricRelabelings = null;
        }
        return (A)this;
    }

    @Override
    public A withMetricRelabelings(RelabelConfig ... metricRelabelings) {
        if (this.metricRelabelings != null) {
            this.metricRelabelings.clear();
        }
        if (metricRelabelings != null) {
            for (RelabelConfig item : metricRelabelings) {
                this.addToMetricRelabelings(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetricRelabelings() {
        return this.metricRelabelings != null && !this.metricRelabelings.isEmpty();
    }

    @Override
    public ProbeSpecFluent.MetricRelabelingsNested<A> addNewMetricRelabeling() {
        return new MetricRelabelingsNestedImpl();
    }

    @Override
    public ProbeSpecFluent.MetricRelabelingsNested<A> addNewMetricRelabelingLike(RelabelConfig item) {
        return new MetricRelabelingsNestedImpl(-1, item);
    }

    @Override
    public ProbeSpecFluent.MetricRelabelingsNested<A> setNewMetricRelabelingLike(Integer index, RelabelConfig item) {
        return new MetricRelabelingsNestedImpl(index, item);
    }

    @Override
    public ProbeSpecFluent.MetricRelabelingsNested<A> editMetricRelabeling(Integer index) {
        if (this.metricRelabelings.size() <= index) {
            throw new RuntimeException("Can't edit metricRelabelings. Index exceeds size.");
        }
        return this.setNewMetricRelabelingLike(index, this.buildMetricRelabeling(index));
    }

    @Override
    public ProbeSpecFluent.MetricRelabelingsNested<A> editFirstMetricRelabeling() {
        if (this.metricRelabelings.size() == 0) {
            throw new RuntimeException("Can't edit first metricRelabelings. The list is empty.");
        }
        return this.setNewMetricRelabelingLike(0, this.buildMetricRelabeling(0));
    }

    @Override
    public ProbeSpecFluent.MetricRelabelingsNested<A> editLastMetricRelabeling() {
        int index = this.metricRelabelings.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last metricRelabelings. The list is empty.");
        }
        return this.setNewMetricRelabelingLike(index, this.buildMetricRelabeling(index));
    }

    @Override
    public ProbeSpecFluent.MetricRelabelingsNested<A> editMatchingMetricRelabeling(Predicate<RelabelConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.metricRelabelings.size(); ++i) {
            if (!predicate.test(this.metricRelabelings.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching metricRelabelings. No match found.");
        }
        return this.setNewMetricRelabelingLike(index, this.buildMetricRelabeling(index));
    }

    @Override
    public String getModule() {
        return this.module;
    }

    @Override
    public A withModule(String module) {
        this.module = module;
        return (A)this;
    }

    @Override
    public Boolean hasModule() {
        return this.module != null;
    }

    @Override
    @Deprecated
    public OAuth2 getOauth2() {
        return this.oauth2 != null ? this.oauth2.build() : null;
    }

    @Override
    public OAuth2 buildOauth2() {
        return this.oauth2 != null ? this.oauth2.build() : null;
    }

    @Override
    public A withOauth2(OAuth2 oauth2) {
        this._visitables.get("oauth2").remove(this.oauth2);
        if (oauth2 != null) {
            this.oauth2 = new OAuth2Builder(oauth2);
            this._visitables.get("oauth2").add(this.oauth2);
        } else {
            this.oauth2 = null;
            this._visitables.get("oauth2").remove(this.oauth2);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOauth2() {
        return this.oauth2 != null;
    }

    @Override
    public ProbeSpecFluent.Oauth2Nested<A> withNewOauth2() {
        return new Oauth2NestedImpl();
    }

    @Override
    public ProbeSpecFluent.Oauth2Nested<A> withNewOauth2Like(OAuth2 item) {
        return new Oauth2NestedImpl(item);
    }

    @Override
    public ProbeSpecFluent.Oauth2Nested<A> editOauth2() {
        return this.withNewOauth2Like(this.getOauth2());
    }

    @Override
    public ProbeSpecFluent.Oauth2Nested<A> editOrNewOauth2() {
        return this.withNewOauth2Like(this.getOauth2() != null ? this.getOauth2() : new OAuth2Builder().build());
    }

    @Override
    public ProbeSpecFluent.Oauth2Nested<A> editOrNewOauth2Like(OAuth2 item) {
        return this.withNewOauth2Like(this.getOauth2() != null ? this.getOauth2() : item);
    }

    @Override
    @Deprecated
    public ProberSpec getProber() {
        return this.prober != null ? this.prober.build() : null;
    }

    @Override
    public ProberSpec buildProber() {
        return this.prober != null ? this.prober.build() : null;
    }

    @Override
    public A withProber(ProberSpec prober) {
        this._visitables.get("prober").remove(this.prober);
        if (prober != null) {
            this.prober = new ProberSpecBuilder(prober);
            this._visitables.get("prober").add(this.prober);
        } else {
            this.prober = null;
            this._visitables.get("prober").remove(this.prober);
        }
        return (A)this;
    }

    @Override
    public Boolean hasProber() {
        return this.prober != null;
    }

    @Override
    public A withNewProber(String path, String proxyUrl, String scheme, String url) {
        return this.withProber(new ProberSpec(path, proxyUrl, scheme, url));
    }

    @Override
    public ProbeSpecFluent.ProberNested<A> withNewProber() {
        return new ProberNestedImpl();
    }

    @Override
    public ProbeSpecFluent.ProberNested<A> withNewProberLike(ProberSpec item) {
        return new ProberNestedImpl(item);
    }

    @Override
    public ProbeSpecFluent.ProberNested<A> editProber() {
        return this.withNewProberLike(this.getProber());
    }

    @Override
    public ProbeSpecFluent.ProberNested<A> editOrNewProber() {
        return this.withNewProberLike(this.getProber() != null ? this.getProber() : new ProberSpecBuilder().build());
    }

    @Override
    public ProbeSpecFluent.ProberNested<A> editOrNewProberLike(ProberSpec item) {
        return this.withNewProberLike(this.getProber() != null ? this.getProber() : item);
    }

    @Override
    public Long getSampleLimit() {
        return this.sampleLimit;
    }

    @Override
    public A withSampleLimit(Long sampleLimit) {
        this.sampleLimit = sampleLimit;
        return (A)this;
    }

    @Override
    public Boolean hasSampleLimit() {
        return this.sampleLimit != null;
    }

    @Override
    public String getScrapeTimeout() {
        return this.scrapeTimeout;
    }

    @Override
    public A withScrapeTimeout(String scrapeTimeout) {
        this.scrapeTimeout = scrapeTimeout;
        return (A)this;
    }

    @Override
    public Boolean hasScrapeTimeout() {
        return this.scrapeTimeout != null;
    }

    @Override
    public Long getTargetLimit() {
        return this.targetLimit;
    }

    @Override
    public A withTargetLimit(Long targetLimit) {
        this.targetLimit = targetLimit;
        return (A)this;
    }

    @Override
    public Boolean hasTargetLimit() {
        return this.targetLimit != null;
    }

    @Override
    @Deprecated
    public ProbeTargets getTargets() {
        return this.targets != null ? this.targets.build() : null;
    }

    @Override
    public ProbeTargets buildTargets() {
        return this.targets != null ? this.targets.build() : null;
    }

    @Override
    public A withTargets(ProbeTargets targets) {
        this._visitables.get("targets").remove(this.targets);
        if (targets != null) {
            this.targets = new ProbeTargetsBuilder(targets);
            this._visitables.get("targets").add(this.targets);
        } else {
            this.targets = null;
            this._visitables.get("targets").remove(this.targets);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTargets() {
        return this.targets != null;
    }

    @Override
    public ProbeSpecFluent.TargetsNested<A> withNewTargets() {
        return new TargetsNestedImpl();
    }

    @Override
    public ProbeSpecFluent.TargetsNested<A> withNewTargetsLike(ProbeTargets item) {
        return new TargetsNestedImpl(item);
    }

    @Override
    public ProbeSpecFluent.TargetsNested<A> editTargets() {
        return this.withNewTargetsLike(this.getTargets());
    }

    @Override
    public ProbeSpecFluent.TargetsNested<A> editOrNewTargets() {
        return this.withNewTargetsLike(this.getTargets() != null ? this.getTargets() : new ProbeTargetsBuilder().build());
    }

    @Override
    public ProbeSpecFluent.TargetsNested<A> editOrNewTargetsLike(ProbeTargets item) {
        return this.withNewTargetsLike(this.getTargets() != null ? this.getTargets() : item);
    }

    @Override
    @Deprecated
    public ProbeTLSConfig getTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    @Override
    public ProbeTLSConfig buildTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    @Override
    public A withTlsConfig(ProbeTLSConfig tlsConfig) {
        this._visitables.get("tlsConfig").remove(this.tlsConfig);
        if (tlsConfig != null) {
            this.tlsConfig = new ProbeTLSConfigBuilder(tlsConfig);
            this._visitables.get("tlsConfig").add(this.tlsConfig);
        } else {
            this.tlsConfig = null;
            this._visitables.get("tlsConfig").remove(this.tlsConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    @Override
    public ProbeSpecFluent.TlsConfigNested<A> withNewTlsConfig() {
        return new TlsConfigNestedImpl();
    }

    @Override
    public ProbeSpecFluent.TlsConfigNested<A> withNewTlsConfigLike(ProbeTLSConfig item) {
        return new TlsConfigNestedImpl(item);
    }

    @Override
    public ProbeSpecFluent.TlsConfigNested<A> editTlsConfig() {
        return this.withNewTlsConfigLike(this.getTlsConfig());
    }

    @Override
    public ProbeSpecFluent.TlsConfigNested<A> editOrNewTlsConfig() {
        return this.withNewTlsConfigLike(this.getTlsConfig() != null ? this.getTlsConfig() : new ProbeTLSConfigBuilder().build());
    }

    @Override
    public ProbeSpecFluent.TlsConfigNested<A> editOrNewTlsConfigLike(ProbeTLSConfig item) {
        return this.withNewTlsConfigLike(this.getTlsConfig() != null ? this.getTlsConfig() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProbeSpecFluentImpl that = (ProbeSpecFluentImpl)o;
        if (this.authorization != null ? !this.authorization.equals(that.authorization) : that.authorization != null) {
            return false;
        }
        if (this.basicAuth != null ? !this.basicAuth.equals(that.basicAuth) : that.basicAuth != null) {
            return false;
        }
        if (this.bearerTokenSecret != null ? !this.bearerTokenSecret.equals(that.bearerTokenSecret) : that.bearerTokenSecret != null) {
            return false;
        }
        if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) {
            return false;
        }
        if (this.jobName != null ? !this.jobName.equals(that.jobName) : that.jobName != null) {
            return false;
        }
        if (this.labelLimit != null ? !this.labelLimit.equals(that.labelLimit) : that.labelLimit != null) {
            return false;
        }
        if (this.labelNameLengthLimit != null ? !this.labelNameLengthLimit.equals(that.labelNameLengthLimit) : that.labelNameLengthLimit != null) {
            return false;
        }
        if (this.labelValueLengthLimit != null ? !this.labelValueLengthLimit.equals(that.labelValueLengthLimit) : that.labelValueLengthLimit != null) {
            return false;
        }
        if (this.metricRelabelings != null ? !this.metricRelabelings.equals(that.metricRelabelings) : that.metricRelabelings != null) {
            return false;
        }
        if (this.module != null ? !this.module.equals(that.module) : that.module != null) {
            return false;
        }
        if (this.oauth2 != null ? !this.oauth2.equals(that.oauth2) : that.oauth2 != null) {
            return false;
        }
        if (this.prober != null ? !this.prober.equals(that.prober) : that.prober != null) {
            return false;
        }
        if (this.sampleLimit != null ? !this.sampleLimit.equals(that.sampleLimit) : that.sampleLimit != null) {
            return false;
        }
        if (this.scrapeTimeout != null ? !this.scrapeTimeout.equals(that.scrapeTimeout) : that.scrapeTimeout != null) {
            return false;
        }
        if (this.targetLimit != null ? !this.targetLimit.equals(that.targetLimit) : that.targetLimit != null) {
            return false;
        }
        if (this.targets != null ? !this.targets.equals(that.targets) : that.targets != null) {
            return false;
        }
        if (this.tlsConfig != null ? !this.tlsConfig.equals(that.tlsConfig) : that.tlsConfig != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.authorization, this.basicAuth, this.bearerTokenSecret, this.interval, this.jobName, this.labelLimit, this.labelNameLengthLimit, this.labelValueLengthLimit, this.metricRelabelings, this.module, this.oauth2, this.prober, this.sampleLimit, this.scrapeTimeout, this.targetLimit, this.targets, this.tlsConfig, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authorization != null) {
            sb.append("authorization:");
            sb.append(this.authorization + ",");
        }
        if (this.basicAuth != null) {
            sb.append("basicAuth:");
            sb.append(this.basicAuth + ",");
        }
        if (this.bearerTokenSecret != null) {
            sb.append("bearerTokenSecret:");
            sb.append(this.bearerTokenSecret + ",");
        }
        if (this.interval != null) {
            sb.append("interval:");
            sb.append(this.interval + ",");
        }
        if (this.jobName != null) {
            sb.append("jobName:");
            sb.append(this.jobName + ",");
        }
        if (this.labelLimit != null) {
            sb.append("labelLimit:");
            sb.append(this.labelLimit + ",");
        }
        if (this.labelNameLengthLimit != null) {
            sb.append("labelNameLengthLimit:");
            sb.append(this.labelNameLengthLimit + ",");
        }
        if (this.labelValueLengthLimit != null) {
            sb.append("labelValueLengthLimit:");
            sb.append(this.labelValueLengthLimit + ",");
        }
        if (this.metricRelabelings != null && !this.metricRelabelings.isEmpty()) {
            sb.append("metricRelabelings:");
            sb.append(this.metricRelabelings + ",");
        }
        if (this.module != null) {
            sb.append("module:");
            sb.append(this.module + ",");
        }
        if (this.oauth2 != null) {
            sb.append("oauth2:");
            sb.append(this.oauth2 + ",");
        }
        if (this.prober != null) {
            sb.append("prober:");
            sb.append(this.prober + ",");
        }
        if (this.sampleLimit != null) {
            sb.append("sampleLimit:");
            sb.append(this.sampleLimit + ",");
        }
        if (this.scrapeTimeout != null) {
            sb.append("scrapeTimeout:");
            sb.append(this.scrapeTimeout + ",");
        }
        if (this.targetLimit != null) {
            sb.append("targetLimit:");
            sb.append(this.targetLimit + ",");
        }
        if (this.targets != null) {
            sb.append("targets:");
            sb.append(this.targets + ",");
        }
        if (this.tlsConfig != null) {
            sb.append("tlsConfig:");
            sb.append(this.tlsConfig + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class TlsConfigNestedImpl<N>
    extends ProbeTLSConfigFluentImpl<ProbeSpecFluent.TlsConfigNested<N>>
    implements ProbeSpecFluent.TlsConfigNested<N>,
    Nested<N> {
        ProbeTLSConfigBuilder builder;

        TlsConfigNestedImpl(ProbeTLSConfig item) {
            this.builder = new ProbeTLSConfigBuilder(this, item);
        }

        TlsConfigNestedImpl() {
            this.builder = new ProbeTLSConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)ProbeSpecFluentImpl.this.withTlsConfig(this.builder.build());
        }

        @Override
        public N endTlsConfig() {
            return this.and();
        }
    }

    class TargetsNestedImpl<N>
    extends ProbeTargetsFluentImpl<ProbeSpecFluent.TargetsNested<N>>
    implements ProbeSpecFluent.TargetsNested<N>,
    Nested<N> {
        ProbeTargetsBuilder builder;

        TargetsNestedImpl(ProbeTargets item) {
            this.builder = new ProbeTargetsBuilder(this, item);
        }

        TargetsNestedImpl() {
            this.builder = new ProbeTargetsBuilder(this);
        }

        @Override
        public N and() {
            return (N)ProbeSpecFluentImpl.this.withTargets(this.builder.build());
        }

        @Override
        public N endTargets() {
            return this.and();
        }
    }

    class ProberNestedImpl<N>
    extends ProberSpecFluentImpl<ProbeSpecFluent.ProberNested<N>>
    implements ProbeSpecFluent.ProberNested<N>,
    Nested<N> {
        ProberSpecBuilder builder;

        ProberNestedImpl(ProberSpec item) {
            this.builder = new ProberSpecBuilder(this, item);
        }

        ProberNestedImpl() {
            this.builder = new ProberSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ProbeSpecFluentImpl.this.withProber(this.builder.build());
        }

        @Override
        public N endProber() {
            return this.and();
        }
    }

    class Oauth2NestedImpl<N>
    extends OAuth2FluentImpl<ProbeSpecFluent.Oauth2Nested<N>>
    implements ProbeSpecFluent.Oauth2Nested<N>,
    Nested<N> {
        OAuth2Builder builder;

        Oauth2NestedImpl(OAuth2 item) {
            this.builder = new OAuth2Builder(this, item);
        }

        Oauth2NestedImpl() {
            this.builder = new OAuth2Builder(this);
        }

        @Override
        public N and() {
            return (N)ProbeSpecFluentImpl.this.withOauth2(this.builder.build());
        }

        @Override
        public N endOauth2() {
            return this.and();
        }
    }

    class MetricRelabelingsNestedImpl<N>
    extends RelabelConfigFluentImpl<ProbeSpecFluent.MetricRelabelingsNested<N>>
    implements ProbeSpecFluent.MetricRelabelingsNested<N>,
    Nested<N> {
        RelabelConfigBuilder builder;
        Integer index;

        MetricRelabelingsNestedImpl(Integer index, RelabelConfig item) {
            this.index = index;
            this.builder = new RelabelConfigBuilder(this, item);
        }

        MetricRelabelingsNestedImpl() {
            this.index = -1;
            this.builder = new RelabelConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)ProbeSpecFluentImpl.this.setToMetricRelabelings(this.index, this.builder.build());
        }

        @Override
        public N endMetricRelabeling() {
            return this.and();
        }
    }

    class BasicAuthNestedImpl<N>
    extends BasicAuthFluentImpl<ProbeSpecFluent.BasicAuthNested<N>>
    implements ProbeSpecFluent.BasicAuthNested<N>,
    Nested<N> {
        BasicAuthBuilder builder;

        BasicAuthNestedImpl(BasicAuth item) {
            this.builder = new BasicAuthBuilder(this, item);
        }

        BasicAuthNestedImpl() {
            this.builder = new BasicAuthBuilder(this);
        }

        @Override
        public N and() {
            return (N)ProbeSpecFluentImpl.this.withBasicAuth(this.builder.build());
        }

        @Override
        public N endBasicAuth() {
            return this.and();
        }
    }

    class AuthorizationNestedImpl<N>
    extends SafeAuthorizationFluentImpl<ProbeSpecFluent.AuthorizationNested<N>>
    implements ProbeSpecFluent.AuthorizationNested<N>,
    Nested<N> {
        SafeAuthorizationBuilder builder;

        AuthorizationNestedImpl(SafeAuthorization item) {
            this.builder = new SafeAuthorizationBuilder(this, item);
        }

        AuthorizationNestedImpl() {
            this.builder = new SafeAuthorizationBuilder(this);
        }

        @Override
        public N and() {
            return (N)ProbeSpecFluentImpl.this.withAuthorization(this.builder.build());
        }

        @Override
        public N endAuthorization() {
            return this.and();
        }
    }
}

