/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_1.miscellaneous.apiserver.v1;

import io.fabric8.kubernetes.api.builder.v6_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_1.Nested;
import io.fabric8.kubernetes.api.model.v6_1.Condition;
import io.fabric8.openshift.api.model.v6_1.miscellaneous.apiserver.v1.APIRequestCountStatus;
import io.fabric8.openshift.api.model.v6_1.miscellaneous.apiserver.v1.APIRequestCountStatusFluent;
import io.fabric8.openshift.api.model.v6_1.miscellaneous.apiserver.v1.PerResourceAPIRequestLog;
import io.fabric8.openshift.api.model.v6_1.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder;
import io.fabric8.openshift.api.model.v6_1.miscellaneous.apiserver.v1.PerResourceAPIRequestLogFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class APIRequestCountStatusFluentImpl<A extends APIRequestCountStatusFluent<A>>
extends BaseFluent<A>
implements APIRequestCountStatusFluent<A> {
    private List<Condition> conditions = new ArrayList<Condition>();
    private PerResourceAPIRequestLogBuilder currentHour;
    private ArrayList<PerResourceAPIRequestLogBuilder> last24h = new ArrayList();
    private String removedInRelease;
    private Long requestCount;
    private Map<String, Object> additionalProperties;

    public APIRequestCountStatusFluentImpl() {
    }

    public APIRequestCountStatusFluentImpl(APIRequestCountStatus instance) {
        this.withConditions(instance.getConditions());
        this.withCurrentHour(instance.getCurrentHour());
        this.withLast24h(instance.getLast24h());
        this.withRemovedInRelease(instance.getRemovedInRelease());
        this.withRequestCount(instance.getRequestCount());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(Condition ... items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Override
    public Condition getCondition(Integer index) {
        return this.conditions.get(index);
    }

    @Override
    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    @Override
    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    @Override
    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    @Deprecated
    public PerResourceAPIRequestLog getCurrentHour() {
        return this.currentHour != null ? this.currentHour.build() : null;
    }

    @Override
    public PerResourceAPIRequestLog buildCurrentHour() {
        return this.currentHour != null ? this.currentHour.build() : null;
    }

    @Override
    public A withCurrentHour(PerResourceAPIRequestLog currentHour) {
        this._visitables.get("currentHour").remove(this.currentHour);
        if (currentHour != null) {
            this.currentHour = new PerResourceAPIRequestLogBuilder(currentHour);
            this._visitables.get("currentHour").add(this.currentHour);
        } else {
            this.currentHour = null;
            this._visitables.get("currentHour").remove(this.currentHour);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCurrentHour() {
        return this.currentHour != null;
    }

    @Override
    public APIRequestCountStatusFluent.CurrentHourNested<A> withNewCurrentHour() {
        return new CurrentHourNestedImpl();
    }

    @Override
    public APIRequestCountStatusFluent.CurrentHourNested<A> withNewCurrentHourLike(PerResourceAPIRequestLog item) {
        return new CurrentHourNestedImpl(item);
    }

    @Override
    public APIRequestCountStatusFluent.CurrentHourNested<A> editCurrentHour() {
        return this.withNewCurrentHourLike(this.getCurrentHour());
    }

    @Override
    public APIRequestCountStatusFluent.CurrentHourNested<A> editOrNewCurrentHour() {
        return this.withNewCurrentHourLike(this.getCurrentHour() != null ? this.getCurrentHour() : new PerResourceAPIRequestLogBuilder().build());
    }

    @Override
    public APIRequestCountStatusFluent.CurrentHourNested<A> editOrNewCurrentHourLike(PerResourceAPIRequestLog item) {
        return this.withNewCurrentHourLike(this.getCurrentHour() != null ? this.getCurrentHour() : item);
    }

    @Override
    public A addToLast24h(Integer index, PerResourceAPIRequestLog item) {
        if (this.last24h == null) {
            this.last24h = new ArrayList();
        }
        PerResourceAPIRequestLogBuilder builder = new PerResourceAPIRequestLogBuilder(item);
        this._visitables.get("last24h").add(index >= 0 ? index.intValue() : this._visitables.get("last24h").size(), builder);
        this.last24h.add(index >= 0 ? index.intValue() : this.last24h.size(), builder);
        return (A)this;
    }

    @Override
    public A setToLast24h(Integer index, PerResourceAPIRequestLog item) {
        if (this.last24h == null) {
            this.last24h = new ArrayList();
        }
        PerResourceAPIRequestLogBuilder builder = new PerResourceAPIRequestLogBuilder(item);
        if (index < 0 || index >= this._visitables.get("last24h").size()) {
            this._visitables.get("last24h").add(builder);
        } else {
            this._visitables.get("last24h").set(index, builder);
        }
        if (index < 0 || index >= this.last24h.size()) {
            this.last24h.add(builder);
        } else {
            this.last24h.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToLast24h(PerResourceAPIRequestLog ... items) {
        if (this.last24h == null) {
            this.last24h = new ArrayList();
        }
        for (PerResourceAPIRequestLog item : items) {
            PerResourceAPIRequestLogBuilder builder = new PerResourceAPIRequestLogBuilder(item);
            this._visitables.get("last24h").add(builder);
            this.last24h.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToLast24h(Collection<PerResourceAPIRequestLog> items) {
        if (this.last24h == null) {
            this.last24h = new ArrayList();
        }
        for (PerResourceAPIRequestLog item : items) {
            PerResourceAPIRequestLogBuilder builder = new PerResourceAPIRequestLogBuilder(item);
            this._visitables.get("last24h").add(builder);
            this.last24h.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromLast24h(PerResourceAPIRequestLog ... items) {
        for (PerResourceAPIRequestLog item : items) {
            PerResourceAPIRequestLogBuilder builder = new PerResourceAPIRequestLogBuilder(item);
            this._visitables.get("last24h").remove(builder);
            if (this.last24h == null) continue;
            this.last24h.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromLast24h(Collection<PerResourceAPIRequestLog> items) {
        for (PerResourceAPIRequestLog item : items) {
            PerResourceAPIRequestLogBuilder builder = new PerResourceAPIRequestLogBuilder(item);
            this._visitables.get("last24h").remove(builder);
            if (this.last24h == null) continue;
            this.last24h.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromLast24h(Predicate<PerResourceAPIRequestLogBuilder> predicate) {
        if (this.last24h == null) {
            return (A)this;
        }
        Iterator<PerResourceAPIRequestLogBuilder> each = this.last24h.iterator();
        Object visitables = this._visitables.get("last24h");
        while (each.hasNext()) {
            PerResourceAPIRequestLogBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PerResourceAPIRequestLog> getLast24h() {
        return this.last24h != null ? APIRequestCountStatusFluentImpl.build(this.last24h) : null;
    }

    @Override
    public List<PerResourceAPIRequestLog> buildLast24h() {
        return this.last24h != null ? APIRequestCountStatusFluentImpl.build(this.last24h) : null;
    }

    @Override
    public PerResourceAPIRequestLog buildLast24h(Integer index) {
        return this.last24h.get(index).build();
    }

    @Override
    public PerResourceAPIRequestLog buildFirstLast24h() {
        return this.last24h.get(0).build();
    }

    @Override
    public PerResourceAPIRequestLog buildLastLast24h() {
        return this.last24h.get(this.last24h.size() - 1).build();
    }

    @Override
    public PerResourceAPIRequestLog buildMatchingLast24h(Predicate<PerResourceAPIRequestLogBuilder> predicate) {
        for (PerResourceAPIRequestLogBuilder item : this.last24h) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingLast24h(Predicate<PerResourceAPIRequestLogBuilder> predicate) {
        for (PerResourceAPIRequestLogBuilder item : this.last24h) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withLast24h(List<PerResourceAPIRequestLog> last24h) {
        if (this.last24h != null) {
            this._visitables.get("last24h").removeAll(this.last24h);
        }
        if (last24h != null) {
            this.last24h = new ArrayList();
            for (PerResourceAPIRequestLog item : last24h) {
                this.addToLast24h(item);
            }
        } else {
            this.last24h = null;
        }
        return (A)this;
    }

    @Override
    public A withLast24h(PerResourceAPIRequestLog ... last24h) {
        if (this.last24h != null) {
            this.last24h.clear();
        }
        if (last24h != null) {
            for (PerResourceAPIRequestLog item : last24h) {
                this.addToLast24h(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasLast24h() {
        return this.last24h != null && !this.last24h.isEmpty();
    }

    @Override
    public APIRequestCountStatusFluent.Last24hNested<A> addNewLast24h() {
        return new Last24hNestedImpl();
    }

    @Override
    public APIRequestCountStatusFluent.Last24hNested<A> addNewLast24hLike(PerResourceAPIRequestLog item) {
        return new Last24hNestedImpl(-1, item);
    }

    @Override
    public APIRequestCountStatusFluent.Last24hNested<A> setNewLast24hLike(Integer index, PerResourceAPIRequestLog item) {
        return new Last24hNestedImpl(index, item);
    }

    @Override
    public APIRequestCountStatusFluent.Last24hNested<A> editLast24h(Integer index) {
        if (this.last24h.size() <= index) {
            throw new RuntimeException("Can't edit last24h. Index exceeds size.");
        }
        return this.setNewLast24hLike(index, this.buildLast24h(index));
    }

    @Override
    public APIRequestCountStatusFluent.Last24hNested<A> editFirstLast24h() {
        if (this.last24h.size() == 0) {
            throw new RuntimeException("Can't edit first last24h. The list is empty.");
        }
        return this.setNewLast24hLike(0, this.buildLast24h(0));
    }

    @Override
    public APIRequestCountStatusFluent.Last24hNested<A> editLastLast24h() {
        int index = this.last24h.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last last24h. The list is empty.");
        }
        return this.setNewLast24hLike(index, this.buildLast24h(index));
    }

    @Override
    public APIRequestCountStatusFluent.Last24hNested<A> editMatchingLast24h(Predicate<PerResourceAPIRequestLogBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.last24h.size(); ++i) {
            if (!predicate.test(this.last24h.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching last24h. No match found.");
        }
        return this.setNewLast24hLike(index, this.buildLast24h(index));
    }

    @Override
    public String getRemovedInRelease() {
        return this.removedInRelease;
    }

    @Override
    public A withRemovedInRelease(String removedInRelease) {
        this.removedInRelease = removedInRelease;
        return (A)this;
    }

    @Override
    public Boolean hasRemovedInRelease() {
        return this.removedInRelease != null;
    }

    @Override
    public Long getRequestCount() {
        return this.requestCount;
    }

    @Override
    public A withRequestCount(Long requestCount) {
        this.requestCount = requestCount;
        return (A)this;
    }

    @Override
    public Boolean hasRequestCount() {
        return this.requestCount != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIRequestCountStatusFluentImpl that = (APIRequestCountStatusFluentImpl)o;
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.currentHour != null ? !this.currentHour.equals(that.currentHour) : that.currentHour != null) {
            return false;
        }
        if (this.last24h != null ? !this.last24h.equals(that.last24h) : that.last24h != null) {
            return false;
        }
        if (this.removedInRelease != null ? !this.removedInRelease.equals(that.removedInRelease) : that.removedInRelease != null) {
            return false;
        }
        if (this.requestCount != null ? !this.requestCount.equals(that.requestCount) : that.requestCount != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.currentHour, this.last24h, this.removedInRelease, this.requestCount, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.currentHour != null) {
            sb.append("currentHour:");
            sb.append(this.currentHour + ",");
        }
        if (this.last24h != null && !this.last24h.isEmpty()) {
            sb.append("last24h:");
            sb.append(this.last24h + ",");
        }
        if (this.removedInRelease != null) {
            sb.append("removedInRelease:");
            sb.append(this.removedInRelease + ",");
        }
        if (this.requestCount != null) {
            sb.append("requestCount:");
            sb.append(this.requestCount + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class Last24hNestedImpl<N>
    extends PerResourceAPIRequestLogFluentImpl<APIRequestCountStatusFluent.Last24hNested<N>>
    implements APIRequestCountStatusFluent.Last24hNested<N>,
    Nested<N> {
        PerResourceAPIRequestLogBuilder builder;
        Integer index;

        Last24hNestedImpl(Integer index, PerResourceAPIRequestLog item) {
            this.index = index;
            this.builder = new PerResourceAPIRequestLogBuilder(this, item);
        }

        Last24hNestedImpl() {
            this.index = -1;
            this.builder = new PerResourceAPIRequestLogBuilder(this);
        }

        @Override
        public N and() {
            return (N)APIRequestCountStatusFluentImpl.this.setToLast24h(this.index, this.builder.build());
        }

        @Override
        public N endLast24h() {
            return this.and();
        }
    }

    class CurrentHourNestedImpl<N>
    extends PerResourceAPIRequestLogFluentImpl<APIRequestCountStatusFluent.CurrentHourNested<N>>
    implements APIRequestCountStatusFluent.CurrentHourNested<N>,
    Nested<N> {
        PerResourceAPIRequestLogBuilder builder;

        CurrentHourNestedImpl(PerResourceAPIRequestLog item) {
            this.builder = new PerResourceAPIRequestLogBuilder(this, item);
        }

        CurrentHourNestedImpl() {
            this.builder = new PerResourceAPIRequestLogBuilder(this);
        }

        @Override
        public N and() {
            return (N)APIRequestCountStatusFluentImpl.this.withCurrentHour(this.builder.build());
        }

        @Override
        public N endCurrentHour() {
            return this.and();
        }
    }
}

