/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_1.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.v6_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_1.Nested;
import io.fabric8.kubernetes.api.model.v6_1.ObjectReference;
import io.fabric8.kubernetes.api.model.v6_1.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_1.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.v6_1.machineconfig.v1.MachineConfigPoolStatusConfiguration;
import io.fabric8.openshift.api.model.v6_1.machineconfig.v1.MachineConfigPoolStatusConfigurationFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class MachineConfigPoolStatusConfigurationFluentImpl<A extends MachineConfigPoolStatusConfigurationFluent<A>>
extends BaseFluent<A>
implements MachineConfigPoolStatusConfigurationFluent<A> {
    private String apiVersion;
    private String fieldPath;
    private String kind;
    private String name;
    private String namespace;
    private String resourceVersion;
    private ArrayList<ObjectReferenceBuilder> source = new ArrayList();
    private String uid;
    private Map<String, Object> additionalProperties;

    public MachineConfigPoolStatusConfigurationFluentImpl() {
    }

    public MachineConfigPoolStatusConfigurationFluentImpl(MachineConfigPoolStatusConfiguration instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withFieldPath(instance.getFieldPath());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withResourceVersion(instance.getResourceVersion());
        this.withSource(instance.getSource());
        this.withUid(instance.getUid());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getFieldPath() {
        return this.fieldPath;
    }

    @Override
    public A withFieldPath(String fieldPath) {
        this.fieldPath = fieldPath;
        return (A)this;
    }

    @Override
    public Boolean hasFieldPath() {
        return this.fieldPath != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    @Override
    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    @Override
    public String getResourceVersion() {
        return this.resourceVersion;
    }

    @Override
    public A withResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
        return (A)this;
    }

    @Override
    public Boolean hasResourceVersion() {
        return this.resourceVersion != null;
    }

    @Override
    public A addToSource(Integer index, ObjectReference item) {
        if (this.source == null) {
            this.source = new ArrayList();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        this._visitables.get("source").add(index >= 0 ? index.intValue() : this._visitables.get("source").size(), builder);
        this.source.add(index >= 0 ? index.intValue() : this.source.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSource(Integer index, ObjectReference item) {
        if (this.source == null) {
            this.source = new ArrayList();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        if (index < 0 || index >= this._visitables.get("source").size()) {
            this._visitables.get("source").add(builder);
        } else {
            this._visitables.get("source").set(index, builder);
        }
        if (index < 0 || index >= this.source.size()) {
            this.source.add(builder);
        } else {
            this.source.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSource(ObjectReference ... items) {
        if (this.source == null) {
            this.source = new ArrayList();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("source").add(builder);
            this.source.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSource(Collection<ObjectReference> items) {
        if (this.source == null) {
            this.source = new ArrayList();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("source").add(builder);
            this.source.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSource(ObjectReference ... items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("source").remove(builder);
            if (this.source == null) continue;
            this.source.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSource(Collection<ObjectReference> items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("source").remove(builder);
            if (this.source == null) continue;
            this.source.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSource(Predicate<ObjectReferenceBuilder> predicate) {
        if (this.source == null) {
            return (A)this;
        }
        Iterator<ObjectReferenceBuilder> each = this.source.iterator();
        Object visitables = this._visitables.get("source");
        while (each.hasNext()) {
            ObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ObjectReference> getSource() {
        return this.source != null ? MachineConfigPoolStatusConfigurationFluentImpl.build(this.source) : null;
    }

    @Override
    public List<ObjectReference> buildSource() {
        return this.source != null ? MachineConfigPoolStatusConfigurationFluentImpl.build(this.source) : null;
    }

    @Override
    public ObjectReference buildSource(Integer index) {
        return this.source.get(index).build();
    }

    @Override
    public ObjectReference buildFirstSource() {
        return this.source.get(0).build();
    }

    @Override
    public ObjectReference buildLastSource() {
        return this.source.get(this.source.size() - 1).build();
    }

    @Override
    public ObjectReference buildMatchingSource(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.source) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSource(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.source) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSource(List<ObjectReference> source) {
        if (this.source != null) {
            this._visitables.get("source").removeAll(this.source);
        }
        if (source != null) {
            this.source = new ArrayList();
            for (ObjectReference item : source) {
                this.addToSource(item);
            }
        } else {
            this.source = null;
        }
        return (A)this;
    }

    @Override
    public A withSource(ObjectReference ... source) {
        if (this.source != null) {
            this.source.clear();
        }
        if (source != null) {
            for (ObjectReference item : source) {
                this.addToSource(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    @Override
    public MachineConfigPoolStatusConfigurationFluent.SourceNested<A> addNewSource() {
        return new SourceNestedImpl();
    }

    @Override
    public MachineConfigPoolStatusConfigurationFluent.SourceNested<A> addNewSourceLike(ObjectReference item) {
        return new SourceNestedImpl(-1, item);
    }

    @Override
    public MachineConfigPoolStatusConfigurationFluent.SourceNested<A> setNewSourceLike(Integer index, ObjectReference item) {
        return new SourceNestedImpl(index, item);
    }

    @Override
    public MachineConfigPoolStatusConfigurationFluent.SourceNested<A> editSource(Integer index) {
        if (this.source.size() <= index) {
            throw new RuntimeException("Can't edit source. Index exceeds size.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    @Override
    public MachineConfigPoolStatusConfigurationFluent.SourceNested<A> editFirstSource() {
        if (this.source.size() == 0) {
            throw new RuntimeException("Can't edit first source. The list is empty.");
        }
        return this.setNewSourceLike(0, this.buildSource(0));
    }

    @Override
    public MachineConfigPoolStatusConfigurationFluent.SourceNested<A> editLastSource() {
        int index = this.source.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last source. The list is empty.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    @Override
    public MachineConfigPoolStatusConfigurationFluent.SourceNested<A> editMatchingSource(Predicate<ObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.source.size(); ++i) {
            if (!predicate.test(this.source.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching source. No match found.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public A withUid(String uid) {
        this.uid = uid;
        return (A)this;
    }

    @Override
    public Boolean hasUid() {
        return this.uid != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MachineConfigPoolStatusConfigurationFluentImpl that = (MachineConfigPoolStatusConfigurationFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.fieldPath != null ? !this.fieldPath.equals(that.fieldPath) : that.fieldPath != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        if (this.resourceVersion != null ? !this.resourceVersion.equals(that.resourceVersion) : that.resourceVersion != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        if (this.uid != null ? !this.uid.equals(that.uid) : that.uid != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.fieldPath, this.kind, this.name, this.namespace, this.resourceVersion, this.source, this.uid, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.fieldPath != null) {
            sb.append("fieldPath:");
            sb.append(this.fieldPath + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        if (this.resourceVersion != null) {
            sb.append("resourceVersion:");
            sb.append(this.resourceVersion + ",");
        }
        if (this.source != null && !this.source.isEmpty()) {
            sb.append("source:");
            sb.append(this.source + ",");
        }
        if (this.uid != null) {
            sb.append("uid:");
            sb.append(this.uid + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class SourceNestedImpl<N>
    extends ObjectReferenceFluentImpl<MachineConfigPoolStatusConfigurationFluent.SourceNested<N>>
    implements MachineConfigPoolStatusConfigurationFluent.SourceNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;
        Integer index;

        SourceNestedImpl(Integer index, ObjectReference item) {
            this.index = index;
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        SourceNestedImpl() {
            this.index = -1;
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)MachineConfigPoolStatusConfigurationFluentImpl.this.setToSource(this.index, this.builder.build());
        }

        @Override
        public N endSource() {
            return this.and();
        }
    }
}

