/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_1.installer.v1;

import io.fabric8.kubernetes.api.builder.v6_1.VisitableBuilder;
import io.fabric8.openshift.api.model.v6_1.installer.v1.Networking;
import io.fabric8.openshift.api.model.v6_1.installer.v1.NetworkingFluent;
import io.fabric8.openshift.api.model.v6_1.installer.v1.NetworkingFluentImpl;

public class NetworkingBuilder
extends NetworkingFluentImpl<NetworkingBuilder>
implements VisitableBuilder<Networking, NetworkingBuilder> {
    NetworkingFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkingBuilder() {
        this(false);
    }

    public NetworkingBuilder(Boolean validationEnabled) {
        this(new Networking(), validationEnabled);
    }

    public NetworkingBuilder(NetworkingFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public NetworkingBuilder(NetworkingFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Networking(), validationEnabled);
    }

    public NetworkingBuilder(NetworkingFluent<?> fluent, Networking instance) {
        this(fluent, instance, false);
    }

    public NetworkingBuilder(NetworkingFluent<?> fluent, Networking instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withClusterNetwork(instance.getClusterNetwork());
        fluent.withDeprecatedClusterNetworks(instance.getDeprecatedClusterNetworks());
        fluent.withMachineCIDR(instance.getMachineCIDR());
        fluent.withMachineNetwork(instance.getMachineNetwork());
        fluent.withNetworkType(instance.getNetworkType());
        fluent.withServiceCIDR(instance.getServiceCIDR());
        fluent.withServiceNetwork(instance.getServiceNetwork());
        fluent.withType(instance.getType());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public NetworkingBuilder(Networking instance) {
        this(instance, (Boolean)false);
    }

    public NetworkingBuilder(Networking instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withClusterNetwork(instance.getClusterNetwork());
        this.withDeprecatedClusterNetworks(instance.getDeprecatedClusterNetworks());
        this.withMachineCIDR(instance.getMachineCIDR());
        this.withMachineNetwork(instance.getMachineNetwork());
        this.withNetworkType(instance.getNetworkType());
        this.withServiceCIDR(instance.getServiceCIDR());
        this.withServiceNetwork(instance.getServiceNetwork());
        this.withType(instance.getType());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Networking build() {
        Networking buildable = new Networking(this.fluent.getClusterNetwork(), this.fluent.getDeprecatedClusterNetworks(), this.fluent.getMachineCIDR(), this.fluent.getMachineNetwork(), this.fluent.getNetworkType(), this.fluent.getServiceCIDR(), this.fluent.getServiceNetwork(), this.fluent.getType());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

