/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_1.installer.openstack.v1;

import io.fabric8.kubernetes.api.builder.v6_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_1.Nested;
import io.fabric8.openshift.api.model.v6_1.installer.openstack.v1.MachinePool;
import io.fabric8.openshift.api.model.v6_1.installer.openstack.v1.MachinePoolBuilder;
import io.fabric8.openshift.api.model.v6_1.installer.openstack.v1.MachinePoolFluentImpl;
import io.fabric8.openshift.api.model.v6_1.installer.openstack.v1.Platform;
import io.fabric8.openshift.api.model.v6_1.installer.openstack.v1.PlatformFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PlatformFluentImpl<A extends PlatformFluent<A>>
extends BaseFluent<A>
implements PlatformFluent<A> {
    private String apiFloatingIP;
    private String apiVIP;
    private String cloud;
    private String clusterOSImage;
    private Map<String, String> clusterOSImageProperties;
    private String computeFlavor;
    private MachinePoolBuilder defaultMachinePlatform;
    private List<String> externalDNS = new ArrayList<String>();
    private String externalNetwork;
    private String ingressFloatingIP;
    private String ingressVIP;
    private String lbFloatingIP;
    private String machinesSubnet;
    private String octaviaSupport;
    private String region;
    private String trunkSupport;
    private Map<String, Object> additionalProperties;

    public PlatformFluentImpl() {
    }

    public PlatformFluentImpl(Platform instance) {
        this.withApiFloatingIP(instance.getApiFloatingIP());
        this.withApiVIP(instance.getApiVIP());
        this.withCloud(instance.getCloud());
        this.withClusterOSImage(instance.getClusterOSImage());
        this.withClusterOSImageProperties(instance.getClusterOSImageProperties());
        this.withComputeFlavor(instance.getComputeFlavor());
        this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
        this.withExternalDNS(instance.getExternalDNS());
        this.withExternalNetwork(instance.getExternalNetwork());
        this.withIngressFloatingIP(instance.getIngressFloatingIP());
        this.withIngressVIP(instance.getIngressVIP());
        this.withLbFloatingIP(instance.getLbFloatingIP());
        this.withMachinesSubnet(instance.getMachinesSubnet());
        this.withOctaviaSupport(instance.getOctaviaSupport());
        this.withRegion(instance.getRegion());
        this.withTrunkSupport(instance.getTrunkSupport());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiFloatingIP() {
        return this.apiFloatingIP;
    }

    @Override
    public A withApiFloatingIP(String apiFloatingIP) {
        this.apiFloatingIP = apiFloatingIP;
        return (A)this;
    }

    @Override
    public Boolean hasApiFloatingIP() {
        return this.apiFloatingIP != null;
    }

    @Override
    public String getApiVIP() {
        return this.apiVIP;
    }

    @Override
    public A withApiVIP(String apiVIP) {
        this.apiVIP = apiVIP;
        return (A)this;
    }

    @Override
    public Boolean hasApiVIP() {
        return this.apiVIP != null;
    }

    @Override
    public String getCloud() {
        return this.cloud;
    }

    @Override
    public A withCloud(String cloud) {
        this.cloud = cloud;
        return (A)this;
    }

    @Override
    public Boolean hasCloud() {
        return this.cloud != null;
    }

    @Override
    public String getClusterOSImage() {
        return this.clusterOSImage;
    }

    @Override
    public A withClusterOSImage(String clusterOSImage) {
        this.clusterOSImage = clusterOSImage;
        return (A)this;
    }

    @Override
    public Boolean hasClusterOSImage() {
        return this.clusterOSImage != null;
    }

    @Override
    public A addToClusterOSImageProperties(String key, String value) {
        if (this.clusterOSImageProperties == null && key != null && value != null) {
            this.clusterOSImageProperties = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.clusterOSImageProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToClusterOSImageProperties(Map<String, String> map) {
        if (this.clusterOSImageProperties == null && map != null) {
            this.clusterOSImageProperties = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.clusterOSImageProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromClusterOSImageProperties(String key) {
        if (this.clusterOSImageProperties == null) {
            return (A)this;
        }
        if (key != null && this.clusterOSImageProperties != null) {
            this.clusterOSImageProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromClusterOSImageProperties(Map<String, String> map) {
        if (this.clusterOSImageProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.clusterOSImageProperties == null) continue;
                this.clusterOSImageProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getClusterOSImageProperties() {
        return this.clusterOSImageProperties;
    }

    @Override
    public <K, V> A withClusterOSImageProperties(Map<String, String> clusterOSImageProperties) {
        this.clusterOSImageProperties = clusterOSImageProperties == null ? null : new LinkedHashMap<String, String>(clusterOSImageProperties);
        return (A)this;
    }

    @Override
    public Boolean hasClusterOSImageProperties() {
        return this.clusterOSImageProperties != null;
    }

    @Override
    public String getComputeFlavor() {
        return this.computeFlavor;
    }

    @Override
    public A withComputeFlavor(String computeFlavor) {
        this.computeFlavor = computeFlavor;
        return (A)this;
    }

    @Override
    public Boolean hasComputeFlavor() {
        return this.computeFlavor != null;
    }

    @Override
    @Deprecated
    public MachinePool getDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    @Override
    public MachinePool buildDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    @Override
    public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
        this._visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
        if (defaultMachinePlatform != null) {
            this.defaultMachinePlatform = new MachinePoolBuilder(defaultMachinePlatform);
            this._visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);
        } else {
            this.defaultMachinePlatform = null;
            this._visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null;
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
        return new DefaultMachinePlatformNestedImpl();
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
        return new DefaultMachinePlatformNestedImpl(item);
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform());
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform() != null ? this.getDefaultMachinePlatform() : new MachinePoolBuilder().build());
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform() != null ? this.getDefaultMachinePlatform() : item);
    }

    @Override
    public A addToExternalDNS(Integer index, String item) {
        if (this.externalDNS == null) {
            this.externalDNS = new ArrayList<String>();
        }
        this.externalDNS.add(index, item);
        return (A)this;
    }

    @Override
    public A setToExternalDNS(Integer index, String item) {
        if (this.externalDNS == null) {
            this.externalDNS = new ArrayList<String>();
        }
        this.externalDNS.set(index, item);
        return (A)this;
    }

    @Override
    public A addToExternalDNS(String ... items) {
        if (this.externalDNS == null) {
            this.externalDNS = new ArrayList<String>();
        }
        for (String item : items) {
            this.externalDNS.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToExternalDNS(Collection<String> items) {
        if (this.externalDNS == null) {
            this.externalDNS = new ArrayList<String>();
        }
        for (String item : items) {
            this.externalDNS.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromExternalDNS(String ... items) {
        for (String item : items) {
            if (this.externalDNS == null) continue;
            this.externalDNS.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromExternalDNS(Collection<String> items) {
        for (String item : items) {
            if (this.externalDNS == null) continue;
            this.externalDNS.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getExternalDNS() {
        return this.externalDNS;
    }

    @Override
    public String getExternalDN(Integer index) {
        return this.externalDNS.get(index);
    }

    @Override
    public String getFirstExternalDN() {
        return this.externalDNS.get(0);
    }

    @Override
    public String getLastExternalDN() {
        return this.externalDNS.get(this.externalDNS.size() - 1);
    }

    @Override
    public String getMatchingExternalDN(Predicate<String> predicate) {
        for (String item : this.externalDNS) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingExternalDN(Predicate<String> predicate) {
        for (String item : this.externalDNS) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withExternalDNS(List<String> externalDNS) {
        if (externalDNS != null) {
            this.externalDNS = new ArrayList<String>();
            for (String item : externalDNS) {
                this.addToExternalDNS(item);
            }
        } else {
            this.externalDNS = null;
        }
        return (A)this;
    }

    @Override
    public A withExternalDNS(String ... externalDNS) {
        if (this.externalDNS != null) {
            this.externalDNS.clear();
        }
        if (externalDNS != null) {
            for (String item : externalDNS) {
                this.addToExternalDNS(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasExternalDNS() {
        return this.externalDNS != null && !this.externalDNS.isEmpty();
    }

    @Override
    public String getExternalNetwork() {
        return this.externalNetwork;
    }

    @Override
    public A withExternalNetwork(String externalNetwork) {
        this.externalNetwork = externalNetwork;
        return (A)this;
    }

    @Override
    public Boolean hasExternalNetwork() {
        return this.externalNetwork != null;
    }

    @Override
    public String getIngressFloatingIP() {
        return this.ingressFloatingIP;
    }

    @Override
    public A withIngressFloatingIP(String ingressFloatingIP) {
        this.ingressFloatingIP = ingressFloatingIP;
        return (A)this;
    }

    @Override
    public Boolean hasIngressFloatingIP() {
        return this.ingressFloatingIP != null;
    }

    @Override
    public String getIngressVIP() {
        return this.ingressVIP;
    }

    @Override
    public A withIngressVIP(String ingressVIP) {
        this.ingressVIP = ingressVIP;
        return (A)this;
    }

    @Override
    public Boolean hasIngressVIP() {
        return this.ingressVIP != null;
    }

    @Override
    public String getLbFloatingIP() {
        return this.lbFloatingIP;
    }

    @Override
    public A withLbFloatingIP(String lbFloatingIP) {
        this.lbFloatingIP = lbFloatingIP;
        return (A)this;
    }

    @Override
    public Boolean hasLbFloatingIP() {
        return this.lbFloatingIP != null;
    }

    @Override
    public String getMachinesSubnet() {
        return this.machinesSubnet;
    }

    @Override
    public A withMachinesSubnet(String machinesSubnet) {
        this.machinesSubnet = machinesSubnet;
        return (A)this;
    }

    @Override
    public Boolean hasMachinesSubnet() {
        return this.machinesSubnet != null;
    }

    @Override
    public String getOctaviaSupport() {
        return this.octaviaSupport;
    }

    @Override
    public A withOctaviaSupport(String octaviaSupport) {
        this.octaviaSupport = octaviaSupport;
        return (A)this;
    }

    @Override
    public Boolean hasOctaviaSupport() {
        return this.octaviaSupport != null;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    @Override
    public Boolean hasRegion() {
        return this.region != null;
    }

    @Override
    public String getTrunkSupport() {
        return this.trunkSupport;
    }

    @Override
    public A withTrunkSupport(String trunkSupport) {
        this.trunkSupport = trunkSupport;
        return (A)this;
    }

    @Override
    public Boolean hasTrunkSupport() {
        return this.trunkSupport != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlatformFluentImpl that = (PlatformFluentImpl)o;
        if (this.apiFloatingIP != null ? !this.apiFloatingIP.equals(that.apiFloatingIP) : that.apiFloatingIP != null) {
            return false;
        }
        if (this.apiVIP != null ? !this.apiVIP.equals(that.apiVIP) : that.apiVIP != null) {
            return false;
        }
        if (this.cloud != null ? !this.cloud.equals(that.cloud) : that.cloud != null) {
            return false;
        }
        if (this.clusterOSImage != null ? !this.clusterOSImage.equals(that.clusterOSImage) : that.clusterOSImage != null) {
            return false;
        }
        if (this.clusterOSImageProperties != null ? !this.clusterOSImageProperties.equals(that.clusterOSImageProperties) : that.clusterOSImageProperties != null) {
            return false;
        }
        if (this.computeFlavor != null ? !this.computeFlavor.equals(that.computeFlavor) : that.computeFlavor != null) {
            return false;
        }
        if (this.defaultMachinePlatform != null ? !this.defaultMachinePlatform.equals(that.defaultMachinePlatform) : that.defaultMachinePlatform != null) {
            return false;
        }
        if (this.externalDNS != null ? !this.externalDNS.equals(that.externalDNS) : that.externalDNS != null) {
            return false;
        }
        if (this.externalNetwork != null ? !this.externalNetwork.equals(that.externalNetwork) : that.externalNetwork != null) {
            return false;
        }
        if (this.ingressFloatingIP != null ? !this.ingressFloatingIP.equals(that.ingressFloatingIP) : that.ingressFloatingIP != null) {
            return false;
        }
        if (this.ingressVIP != null ? !this.ingressVIP.equals(that.ingressVIP) : that.ingressVIP != null) {
            return false;
        }
        if (this.lbFloatingIP != null ? !this.lbFloatingIP.equals(that.lbFloatingIP) : that.lbFloatingIP != null) {
            return false;
        }
        if (this.machinesSubnet != null ? !this.machinesSubnet.equals(that.machinesSubnet) : that.machinesSubnet != null) {
            return false;
        }
        if (this.octaviaSupport != null ? !this.octaviaSupport.equals(that.octaviaSupport) : that.octaviaSupport != null) {
            return false;
        }
        if (this.region != null ? !this.region.equals(that.region) : that.region != null) {
            return false;
        }
        if (this.trunkSupport != null ? !this.trunkSupport.equals(that.trunkSupport) : that.trunkSupport != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiFloatingIP, this.apiVIP, this.cloud, this.clusterOSImage, this.clusterOSImageProperties, this.computeFlavor, this.defaultMachinePlatform, this.externalDNS, this.externalNetwork, this.ingressFloatingIP, this.ingressVIP, this.lbFloatingIP, this.machinesSubnet, this.octaviaSupport, this.region, this.trunkSupport, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiFloatingIP != null) {
            sb.append("apiFloatingIP:");
            sb.append(this.apiFloatingIP + ",");
        }
        if (this.apiVIP != null) {
            sb.append("apiVIP:");
            sb.append(this.apiVIP + ",");
        }
        if (this.cloud != null) {
            sb.append("cloud:");
            sb.append(this.cloud + ",");
        }
        if (this.clusterOSImage != null) {
            sb.append("clusterOSImage:");
            sb.append(this.clusterOSImage + ",");
        }
        if (this.clusterOSImageProperties != null && !this.clusterOSImageProperties.isEmpty()) {
            sb.append("clusterOSImageProperties:");
            sb.append(this.clusterOSImageProperties + ",");
        }
        if (this.computeFlavor != null) {
            sb.append("computeFlavor:");
            sb.append(this.computeFlavor + ",");
        }
        if (this.defaultMachinePlatform != null) {
            sb.append("defaultMachinePlatform:");
            sb.append(this.defaultMachinePlatform + ",");
        }
        if (this.externalDNS != null && !this.externalDNS.isEmpty()) {
            sb.append("externalDNS:");
            sb.append(this.externalDNS + ",");
        }
        if (this.externalNetwork != null) {
            sb.append("externalNetwork:");
            sb.append(this.externalNetwork + ",");
        }
        if (this.ingressFloatingIP != null) {
            sb.append("ingressFloatingIP:");
            sb.append(this.ingressFloatingIP + ",");
        }
        if (this.ingressVIP != null) {
            sb.append("ingressVIP:");
            sb.append(this.ingressVIP + ",");
        }
        if (this.lbFloatingIP != null) {
            sb.append("lbFloatingIP:");
            sb.append(this.lbFloatingIP + ",");
        }
        if (this.machinesSubnet != null) {
            sb.append("machinesSubnet:");
            sb.append(this.machinesSubnet + ",");
        }
        if (this.octaviaSupport != null) {
            sb.append("octaviaSupport:");
            sb.append(this.octaviaSupport + ",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region + ",");
        }
        if (this.trunkSupport != null) {
            sb.append("trunkSupport:");
            sb.append(this.trunkSupport + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class DefaultMachinePlatformNestedImpl<N>
    extends MachinePoolFluentImpl<PlatformFluent.DefaultMachinePlatformNested<N>>
    implements PlatformFluent.DefaultMachinePlatformNested<N>,
    Nested<N> {
        MachinePoolBuilder builder;

        DefaultMachinePlatformNestedImpl(MachinePool item) {
            this.builder = new MachinePoolBuilder(this, item);
        }

        DefaultMachinePlatformNestedImpl() {
            this.builder = new MachinePoolBuilder(this);
        }

        @Override
        public N and() {
            return (N)PlatformFluentImpl.this.withDefaultMachinePlatform(this.builder.build());
        }

        @Override
        public N endDefaultMachinePlatform() {
            return this.and();
        }
    }
}

