/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_1.hive.v1;

import io.fabric8.kubernetes.api.builder.v6_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_1.Nested;
import io.fabric8.openshift.api.model.v6_1.hive.v1.AWSPrivateLinkInventory;
import io.fabric8.openshift.api.model.v6_1.hive.v1.AWSPrivateLinkInventoryFluent;
import io.fabric8.openshift.api.model.v6_1.hive.v1.AWSPrivateLinkSubnet;
import io.fabric8.openshift.api.model.v6_1.hive.v1.AWSPrivateLinkSubnetBuilder;
import io.fabric8.openshift.api.model.v6_1.hive.v1.AWSPrivateLinkSubnetFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AWSPrivateLinkInventoryFluentImpl<A extends AWSPrivateLinkInventoryFluent<A>>
extends BaseFluent<A>
implements AWSPrivateLinkInventoryFluent<A> {
    private String region;
    private ArrayList<AWSPrivateLinkSubnetBuilder> subnets = new ArrayList();
    private String vpcID;
    private Map<String, Object> additionalProperties;

    public AWSPrivateLinkInventoryFluentImpl() {
    }

    public AWSPrivateLinkInventoryFluentImpl(AWSPrivateLinkInventory instance) {
        this.withRegion(instance.getRegion());
        this.withSubnets(instance.getSubnets());
        this.withVpcID(instance.getVpcID());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    @Override
    public Boolean hasRegion() {
        return this.region != null;
    }

    @Override
    public A addToSubnets(Integer index, AWSPrivateLinkSubnet item) {
        if (this.subnets == null) {
            this.subnets = new ArrayList();
        }
        AWSPrivateLinkSubnetBuilder builder = new AWSPrivateLinkSubnetBuilder(item);
        this._visitables.get("subnets").add(index >= 0 ? index.intValue() : this._visitables.get("subnets").size(), builder);
        this.subnets.add(index >= 0 ? index.intValue() : this.subnets.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSubnets(Integer index, AWSPrivateLinkSubnet item) {
        if (this.subnets == null) {
            this.subnets = new ArrayList();
        }
        AWSPrivateLinkSubnetBuilder builder = new AWSPrivateLinkSubnetBuilder(item);
        if (index < 0 || index >= this._visitables.get("subnets").size()) {
            this._visitables.get("subnets").add(builder);
        } else {
            this._visitables.get("subnets").set(index, builder);
        }
        if (index < 0 || index >= this.subnets.size()) {
            this.subnets.add(builder);
        } else {
            this.subnets.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSubnets(AWSPrivateLinkSubnet ... items) {
        if (this.subnets == null) {
            this.subnets = new ArrayList();
        }
        for (AWSPrivateLinkSubnet item : items) {
            AWSPrivateLinkSubnetBuilder builder = new AWSPrivateLinkSubnetBuilder(item);
            this._visitables.get("subnets").add(builder);
            this.subnets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSubnets(Collection<AWSPrivateLinkSubnet> items) {
        if (this.subnets == null) {
            this.subnets = new ArrayList();
        }
        for (AWSPrivateLinkSubnet item : items) {
            AWSPrivateLinkSubnetBuilder builder = new AWSPrivateLinkSubnetBuilder(item);
            this._visitables.get("subnets").add(builder);
            this.subnets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubnets(AWSPrivateLinkSubnet ... items) {
        for (AWSPrivateLinkSubnet item : items) {
            AWSPrivateLinkSubnetBuilder builder = new AWSPrivateLinkSubnetBuilder(item);
            this._visitables.get("subnets").remove(builder);
            if (this.subnets == null) continue;
            this.subnets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSubnets(Collection<AWSPrivateLinkSubnet> items) {
        for (AWSPrivateLinkSubnet item : items) {
            AWSPrivateLinkSubnetBuilder builder = new AWSPrivateLinkSubnetBuilder(item);
            this._visitables.get("subnets").remove(builder);
            if (this.subnets == null) continue;
            this.subnets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSubnets(Predicate<AWSPrivateLinkSubnetBuilder> predicate) {
        if (this.subnets == null) {
            return (A)this;
        }
        Iterator<AWSPrivateLinkSubnetBuilder> each = this.subnets.iterator();
        Object visitables = this._visitables.get("subnets");
        while (each.hasNext()) {
            AWSPrivateLinkSubnetBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<AWSPrivateLinkSubnet> getSubnets() {
        return this.subnets != null ? AWSPrivateLinkInventoryFluentImpl.build(this.subnets) : null;
    }

    @Override
    public List<AWSPrivateLinkSubnet> buildSubnets() {
        return this.subnets != null ? AWSPrivateLinkInventoryFluentImpl.build(this.subnets) : null;
    }

    @Override
    public AWSPrivateLinkSubnet buildSubnet(Integer index) {
        return this.subnets.get(index).build();
    }

    @Override
    public AWSPrivateLinkSubnet buildFirstSubnet() {
        return this.subnets.get(0).build();
    }

    @Override
    public AWSPrivateLinkSubnet buildLastSubnet() {
        return this.subnets.get(this.subnets.size() - 1).build();
    }

    @Override
    public AWSPrivateLinkSubnet buildMatchingSubnet(Predicate<AWSPrivateLinkSubnetBuilder> predicate) {
        for (AWSPrivateLinkSubnetBuilder item : this.subnets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSubnet(Predicate<AWSPrivateLinkSubnetBuilder> predicate) {
        for (AWSPrivateLinkSubnetBuilder item : this.subnets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSubnets(List<AWSPrivateLinkSubnet> subnets) {
        if (this.subnets != null) {
            this._visitables.get("subnets").removeAll(this.subnets);
        }
        if (subnets != null) {
            this.subnets = new ArrayList();
            for (AWSPrivateLinkSubnet item : subnets) {
                this.addToSubnets(item);
            }
        } else {
            this.subnets = null;
        }
        return (A)this;
    }

    @Override
    public A withSubnets(AWSPrivateLinkSubnet ... subnets) {
        if (this.subnets != null) {
            this.subnets.clear();
        }
        if (subnets != null) {
            for (AWSPrivateLinkSubnet item : subnets) {
                this.addToSubnets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubnets() {
        return this.subnets != null && !this.subnets.isEmpty();
    }

    @Override
    public A addNewSubnet(String availabilityZone, String subnetID) {
        return this.addToSubnets(new AWSPrivateLinkSubnet(availabilityZone, subnetID));
    }

    @Override
    public AWSPrivateLinkInventoryFluent.SubnetsNested<A> addNewSubnet() {
        return new SubnetsNestedImpl();
    }

    @Override
    public AWSPrivateLinkInventoryFluent.SubnetsNested<A> addNewSubnetLike(AWSPrivateLinkSubnet item) {
        return new SubnetsNestedImpl(-1, item);
    }

    @Override
    public AWSPrivateLinkInventoryFluent.SubnetsNested<A> setNewSubnetLike(Integer index, AWSPrivateLinkSubnet item) {
        return new SubnetsNestedImpl(index, item);
    }

    @Override
    public AWSPrivateLinkInventoryFluent.SubnetsNested<A> editSubnet(Integer index) {
        if (this.subnets.size() <= index) {
            throw new RuntimeException("Can't edit subnets. Index exceeds size.");
        }
        return this.setNewSubnetLike(index, this.buildSubnet(index));
    }

    @Override
    public AWSPrivateLinkInventoryFluent.SubnetsNested<A> editFirstSubnet() {
        if (this.subnets.size() == 0) {
            throw new RuntimeException("Can't edit first subnets. The list is empty.");
        }
        return this.setNewSubnetLike(0, this.buildSubnet(0));
    }

    @Override
    public AWSPrivateLinkInventoryFluent.SubnetsNested<A> editLastSubnet() {
        int index = this.subnets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subnets. The list is empty.");
        }
        return this.setNewSubnetLike(index, this.buildSubnet(index));
    }

    @Override
    public AWSPrivateLinkInventoryFluent.SubnetsNested<A> editMatchingSubnet(Predicate<AWSPrivateLinkSubnetBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subnets.size(); ++i) {
            if (!predicate.test(this.subnets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subnets. No match found.");
        }
        return this.setNewSubnetLike(index, this.buildSubnet(index));
    }

    @Override
    public String getVpcID() {
        return this.vpcID;
    }

    @Override
    public A withVpcID(String vpcID) {
        this.vpcID = vpcID;
        return (A)this;
    }

    @Override
    public Boolean hasVpcID() {
        return this.vpcID != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSPrivateLinkInventoryFluentImpl that = (AWSPrivateLinkInventoryFluentImpl)o;
        if (this.region != null ? !this.region.equals(that.region) : that.region != null) {
            return false;
        }
        if (this.subnets != null ? !this.subnets.equals(that.subnets) : that.subnets != null) {
            return false;
        }
        if (this.vpcID != null ? !this.vpcID.equals(that.vpcID) : that.vpcID != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.region, this.subnets, this.vpcID, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region + ",");
        }
        if (this.subnets != null && !this.subnets.isEmpty()) {
            sb.append("subnets:");
            sb.append(this.subnets + ",");
        }
        if (this.vpcID != null) {
            sb.append("vpcID:");
            sb.append(this.vpcID + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class SubnetsNestedImpl<N>
    extends AWSPrivateLinkSubnetFluentImpl<AWSPrivateLinkInventoryFluent.SubnetsNested<N>>
    implements AWSPrivateLinkInventoryFluent.SubnetsNested<N>,
    Nested<N> {
        AWSPrivateLinkSubnetBuilder builder;
        Integer index;

        SubnetsNestedImpl(Integer index, AWSPrivateLinkSubnet item) {
            this.index = index;
            this.builder = new AWSPrivateLinkSubnetBuilder(this, item);
        }

        SubnetsNestedImpl() {
            this.index = -1;
            this.builder = new AWSPrivateLinkSubnetBuilder(this);
        }

        @Override
        public N and() {
            return (N)AWSPrivateLinkInventoryFluentImpl.this.setToSubnets(this.index, this.builder.build());
        }

        @Override
        public N endSubnet() {
            return this.and();
        }
    }
}

