/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_1.config.v1;

import io.fabric8.kubernetes.api.builder.v6_1.BaseFluent;
import io.fabric8.openshift.api.model.v6_1.config.v1.RegistrySources;
import io.fabric8.openshift.api.model.v6_1.config.v1.RegistrySourcesFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RegistrySourcesFluentImpl<A extends RegistrySourcesFluent<A>>
extends BaseFluent<A>
implements RegistrySourcesFluent<A> {
    private List<String> allowedRegistries = new ArrayList<String>();
    private List<String> blockedRegistries = new ArrayList<String>();
    private List<String> containerRuntimeSearchRegistries = new ArrayList<String>();
    private List<String> insecureRegistries = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public RegistrySourcesFluentImpl() {
    }

    public RegistrySourcesFluentImpl(RegistrySources instance) {
        this.withAllowedRegistries(instance.getAllowedRegistries());
        this.withBlockedRegistries(instance.getBlockedRegistries());
        this.withContainerRuntimeSearchRegistries(instance.getContainerRuntimeSearchRegistries());
        this.withInsecureRegistries(instance.getInsecureRegistries());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToAllowedRegistries(Integer index, String item) {
        if (this.allowedRegistries == null) {
            this.allowedRegistries = new ArrayList<String>();
        }
        this.allowedRegistries.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAllowedRegistries(Integer index, String item) {
        if (this.allowedRegistries == null) {
            this.allowedRegistries = new ArrayList<String>();
        }
        this.allowedRegistries.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAllowedRegistries(String ... items) {
        if (this.allowedRegistries == null) {
            this.allowedRegistries = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedRegistries.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAllowedRegistries(Collection<String> items) {
        if (this.allowedRegistries == null) {
            this.allowedRegistries = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedRegistries.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllowedRegistries(String ... items) {
        for (String item : items) {
            if (this.allowedRegistries == null) continue;
            this.allowedRegistries.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAllowedRegistries(Collection<String> items) {
        for (String item : items) {
            if (this.allowedRegistries == null) continue;
            this.allowedRegistries.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAllowedRegistries() {
        return this.allowedRegistries;
    }

    @Override
    public String getAllowedRegistry(Integer index) {
        return this.allowedRegistries.get(index);
    }

    @Override
    public String getFirstAllowedRegistry() {
        return this.allowedRegistries.get(0);
    }

    @Override
    public String getLastAllowedRegistry() {
        return this.allowedRegistries.get(this.allowedRegistries.size() - 1);
    }

    @Override
    public String getMatchingAllowedRegistry(Predicate<String> predicate) {
        for (String item : this.allowedRegistries) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAllowedRegistry(Predicate<String> predicate) {
        for (String item : this.allowedRegistries) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAllowedRegistries(List<String> allowedRegistries) {
        if (allowedRegistries != null) {
            this.allowedRegistries = new ArrayList<String>();
            for (String item : allowedRegistries) {
                this.addToAllowedRegistries(item);
            }
        } else {
            this.allowedRegistries = null;
        }
        return (A)this;
    }

    @Override
    public A withAllowedRegistries(String ... allowedRegistries) {
        if (this.allowedRegistries != null) {
            this.allowedRegistries.clear();
        }
        if (allowedRegistries != null) {
            for (String item : allowedRegistries) {
                this.addToAllowedRegistries(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllowedRegistries() {
        return this.allowedRegistries != null && !this.allowedRegistries.isEmpty();
    }

    @Override
    public A addToBlockedRegistries(Integer index, String item) {
        if (this.blockedRegistries == null) {
            this.blockedRegistries = new ArrayList<String>();
        }
        this.blockedRegistries.add(index, item);
        return (A)this;
    }

    @Override
    public A setToBlockedRegistries(Integer index, String item) {
        if (this.blockedRegistries == null) {
            this.blockedRegistries = new ArrayList<String>();
        }
        this.blockedRegistries.set(index, item);
        return (A)this;
    }

    @Override
    public A addToBlockedRegistries(String ... items) {
        if (this.blockedRegistries == null) {
            this.blockedRegistries = new ArrayList<String>();
        }
        for (String item : items) {
            this.blockedRegistries.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToBlockedRegistries(Collection<String> items) {
        if (this.blockedRegistries == null) {
            this.blockedRegistries = new ArrayList<String>();
        }
        for (String item : items) {
            this.blockedRegistries.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromBlockedRegistries(String ... items) {
        for (String item : items) {
            if (this.blockedRegistries == null) continue;
            this.blockedRegistries.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromBlockedRegistries(Collection<String> items) {
        for (String item : items) {
            if (this.blockedRegistries == null) continue;
            this.blockedRegistries.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getBlockedRegistries() {
        return this.blockedRegistries;
    }

    @Override
    public String getBlockedRegistry(Integer index) {
        return this.blockedRegistries.get(index);
    }

    @Override
    public String getFirstBlockedRegistry() {
        return this.blockedRegistries.get(0);
    }

    @Override
    public String getLastBlockedRegistry() {
        return this.blockedRegistries.get(this.blockedRegistries.size() - 1);
    }

    @Override
    public String getMatchingBlockedRegistry(Predicate<String> predicate) {
        for (String item : this.blockedRegistries) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingBlockedRegistry(Predicate<String> predicate) {
        for (String item : this.blockedRegistries) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withBlockedRegistries(List<String> blockedRegistries) {
        if (blockedRegistries != null) {
            this.blockedRegistries = new ArrayList<String>();
            for (String item : blockedRegistries) {
                this.addToBlockedRegistries(item);
            }
        } else {
            this.blockedRegistries = null;
        }
        return (A)this;
    }

    @Override
    public A withBlockedRegistries(String ... blockedRegistries) {
        if (this.blockedRegistries != null) {
            this.blockedRegistries.clear();
        }
        if (blockedRegistries != null) {
            for (String item : blockedRegistries) {
                this.addToBlockedRegistries(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasBlockedRegistries() {
        return this.blockedRegistries != null && !this.blockedRegistries.isEmpty();
    }

    @Override
    public A addToContainerRuntimeSearchRegistries(Integer index, String item) {
        if (this.containerRuntimeSearchRegistries == null) {
            this.containerRuntimeSearchRegistries = new ArrayList<String>();
        }
        this.containerRuntimeSearchRegistries.add(index, item);
        return (A)this;
    }

    @Override
    public A setToContainerRuntimeSearchRegistries(Integer index, String item) {
        if (this.containerRuntimeSearchRegistries == null) {
            this.containerRuntimeSearchRegistries = new ArrayList<String>();
        }
        this.containerRuntimeSearchRegistries.set(index, item);
        return (A)this;
    }

    @Override
    public A addToContainerRuntimeSearchRegistries(String ... items) {
        if (this.containerRuntimeSearchRegistries == null) {
            this.containerRuntimeSearchRegistries = new ArrayList<String>();
        }
        for (String item : items) {
            this.containerRuntimeSearchRegistries.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToContainerRuntimeSearchRegistries(Collection<String> items) {
        if (this.containerRuntimeSearchRegistries == null) {
            this.containerRuntimeSearchRegistries = new ArrayList<String>();
        }
        for (String item : items) {
            this.containerRuntimeSearchRegistries.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainerRuntimeSearchRegistries(String ... items) {
        for (String item : items) {
            if (this.containerRuntimeSearchRegistries == null) continue;
            this.containerRuntimeSearchRegistries.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContainerRuntimeSearchRegistries(Collection<String> items) {
        for (String item : items) {
            if (this.containerRuntimeSearchRegistries == null) continue;
            this.containerRuntimeSearchRegistries.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getContainerRuntimeSearchRegistries() {
        return this.containerRuntimeSearchRegistries;
    }

    @Override
    public String getContainerRuntimeSearchRegistry(Integer index) {
        return this.containerRuntimeSearchRegistries.get(index);
    }

    @Override
    public String getFirstContainerRuntimeSearchRegistry() {
        return this.containerRuntimeSearchRegistries.get(0);
    }

    @Override
    public String getLastContainerRuntimeSearchRegistry() {
        return this.containerRuntimeSearchRegistries.get(this.containerRuntimeSearchRegistries.size() - 1);
    }

    @Override
    public String getMatchingContainerRuntimeSearchRegistry(Predicate<String> predicate) {
        for (String item : this.containerRuntimeSearchRegistries) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingContainerRuntimeSearchRegistry(Predicate<String> predicate) {
        for (String item : this.containerRuntimeSearchRegistries) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withContainerRuntimeSearchRegistries(List<String> containerRuntimeSearchRegistries) {
        if (containerRuntimeSearchRegistries != null) {
            this.containerRuntimeSearchRegistries = new ArrayList<String>();
            for (String item : containerRuntimeSearchRegistries) {
                this.addToContainerRuntimeSearchRegistries(item);
            }
        } else {
            this.containerRuntimeSearchRegistries = null;
        }
        return (A)this;
    }

    @Override
    public A withContainerRuntimeSearchRegistries(String ... containerRuntimeSearchRegistries) {
        if (this.containerRuntimeSearchRegistries != null) {
            this.containerRuntimeSearchRegistries.clear();
        }
        if (containerRuntimeSearchRegistries != null) {
            for (String item : containerRuntimeSearchRegistries) {
                this.addToContainerRuntimeSearchRegistries(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasContainerRuntimeSearchRegistries() {
        return this.containerRuntimeSearchRegistries != null && !this.containerRuntimeSearchRegistries.isEmpty();
    }

    @Override
    public A addToInsecureRegistries(Integer index, String item) {
        if (this.insecureRegistries == null) {
            this.insecureRegistries = new ArrayList<String>();
        }
        this.insecureRegistries.add(index, item);
        return (A)this;
    }

    @Override
    public A setToInsecureRegistries(Integer index, String item) {
        if (this.insecureRegistries == null) {
            this.insecureRegistries = new ArrayList<String>();
        }
        this.insecureRegistries.set(index, item);
        return (A)this;
    }

    @Override
    public A addToInsecureRegistries(String ... items) {
        if (this.insecureRegistries == null) {
            this.insecureRegistries = new ArrayList<String>();
        }
        for (String item : items) {
            this.insecureRegistries.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToInsecureRegistries(Collection<String> items) {
        if (this.insecureRegistries == null) {
            this.insecureRegistries = new ArrayList<String>();
        }
        for (String item : items) {
            this.insecureRegistries.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromInsecureRegistries(String ... items) {
        for (String item : items) {
            if (this.insecureRegistries == null) continue;
            this.insecureRegistries.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromInsecureRegistries(Collection<String> items) {
        for (String item : items) {
            if (this.insecureRegistries == null) continue;
            this.insecureRegistries.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getInsecureRegistries() {
        return this.insecureRegistries;
    }

    @Override
    public String getInsecureRegistry(Integer index) {
        return this.insecureRegistries.get(index);
    }

    @Override
    public String getFirstInsecureRegistry() {
        return this.insecureRegistries.get(0);
    }

    @Override
    public String getLastInsecureRegistry() {
        return this.insecureRegistries.get(this.insecureRegistries.size() - 1);
    }

    @Override
    public String getMatchingInsecureRegistry(Predicate<String> predicate) {
        for (String item : this.insecureRegistries) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingInsecureRegistry(Predicate<String> predicate) {
        for (String item : this.insecureRegistries) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withInsecureRegistries(List<String> insecureRegistries) {
        if (insecureRegistries != null) {
            this.insecureRegistries = new ArrayList<String>();
            for (String item : insecureRegistries) {
                this.addToInsecureRegistries(item);
            }
        } else {
            this.insecureRegistries = null;
        }
        return (A)this;
    }

    @Override
    public A withInsecureRegistries(String ... insecureRegistries) {
        if (this.insecureRegistries != null) {
            this.insecureRegistries.clear();
        }
        if (insecureRegistries != null) {
            for (String item : insecureRegistries) {
                this.addToInsecureRegistries(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasInsecureRegistries() {
        return this.insecureRegistries != null && !this.insecureRegistries.isEmpty();
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegistrySourcesFluentImpl that = (RegistrySourcesFluentImpl)o;
        if (this.allowedRegistries != null ? !this.allowedRegistries.equals(that.allowedRegistries) : that.allowedRegistries != null) {
            return false;
        }
        if (this.blockedRegistries != null ? !this.blockedRegistries.equals(that.blockedRegistries) : that.blockedRegistries != null) {
            return false;
        }
        if (this.containerRuntimeSearchRegistries != null ? !this.containerRuntimeSearchRegistries.equals(that.containerRuntimeSearchRegistries) : that.containerRuntimeSearchRegistries != null) {
            return false;
        }
        if (this.insecureRegistries != null ? !this.insecureRegistries.equals(that.insecureRegistries) : that.insecureRegistries != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allowedRegistries, this.blockedRegistries, this.containerRuntimeSearchRegistries, this.insecureRegistries, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowedRegistries != null && !this.allowedRegistries.isEmpty()) {
            sb.append("allowedRegistries:");
            sb.append(this.allowedRegistries + ",");
        }
        if (this.blockedRegistries != null && !this.blockedRegistries.isEmpty()) {
            sb.append("blockedRegistries:");
            sb.append(this.blockedRegistries + ",");
        }
        if (this.containerRuntimeSearchRegistries != null && !this.containerRuntimeSearchRegistries.isEmpty()) {
            sb.append("containerRuntimeSearchRegistries:");
            sb.append(this.containerRuntimeSearchRegistries + ",");
        }
        if (this.insecureRegistries != null && !this.insecureRegistries.isEmpty()) {
            sb.append("insecureRegistries:");
            sb.append(this.insecureRegistries + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

