/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_1;

import io.fabric8.kubernetes.api.builder.v6_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_1.Nested;
import io.fabric8.kubernetes.api.model.v6_1.LocalObjectReference;
import io.fabric8.kubernetes.api.model.v6_1.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_1.LocalObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.v6_1.SecretSpec;
import io.fabric8.openshift.api.model.v6_1.SecretSpecFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class SecretSpecFluentImpl<A extends SecretSpecFluent<A>>
extends BaseFluent<A>
implements SecretSpecFluent<A> {
    private String mountPath;
    private LocalObjectReferenceBuilder secretSource;
    private Map<String, Object> additionalProperties;

    public SecretSpecFluentImpl() {
    }

    public SecretSpecFluentImpl(SecretSpec instance) {
        this.withMountPath(instance.getMountPath());
        this.withSecretSource(instance.getSecretSource());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getMountPath() {
        return this.mountPath;
    }

    @Override
    public A withMountPath(String mountPath) {
        this.mountPath = mountPath;
        return (A)this;
    }

    @Override
    public Boolean hasMountPath() {
        return this.mountPath != null;
    }

    @Override
    @Deprecated
    public LocalObjectReference getSecretSource() {
        return this.secretSource != null ? this.secretSource.build() : null;
    }

    @Override
    public LocalObjectReference buildSecretSource() {
        return this.secretSource != null ? this.secretSource.build() : null;
    }

    @Override
    public A withSecretSource(LocalObjectReference secretSource) {
        this._visitables.get("secretSource").remove(this.secretSource);
        if (secretSource != null) {
            this.secretSource = new LocalObjectReferenceBuilder(secretSource);
            this._visitables.get("secretSource").add(this.secretSource);
        } else {
            this.secretSource = null;
            this._visitables.get("secretSource").remove(this.secretSource);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretSource() {
        return this.secretSource != null;
    }

    @Override
    public A withNewSecretSource(String name) {
        return this.withSecretSource(new LocalObjectReference(name));
    }

    @Override
    public SecretSpecFluent.SecretSourceNested<A> withNewSecretSource() {
        return new SecretSourceNestedImpl();
    }

    @Override
    public SecretSpecFluent.SecretSourceNested<A> withNewSecretSourceLike(LocalObjectReference item) {
        return new SecretSourceNestedImpl(item);
    }

    @Override
    public SecretSpecFluent.SecretSourceNested<A> editSecretSource() {
        return this.withNewSecretSourceLike(this.getSecretSource());
    }

    @Override
    public SecretSpecFluent.SecretSourceNested<A> editOrNewSecretSource() {
        return this.withNewSecretSourceLike(this.getSecretSource() != null ? this.getSecretSource() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public SecretSpecFluent.SecretSourceNested<A> editOrNewSecretSourceLike(LocalObjectReference item) {
        return this.withNewSecretSourceLike(this.getSecretSource() != null ? this.getSecretSource() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretSpecFluentImpl that = (SecretSpecFluentImpl)o;
        if (this.mountPath != null ? !this.mountPath.equals(that.mountPath) : that.mountPath != null) {
            return false;
        }
        if (this.secretSource != null ? !this.secretSource.equals(that.secretSource) : that.secretSource != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mountPath, this.secretSource, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.mountPath != null) {
            sb.append("mountPath:");
            sb.append(this.mountPath + ",");
        }
        if (this.secretSource != null) {
            sb.append("secretSource:");
            sb.append(this.secretSource + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class SecretSourceNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<SecretSpecFluent.SecretSourceNested<N>>
    implements SecretSpecFluent.SecretSourceNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;

        SecretSourceNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        SecretSourceNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)SecretSpecFluentImpl.this.withSecretSource(this.builder.build());
        }

        @Override
        public N endSecretSource() {
            return this.and();
        }
    }
}

