/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_1;

import io.fabric8.kubernetes.api.builder.v6_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_1.Nested;
import io.fabric8.openshift.api.model.v6_1.ImageImportSpec;
import io.fabric8.openshift.api.model.v6_1.ImageImportSpecBuilder;
import io.fabric8.openshift.api.model.v6_1.ImageImportSpecFluentImpl;
import io.fabric8.openshift.api.model.v6_1.ImageStreamImportSpec;
import io.fabric8.openshift.api.model.v6_1.ImageStreamImportSpecFluent;
import io.fabric8.openshift.api.model.v6_1.RepositoryImportSpec;
import io.fabric8.openshift.api.model.v6_1.RepositoryImportSpecBuilder;
import io.fabric8.openshift.api.model.v6_1.RepositoryImportSpecFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ImageStreamImportSpecFluentImpl<A extends ImageStreamImportSpecFluent<A>>
extends BaseFluent<A>
implements ImageStreamImportSpecFluent<A> {
    private ArrayList<ImageImportSpecBuilder> images = new ArrayList();
    private Boolean _import;
    private RepositoryImportSpecBuilder repository;
    private Map<String, Object> additionalProperties;

    public ImageStreamImportSpecFluentImpl() {
    }

    public ImageStreamImportSpecFluentImpl(ImageStreamImportSpec instance) {
        this.withImages(instance.getImages());
        this.withImport(instance.getImport());
        this.withRepository(instance.getRepository());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToImages(Integer index, ImageImportSpec item) {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        ImageImportSpecBuilder builder = new ImageImportSpecBuilder(item);
        this._visitables.get("images").add(index >= 0 ? index.intValue() : this._visitables.get("images").size(), builder);
        this.images.add(index >= 0 ? index.intValue() : this.images.size(), builder);
        return (A)this;
    }

    @Override
    public A setToImages(Integer index, ImageImportSpec item) {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        ImageImportSpecBuilder builder = new ImageImportSpecBuilder(item);
        if (index < 0 || index >= this._visitables.get("images").size()) {
            this._visitables.get("images").add(builder);
        } else {
            this._visitables.get("images").set(index, builder);
        }
        if (index < 0 || index >= this.images.size()) {
            this.images.add(builder);
        } else {
            this.images.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToImages(ImageImportSpec ... items) {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        for (ImageImportSpec item : items) {
            ImageImportSpecBuilder builder = new ImageImportSpecBuilder(item);
            this._visitables.get("images").add(builder);
            this.images.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToImages(Collection<ImageImportSpec> items) {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        for (ImageImportSpec item : items) {
            ImageImportSpecBuilder builder = new ImageImportSpecBuilder(item);
            this._visitables.get("images").add(builder);
            this.images.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromImages(ImageImportSpec ... items) {
        for (ImageImportSpec item : items) {
            ImageImportSpecBuilder builder = new ImageImportSpecBuilder(item);
            this._visitables.get("images").remove(builder);
            if (this.images == null) continue;
            this.images.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImages(Collection<ImageImportSpec> items) {
        for (ImageImportSpec item : items) {
            ImageImportSpecBuilder builder = new ImageImportSpecBuilder(item);
            this._visitables.get("images").remove(builder);
            if (this.images == null) continue;
            this.images.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromImages(Predicate<ImageImportSpecBuilder> predicate) {
        if (this.images == null) {
            return (A)this;
        }
        Iterator<ImageImportSpecBuilder> each = this.images.iterator();
        Object visitables = this._visitables.get("images");
        while (each.hasNext()) {
            ImageImportSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ImageImportSpec> getImages() {
        return this.images != null ? ImageStreamImportSpecFluentImpl.build(this.images) : null;
    }

    @Override
    public List<ImageImportSpec> buildImages() {
        return this.images != null ? ImageStreamImportSpecFluentImpl.build(this.images) : null;
    }

    @Override
    public ImageImportSpec buildImage(Integer index) {
        return this.images.get(index).build();
    }

    @Override
    public ImageImportSpec buildFirstImage() {
        return this.images.get(0).build();
    }

    @Override
    public ImageImportSpec buildLastImage() {
        return this.images.get(this.images.size() - 1).build();
    }

    @Override
    public ImageImportSpec buildMatchingImage(Predicate<ImageImportSpecBuilder> predicate) {
        for (ImageImportSpecBuilder item : this.images) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingImage(Predicate<ImageImportSpecBuilder> predicate) {
        for (ImageImportSpecBuilder item : this.images) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withImages(List<ImageImportSpec> images) {
        if (this.images != null) {
            this._visitables.get("images").removeAll(this.images);
        }
        if (images != null) {
            this.images = new ArrayList();
            for (ImageImportSpec item : images) {
                this.addToImages(item);
            }
        } else {
            this.images = null;
        }
        return (A)this;
    }

    @Override
    public A withImages(ImageImportSpec ... images) {
        if (this.images != null) {
            this.images.clear();
        }
        if (images != null) {
            for (ImageImportSpec item : images) {
                this.addToImages(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasImages() {
        return this.images != null && !this.images.isEmpty();
    }

    @Override
    public ImageStreamImportSpecFluent.ImagesNested<A> addNewImage() {
        return new ImagesNestedImpl();
    }

    @Override
    public ImageStreamImportSpecFluent.ImagesNested<A> addNewImageLike(ImageImportSpec item) {
        return new ImagesNestedImpl(-1, item);
    }

    @Override
    public ImageStreamImportSpecFluent.ImagesNested<A> setNewImageLike(Integer index, ImageImportSpec item) {
        return new ImagesNestedImpl(index, item);
    }

    @Override
    public ImageStreamImportSpecFluent.ImagesNested<A> editImage(Integer index) {
        if (this.images.size() <= index) {
            throw new RuntimeException("Can't edit images. Index exceeds size.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    public ImageStreamImportSpecFluent.ImagesNested<A> editFirstImage() {
        if (this.images.size() == 0) {
            throw new RuntimeException("Can't edit first images. The list is empty.");
        }
        return this.setNewImageLike(0, this.buildImage(0));
    }

    @Override
    public ImageStreamImportSpecFluent.ImagesNested<A> editLastImage() {
        int index = this.images.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last images. The list is empty.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    public ImageStreamImportSpecFluent.ImagesNested<A> editMatchingImage(Predicate<ImageImportSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.images.size(); ++i) {
            if (!predicate.test(this.images.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching images. No match found.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    public Boolean getImport() {
        return this._import;
    }

    @Override
    public A withImport(Boolean _import) {
        this._import = _import;
        return (A)this;
    }

    @Override
    public Boolean hasImport() {
        return this._import != null;
    }

    @Override
    @Deprecated
    public RepositoryImportSpec getRepository() {
        return this.repository != null ? this.repository.build() : null;
    }

    @Override
    public RepositoryImportSpec buildRepository() {
        return this.repository != null ? this.repository.build() : null;
    }

    @Override
    public A withRepository(RepositoryImportSpec repository) {
        this._visitables.get("repository").remove(this.repository);
        if (repository != null) {
            this.repository = new RepositoryImportSpecBuilder(repository);
            this._visitables.get("repository").add(this.repository);
        } else {
            this.repository = null;
            this._visitables.get("repository").remove(this.repository);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRepository() {
        return this.repository != null;
    }

    @Override
    public ImageStreamImportSpecFluent.RepositoryNested<A> withNewRepository() {
        return new RepositoryNestedImpl();
    }

    @Override
    public ImageStreamImportSpecFluent.RepositoryNested<A> withNewRepositoryLike(RepositoryImportSpec item) {
        return new RepositoryNestedImpl(item);
    }

    @Override
    public ImageStreamImportSpecFluent.RepositoryNested<A> editRepository() {
        return this.withNewRepositoryLike(this.getRepository());
    }

    @Override
    public ImageStreamImportSpecFluent.RepositoryNested<A> editOrNewRepository() {
        return this.withNewRepositoryLike(this.getRepository() != null ? this.getRepository() : new RepositoryImportSpecBuilder().build());
    }

    @Override
    public ImageStreamImportSpecFluent.RepositoryNested<A> editOrNewRepositoryLike(RepositoryImportSpec item) {
        return this.withNewRepositoryLike(this.getRepository() != null ? this.getRepository() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageStreamImportSpecFluentImpl that = (ImageStreamImportSpecFluentImpl)o;
        if (this.images != null ? !this.images.equals(that.images) : that.images != null) {
            return false;
        }
        if (this._import != null ? !this._import.equals(that._import) : that._import != null) {
            return false;
        }
        if (this.repository != null ? !this.repository.equals(that.repository) : that.repository != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.images, this._import, this.repository, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.images != null && !this.images.isEmpty()) {
            sb.append("images:");
            sb.append(this.images + ",");
        }
        if (this._import != null) {
            sb.append("_import:");
            sb.append(this._import + ",");
        }
        if (this.repository != null) {
            sb.append("repository:");
            sb.append(this.repository + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withImport() {
        return this.withImport(true);
    }

    class RepositoryNestedImpl<N>
    extends RepositoryImportSpecFluentImpl<ImageStreamImportSpecFluent.RepositoryNested<N>>
    implements ImageStreamImportSpecFluent.RepositoryNested<N>,
    Nested<N> {
        RepositoryImportSpecBuilder builder;

        RepositoryNestedImpl(RepositoryImportSpec item) {
            this.builder = new RepositoryImportSpecBuilder(this, item);
        }

        RepositoryNestedImpl() {
            this.builder = new RepositoryImportSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamImportSpecFluentImpl.this.withRepository(this.builder.build());
        }

        @Override
        public N endRepository() {
            return this.and();
        }
    }

    class ImagesNestedImpl<N>
    extends ImageImportSpecFluentImpl<ImageStreamImportSpecFluent.ImagesNested<N>>
    implements ImageStreamImportSpecFluent.ImagesNested<N>,
    Nested<N> {
        ImageImportSpecBuilder builder;
        Integer index;

        ImagesNestedImpl(Integer index, ImageImportSpec item) {
            this.index = index;
            this.builder = new ImageImportSpecBuilder(this, item);
        }

        ImagesNestedImpl() {
            this.index = -1;
            this.builder = new ImageImportSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamImportSpecFluentImpl.this.setToImages(this.index, this.builder.build());
        }

        @Override
        public N endImage() {
            return this.and();
        }
    }
}

