/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_1;

import io.fabric8.kubernetes.api.builder.v6_1.VisitableBuilder;
import io.fabric8.openshift.api.model.v6_1.BuildOutput;
import io.fabric8.openshift.api.model.v6_1.BuildOutputFluent;
import io.fabric8.openshift.api.model.v6_1.BuildOutputFluentImpl;

public class BuildOutputBuilder
extends BuildOutputFluentImpl<BuildOutputBuilder>
implements VisitableBuilder<BuildOutput, BuildOutputBuilder> {
    BuildOutputFluent<?> fluent;
    Boolean validationEnabled;

    public BuildOutputBuilder() {
        this(false);
    }

    public BuildOutputBuilder(Boolean validationEnabled) {
        this(new BuildOutput(), validationEnabled);
    }

    public BuildOutputBuilder(BuildOutputFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public BuildOutputBuilder(BuildOutputFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new BuildOutput(), validationEnabled);
    }

    public BuildOutputBuilder(BuildOutputFluent<?> fluent, BuildOutput instance) {
        this(fluent, instance, false);
    }

    public BuildOutputBuilder(BuildOutputFluent<?> fluent, BuildOutput instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withImageLabels(instance.getImageLabels());
        fluent.withPushSecret(instance.getPushSecret());
        fluent.withTo(instance.getTo());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public BuildOutputBuilder(BuildOutput instance) {
        this(instance, (Boolean)false);
    }

    public BuildOutputBuilder(BuildOutput instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withImageLabels(instance.getImageLabels());
        this.withPushSecret(instance.getPushSecret());
        this.withTo(instance.getTo());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public BuildOutput build() {
        BuildOutput buildable = new BuildOutput(this.fluent.getImageLabels(), this.fluent.getPushSecret(), this.fluent.getTo());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

