/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_1.server.mock.crud;

import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.kubernetes.clnt.v6_1.server.mock.crud.KubernetesCrudDispatcherException;
import io.fabric8.kubernetes.clnt.v6_1.server.mock.crud.KubernetesCrudDispatcherHandler;
import io.fabric8.kubernetes.clnt.v6_1.server.mock.crud.KubernetesCrudPersistence;
import io.fabric8.kubernetes.clnt.v6_1.utils.Serialization;
import io.fabric8.mockwebserver.crud.AttributeSet;
import java.util.Map;
import okhttp3.mockwebserver.MockResponse;

public class PutHandler
implements KubernetesCrudDispatcherHandler {
    private final KubernetesCrudPersistence persistence;

    public PutHandler(KubernetesCrudPersistence persistence) {
        this.persistence = persistence;
    }

    @Override
    public MockResponse handle(String path, String contentType, String requestBody) throws KubernetesCrudDispatcherException {
        JsonNode updatedResource;
        this.validateRequestBody(requestBody);
        AttributeSet attributes = this.persistence.getKey(path);
        Map.Entry<AttributeSet, String> currentResourceEntry = this.persistence.findResource(attributes);
        if (currentResourceEntry == null) {
            return new MockResponse().setResponseCode(404);
        }
        JsonNode currentResource = this.persistence.asNode(currentResourceEntry);
        if (KubernetesCrudDispatcherHandler.isStatusPath(path)) {
            updatedResource = currentResource.deepCopy();
            KubernetesCrudDispatcherHandler.setStatus(updatedResource, this.persistence.asNode(requestBody).path("status"));
        } else {
            updatedResource = this.persistence.asNode(requestBody);
            if (this.persistence.isStatusSubresourceEnabledForResource(path)) {
                KubernetesCrudDispatcherHandler.setStatus(updatedResource, currentResource.path("status"));
            }
        }
        this.validatePath(attributes, updatedResource);
        this.persistence.preserveMetadata(currentResource, updatedResource);
        if (!KubernetesCrudDispatcherHandler.isStatusPath(path)) {
            this.persistence.touchGeneration(currentResource, updatedResource);
        }
        this.persistence.touchResourceVersion(currentResource, updatedResource);
        String response = Serialization.asJson((Object)updatedResource);
        this.persistence.processEvent(path, attributes, currentResourceEntry.getKey(), response);
        return new MockResponse().setResponseCode(200).setBody(response);
    }
}

