/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_1.dsl.internal.extensions.v1beta1;

import io.fabric8.kubernetes.api.model.v6_1.Container;
import io.fabric8.kubernetes.api.model.v6_1.Status;
import io.fabric8.kubernetes.api.model.v6_1.extensions.DeploymentRollback;
import io.fabric8.kubernetes.api.model.v6_1.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.v6_1.extensions.ReplicaSetList;
import io.fabric8.kubernetes.clnt.v6_1.Client;
import io.fabric8.kubernetes.clnt.v6_1.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v6_1.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v6_1.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v6_1.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v6_1.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.clnt.v6_1.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.clnt.v6_1.dsl.internal.OperationContext;
import io.fabric8.kubernetes.clnt.v6_1.dsl.internal.RollingOperationContext;
import io.fabric8.kubernetes.clnt.v6_1.dsl.internal.apps.v1.RollableScalableResourceOperation;
import io.fabric8.kubernetes.clnt.v6_1.dsl.internal.apps.v1.RollingUpdater;
import io.fabric8.kubernetes.clnt.v6_1.dsl.internal.extensions.v1beta1.ReplicaSetRollingUpdater;
import io.fabric8.kubernetes.clnt.v6_1.utils.internal.PodOperationUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ReplicaSetOperationsImpl
extends RollableScalableResourceOperation<ReplicaSet, ReplicaSetList, RollableScalableResource<ReplicaSet>>
implements TimeoutImageEditReplacePatchable<ReplicaSet> {
    public ReplicaSetOperationsImpl(Client client) {
        this(new RollingOperationContext(), HasMetadataOperationsImpl.defaultContext(client));
    }

    ReplicaSetOperationsImpl(RollingOperationContext context, OperationContext superContext) {
        super(context, superContext.withApiGroupName("extensions").withApiGroupVersion("v1beta1").withPlural("replicasets"), ReplicaSet.class, ReplicaSetList.class);
    }

    @Override
    public ReplicaSetOperationsImpl newInstance(OperationContext context) {
        return new ReplicaSetOperationsImpl(this.rollingOperationContext, context);
    }

    public ReplicaSetOperationsImpl newInstance(RollingOperationContext context) {
        return new ReplicaSetOperationsImpl(context, this.context);
    }

    public ReplicaSet pause() {
        throw new UnsupportedOperationException(this.context.getPlural() + " \"" + this.name + "\" pausing is not supported");
    }

    public ReplicaSet resume() {
        throw new UnsupportedOperationException(this.context.getPlural() + " \"" + this.name + "\" resuming is not supported");
    }

    public ReplicaSet restart() {
        throw new UnsupportedOperationException(this.context.getPlural() + " \"" + this.name + "\" restarting is not supported");
    }

    public ReplicaSet undo() {
        throw new UnsupportedOperationException("no rollbacker has been implemented for \"" + ((ReplicaSet)this.get()).getKind() + "\"");
    }

    @Override
    public ReplicaSet withReplicas(int count) {
        return (ReplicaSet)this.accept(r -> r.getSpec().setReplicas(count));
    }

    @Override
    public RollingUpdater<ReplicaSet, ReplicaSetList> getRollingUpdater(long rollingTimeout, TimeUnit rollingTimeUnit) {
        return new ReplicaSetRollingUpdater(this.context.getClient(), this.getNamespace(), rollingTimeUnit.toMillis(rollingTimeout), this.config.getLoggingInterval());
    }

    @Override
    public int getCurrentReplicas(ReplicaSet current) {
        return current.getStatus().getReplicas();
    }

    @Override
    public int getDesiredReplicas(ReplicaSet item) {
        return item.getSpec().getReplicas();
    }

    @Override
    public long getObservedGeneration(ReplicaSet current) {
        return current != null && current.getStatus() != null && current.getStatus().getObservedGeneration() != null ? current.getStatus().getObservedGeneration() : -1L;
    }

    public Status rollback(DeploymentRollback deploymentRollback) {
        throw new KubernetesClientException("rollback not supported in case of ReplicaSets");
    }

    public String getLog(boolean isPretty) {
        StringBuilder stringBuilder = new StringBuilder();
        List<PodResource> podOperationList = this.doGetLog(isPretty);
        for (PodResource podOperation : podOperationList) {
            stringBuilder.append(podOperation.getLog(isPretty));
        }
        return stringBuilder.toString();
    }

    private List<PodResource> doGetLog(boolean isPretty) {
        ReplicaSet replicaSet = (ReplicaSet)this.requireFromServer();
        return PodOperationUtil.getPodOperationsForController(this.context, replicaSet.getMetadata().getUid(), ReplicaSetOperationsImpl.getReplicaSetSelectorLabels(replicaSet), isPretty, this.rollingOperationContext.getLogWaitTimeout(), this.rollingOperationContext.getContainerId());
    }

    public Reader getLogReader() {
        return PodOperationUtil.getLogReader(this.doGetLog(false));
    }

    public InputStream getLogInputStream() {
        return PodOperationUtil.getLogInputStream(this.doGetLog(false));
    }

    public LogWatch watchLog(OutputStream out) {
        return PodOperationUtil.watchLog(this.doGetLog(false), out);
    }

    static Map<String, String> getReplicaSetSelectorLabels(ReplicaSet replicaSet) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (replicaSet != null && replicaSet.getSpec() != null && replicaSet.getSpec().getSelector() != null) {
            labels.putAll(replicaSet.getSpec().getSelector().getMatchLabels());
        }
        return labels;
    }

    @Override
    protected List<Container> getContainers(ReplicaSet value) {
        return value.getSpec().getTemplate().getSpec().getContainers();
    }
}

