/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_1.dsl.internal.core.v1;

import io.fabric8.kubernetes.api.model.v6_1.Endpoints;
import io.fabric8.kubernetes.api.model.v6_1.EndpointsList;
import io.fabric8.kubernetes.api.model.v6_1.Pod;
import io.fabric8.kubernetes.api.model.v6_1.PodList;
import io.fabric8.kubernetes.api.model.v6_1.Service;
import io.fabric8.kubernetes.api.model.v6_1.ServiceBuilder;
import io.fabric8.kubernetes.api.model.v6_1.ServiceFluent;
import io.fabric8.kubernetes.api.model.v6_1.ServiceList;
import io.fabric8.kubernetes.clnt.v6_1.Client;
import io.fabric8.kubernetes.clnt.v6_1.KubernetesClient;
import io.fabric8.kubernetes.clnt.v6_1.LocalPortForward;
import io.fabric8.kubernetes.clnt.v6_1.PortForward;
import io.fabric8.kubernetes.clnt.v6_1.ServiceToURLProvider;
import io.fabric8.kubernetes.clnt.v6_1.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v6_1.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v6_1.dsl.Resource;
import io.fabric8.kubernetes.clnt.v6_1.dsl.ServiceResource;
import io.fabric8.kubernetes.clnt.v6_1.dsl.internal.BaseOperation;
import io.fabric8.kubernetes.clnt.v6_1.dsl.internal.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v6_1.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.clnt.v6_1.dsl.internal.OperationContext;
import io.fabric8.kubernetes.clnt.v6_1.dsl.internal.core.v1.PodOperationsImpl;
import io.fabric8.kubernetes.clnt.v6_1.utils.URLUtils;
import java.net.InetAddress;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class ServiceOperationsImpl
extends HasMetadataOperation<Service, ServiceList, ServiceResource<Service>>
implements ServiceResource<Service> {
    public static final String EXTERNAL_NAME = "ExternalName";

    public ServiceOperationsImpl(Client client) {
        this(HasMetadataOperationsImpl.defaultContext(client));
    }

    private ServiceOperationsImpl(OperationContext context) {
        super(context.withPlural("services"), Service.class, ServiceList.class);
    }

    @Override
    public ServiceOperationsImpl newInstance(OperationContext context) {
        return new ServiceOperationsImpl(context);
    }

    @Override
    public Service waitUntilReady(long amount, TimeUnit timeUnit) {
        long started = System.nanoTime();
        super.waitUntilReady(amount, timeUnit);
        long alreadySpent = System.nanoTime() - started;
        long remaining = Math.max(10000L, timeUnit.toNanos(amount) - alreadySpent);
        Resource endpointsOperation = (Resource)((NonNamespaceOperation)this.context.getClient().resources(Endpoints.class, EndpointsList.class).inNamespace(this.context.getNamespace())).withName(this.context.getName());
        endpointsOperation.waitUntilReady(remaining, TimeUnit.MILLISECONDS);
        return (Service)this.get();
    }

    public String getURL(String portName) {
        String clusterIP = ((Service)this.getMandatory()).getSpec().getClusterIP();
        if ("None".equals(clusterIP)) {
            throw new IllegalStateException("Service: " + ((Service)this.getMandatory()).getMetadata().getName() + " in namespace " + this.namespace + " is head-less. Search for endpoints instead");
        }
        return this.getUrlHelper(portName);
    }

    private String getUrlHelper(String portName) {
        ServiceLoader<ServiceToURLProvider> urlProvider = ServiceLoader.load(ServiceToURLProvider.class, Thread.currentThread().getContextClassLoader());
        Iterator<ServiceToURLProvider> iterator = urlProvider.iterator();
        ArrayList<ServiceToURLProvider> servicesList = new ArrayList<ServiceToURLProvider>();
        while (iterator.hasNext()) {
            servicesList.add(iterator.next());
        }
        Collections.sort(servicesList, new ServiceToUrlSortComparator());
        for (ServiceToURLProvider serviceToURLProvider : servicesList) {
            String url = serviceToURLProvider.getURL((Service)this.getMandatory(), portName, this.namespace, (KubernetesClient)this.context.getClient().adapt(KubernetesClient.class));
            if (url == null || !URLUtils.isValidURL((String)url)) continue;
            return url;
        }
        return null;
    }

    private Pod matchingPod() {
        Service item = (Service)this.requireFromServer();
        Map<String, String> labels = item.getSpec().getSelector();
        PodList list = (PodList)((BaseOperation)new PodOperationsImpl(this.context.getClient()).inNamespace(item.getMetadata().getNamespace())).withLabels(labels).list();
        return (Pod)list.getItems().stream().findFirst().orElseThrow(() -> new IllegalStateException("Could not find matching pod for service:" + item + "."));
    }

    public PortForward portForward(int port, ReadableByteChannel in, WritableByteChannel out) {
        Pod m = this.matchingPod();
        return ((PodResource)((BaseOperation)new PodOperationsImpl(this.context.getClient()).inNamespace(m.getMetadata().getNamespace())).withName(m.getMetadata().getName())).portForward(port, in, out);
    }

    public LocalPortForward portForward(int port, int localPort) {
        Pod m = this.matchingPod();
        return ((PodResource)((BaseOperation)new PodOperationsImpl(this.context.getClient()).inNamespace(m.getMetadata().getNamespace())).withName(m.getMetadata().getName())).portForward(port, localPort);
    }

    public LocalPortForward portForward(int port, InetAddress localInetAddress, int localPort) {
        Pod m = this.matchingPod();
        return ((PodResource)((BaseOperation)new PodOperationsImpl(this.context.getClient()).inNamespace(m.getMetadata().getNamespace())).withName(m.getMetadata().getName())).portForward(port, localInetAddress, localPort);
    }

    public LocalPortForward portForward(int port) {
        Pod m = this.matchingPod();
        return ((PodResource)((BaseOperation)new PodOperationsImpl(this.context.getClient()).inNamespace(m.getMetadata().getNamespace())).withName(m.getMetadata().getName())).portForward(port);
    }

    @Override
    protected Service modifyItemForReplaceOrPatch(Supplier<Service> currentSupplier, Service item) {
        if (!this.isExternalNameService(item)) {
            Service old = currentSupplier.get();
            return ((ServiceBuilder)((ServiceFluent.SpecNested)new ServiceBuilder(item).editSpec().withClusterIP(old.getSpec().getClusterIP())).endSpec()).build();
        }
        return item;
    }

    private boolean isExternalNameService(Service item) {
        if (item.getSpec() != null && item.getSpec().getType() != null) {
            return item.getSpec().getType().equals(EXTERNAL_NAME);
        }
        return false;
    }

    public class ServiceToUrlSortComparator
    implements Comparator<ServiceToURLProvider> {
        @Override
        public int compare(ServiceToURLProvider first, ServiceToURLProvider second) {
            return first.getPriority() - second.getPriority();
        }
    }
}

