/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_1.dsl.internal.batch.v1;

import io.fabric8.kubernetes.api.model.v6_1.autoscaling.v1.Scale;
import io.fabric8.kubernetes.api.model.v6_1.batch.v1.Job;
import io.fabric8.kubernetes.api.model.v6_1.batch.v1.JobList;
import io.fabric8.kubernetes.clnt.v6_1.Client;
import io.fabric8.kubernetes.clnt.v6_1.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v6_1.dsl.Loggable;
import io.fabric8.kubernetes.clnt.v6_1.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v6_1.dsl.ScalableResource;
import io.fabric8.kubernetes.clnt.v6_1.dsl.internal.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v6_1.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.clnt.v6_1.dsl.internal.OperationContext;
import io.fabric8.kubernetes.clnt.v6_1.dsl.internal.PodControllerOperationContext;
import io.fabric8.kubernetes.clnt.v6_1.utils.internal.PodOperationUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobOperationsImpl
extends HasMetadataOperation<Job, JobList, ScalableResource<Job>>
implements ScalableResource<Job> {
    static final transient Logger LOG = LoggerFactory.getLogger(JobOperationsImpl.class);
    private final PodControllerOperationContext podControllerOperationContext;

    public JobOperationsImpl(Client client) {
        this(new PodControllerOperationContext(), HasMetadataOperationsImpl.defaultContext(client));
    }

    public JobOperationsImpl(PodControllerOperationContext context, OperationContext superContext) {
        super(superContext.withApiGroupName("batch").withApiGroupVersion("v1").withPlural("jobs"), Job.class, JobList.class);
        this.podControllerOperationContext = context;
    }

    @Override
    public JobOperationsImpl newInstance(OperationContext context) {
        return new JobOperationsImpl(this.podControllerOperationContext, context);
    }

    public Job scale(int count) {
        return this.scale(count, false);
    }

    public Scale scale() {
        return this.handleScale(null);
    }

    public Scale scale(Scale scale) {
        return this.handleScale(scale);
    }

    public Job scale(int count, boolean wait) {
        Job res = (Job)this.accept(b -> b.getSpec().setParallelism(count));
        if (wait) {
            this.waitUntilJobIsScaled();
            res = (Job)this.getMandatory();
        }
        return res;
    }

    private void waitUntilJobIsScaled() {
        AtomicReference atomicJob = new AtomicReference();
        this.waitUntilCondition(job -> {
            atomicJob.set(job);
            Integer activeJobs = job.getStatus().getActive();
            if (activeJobs == null) {
                activeJobs = 0;
            }
            if (Objects.equals(job.getSpec().getParallelism(), activeJobs)) {
                return true;
            }
            LOG.debug("Only {}/{} pods scheduled for Job: {} in namespace: {} seconds so waiting...", new Object[]{job.getStatus().getActive(), job.getSpec().getParallelism(), job.getMetadata().getName(), this.namespace});
            return false;
        }, this.getConfig().getScaleTimeout(), TimeUnit.MILLISECONDS);
    }

    public String getLog() {
        return this.getLog(false);
    }

    public String getLog(boolean isPretty) {
        StringBuilder stringBuilder = new StringBuilder();
        List<PodResource> podOperationList = this.doGetLog(false);
        for (PodResource podOperation : podOperationList) {
            stringBuilder.append(podOperation.getLog(isPretty));
        }
        return stringBuilder.toString();
    }

    private List<PodResource> doGetLog(boolean isPretty) {
        Job job = (Job)this.requireFromServer();
        return PodOperationUtil.getPodOperationsForController(this.context, job.getMetadata().getUid(), JobOperationsImpl.getJobPodLabels(job), isPretty, this.podControllerOperationContext.getLogWaitTimeout(), this.podControllerOperationContext.getContainerId());
    }

    public Reader getLogReader() {
        return PodOperationUtil.getLogReader(this.doGetLog(false));
    }

    public InputStream getLogInputStream() {
        return PodOperationUtil.getLogInputStream(this.doGetLog(false));
    }

    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    public LogWatch watchLog(OutputStream out) {
        return PodOperationUtil.watchLog(this.doGetLog(false), out);
    }

    public Loggable withLogWaitTimeout(Integer logWaitTimeout) {
        return new JobOperationsImpl(this.podControllerOperationContext.withLogWaitTimout(logWaitTimeout), this.context);
    }

    @Override
    protected Job modifyItemForReplaceOrPatch(Supplier<Job> current, Job job) {
        Job jobFromServer = current.get();
        if (job.getSpec().getSelector() == null) {
            job.getSpec().setSelector(jobFromServer.getSpec().getSelector());
        }
        if (job.getSpec().getTemplate().getMetadata() != null) {
            job.getSpec().getTemplate().getMetadata().setLabels(jobFromServer.getSpec().getTemplate().getMetadata().getLabels());
        } else {
            job.getSpec().getTemplate().setMetadata(jobFromServer.getSpec().getTemplate().getMetadata());
        }
        return job;
    }

    static Map<String, String> getJobPodLabels(Job job) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (job != null && job.getMetadata() != null && job.getMetadata().getUid() != null) {
            labels.put("controller-uid", job.getMetadata().getUid());
        }
        return labels;
    }

    public Loggable inContainer(String id) {
        return new JobOperationsImpl(this.podControllerOperationContext.withContainerId(id), this.context);
    }
}

