/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_1.dsl.internal;

import io.fabric8.kubernetes.api.model.v6_1.HasMetadata;
import io.fabric8.kubernetes.api.model.v6_1.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v6_1.LabelSelector;
import io.fabric8.kubernetes.api.model.v6_1.LabelSelectorRequirement;
import io.fabric8.kubernetes.api.model.v6_1.ObjectReference;
import io.fabric8.kubernetes.clnt.v6_1.dsl.FilterNested;
import io.fabric8.kubernetes.clnt.v6_1.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.clnt.v6_1.dsl.Resource;
import io.fabric8.kubernetes.clnt.v6_1.dsl.internal.BaseOperation;
import io.fabric8.kubernetes.clnt.v6_1.dsl.internal.OperationContext;
import io.fabric8.kubernetes.clnt.v6_1.utils.Utils;
import java.lang.reflect.Array;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class FilterNestedImpl<T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>>
implements FilterNested<FilterWatchListDeletable<T, L, R>> {
    private static final String INVOLVED_OBJECT_NAME = "involvedObject.name";
    private static final String INVOLVED_OBJECT_NAMESPACE = "involvedObject.namespace";
    private static final String INVOLVED_OBJECT_KIND = "involvedObject.kind";
    private static final String INVOLVED_OBJECT_UID = "involvedObject.uid";
    private static final String INVOLVED_OBJECT_RESOURCE_VERSION = "involvedObject.resourceVersion";
    private static final String INVOLVED_OBJECT_API_VERSION = "involvedObject.apiVersion";
    private static final String INVOLVED_OBJECT_FIELD_PATH = "involvedObject.fieldPath";
    private final BaseOperation<T, L, R> baseOperation;
    private OperationContext context;

    FilterNestedImpl(BaseOperation<T, L, R> baseOperation) {
        this.baseOperation = baseOperation;
        this.context = this.baseOperation.context;
        this.context = this.context.copy();
        this.context.labels = new LinkedHashMap<String, String>(this.baseOperation.context.getLabels());
        this.context.labelsNot = new LinkedHashMap<String, String[]>(this.baseOperation.context.getLabelsNot());
        this.context.labelsIn = new LinkedHashMap<String, String[]>(this.baseOperation.context.getLabelsIn());
        this.context.labelsNotIn = new LinkedHashMap<String, String[]>(this.baseOperation.context.getLabelsNotIn());
        this.context.fields = new LinkedHashMap<String, String>(this.baseOperation.context.getFields());
        this.context.fieldsNot = new LinkedHashMap<String, String[]>(this.baseOperation.context.getFieldsNot());
        this.context.selectorAsString = this.baseOperation.context.selectorAsString;
    }

    public FilterNested<FilterWatchListDeletable<T, L, R>> withLabels(Map<String, String> labels) {
        this.context.labels.putAll(labels);
        return this;
    }

    public FilterNested<FilterWatchListDeletable<T, L, R>> withoutLabels(Map<String, String> labels) {
        labels.forEach(this::withoutLabel);
        return this;
    }

    public FilterNested<FilterWatchListDeletable<T, L, R>> withLabelIn(String key, String ... values) {
        this.context.labelsIn.put(key, values);
        return this;
    }

    public FilterNested<FilterWatchListDeletable<T, L, R>> withLabelNotIn(String key, String ... values) {
        this.context.labelsNotIn.put(key, values);
        return this;
    }

    public FilterNested<FilterWatchListDeletable<T, L, R>> withLabel(String key, String value) {
        this.context.labels.put(key, value);
        return this;
    }

    public FilterNested<FilterWatchListDeletable<T, L, R>> withoutLabel(String key, String value) {
        this.context.labelsNot.merge(key, new String[]{value}, (oldList, newList) -> {
            String[] concatList = (String[])Array.newInstance(String.class, ((String[])oldList).length + ((String[])newList).length);
            System.arraycopy(oldList, 0, concatList, 0, ((String[])oldList).length);
            System.arraycopy(newList, 0, concatList, ((String[])oldList).length, ((String[])newList).length);
            return concatList;
        });
        return this;
    }

    public FilterNested<FilterWatchListDeletable<T, L, R>> withFields(Map<String, String> fields) {
        this.context.fields.putAll(fields);
        return this;
    }

    public FilterNested<FilterWatchListDeletable<T, L, R>> withField(String key, String value) {
        this.context.fields.put(key, value);
        return this;
    }

    public FilterNested<FilterWatchListDeletable<T, L, R>> withoutFields(Map<String, String> fields) {
        fields.forEach(this::withoutField);
        return this;
    }

    public FilterNested<FilterWatchListDeletable<T, L, R>> withoutField(String key, String value) {
        this.context.fieldsNot.merge(key, new String[]{value}, (oldList, newList) -> {
            if (Utils.isNotNullOrEmpty((String)newList[0])) {
                String[] concatList = (String[])Array.newInstance(String.class, ((String[])oldList).length + ((String[])newList).length);
                System.arraycopy(oldList, 0, concatList, 0, ((String[])oldList).length);
                System.arraycopy(newList, 0, concatList, ((String[])oldList).length, ((String[])newList).length);
                return concatList;
            }
            return oldList;
        });
        return this;
    }

    public FilterNested<FilterWatchListDeletable<T, L, R>> withLabelSelector(LabelSelector selector) {
        List<LabelSelectorRequirement> matchExpressions;
        Map<String, String> matchLabels = selector.getMatchLabels();
        if (matchLabels != null) {
            this.withLabels(matchLabels);
        }
        if ((matchExpressions = selector.getMatchExpressions()) != null) {
            block12: for (LabelSelectorRequirement req : matchExpressions) {
                String operator = req.getOperator();
                String key = req.getKey();
                switch (operator) {
                    case "In": {
                        this.withLabelIn(key, req.getValues().toArray(new String[0]));
                        continue block12;
                    }
                    case "NotIn": {
                        this.withLabelNotIn(key, req.getValues().toArray(new String[0]));
                        continue block12;
                    }
                    case "DoesNotExist": {
                        this.withoutLabel(key);
                        continue block12;
                    }
                    case "Exists": {
                        this.withLabel(key);
                        continue block12;
                    }
                }
                throw new IllegalArgumentException("Unsupported operator: " + operator);
            }
        }
        return this;
    }

    public FilterNested<FilterWatchListDeletable<T, L, R>> withInvolvedObject(ObjectReference objectReference) {
        if (objectReference.getName() != null) {
            this.context.fields.put(INVOLVED_OBJECT_NAME, objectReference.getName());
        }
        if (objectReference.getNamespace() != null) {
            this.context.fields.put(INVOLVED_OBJECT_NAMESPACE, objectReference.getNamespace());
        }
        if (objectReference.getKind() != null) {
            this.context.fields.put(INVOLVED_OBJECT_KIND, objectReference.getKind());
        }
        if (objectReference.getUid() != null) {
            this.context.fields.put(INVOLVED_OBJECT_UID, objectReference.getUid());
        }
        if (objectReference.getResourceVersion() != null) {
            this.context.fields.put(INVOLVED_OBJECT_RESOURCE_VERSION, objectReference.getResourceVersion());
        }
        if (objectReference.getApiVersion() != null) {
            this.context.fields.put(INVOLVED_OBJECT_API_VERSION, objectReference.getApiVersion());
        }
        if (objectReference.getFieldPath() != null) {
            this.context.fields.put(INVOLVED_OBJECT_FIELD_PATH, objectReference.getFieldPath());
        }
        return this;
    }

    public FilterWatchListDeletable<T, L, R> and() {
        return this.baseOperation.newInstance(this.context);
    }

    public FilterNested<FilterWatchListDeletable<T, L, R>> withLabelSelector(String selectorAsString) {
        this.context.selectorAsString = selectorAsString;
        return this;
    }
}

