/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_1.storage;

import io.fabric8.kubernetes.api.builder.v6_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v6_1.storage.StorageClass;
import io.fabric8.kubernetes.api.model.v6_1.storage.StorageClassFluent;
import io.fabric8.kubernetes.api.model.v6_1.storage.StorageClassFluentImpl;

public class StorageClassBuilder
extends StorageClassFluentImpl<StorageClassBuilder>
implements VisitableBuilder<StorageClass, StorageClassBuilder> {
    StorageClassFluent<?> fluent;
    Boolean validationEnabled;

    public StorageClassBuilder() {
        this(false);
    }

    public StorageClassBuilder(Boolean validationEnabled) {
        this(new StorageClass(), validationEnabled);
    }

    public StorageClassBuilder(StorageClassFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public StorageClassBuilder(StorageClassFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new StorageClass(), validationEnabled);
    }

    public StorageClassBuilder(StorageClassFluent<?> fluent, StorageClass instance) {
        this(fluent, instance, false);
    }

    public StorageClassBuilder(StorageClassFluent<?> fluent, StorageClass instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAllowVolumeExpansion(instance.getAllowVolumeExpansion());
        fluent.withAllowedTopologies(instance.getAllowedTopologies());
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withMountOptions(instance.getMountOptions());
        fluent.withParameters(instance.getParameters());
        fluent.withProvisioner(instance.getProvisioner());
        fluent.withReclaimPolicy(instance.getReclaimPolicy());
        fluent.withVolumeBindingMode(instance.getVolumeBindingMode());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public StorageClassBuilder(StorageClass instance) {
        this(instance, (Boolean)false);
    }

    public StorageClassBuilder(StorageClass instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAllowVolumeExpansion(instance.getAllowVolumeExpansion());
        this.withAllowedTopologies(instance.getAllowedTopologies());
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withMountOptions(instance.getMountOptions());
        this.withParameters(instance.getParameters());
        this.withProvisioner(instance.getProvisioner());
        this.withReclaimPolicy(instance.getReclaimPolicy());
        this.withVolumeBindingMode(instance.getVolumeBindingMode());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public StorageClass build() {
        StorageClass buildable = new StorageClass(this.fluent.getAllowVolumeExpansion(), this.fluent.getAllowedTopologies(), this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getMountOptions(), this.fluent.getParameters(), this.fluent.getProvisioner(), this.fluent.getReclaimPolicy(), this.fluent.getVolumeBindingMode());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

