/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_1.networking.v1;

import io.fabric8.kubernetes.api.builder.v6_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_1.Nested;
import io.fabric8.kubernetes.api.model.v6_1.networking.v1.IngressServiceBackend;
import io.fabric8.kubernetes.api.model.v6_1.networking.v1.IngressServiceBackendFluent;
import io.fabric8.kubernetes.api.model.v6_1.networking.v1.ServiceBackendPort;
import io.fabric8.kubernetes.api.model.v6_1.networking.v1.ServiceBackendPortBuilder;
import io.fabric8.kubernetes.api.model.v6_1.networking.v1.ServiceBackendPortFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class IngressServiceBackendFluentImpl<A extends IngressServiceBackendFluent<A>>
extends BaseFluent<A>
implements IngressServiceBackendFluent<A> {
    private String name;
    private ServiceBackendPortBuilder port;
    private Map<String, Object> additionalProperties;

    public IngressServiceBackendFluentImpl() {
    }

    public IngressServiceBackendFluentImpl(IngressServiceBackend instance) {
        this.withName(instance.getName());
        this.withPort(instance.getPort());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public ServiceBackendPort getPort() {
        return this.port != null ? this.port.build() : null;
    }

    @Override
    public ServiceBackendPort buildPort() {
        return this.port != null ? this.port.build() : null;
    }

    @Override
    public A withPort(ServiceBackendPort port) {
        this._visitables.get("port").remove(this.port);
        if (port != null) {
            this.port = new ServiceBackendPortBuilder(port);
            this._visitables.get("port").add(this.port);
        } else {
            this.port = null;
            this._visitables.get("port").remove(this.port);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPort() {
        return this.port != null;
    }

    @Override
    public A withNewPort(String name, Integer number) {
        return this.withPort(new ServiceBackendPort(name, number));
    }

    @Override
    public IngressServiceBackendFluent.PortNested<A> withNewPort() {
        return new PortNestedImpl();
    }

    @Override
    public IngressServiceBackendFluent.PortNested<A> withNewPortLike(ServiceBackendPort item) {
        return new PortNestedImpl(item);
    }

    @Override
    public IngressServiceBackendFluent.PortNested<A> editPort() {
        return this.withNewPortLike(this.getPort());
    }

    @Override
    public IngressServiceBackendFluent.PortNested<A> editOrNewPort() {
        return this.withNewPortLike(this.getPort() != null ? this.getPort() : new ServiceBackendPortBuilder().build());
    }

    @Override
    public IngressServiceBackendFluent.PortNested<A> editOrNewPortLike(ServiceBackendPort item) {
        return this.withNewPortLike(this.getPort() != null ? this.getPort() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngressServiceBackendFluentImpl that = (IngressServiceBackendFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.port, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class PortNestedImpl<N>
    extends ServiceBackendPortFluentImpl<IngressServiceBackendFluent.PortNested<N>>
    implements IngressServiceBackendFluent.PortNested<N>,
    Nested<N> {
        ServiceBackendPortBuilder builder;

        PortNestedImpl(ServiceBackendPort item) {
            this.builder = new ServiceBackendPortBuilder(this, item);
        }

        PortNestedImpl() {
            this.builder = new ServiceBackendPortBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressServiceBackendFluentImpl.this.withPort(this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }
}

