/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_1.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.v6_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_1.Nested;
import io.fabric8.kubernetes.api.model.v6_1.gatewayapi.v1beta1.HTTPHeaderMatch;
import io.fabric8.kubernetes.api.model.v6_1.gatewayapi.v1beta1.HTTPHeaderMatchBuilder;
import io.fabric8.kubernetes.api.model.v6_1.gatewayapi.v1beta1.HTTPHeaderMatchFluentImpl;
import io.fabric8.kubernetes.api.model.v6_1.gatewayapi.v1beta1.HTTPPathMatch;
import io.fabric8.kubernetes.api.model.v6_1.gatewayapi.v1beta1.HTTPPathMatchBuilder;
import io.fabric8.kubernetes.api.model.v6_1.gatewayapi.v1beta1.HTTPPathMatchFluentImpl;
import io.fabric8.kubernetes.api.model.v6_1.gatewayapi.v1beta1.HTTPQueryParamMatch;
import io.fabric8.kubernetes.api.model.v6_1.gatewayapi.v1beta1.HTTPQueryParamMatchBuilder;
import io.fabric8.kubernetes.api.model.v6_1.gatewayapi.v1beta1.HTTPQueryParamMatchFluentImpl;
import io.fabric8.kubernetes.api.model.v6_1.gatewayapi.v1beta1.HTTPRouteMatch;
import io.fabric8.kubernetes.api.model.v6_1.gatewayapi.v1beta1.HTTPRouteMatchFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HTTPRouteMatchFluentImpl<A extends HTTPRouteMatchFluent<A>>
extends BaseFluent<A>
implements HTTPRouteMatchFluent<A> {
    private ArrayList<HTTPHeaderMatchBuilder> headers = new ArrayList();
    private String method;
    private HTTPPathMatchBuilder path;
    private ArrayList<HTTPQueryParamMatchBuilder> queryParams = new ArrayList();
    private Map<String, Object> additionalProperties;

    public HTTPRouteMatchFluentImpl() {
    }

    public HTTPRouteMatchFluentImpl(HTTPRouteMatch instance) {
        this.withHeaders(instance.getHeaders());
        this.withMethod(instance.getMethod());
        this.withPath(instance.getPath());
        this.withQueryParams(instance.getQueryParams());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToHeaders(Integer index, HTTPHeaderMatch item) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        HTTPHeaderMatchBuilder builder = new HTTPHeaderMatchBuilder(item);
        this._visitables.get("headers").add(index >= 0 ? index.intValue() : this._visitables.get("headers").size(), builder);
        this.headers.add(index >= 0 ? index.intValue() : this.headers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToHeaders(Integer index, HTTPHeaderMatch item) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        HTTPHeaderMatchBuilder builder = new HTTPHeaderMatchBuilder(item);
        if (index < 0 || index >= this._visitables.get("headers").size()) {
            this._visitables.get("headers").add(builder);
        } else {
            this._visitables.get("headers").set(index, builder);
        }
        if (index < 0 || index >= this.headers.size()) {
            this.headers.add(builder);
        } else {
            this.headers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToHeaders(HTTPHeaderMatch ... items) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        for (HTTPHeaderMatch item : items) {
            HTTPHeaderMatchBuilder builder = new HTTPHeaderMatchBuilder(item);
            this._visitables.get("headers").add(builder);
            this.headers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToHeaders(Collection<HTTPHeaderMatch> items) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        for (HTTPHeaderMatch item : items) {
            HTTPHeaderMatchBuilder builder = new HTTPHeaderMatchBuilder(item);
            this._visitables.get("headers").add(builder);
            this.headers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromHeaders(HTTPHeaderMatch ... items) {
        for (HTTPHeaderMatch item : items) {
            HTTPHeaderMatchBuilder builder = new HTTPHeaderMatchBuilder(item);
            this._visitables.get("headers").remove(builder);
            if (this.headers == null) continue;
            this.headers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHeaders(Collection<HTTPHeaderMatch> items) {
        for (HTTPHeaderMatch item : items) {
            HTTPHeaderMatchBuilder builder = new HTTPHeaderMatchBuilder(item);
            this._visitables.get("headers").remove(builder);
            if (this.headers == null) continue;
            this.headers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromHeaders(Predicate<HTTPHeaderMatchBuilder> predicate) {
        if (this.headers == null) {
            return (A)this;
        }
        Iterator<HTTPHeaderMatchBuilder> each = this.headers.iterator();
        Object visitables = this._visitables.get("headers");
        while (each.hasNext()) {
            HTTPHeaderMatchBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<HTTPHeaderMatch> getHeaders() {
        return this.headers != null ? HTTPRouteMatchFluentImpl.build(this.headers) : null;
    }

    @Override
    public List<HTTPHeaderMatch> buildHeaders() {
        return this.headers != null ? HTTPRouteMatchFluentImpl.build(this.headers) : null;
    }

    @Override
    public HTTPHeaderMatch buildHeader(Integer index) {
        return this.headers.get(index).build();
    }

    @Override
    public HTTPHeaderMatch buildFirstHeader() {
        return this.headers.get(0).build();
    }

    @Override
    public HTTPHeaderMatch buildLastHeader() {
        return this.headers.get(this.headers.size() - 1).build();
    }

    @Override
    public HTTPHeaderMatch buildMatchingHeader(Predicate<HTTPHeaderMatchBuilder> predicate) {
        for (HTTPHeaderMatchBuilder item : this.headers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHeader(Predicate<HTTPHeaderMatchBuilder> predicate) {
        for (HTTPHeaderMatchBuilder item : this.headers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHeaders(List<HTTPHeaderMatch> headers) {
        if (this.headers != null) {
            this._visitables.get("headers").removeAll(this.headers);
        }
        if (headers != null) {
            this.headers = new ArrayList();
            for (HTTPHeaderMatch item : headers) {
                this.addToHeaders(item);
            }
        } else {
            this.headers = null;
        }
        return (A)this;
    }

    @Override
    public A withHeaders(HTTPHeaderMatch ... headers) {
        if (this.headers != null) {
            this.headers.clear();
        }
        if (headers != null) {
            for (HTTPHeaderMatch item : headers) {
                this.addToHeaders(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHeaders() {
        return this.headers != null && !this.headers.isEmpty();
    }

    @Override
    public A addNewHeader(String name, String type, String value) {
        return this.addToHeaders(new HTTPHeaderMatch(name, type, value));
    }

    @Override
    public HTTPRouteMatchFluent.HeadersNested<A> addNewHeader() {
        return new HeadersNestedImpl();
    }

    @Override
    public HTTPRouteMatchFluent.HeadersNested<A> addNewHeaderLike(HTTPHeaderMatch item) {
        return new HeadersNestedImpl(-1, item);
    }

    @Override
    public HTTPRouteMatchFluent.HeadersNested<A> setNewHeaderLike(Integer index, HTTPHeaderMatch item) {
        return new HeadersNestedImpl(index, item);
    }

    @Override
    public HTTPRouteMatchFluent.HeadersNested<A> editHeader(Integer index) {
        if (this.headers.size() <= index) {
            throw new RuntimeException("Can't edit headers. Index exceeds size.");
        }
        return this.setNewHeaderLike(index, this.buildHeader(index));
    }

    @Override
    public HTTPRouteMatchFluent.HeadersNested<A> editFirstHeader() {
        if (this.headers.size() == 0) {
            throw new RuntimeException("Can't edit first headers. The list is empty.");
        }
        return this.setNewHeaderLike(0, this.buildHeader(0));
    }

    @Override
    public HTTPRouteMatchFluent.HeadersNested<A> editLastHeader() {
        int index = this.headers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last headers. The list is empty.");
        }
        return this.setNewHeaderLike(index, this.buildHeader(index));
    }

    @Override
    public HTTPRouteMatchFluent.HeadersNested<A> editMatchingHeader(Predicate<HTTPHeaderMatchBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.headers.size(); ++i) {
            if (!predicate.test(this.headers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching headers. No match found.");
        }
        return this.setNewHeaderLike(index, this.buildHeader(index));
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public A withMethod(String method) {
        this.method = method;
        return (A)this;
    }

    @Override
    public Boolean hasMethod() {
        return this.method != null;
    }

    @Override
    @Deprecated
    public HTTPPathMatch getPath() {
        return this.path != null ? this.path.build() : null;
    }

    @Override
    public HTTPPathMatch buildPath() {
        return this.path != null ? this.path.build() : null;
    }

    @Override
    public A withPath(HTTPPathMatch path) {
        this._visitables.get("path").remove(this.path);
        if (path != null) {
            this.path = new HTTPPathMatchBuilder(path);
            this._visitables.get("path").add(this.path);
        } else {
            this.path = null;
            this._visitables.get("path").remove(this.path);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPath() {
        return this.path != null;
    }

    @Override
    public A withNewPath(String type, String value) {
        return this.withPath(new HTTPPathMatch(type, value));
    }

    @Override
    public HTTPRouteMatchFluent.PathNested<A> withNewPath() {
        return new PathNestedImpl();
    }

    @Override
    public HTTPRouteMatchFluent.PathNested<A> withNewPathLike(HTTPPathMatch item) {
        return new PathNestedImpl(item);
    }

    @Override
    public HTTPRouteMatchFluent.PathNested<A> editPath() {
        return this.withNewPathLike(this.getPath());
    }

    @Override
    public HTTPRouteMatchFluent.PathNested<A> editOrNewPath() {
        return this.withNewPathLike(this.getPath() != null ? this.getPath() : new HTTPPathMatchBuilder().build());
    }

    @Override
    public HTTPRouteMatchFluent.PathNested<A> editOrNewPathLike(HTTPPathMatch item) {
        return this.withNewPathLike(this.getPath() != null ? this.getPath() : item);
    }

    @Override
    public A addToQueryParams(Integer index, HTTPQueryParamMatch item) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList();
        }
        HTTPQueryParamMatchBuilder builder = new HTTPQueryParamMatchBuilder(item);
        this._visitables.get("queryParams").add(index >= 0 ? index.intValue() : this._visitables.get("queryParams").size(), builder);
        this.queryParams.add(index >= 0 ? index.intValue() : this.queryParams.size(), builder);
        return (A)this;
    }

    @Override
    public A setToQueryParams(Integer index, HTTPQueryParamMatch item) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList();
        }
        HTTPQueryParamMatchBuilder builder = new HTTPQueryParamMatchBuilder(item);
        if (index < 0 || index >= this._visitables.get("queryParams").size()) {
            this._visitables.get("queryParams").add(builder);
        } else {
            this._visitables.get("queryParams").set(index, builder);
        }
        if (index < 0 || index >= this.queryParams.size()) {
            this.queryParams.add(builder);
        } else {
            this.queryParams.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToQueryParams(HTTPQueryParamMatch ... items) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList();
        }
        for (HTTPQueryParamMatch item : items) {
            HTTPQueryParamMatchBuilder builder = new HTTPQueryParamMatchBuilder(item);
            this._visitables.get("queryParams").add(builder);
            this.queryParams.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToQueryParams(Collection<HTTPQueryParamMatch> items) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList();
        }
        for (HTTPQueryParamMatch item : items) {
            HTTPQueryParamMatchBuilder builder = new HTTPQueryParamMatchBuilder(item);
            this._visitables.get("queryParams").add(builder);
            this.queryParams.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromQueryParams(HTTPQueryParamMatch ... items) {
        for (HTTPQueryParamMatch item : items) {
            HTTPQueryParamMatchBuilder builder = new HTTPQueryParamMatchBuilder(item);
            this._visitables.get("queryParams").remove(builder);
            if (this.queryParams == null) continue;
            this.queryParams.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromQueryParams(Collection<HTTPQueryParamMatch> items) {
        for (HTTPQueryParamMatch item : items) {
            HTTPQueryParamMatchBuilder builder = new HTTPQueryParamMatchBuilder(item);
            this._visitables.get("queryParams").remove(builder);
            if (this.queryParams == null) continue;
            this.queryParams.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromQueryParams(Predicate<HTTPQueryParamMatchBuilder> predicate) {
        if (this.queryParams == null) {
            return (A)this;
        }
        Iterator<HTTPQueryParamMatchBuilder> each = this.queryParams.iterator();
        Object visitables = this._visitables.get("queryParams");
        while (each.hasNext()) {
            HTTPQueryParamMatchBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<HTTPQueryParamMatch> getQueryParams() {
        return this.queryParams != null ? HTTPRouteMatchFluentImpl.build(this.queryParams) : null;
    }

    @Override
    public List<HTTPQueryParamMatch> buildQueryParams() {
        return this.queryParams != null ? HTTPRouteMatchFluentImpl.build(this.queryParams) : null;
    }

    @Override
    public HTTPQueryParamMatch buildQueryParam(Integer index) {
        return this.queryParams.get(index).build();
    }

    @Override
    public HTTPQueryParamMatch buildFirstQueryParam() {
        return this.queryParams.get(0).build();
    }

    @Override
    public HTTPQueryParamMatch buildLastQueryParam() {
        return this.queryParams.get(this.queryParams.size() - 1).build();
    }

    @Override
    public HTTPQueryParamMatch buildMatchingQueryParam(Predicate<HTTPQueryParamMatchBuilder> predicate) {
        for (HTTPQueryParamMatchBuilder item : this.queryParams) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingQueryParam(Predicate<HTTPQueryParamMatchBuilder> predicate) {
        for (HTTPQueryParamMatchBuilder item : this.queryParams) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withQueryParams(List<HTTPQueryParamMatch> queryParams) {
        if (this.queryParams != null) {
            this._visitables.get("queryParams").removeAll(this.queryParams);
        }
        if (queryParams != null) {
            this.queryParams = new ArrayList();
            for (HTTPQueryParamMatch item : queryParams) {
                this.addToQueryParams(item);
            }
        } else {
            this.queryParams = null;
        }
        return (A)this;
    }

    @Override
    public A withQueryParams(HTTPQueryParamMatch ... queryParams) {
        if (this.queryParams != null) {
            this.queryParams.clear();
        }
        if (queryParams != null) {
            for (HTTPQueryParamMatch item : queryParams) {
                this.addToQueryParams(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasQueryParams() {
        return this.queryParams != null && !this.queryParams.isEmpty();
    }

    @Override
    public A addNewQueryParam(String name, String type, String value) {
        return this.addToQueryParams(new HTTPQueryParamMatch(name, type, value));
    }

    @Override
    public HTTPRouteMatchFluent.QueryParamsNested<A> addNewQueryParam() {
        return new QueryParamsNestedImpl();
    }

    @Override
    public HTTPRouteMatchFluent.QueryParamsNested<A> addNewQueryParamLike(HTTPQueryParamMatch item) {
        return new QueryParamsNestedImpl(-1, item);
    }

    @Override
    public HTTPRouteMatchFluent.QueryParamsNested<A> setNewQueryParamLike(Integer index, HTTPQueryParamMatch item) {
        return new QueryParamsNestedImpl(index, item);
    }

    @Override
    public HTTPRouteMatchFluent.QueryParamsNested<A> editQueryParam(Integer index) {
        if (this.queryParams.size() <= index) {
            throw new RuntimeException("Can't edit queryParams. Index exceeds size.");
        }
        return this.setNewQueryParamLike(index, this.buildQueryParam(index));
    }

    @Override
    public HTTPRouteMatchFluent.QueryParamsNested<A> editFirstQueryParam() {
        if (this.queryParams.size() == 0) {
            throw new RuntimeException("Can't edit first queryParams. The list is empty.");
        }
        return this.setNewQueryParamLike(0, this.buildQueryParam(0));
    }

    @Override
    public HTTPRouteMatchFluent.QueryParamsNested<A> editLastQueryParam() {
        int index = this.queryParams.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last queryParams. The list is empty.");
        }
        return this.setNewQueryParamLike(index, this.buildQueryParam(index));
    }

    @Override
    public HTTPRouteMatchFluent.QueryParamsNested<A> editMatchingQueryParam(Predicate<HTTPQueryParamMatchBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.queryParams.size(); ++i) {
            if (!predicate.test(this.queryParams.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching queryParams. No match found.");
        }
        return this.setNewQueryParamLike(index, this.buildQueryParam(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HTTPRouteMatchFluentImpl that = (HTTPRouteMatchFluentImpl)o;
        if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) {
            return false;
        }
        if (this.method != null ? !this.method.equals(that.method) : that.method != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.queryParams != null ? !this.queryParams.equals(that.queryParams) : that.queryParams != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.headers, this.method, this.path, this.queryParams, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.headers != null && !this.headers.isEmpty()) {
            sb.append("headers:");
            sb.append(this.headers + ",");
        }
        if (this.method != null) {
            sb.append("method:");
            sb.append(this.method + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.queryParams != null && !this.queryParams.isEmpty()) {
            sb.append("queryParams:");
            sb.append(this.queryParams + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class QueryParamsNestedImpl<N>
    extends HTTPQueryParamMatchFluentImpl<HTTPRouteMatchFluent.QueryParamsNested<N>>
    implements HTTPRouteMatchFluent.QueryParamsNested<N>,
    Nested<N> {
        HTTPQueryParamMatchBuilder builder;
        Integer index;

        QueryParamsNestedImpl(Integer index, HTTPQueryParamMatch item) {
            this.index = index;
            this.builder = new HTTPQueryParamMatchBuilder(this, item);
        }

        QueryParamsNestedImpl() {
            this.index = -1;
            this.builder = new HTTPQueryParamMatchBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPRouteMatchFluentImpl.this.setToQueryParams(this.index, this.builder.build());
        }

        @Override
        public N endQueryParam() {
            return this.and();
        }
    }

    class PathNestedImpl<N>
    extends HTTPPathMatchFluentImpl<HTTPRouteMatchFluent.PathNested<N>>
    implements HTTPRouteMatchFluent.PathNested<N>,
    Nested<N> {
        HTTPPathMatchBuilder builder;

        PathNestedImpl(HTTPPathMatch item) {
            this.builder = new HTTPPathMatchBuilder(this, item);
        }

        PathNestedImpl() {
            this.builder = new HTTPPathMatchBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPRouteMatchFluentImpl.this.withPath(this.builder.build());
        }

        @Override
        public N endPath() {
            return this.and();
        }
    }

    class HeadersNestedImpl<N>
    extends HTTPHeaderMatchFluentImpl<HTTPRouteMatchFluent.HeadersNested<N>>
    implements HTTPRouteMatchFluent.HeadersNested<N>,
    Nested<N> {
        HTTPHeaderMatchBuilder builder;
        Integer index;

        HeadersNestedImpl(Integer index, HTTPHeaderMatch item) {
            this.index = index;
            this.builder = new HTTPHeaderMatchBuilder(this, item);
        }

        HeadersNestedImpl() {
            this.index = -1;
            this.builder = new HTTPHeaderMatchBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPRouteMatchFluentImpl.this.setToHeaders(this.index, this.builder.build());
        }

        @Override
        public N endHeader() {
            return this.and();
        }
    }
}

