/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_1.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.v6_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_1.Nested;
import io.fabric8.kubernetes.api.model.v6_1.Condition;
import io.fabric8.kubernetes.api.model.v6_1.gatewayapi.v1alpha2.ParentReference;
import io.fabric8.kubernetes.api.model.v6_1.gatewayapi.v1alpha2.ParentReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_1.gatewayapi.v1alpha2.ParentReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.v6_1.gatewayapi.v1alpha2.RouteParentStatus;
import io.fabric8.kubernetes.api.model.v6_1.gatewayapi.v1alpha2.RouteParentStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RouteParentStatusFluentImpl<A extends RouteParentStatusFluent<A>>
extends BaseFluent<A>
implements RouteParentStatusFluent<A> {
    private List<Condition> conditions = new ArrayList<Condition>();
    private String controllerName;
    private ParentReferenceBuilder parentRef;
    private Map<String, Object> additionalProperties;

    public RouteParentStatusFluentImpl() {
    }

    public RouteParentStatusFluentImpl(RouteParentStatus instance) {
        this.withConditions(instance.getConditions());
        this.withControllerName(instance.getControllerName());
        this.withParentRef(instance.getParentRef());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(Condition ... items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Override
    public Condition getCondition(Integer index) {
        return this.conditions.get(index);
    }

    @Override
    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    @Override
    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    @Override
    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public String getControllerName() {
        return this.controllerName;
    }

    @Override
    public A withControllerName(String controllerName) {
        this.controllerName = controllerName;
        return (A)this;
    }

    @Override
    public Boolean hasControllerName() {
        return this.controllerName != null;
    }

    @Override
    @Deprecated
    public ParentReference getParentRef() {
        return this.parentRef != null ? this.parentRef.build() : null;
    }

    @Override
    public ParentReference buildParentRef() {
        return this.parentRef != null ? this.parentRef.build() : null;
    }

    @Override
    public A withParentRef(ParentReference parentRef) {
        this._visitables.get("parentRef").remove(this.parentRef);
        if (parentRef != null) {
            this.parentRef = new ParentReferenceBuilder(parentRef);
            this._visitables.get("parentRef").add(this.parentRef);
        } else {
            this.parentRef = null;
            this._visitables.get("parentRef").remove(this.parentRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasParentRef() {
        return this.parentRef != null;
    }

    @Override
    public RouteParentStatusFluent.ParentRefNested<A> withNewParentRef() {
        return new ParentRefNestedImpl();
    }

    @Override
    public RouteParentStatusFluent.ParentRefNested<A> withNewParentRefLike(ParentReference item) {
        return new ParentRefNestedImpl(item);
    }

    @Override
    public RouteParentStatusFluent.ParentRefNested<A> editParentRef() {
        return this.withNewParentRefLike(this.getParentRef());
    }

    @Override
    public RouteParentStatusFluent.ParentRefNested<A> editOrNewParentRef() {
        return this.withNewParentRefLike(this.getParentRef() != null ? this.getParentRef() : new ParentReferenceBuilder().build());
    }

    @Override
    public RouteParentStatusFluent.ParentRefNested<A> editOrNewParentRefLike(ParentReference item) {
        return this.withNewParentRefLike(this.getParentRef() != null ? this.getParentRef() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteParentStatusFluentImpl that = (RouteParentStatusFluentImpl)o;
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.controllerName != null ? !this.controllerName.equals(that.controllerName) : that.controllerName != null) {
            return false;
        }
        if (this.parentRef != null ? !this.parentRef.equals(that.parentRef) : that.parentRef != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.controllerName, this.parentRef, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.controllerName != null) {
            sb.append("controllerName:");
            sb.append(this.controllerName + ",");
        }
        if (this.parentRef != null) {
            sb.append("parentRef:");
            sb.append(this.parentRef + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ParentRefNestedImpl<N>
    extends ParentReferenceFluentImpl<RouteParentStatusFluent.ParentRefNested<N>>
    implements RouteParentStatusFluent.ParentRefNested<N>,
    Nested<N> {
        ParentReferenceBuilder builder;

        ParentRefNestedImpl(ParentReference item) {
            this.builder = new ParentReferenceBuilder(this, item);
        }

        ParentRefNestedImpl() {
            this.builder = new ParentReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)RouteParentStatusFluentImpl.this.withParentRef(this.builder.build());
        }

        @Override
        public N endParentRef() {
            return this.and();
        }
    }
}

