/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_1;

import io.fabric8.kubernetes.api.builder.v6_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v6_1.ServiceStatus;
import io.fabric8.kubernetes.api.model.v6_1.ServiceStatusFluent;
import io.fabric8.kubernetes.api.model.v6_1.ServiceStatusFluentImpl;

public class ServiceStatusBuilder
extends ServiceStatusFluentImpl<ServiceStatusBuilder>
implements VisitableBuilder<ServiceStatus, ServiceStatusBuilder> {
    ServiceStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceStatusBuilder() {
        this(false);
    }

    public ServiceStatusBuilder(Boolean validationEnabled) {
        this(new ServiceStatus(), validationEnabled);
    }

    public ServiceStatusBuilder(ServiceStatusFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ServiceStatusBuilder(ServiceStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceStatus(), validationEnabled);
    }

    public ServiceStatusBuilder(ServiceStatusFluent<?> fluent, ServiceStatus instance) {
        this(fluent, instance, false);
    }

    public ServiceStatusBuilder(ServiceStatusFluent<?> fluent, ServiceStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withConditions(instance.getConditions());
        fluent.withLoadBalancer(instance.getLoadBalancer());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ServiceStatusBuilder(ServiceStatus instance) {
        this(instance, (Boolean)false);
    }

    public ServiceStatusBuilder(ServiceStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withConditions(instance.getConditions());
        this.withLoadBalancer(instance.getLoadBalancer());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ServiceStatus build() {
        ServiceStatus buildable = new ServiceStatus(this.fluent.getConditions(), this.fluent.getLoadBalancer());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

