/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_1;

import io.fabric8.kubernetes.api.builder.v6_1.BaseFluent;
import io.fabric8.kubernetes.api.model.v6_1.Quantity;
import io.fabric8.kubernetes.api.model.v6_1.ResourceRequirements;
import io.fabric8.kubernetes.api.model.v6_1.ResourceRequirementsFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ResourceRequirementsFluentImpl<A extends ResourceRequirementsFluent<A>>
extends BaseFluent<A>
implements ResourceRequirementsFluent<A> {
    private Map<String, Quantity> limits;
    private Map<String, Quantity> requests;
    private Map<String, Object> additionalProperties;

    public ResourceRequirementsFluentImpl() {
    }

    public ResourceRequirementsFluentImpl(ResourceRequirements instance) {
        this.withLimits(instance.getLimits());
        this.withRequests(instance.getRequests());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToLimits(String key, Quantity value) {
        if (this.limits == null && key != null && value != null) {
            this.limits = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.limits.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLimits(Map<String, Quantity> map) {
        if (this.limits == null && map != null) {
            this.limits = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.limits.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLimits(String key) {
        if (this.limits == null) {
            return (A)this;
        }
        if (key != null && this.limits != null) {
            this.limits.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLimits(Map<String, Quantity> map) {
        if (this.limits == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.limits == null) continue;
                this.limits.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getLimits() {
        return this.limits;
    }

    @Override
    public <K, V> A withLimits(Map<String, Quantity> limits) {
        this.limits = limits == null ? null : new LinkedHashMap<String, Quantity>(limits);
        return (A)this;
    }

    @Override
    public Boolean hasLimits() {
        return this.limits != null;
    }

    @Override
    public A addToRequests(String key, Quantity value) {
        if (this.requests == null && key != null && value != null) {
            this.requests = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.requests.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToRequests(Map<String, Quantity> map) {
        if (this.requests == null && map != null) {
            this.requests = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.requests.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromRequests(String key) {
        if (this.requests == null) {
            return (A)this;
        }
        if (key != null && this.requests != null) {
            this.requests.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromRequests(Map<String, Quantity> map) {
        if (this.requests == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.requests == null) continue;
                this.requests.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getRequests() {
        return this.requests;
    }

    @Override
    public <K, V> A withRequests(Map<String, Quantity> requests) {
        this.requests = requests == null ? null : new LinkedHashMap<String, Quantity>(requests);
        return (A)this;
    }

    @Override
    public Boolean hasRequests() {
        return this.requests != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceRequirementsFluentImpl that = (ResourceRequirementsFluentImpl)o;
        if (this.limits != null ? !this.limits.equals(that.limits) : that.limits != null) {
            return false;
        }
        if (this.requests != null ? !this.requests.equals(that.requests) : that.requests != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.limits, this.requests, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.limits != null && !this.limits.isEmpty()) {
            sb.append("limits:");
            sb.append(this.limits + ",");
        }
        if (this.requests != null && !this.requests.isEmpty()) {
            sb.append("requests:");
            sb.append(this.requests + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

