/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.io.Serializable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
public class IntOrString
implements Serializable {
    private Object value;

    public IntOrString() {
    }

    public IntOrString(Object value) {
        if (value != null && !(value instanceof Integer) && !(value instanceof String)) {
            throw new IllegalArgumentException("Either integer or string value needs to be provided");
        }
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public Integer getIntVal() {
        if (this.value instanceof Integer) {
            return (Integer)this.value;
        }
        return null;
    }

    public String getStrVal() {
        if (this.value instanceof String) {
            return (String)this.value;
        }
        return null;
    }

    public String toString() {
        return "IntOrString(value=" + this.getValue() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntOrString)) {
            return false;
        }
        IntOrString other = (IntOrString)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IntOrString;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public static class Deserializer
    extends JsonDeserializer<IntOrString> {
        public IntOrString deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            IntOrString intOrString = node.isInt() ? new IntOrString(node.asInt()) : new IntOrString(node.asText());
            return intOrString;
        }
    }

    public static class Serializer
    extends JsonSerializer<IntOrString> {
        public void serialize(IntOrString value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (value != null) {
                Integer intValue = value.getIntVal();
                if (intValue != null) {
                    jgen.writeNumber(intValue.intValue());
                } else {
                    String stringValue = value.getStrVal();
                    if (stringValue != null) {
                        jgen.writeString(stringValue);
                    } else {
                        jgen.writeNull();
                    }
                }
            } else {
                jgen.writeNull();
            }
        }
    }
}

