/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_1;

import io.fabric8.kubernetes.api.builder.v6_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_1.Nested;
import io.fabric8.kubernetes.api.model.v6_1.CinderPersistentVolumeSource;
import io.fabric8.kubernetes.api.model.v6_1.CinderPersistentVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.v6_1.SecretReference;
import io.fabric8.kubernetes.api.model.v6_1.SecretReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_1.SecretReferenceFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class CinderPersistentVolumeSourceFluentImpl<A extends CinderPersistentVolumeSourceFluent<A>>
extends BaseFluent<A>
implements CinderPersistentVolumeSourceFluent<A> {
    private String fsType;
    private Boolean readOnly;
    private SecretReferenceBuilder secretRef;
    private String volumeID;
    private Map<String, Object> additionalProperties;

    public CinderPersistentVolumeSourceFluentImpl() {
    }

    public CinderPersistentVolumeSourceFluentImpl(CinderPersistentVolumeSource instance) {
        this.withFsType(instance.getFsType());
        this.withReadOnly(instance.getReadOnly());
        this.withSecretRef(instance.getSecretRef());
        this.withVolumeID(instance.getVolumeID());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    @Override
    public Boolean hasFsType() {
        return this.fsType != null;
    }

    @Override
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    @Deprecated
    public SecretReference getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public SecretReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(SecretReference secretRef) {
        this._visitables.get("secretRef").remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new SecretReferenceBuilder(secretRef);
            this._visitables.get("secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get("secretRef").remove(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public A withNewSecretRef(String name, String namespace) {
        return this.withSecretRef(new SecretReference(name, namespace));
    }

    @Override
    public CinderPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public CinderPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(SecretReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public CinderPersistentVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public CinderPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new SecretReferenceBuilder().build());
    }

    @Override
    public CinderPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(SecretReference item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    @Override
    public String getVolumeID() {
        return this.volumeID;
    }

    @Override
    public A withVolumeID(String volumeID) {
        this.volumeID = volumeID;
        return (A)this;
    }

    @Override
    public Boolean hasVolumeID() {
        return this.volumeID != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CinderPersistentVolumeSourceFluentImpl that = (CinderPersistentVolumeSourceFluentImpl)o;
        if (this.fsType != null ? !this.fsType.equals(that.fsType) : that.fsType != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null) {
            return false;
        }
        if (this.volumeID != null ? !this.volumeID.equals(that.volumeID) : that.volumeID != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fsType, this.readOnly, this.secretRef, this.volumeID, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fsType != null) {
            sb.append("fsType:");
            sb.append(this.fsType + ",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef + ",");
        }
        if (this.volumeID != null) {
            sb.append("volumeID:");
            sb.append(this.volumeID + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    class SecretRefNestedImpl<N>
    extends SecretReferenceFluentImpl<CinderPersistentVolumeSourceFluent.SecretRefNested<N>>
    implements CinderPersistentVolumeSourceFluent.SecretRefNested<N>,
    Nested<N> {
        SecretReferenceBuilder builder;

        SecretRefNestedImpl(SecretReference item) {
            this.builder = new SecretReferenceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new SecretReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)CinderPersistentVolumeSourceFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }
}

