/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.config.v1.Image;
import io.fabric8.openshift.api.model.config.v1.ImageFluent;
import io.fabric8.openshift.api.model.config.v1.ImageFluentImpl;

public class ImageBuilder
extends ImageFluentImpl<ImageBuilder>
implements VisitableBuilder<Image, ImageBuilder> {
    ImageFluent<?> fluent;
    Boolean validationEnabled;

    public ImageBuilder() {
        this(false);
    }

    public ImageBuilder(Boolean validationEnabled) {
        this(new Image(), validationEnabled);
    }

    public ImageBuilder(ImageFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ImageBuilder(ImageFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Image(), validationEnabled);
    }

    public ImageBuilder(ImageFluent<?> fluent, Image instance) {
        this(fluent, instance, false);
    }

    public ImageBuilder(ImageFluent<?> fluent, Image instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ImageBuilder(Image instance) {
        this(instance, (Boolean)false);
    }

    public ImageBuilder(Image instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Image build() {
        Image buildable = new Image(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

