/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.DeploymentCondition;
import io.fabric8.openshift.api.model.DeploymentConditionBuilder;
import io.fabric8.openshift.api.model.DeploymentConditionFluentImpl;
import io.fabric8.openshift.api.model.DeploymentConfigStatus;
import io.fabric8.openshift.api.model.DeploymentConfigStatusFluent;
import io.fabric8.openshift.api.model.DeploymentDetails;
import io.fabric8.openshift.api.model.DeploymentDetailsBuilder;
import io.fabric8.openshift.api.model.DeploymentDetailsFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DeploymentConfigStatusFluentImpl<A extends DeploymentConfigStatusFluent<A>>
extends BaseFluent<A>
implements DeploymentConfigStatusFluent<A> {
    private Integer availableReplicas;
    private ArrayList<DeploymentConditionBuilder> conditions = new ArrayList();
    private DeploymentDetailsBuilder details;
    private Long latestVersion;
    private Long observedGeneration;
    private Integer readyReplicas;
    private Integer replicas;
    private Integer unavailableReplicas;
    private Integer updatedReplicas;
    private Map<String, Object> additionalProperties;

    public DeploymentConfigStatusFluentImpl() {
    }

    public DeploymentConfigStatusFluentImpl(DeploymentConfigStatus instance) {
        this.withAvailableReplicas(instance.getAvailableReplicas());
        this.withConditions(instance.getConditions());
        this.withDetails(instance.getDetails());
        this.withLatestVersion(instance.getLatestVersion());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withReadyReplicas(instance.getReadyReplicas());
        this.withReplicas(instance.getReplicas());
        this.withUnavailableReplicas(instance.getUnavailableReplicas());
        this.withUpdatedReplicas(instance.getUpdatedReplicas());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Integer getAvailableReplicas() {
        return this.availableReplicas;
    }

    @Override
    public A withAvailableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasAvailableReplicas() {
        return this.availableReplicas != null;
    }

    @Override
    public A addToConditions(Integer index, DeploymentCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        DeploymentConditionBuilder builder = new DeploymentConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index.intValue() : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index.intValue() : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, DeploymentCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        DeploymentConditionBuilder builder = new DeploymentConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(DeploymentCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (DeploymentCondition item : items) {
            DeploymentConditionBuilder builder = new DeploymentConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<DeploymentCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (DeploymentCondition item : items) {
            DeploymentConditionBuilder builder = new DeploymentConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(DeploymentCondition ... items) {
        for (DeploymentCondition item : items) {
            DeploymentConditionBuilder builder = new DeploymentConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<DeploymentCondition> items) {
        for (DeploymentCondition item : items) {
            DeploymentConditionBuilder builder = new DeploymentConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<DeploymentConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<DeploymentConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            DeploymentConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<DeploymentCondition> getConditions() {
        return this.conditions != null ? DeploymentConfigStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public List<DeploymentCondition> buildConditions() {
        return this.conditions != null ? DeploymentConfigStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public DeploymentCondition buildCondition(Integer index) {
        return this.conditions.get(index).build();
    }

    @Override
    public DeploymentCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public DeploymentCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public DeploymentCondition buildMatchingCondition(Predicate<DeploymentConditionBuilder> predicate) {
        for (DeploymentConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<DeploymentConditionBuilder> predicate) {
        for (DeploymentConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<DeploymentCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (DeploymentCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(DeploymentCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (DeploymentCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public DeploymentConfigStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public DeploymentConfigStatusFluent.ConditionsNested<A> addNewConditionLike(DeploymentCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public DeploymentConfigStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index, DeploymentCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public DeploymentConfigStatusFluent.ConditionsNested<A> editCondition(Integer index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public DeploymentConfigStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public DeploymentConfigStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public DeploymentConfigStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<DeploymentConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    @Deprecated
    public DeploymentDetails getDetails() {
        return this.details != null ? this.details.build() : null;
    }

    @Override
    public DeploymentDetails buildDetails() {
        return this.details != null ? this.details.build() : null;
    }

    @Override
    public A withDetails(DeploymentDetails details) {
        this._visitables.get("details").remove(this.details);
        if (details != null) {
            this.details = new DeploymentDetailsBuilder(details);
            this._visitables.get("details").add(this.details);
        } else {
            this.details = null;
            this._visitables.get("details").remove(this.details);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDetails() {
        return this.details != null;
    }

    @Override
    public DeploymentConfigStatusFluent.DetailsNested<A> withNewDetails() {
        return new DetailsNestedImpl();
    }

    @Override
    public DeploymentConfigStatusFluent.DetailsNested<A> withNewDetailsLike(DeploymentDetails item) {
        return new DetailsNestedImpl(item);
    }

    @Override
    public DeploymentConfigStatusFluent.DetailsNested<A> editDetails() {
        return this.withNewDetailsLike(this.getDetails());
    }

    @Override
    public DeploymentConfigStatusFluent.DetailsNested<A> editOrNewDetails() {
        return this.withNewDetailsLike(this.getDetails() != null ? this.getDetails() : new DeploymentDetailsBuilder().build());
    }

    @Override
    public DeploymentConfigStatusFluent.DetailsNested<A> editOrNewDetailsLike(DeploymentDetails item) {
        return this.withNewDetailsLike(this.getDetails() != null ? this.getDetails() : item);
    }

    @Override
    public Long getLatestVersion() {
        return this.latestVersion;
    }

    @Override
    public A withLatestVersion(Long latestVersion) {
        this.latestVersion = latestVersion;
        return (A)this;
    }

    @Override
    public Boolean hasLatestVersion() {
        return this.latestVersion != null;
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    @Override
    public A withReadyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasReadyReplicas() {
        return this.readyReplicas != null;
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    public Integer getUnavailableReplicas() {
        return this.unavailableReplicas;
    }

    @Override
    public A withUnavailableReplicas(Integer unavailableReplicas) {
        this.unavailableReplicas = unavailableReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasUnavailableReplicas() {
        return this.unavailableReplicas != null;
    }

    @Override
    public Integer getUpdatedReplicas() {
        return this.updatedReplicas;
    }

    @Override
    public A withUpdatedReplicas(Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasUpdatedReplicas() {
        return this.updatedReplicas != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentConfigStatusFluentImpl that = (DeploymentConfigStatusFluentImpl)o;
        if (this.availableReplicas != null ? !this.availableReplicas.equals(that.availableReplicas) : that.availableReplicas != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.details != null ? !this.details.equals(that.details) : that.details != null) {
            return false;
        }
        if (this.latestVersion != null ? !this.latestVersion.equals(that.latestVersion) : that.latestVersion != null) {
            return false;
        }
        if (this.observedGeneration != null ? !this.observedGeneration.equals(that.observedGeneration) : that.observedGeneration != null) {
            return false;
        }
        if (this.readyReplicas != null ? !this.readyReplicas.equals(that.readyReplicas) : that.readyReplicas != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.unavailableReplicas != null ? !this.unavailableReplicas.equals(that.unavailableReplicas) : that.unavailableReplicas != null) {
            return false;
        }
        if (this.updatedReplicas != null ? !this.updatedReplicas.equals(that.updatedReplicas) : that.updatedReplicas != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.availableReplicas, this.conditions, this.details, this.latestVersion, this.observedGeneration, this.readyReplicas, this.replicas, this.unavailableReplicas, this.updatedReplicas, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.availableReplicas != null) {
            sb.append("availableReplicas:");
            sb.append(this.availableReplicas + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.details != null) {
            sb.append("details:");
            sb.append(this.details + ",");
        }
        if (this.latestVersion != null) {
            sb.append("latestVersion:");
            sb.append(this.latestVersion + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.readyReplicas != null) {
            sb.append("readyReplicas:");
            sb.append(this.readyReplicas + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.unavailableReplicas != null) {
            sb.append("unavailableReplicas:");
            sb.append(this.unavailableReplicas + ",");
        }
        if (this.updatedReplicas != null) {
            sb.append("updatedReplicas:");
            sb.append(this.updatedReplicas + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class DetailsNestedImpl<N>
    extends DeploymentDetailsFluentImpl<DeploymentConfigStatusFluent.DetailsNested<N>>
    implements DeploymentConfigStatusFluent.DetailsNested<N>,
    Nested<N> {
        DeploymentDetailsBuilder builder;

        DetailsNestedImpl(DeploymentDetails item) {
            this.builder = new DeploymentDetailsBuilder(this, item);
        }

        DetailsNestedImpl() {
            this.builder = new DeploymentDetailsBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentConfigStatusFluentImpl.this.withDetails(this.builder.build());
        }

        @Override
        public N endDetails() {
            return this.and();
        }
    }

    class ConditionsNestedImpl<N>
    extends DeploymentConditionFluentImpl<DeploymentConfigStatusFluent.ConditionsNested<N>>
    implements DeploymentConfigStatusFluent.ConditionsNested<N>,
    Nested<N> {
        DeploymentConditionBuilder builder;
        Integer index;

        ConditionsNestedImpl(Integer index, DeploymentCondition item) {
            this.index = index;
            this.builder = new DeploymentConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new DeploymentConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentConfigStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

