/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.DeleteOptions;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Preconditions;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.StatusBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v1.Scale;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollback;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.base.PatchContext;
import io.fabric8.kubernetes.client.dsl.base.PatchType;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.internal.PatchUtils;
import io.fabric8.kubernetes.client.internal.VersionUsageUtils;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.kubernetes.client.utils.internal.ExponentialBackoffIntervalCalculator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationSupport {
    public static final String JSON = "application/json";
    public static final String JSON_PATCH = "application/json-patch+json";
    public static final String STRATEGIC_MERGE_JSON_PATCH = "application/strategic-merge-patch+json";
    public static final String JSON_MERGE_PATCH = "application/merge-patch+json";
    protected static final ObjectMapper JSON_MAPPER = Serialization.jsonMapper();
    private static final Logger LOG = LoggerFactory.getLogger(OperationSupport.class);
    private static final String CLIENT_STATUS_FLAG = "CLIENT_STATUS_FLAG";
    private static final int MAX_RETRY_INTERVAL_EXPONENT = 5;
    protected OperationContext context;
    protected final HttpClient httpClient;
    protected final Config config;
    protected final String resourceT;
    protected String namespace;
    protected String name;
    protected String apiGroupName;
    protected String apiGroupVersion;
    protected boolean dryRun;
    private final ExponentialBackoffIntervalCalculator retryIntervalCalculator;
    private final int requestRetryBackoffLimit;

    public OperationSupport(Client client) {
        this(new OperationContext().withClient(client));
    }

    public OperationSupport(OperationContext ctx) {
        int requestRetryBackoffInterval;
        this.context = ctx;
        this.httpClient = ctx.getHttpClient();
        this.config = ctx.getConfig();
        this.resourceT = ctx.getPlural();
        this.namespace = ctx.getNamespace();
        this.name = ctx.getName();
        this.apiGroupName = ctx.getApiGroupName();
        this.dryRun = ctx.getDryRun();
        this.apiGroupVersion = Utils.isNotNullOrEmpty((String)ctx.getApiGroupVersion()) ? ctx.getApiGroupVersion() : (ctx.getConfig() != null && Utils.isNotNullOrEmpty((String)ctx.getConfig().getApiVersion()) ? ctx.getConfig().getApiVersion() : "v1");
        if (ctx.getConfig() != null) {
            requestRetryBackoffInterval = ctx.getConfig().getRequestRetryBackoffInterval();
            this.requestRetryBackoffLimit = ctx.getConfig().getRequestRetryBackoffLimit();
        } else {
            requestRetryBackoffInterval = Config.DEFAULT_REQUEST_RETRY_BACKOFFINTERVAL;
            this.requestRetryBackoffLimit = Config.DEFAULT_REQUEST_RETRY_BACKOFFLIMIT;
        }
        this.retryIntervalCalculator = new ExponentialBackoffIntervalCalculator(requestRetryBackoffInterval, 5);
    }

    public String getAPIGroupName() {
        return this.apiGroupName;
    }

    public String getAPIGroupVersion() {
        return this.apiGroupVersion;
    }

    public String getResourceT() {
        return this.resourceT;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public boolean isResourceNamespaced() {
        return true;
    }

    public URL getRootUrl() {
        try {
            if (!Utils.isNullOrEmpty((String)this.apiGroupName)) {
                return new URL(URLUtils.join((String[])new String[]{this.config.getMasterUrl(), "apis", this.apiGroupName, this.apiGroupVersion}));
            }
            return new URL(URLUtils.join((String[])new String[]{this.config.getMasterUrl(), "api", this.apiGroupVersion}));
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public URL getNamespacedUrl(String namespace) throws MalformedURLException {
        URL requestUrl = this.getRootUrl();
        if (this.isResourceNamespaced() && Utils.isNotNullOrEmpty((String)namespace)) {
            requestUrl = new URL(URLUtils.join((String[])new String[]{requestUrl.toString(), "namespaces", namespace}));
        }
        requestUrl = new URL(URLUtils.join((String[])new String[]{requestUrl.toString(), this.resourceT}));
        return requestUrl;
    }

    public URL getNamespacedUrl() throws MalformedURLException {
        return this.getNamespacedUrl(this.getNamespace());
    }

    public URL getResourceUrl(String namespace, String name) throws MalformedURLException {
        return this.getResourceUrl(namespace, name, false);
    }

    public URL getResourceUrl(String namespace, String name, boolean status) throws MalformedURLException {
        if (name == null) {
            if (status) {
                throw new KubernetesClientException("name not specified for an operation requiring one.");
            }
            return this.getNamespacedUrl(namespace);
        }
        if (status) {
            return new URL(URLUtils.join((String[])new String[]{this.getNamespacedUrl(namespace).toString(), name, "status"}));
        }
        return new URL(URLUtils.join((String[])new String[]{this.getNamespacedUrl(namespace).toString(), name}));
    }

    public URL getResourceUrl() throws MalformedURLException {
        if (this.name == null) {
            return this.getNamespacedUrl();
        }
        return new URL(URLUtils.join((String[])new String[]{this.getNamespacedUrl().toString(), this.name}));
    }

    public URL getResourceURLForWriteOperation(URL resourceURL) throws MalformedURLException {
        if (this.dryRun) {
            return new URL(URLUtils.join((String[])new String[]{resourceURL.toString(), "?dryRun=All"}));
        }
        return resourceURL;
    }

    public URL getResourceURLForPatchOperation(URL resourceUrl, PatchContext patchContext) throws MalformedURLException {
        if (patchContext != null) {
            String fieldManager;
            String url = resourceUrl.toString();
            if (patchContext.getForce() != null) {
                url = URLUtils.join((String[])new String[]{url, "?force=" + patchContext.getForce()});
            }
            if (patchContext.getDryRun() != null && !patchContext.getDryRun().isEmpty() || this.dryRun) {
                url = URLUtils.join((String[])new String[]{url, "?dryRun=All"});
            }
            if ((fieldManager = patchContext.getFieldManager()) == null && patchContext.getPatchType() == PatchType.SERVER_SIDE_APPLY) {
                fieldManager = "fabric8";
            }
            if (fieldManager != null) {
                url = URLUtils.join((String[])new String[]{url, "?fieldManager=" + fieldManager});
            }
            if (patchContext.getFieldValidation() != null) {
                url = URLUtils.join((String[])new String[]{url, "?fieldValidation=" + patchContext.getFieldValidation()});
            }
            return new URL(url);
        }
        return resourceUrl;
    }

    protected <T> T correctNamespace(T item) {
        if (!this.isResourceNamespaced() || this.context.isDefaultNamespace() || !(item instanceof HasMetadata)) {
            return item;
        }
        String itemNs = KubernetesResourceUtil.getNamespace((HasMetadata)((HasMetadata)item));
        if (Utils.isNotNullOrEmpty((String)this.namespace) && Utils.isNotNullOrEmpty((String)itemNs) && !this.namespace.equals(itemNs)) {
            item = Serialization.clone(item);
            KubernetesResourceUtil.setNamespace((HasMetadata)((HasMetadata)item), (String)this.namespace);
        }
        return item;
    }

    protected <T> String checkNamespace(T item) {
        String itemNs;
        if (!this.isResourceNamespaced()) {
            return null;
        }
        String operationNs = this.getNamespace();
        String string = itemNs = item instanceof HasMetadata ? KubernetesResourceUtil.getNamespace((HasMetadata)((HasMetadata)item)) : null;
        if (Utils.isNullOrEmpty((String)operationNs) && Utils.isNullOrEmpty((String)itemNs)) {
            if (this.context.isDefaultNamespace()) {
                throw new KubernetesClientException("namespace not specified for an operation requiring one and no default was found in the Config.");
            }
            throw new KubernetesClientException("namespace not specified for an operation requiring one.");
        }
        if (!Utils.isNullOrEmpty((String)itemNs) && (Utils.isNullOrEmpty((String)operationNs) || this.context.isDefaultNamespace())) {
            return itemNs;
        }
        return operationNs;
    }

    protected <T> String checkName(T item) {
        String itemName;
        String operationName = this.getName();
        ObjectMeta metadata = item instanceof HasMetadata ? ((HasMetadata)item).getMetadata() : null;
        String string = itemName = metadata != null ? metadata.getName() : null;
        if (Utils.isNullOrEmpty((String)operationName) && Utils.isNullOrEmpty((String)itemName)) {
            return null;
        }
        if (Utils.isNullOrEmpty((String)itemName)) {
            return operationName;
        }
        if (Utils.isNullOrEmpty((String)operationName)) {
            return itemName;
        }
        if (Objects.equals(itemName, operationName)) {
            return itemName;
        }
        throw new KubernetesClientException("Name mismatch. Item name:" + itemName + ". Operation name:" + operationName + ".");
    }

    protected <T> T handleMetric(String resourceUrl, Class<T> type) throws InterruptedException, IOException {
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().uri(resourceUrl);
        return this.handleResponse(requestBuilder, type);
    }

    protected KubernetesResource handleDelete(URL requestUrl, long gracePeriodSeconds, DeletionPropagation propagationPolicy, String resourceVersion) throws InterruptedException, IOException {
        DeleteOptions deleteOptions = new DeleteOptions();
        if (gracePeriodSeconds >= 0L) {
            deleteOptions.setGracePeriodSeconds(gracePeriodSeconds);
        }
        if (resourceVersion != null) {
            deleteOptions.setPreconditions(new Preconditions(resourceVersion, null));
        }
        if (propagationPolicy != null) {
            deleteOptions.setPropagationPolicy(propagationPolicy.toString());
        }
        if (this.dryRun) {
            deleteOptions.setDryRun(Collections.singletonList("All"));
        }
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().delete(JSON, JSON_MAPPER.writeValueAsString((Object)deleteOptions)).url(requestUrl);
        return this.handleResponse(requestBuilder, KubernetesResource.class);
    }

    protected <T, I> T handleCreate(I resource, Class<T> outputType) throws InterruptedException, IOException {
        resource = this.correctNamespace(resource);
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().post(JSON, JSON_MAPPER.writeValueAsString(resource)).url(this.getResourceURLForWriteOperation(this.getResourceUrl(this.checkNamespace(resource), null)));
        return this.handleResponse(requestBuilder, outputType);
    }

    protected <T> T handleUpdate(T updated, Class<T> type, boolean status) throws IOException {
        updated = this.correctNamespace(updated);
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().put(JSON, JSON_MAPPER.writeValueAsString(updated)).url(this.getResourceURLForWriteOperation(this.getResourceUrl(this.checkNamespace(updated), this.checkName(updated), status)));
        return this.handleResponse(requestBuilder, type, this.getParameters());
    }

    protected <T> T handlePatch(PatchContext patchContext, T current, T updated, Class<T> type, boolean status) throws InterruptedException, IOException {
        String patchForUpdate;
        if (current != null && (patchContext == null || patchContext.getPatchType() == PatchType.JSON)) {
            patchForUpdate = PatchUtils.jsonDiff(current, updated, false);
            if (patchContext == null) {
                patchContext = new PatchContext.Builder().withPatchType(PatchType.JSON).build();
            }
        } else {
            ObjectMeta meta;
            if (patchContext != null && patchContext.getPatchType() == PatchType.SERVER_SIDE_APPLY && updated instanceof HasMetadata && (meta = ((HasMetadata)updated).getMetadata()) != null && meta.getManagedFields() != null && !meta.getManagedFields().isEmpty()) {
                meta.setManagedFields(null);
            }
            patchForUpdate = Serialization.asJson(updated);
            current = updated;
        }
        return this.handlePatch(patchContext, current, patchForUpdate, type, status);
    }

    protected <T> T handlePatch(PatchContext patchContext, T current, String patchForUpdate, Class<T> type, boolean status) throws InterruptedException, IOException {
        String bodyContentType = this.getContentTypeFromPatchContextOrDefault(patchContext);
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().patch(bodyContentType, patchForUpdate).url(this.getResourceURLForPatchOperation(this.getResourceUrl(this.checkNamespace(current), this.checkName(current), status), patchContext));
        return this.handleResponse(requestBuilder, type);
    }

    protected Scale handleScale(String resourceUrl, Scale scale) throws InterruptedException, IOException {
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().uri(resourceUrl + "/scale");
        if (scale != null) {
            requestBuilder.put(JSON, JSON_MAPPER.writeValueAsString((Object)scale));
        }
        return this.handleResponse(requestBuilder, Scale.class);
    }

    protected Status handleDeploymentRollback(String resourceUrl, DeploymentRollback deploymentRollback) throws InterruptedException, IOException {
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().uri(resourceUrl + "/rollback").post(JSON, JSON_MAPPER.writeValueAsString((Object)deploymentRollback));
        return this.handleResponse(requestBuilder, Status.class);
    }

    protected <T> T handleGet(URL resourceUrl, Class<T> type) throws InterruptedException, IOException {
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().url(resourceUrl);
        return this.handleResponse(requestBuilder, type, this.getParameters());
    }

    protected Map<String, String> getParameters() {
        return Collections.emptyMap();
    }

    protected <T extends HasMetadata> T handleApproveOrDeny(T csr, Class<T> type) throws IOException, InterruptedException {
        String uri = URLUtils.join((String[])new String[]{this.getResourceUrl(null, csr.getMetadata().getName(), false).toString(), "approval"});
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().put(JSON, JSON_MAPPER.writeValueAsString(csr)).uri(uri);
        return (T)((HasMetadata)this.handleResponse(requestBuilder, type));
    }

    protected <T> T handleRawGet(URL resourceUrl, Class<T> type) throws IOException {
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().url(resourceUrl);
        HttpRequest request = requestBuilder.build();
        HttpResponse response = (HttpResponse)this.waitForResult(this.httpClient.sendAsync(request, type));
        this.assertResponseCode(request, response);
        return (T)response.body();
    }

    protected <T> T waitForResult(CompletableFuture<T> future) throws IOException {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            InterruptedIOException ie = new InterruptedIOException();
            ie.initCause(e);
            throw ie;
        }
        catch (ExecutionException e) {
            Throwable t = e;
            if (e.getCause() != null) {
                t = e.getCause();
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            InterruptedIOException ie = new InterruptedIOException();
            ie.initCause(e);
            throw ie;
        }
    }

    protected <T> T handleResponse(HttpRequest.Builder requestBuilder, Class<T> type) throws InterruptedException, IOException {
        return this.handleResponse(requestBuilder, type, this.getParameters());
    }

    private <T> T handleResponse(HttpRequest.Builder requestBuilder, Class<T> type, Map<String, String> parameters) throws IOException {
        return this.waitForResult(this.handleResponse(this.httpClient, requestBuilder, type, parameters));
    }

    protected <T> CompletableFuture<T> handleResponse(HttpClient client, HttpRequest.Builder requestBuilder, Class<T> type, Map<String, String> parameters) {
        VersionUsageUtils.log(this.resourceT, this.apiGroupVersion);
        HttpRequest request = requestBuilder.build();
        CompletableFuture<HttpResponse<byte[]>> futureResponse = new CompletableFuture<HttpResponse<byte[]>>();
        this.retryWithExponentialBackoff(futureResponse, new AtomicInteger(), (HttpClient)Utils.getNonNullOrElse((Object)client, (Object)this.httpClient), request);
        return futureResponse.thenApply(response -> {
            try {
                this.assertResponseCode(request, (HttpResponse<?>)response);
                if (type != null) {
                    return Serialization.unmarshal((InputStream)new ByteArrayInputStream((byte[])response.body()), (Class)type, (Map)parameters);
                }
                return null;
            }
            catch (KubernetesClientException e) {
                throw e;
            }
            catch (Exception e) {
                throw OperationSupport.requestException(request, e);
            }
        });
    }

    protected void retryWithExponentialBackoff(CompletableFuture<HttpResponse<byte[]>> result, AtomicInteger numRetries, HttpClient client, HttpRequest request) {
        client.sendAsync(request, byte[].class).whenComplete((response, throwable) -> {
            int retries = numRetries.getAndIncrement();
            if (retries < this.requestRetryBackoffLimit) {
                long retryInterval = this.retryIntervalCalculator.getInterval(retries);
                boolean retry = false;
                if (response != null && response.code() >= 500) {
                    LOG.debug("HTTP operation on url: {} should be retried as the response code was {}, retrying after {} millis", new Object[]{request.uri(), response.code(), retryInterval});
                    retry = true;
                } else if (throwable instanceof IOException) {
                    LOG.debug(String.format("HTTP operation on url: %s should be retried after %d millis because of IOException", request.uri(), retryInterval), throwable);
                    retry = true;
                }
                if (retry) {
                    Utils.schedule((Executor)this.context.getExecutor(), () -> this.retryWithExponentialBackoff(result, numRetries, client, request), (long)retryInterval, (TimeUnit)TimeUnit.MILLISECONDS);
                    return;
                }
            }
            if (throwable != null) {
                result.completeExceptionally((Throwable)throwable);
            } else {
                result.complete((HttpResponse<byte[]>)response);
            }
        });
    }

    protected void assertResponseCode(HttpRequest request, HttpResponse<?> response) {
        if (response.isSuccessful()) {
            return;
        }
        int statusCode = response.code();
        String customMessage = (String)this.config.getErrorMessages().get(statusCode);
        if (customMessage != null) {
            throw OperationSupport.requestFailure(request, OperationSupport.createStatus(statusCode, this.combineMessages(customMessage, OperationSupport.createStatus(response))));
        }
        throw OperationSupport.requestFailure(request, OperationSupport.createStatus(response));
    }

    private String combineMessages(String customMessage, Status defaultStatus) {
        String message;
        if (defaultStatus != null && (message = defaultStatus.getMessage()) != null && message.length() > 0) {
            return customMessage + " " + message;
        }
        return customMessage;
    }

    public static Status createStatus(HttpResponse<?> response) {
        int statusCode;
        String statusMessage = "";
        int n = statusCode = response != null ? response.code() : 0;
        if (response == null) {
            statusMessage = "No response";
        } else {
            try {
                String bodyString = response.bodyString();
                if (Utils.isNotNullOrEmpty((String)bodyString)) {
                    Status status = (Status)JSON_MAPPER.readValue(bodyString, Status.class);
                    if (status.getCode() == null) {
                        status = ((StatusBuilder)new StatusBuilder(status).withCode(statusCode)).build();
                    }
                    return status;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (response.message() != null) {
                statusMessage = response.message();
            }
        }
        return OperationSupport.createStatus(statusCode, statusMessage);
    }

    public static Status createStatus(int statusCode, String message) {
        Status status = ((StatusBuilder)((StatusBuilder)new StatusBuilder().withCode(statusCode)).withMessage(message)).build();
        status.getAdditionalProperties().put(CLIENT_STATUS_FLAG, "true");
        return status;
    }

    public static KubernetesClientException requestFailure(HttpRequest request, Status status) {
        return OperationSupport.requestFailure(request, status, null);
    }

    public static KubernetesClientException requestFailure(HttpRequest request, Status status, String message) {
        StringBuilder sb = new StringBuilder();
        if (message != null && !message.isEmpty()) {
            sb.append(message).append(". ");
        }
        sb.append("Failure executing: ").append(request.method()).append(" at: ").append(request.uri()).append(".");
        if (status.getMessage() != null && !status.getMessage().isEmpty()) {
            sb.append(" Message: ").append(status.getMessage()).append(".");
        }
        if (!status.getAdditionalProperties().containsKey(CLIENT_STATUS_FLAG)) {
            sb.append(" Received status: ").append(status).append(".");
        }
        RequestMetadata metadata = RequestMetadata.from(request);
        return new KubernetesClientException(sb.toString(), status.getCode().intValue(), status, metadata.group, metadata.version, metadata.plural, metadata.namespace);
    }

    public static KubernetesClientException requestException(HttpRequest request, Throwable e, String message) {
        StringBuilder sb = new StringBuilder();
        if (message != null && !message.isEmpty()) {
            sb.append(message).append(". ");
        }
        sb.append("Error executing: ").append(request.method()).append(" at: ").append(request.uri()).append(". Cause: ").append(e.getMessage());
        RequestMetadata metadata = RequestMetadata.from(request);
        return new KubernetesClientException(sb.toString(), e, metadata.group, metadata.version, metadata.plural, metadata.namespace);
    }

    public static KubernetesClientException requestException(HttpRequest request, Exception e) {
        return OperationSupport.requestException(request, e, null);
    }

    protected static <T> T unmarshal(InputStream is) {
        return (T)Serialization.unmarshal((InputStream)is);
    }

    protected static <T> T unmarshal(InputStream is, Class<T> type) {
        return (T)Serialization.unmarshal((InputStream)is, type);
    }

    protected static <T> T unmarshal(InputStream is, TypeReference<T> type) {
        return (T)Serialization.unmarshal((InputStream)is, type);
    }

    protected static <T> Map<String, Object> getObjectValueAsMap(T object) {
        return (Map)JSON_MAPPER.convertValue(object, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public Config getConfig() {
        return this.config;
    }

    private String getContentTypeFromPatchContextOrDefault(PatchContext patchContext) {
        if (patchContext != null && patchContext.getPatchType() != null) {
            return patchContext.getPatchType().getContentType();
        }
        return STRATEGIC_MERGE_JSON_PATCH;
    }

    public <R1> R1 restCall(Class<R1> result, String ... path) {
        try {
            URL requestUrl = new URL(this.config.getMasterUrl());
            String url = requestUrl.toString();
            if (path != null && path.length > 0) {
                url = URLUtils.join((String[])new String[]{url, URLUtils.pathJoin((String[])path)});
            }
            HttpRequest.Builder req = this.httpClient.newHttpRequestBuilder().uri(url);
            return this.handleResponse(req, result);
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return null;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable((Throwable)ie);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    private static class RequestMetadata {
        private final String group;
        private final String version;
        private final String plural;
        private final String namespace;
        private static final RequestMetadata EMPTY = new RequestMetadata(null, null, null, null);

        private RequestMetadata(String group, String version, String plural, String namespace) {
            this.group = group;
            this.version = version;
            this.plural = plural;
            this.namespace = namespace;
        }

        static RequestMetadata from(HttpRequest request) {
            List<String> segments = Arrays.asList(request.uri().getRawPath().split("\\/"));
            switch (segments.size()) {
                case 4: {
                    return new RequestMetadata(segments.get(1), segments.get(2), segments.get(3), null);
                }
                case 6: {
                    return new RequestMetadata(segments.get(1), segments.get(2), segments.get(5), segments.get(4));
                }
            }
            return EMPTY;
        }
    }
}

