/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.network.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.EgressRouterAddress;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.EgressRouterAddressBuilder;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.EgressRouterAddressFluentImpl;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.EgressRouterInterface;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.EgressRouterInterfaceBuilder;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.EgressRouterInterfaceFluentImpl;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.EgressRouterSpec;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.EgressRouterSpecFluent;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.RedirectConfig;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.RedirectConfigBuilder;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.RedirectConfigFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class EgressRouterSpecFluentImpl<A extends EgressRouterSpecFluent<A>>
extends BaseFluent<A>
implements EgressRouterSpecFluent<A> {
    private ArrayList<EgressRouterAddressBuilder> addresses = new ArrayList();
    private String mode;
    private EgressRouterInterfaceBuilder networkInterface;
    private RedirectConfigBuilder redirect;
    private Map<String, Object> additionalProperties;

    public EgressRouterSpecFluentImpl() {
    }

    public EgressRouterSpecFluentImpl(EgressRouterSpec instance) {
        this.withAddresses(instance.getAddresses());
        this.withMode(instance.getMode());
        this.withNetworkInterface(instance.getNetworkInterface());
        this.withRedirect(instance.getRedirect());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToAddresses(Integer index, EgressRouterAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        EgressRouterAddressBuilder builder = new EgressRouterAddressBuilder(item);
        this._visitables.get("addresses").add(index >= 0 ? index.intValue() : this._visitables.get("addresses").size(), builder);
        this.addresses.add(index >= 0 ? index.intValue() : this.addresses.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAddresses(Integer index, EgressRouterAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        EgressRouterAddressBuilder builder = new EgressRouterAddressBuilder(item);
        if (index < 0 || index >= this._visitables.get("addresses").size()) {
            this._visitables.get("addresses").add(builder);
        } else {
            this._visitables.get("addresses").set(index, builder);
        }
        if (index < 0 || index >= this.addresses.size()) {
            this.addresses.add(builder);
        } else {
            this.addresses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAddresses(EgressRouterAddress ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (EgressRouterAddress item : items) {
            EgressRouterAddressBuilder builder = new EgressRouterAddressBuilder(item);
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAddresses(Collection<EgressRouterAddress> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (EgressRouterAddress item : items) {
            EgressRouterAddressBuilder builder = new EgressRouterAddressBuilder(item);
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAddresses(EgressRouterAddress ... items) {
        for (EgressRouterAddress item : items) {
            EgressRouterAddressBuilder builder = new EgressRouterAddressBuilder(item);
            this._visitables.get("addresses").remove(builder);
            if (this.addresses == null) continue;
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAddresses(Collection<EgressRouterAddress> items) {
        for (EgressRouterAddress item : items) {
            EgressRouterAddressBuilder builder = new EgressRouterAddressBuilder(item);
            this._visitables.get("addresses").remove(builder);
            if (this.addresses == null) continue;
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAddresses(Predicate<EgressRouterAddressBuilder> predicate) {
        if (this.addresses == null) {
            return (A)this;
        }
        Iterator<EgressRouterAddressBuilder> each = this.addresses.iterator();
        Object visitables = this._visitables.get("addresses");
        while (each.hasNext()) {
            EgressRouterAddressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<EgressRouterAddress> getAddresses() {
        return this.addresses != null ? EgressRouterSpecFluentImpl.build(this.addresses) : null;
    }

    @Override
    public List<EgressRouterAddress> buildAddresses() {
        return this.addresses != null ? EgressRouterSpecFluentImpl.build(this.addresses) : null;
    }

    @Override
    public EgressRouterAddress buildAddress(Integer index) {
        return this.addresses.get(index).build();
    }

    @Override
    public EgressRouterAddress buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    @Override
    public EgressRouterAddress buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    @Override
    public EgressRouterAddress buildMatchingAddress(Predicate<EgressRouterAddressBuilder> predicate) {
        for (EgressRouterAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAddress(Predicate<EgressRouterAddressBuilder> predicate) {
        for (EgressRouterAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAddresses(List<EgressRouterAddress> addresses) {
        if (this.addresses != null) {
            this._visitables.get("addresses").removeAll(this.addresses);
        }
        if (addresses != null) {
            this.addresses = new ArrayList();
            for (EgressRouterAddress item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)this;
    }

    @Override
    public A withAddresses(EgressRouterAddress ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
        }
        if (addresses != null) {
            for (EgressRouterAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    @Override
    public A addNewAddress(String gateway, String ip) {
        return this.addToAddresses(new EgressRouterAddress(gateway, ip));
    }

    @Override
    public EgressRouterSpecFluent.AddressesNested<A> addNewAddress() {
        return new AddressesNestedImpl();
    }

    @Override
    public EgressRouterSpecFluent.AddressesNested<A> addNewAddressLike(EgressRouterAddress item) {
        return new AddressesNestedImpl(-1, item);
    }

    @Override
    public EgressRouterSpecFluent.AddressesNested<A> setNewAddressLike(Integer index, EgressRouterAddress item) {
        return new AddressesNestedImpl(index, item);
    }

    @Override
    public EgressRouterSpecFluent.AddressesNested<A> editAddress(Integer index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException("Can't edit addresses. Index exceeds size.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public EgressRouterSpecFluent.AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException("Can't edit first addresses. The list is empty.");
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    @Override
    public EgressRouterSpecFluent.AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last addresses. The list is empty.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public EgressRouterSpecFluent.AddressesNested<A> editMatchingAddress(Predicate<EgressRouterAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.test(this.addresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching addresses. No match found.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    @Override
    public A withMode(String mode) {
        this.mode = mode;
        return (A)this;
    }

    @Override
    public Boolean hasMode() {
        return this.mode != null;
    }

    @Override
    @Deprecated
    public EgressRouterInterface getNetworkInterface() {
        return this.networkInterface != null ? this.networkInterface.build() : null;
    }

    @Override
    public EgressRouterInterface buildNetworkInterface() {
        return this.networkInterface != null ? this.networkInterface.build() : null;
    }

    @Override
    public A withNetworkInterface(EgressRouterInterface networkInterface) {
        this._visitables.get("networkInterface").remove(this.networkInterface);
        if (networkInterface != null) {
            this.networkInterface = new EgressRouterInterfaceBuilder(networkInterface);
            this._visitables.get("networkInterface").add(this.networkInterface);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNetworkInterface() {
        return this.networkInterface != null;
    }

    @Override
    public EgressRouterSpecFluent.NetworkInterfaceNested<A> withNewNetworkInterface() {
        return new NetworkInterfaceNestedImpl();
    }

    @Override
    public EgressRouterSpecFluent.NetworkInterfaceNested<A> withNewNetworkInterfaceLike(EgressRouterInterface item) {
        return new NetworkInterfaceNestedImpl(item);
    }

    @Override
    public EgressRouterSpecFluent.NetworkInterfaceNested<A> editNetworkInterface() {
        return this.withNewNetworkInterfaceLike(this.getNetworkInterface());
    }

    @Override
    public EgressRouterSpecFluent.NetworkInterfaceNested<A> editOrNewNetworkInterface() {
        return this.withNewNetworkInterfaceLike(this.getNetworkInterface() != null ? this.getNetworkInterface() : new EgressRouterInterfaceBuilder().build());
    }

    @Override
    public EgressRouterSpecFluent.NetworkInterfaceNested<A> editOrNewNetworkInterfaceLike(EgressRouterInterface item) {
        return this.withNewNetworkInterfaceLike(this.getNetworkInterface() != null ? this.getNetworkInterface() : item);
    }

    @Override
    @Deprecated
    public RedirectConfig getRedirect() {
        return this.redirect != null ? this.redirect.build() : null;
    }

    @Override
    public RedirectConfig buildRedirect() {
        return this.redirect != null ? this.redirect.build() : null;
    }

    @Override
    public A withRedirect(RedirectConfig redirect) {
        this._visitables.get("redirect").remove(this.redirect);
        if (redirect != null) {
            this.redirect = new RedirectConfigBuilder(redirect);
            this._visitables.get("redirect").add(this.redirect);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRedirect() {
        return this.redirect != null;
    }

    @Override
    public EgressRouterSpecFluent.RedirectNested<A> withNewRedirect() {
        return new RedirectNestedImpl();
    }

    @Override
    public EgressRouterSpecFluent.RedirectNested<A> withNewRedirectLike(RedirectConfig item) {
        return new RedirectNestedImpl(item);
    }

    @Override
    public EgressRouterSpecFluent.RedirectNested<A> editRedirect() {
        return this.withNewRedirectLike(this.getRedirect());
    }

    @Override
    public EgressRouterSpecFluent.RedirectNested<A> editOrNewRedirect() {
        return this.withNewRedirectLike(this.getRedirect() != null ? this.getRedirect() : new RedirectConfigBuilder().build());
    }

    @Override
    public EgressRouterSpecFluent.RedirectNested<A> editOrNewRedirectLike(RedirectConfig item) {
        return this.withNewRedirectLike(this.getRedirect() != null ? this.getRedirect() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EgressRouterSpecFluentImpl that = (EgressRouterSpecFluentImpl)o;
        if (this.addresses != null ? !this.addresses.equals(that.addresses) : that.addresses != null) {
            return false;
        }
        if (this.mode != null ? !this.mode.equals(that.mode) : that.mode != null) {
            return false;
        }
        if (this.networkInterface != null ? !this.networkInterface.equals(that.networkInterface) : that.networkInterface != null) {
            return false;
        }
        if (this.redirect != null ? !this.redirect.equals(that.redirect) : that.redirect != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.addresses, this.mode, this.networkInterface, this.redirect, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(this.addresses + ",");
        }
        if (this.mode != null) {
            sb.append("mode:");
            sb.append(this.mode + ",");
        }
        if (this.networkInterface != null) {
            sb.append("networkInterface:");
            sb.append(this.networkInterface + ",");
        }
        if (this.redirect != null) {
            sb.append("redirect:");
            sb.append(this.redirect + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class RedirectNestedImpl<N>
    extends RedirectConfigFluentImpl<EgressRouterSpecFluent.RedirectNested<N>>
    implements EgressRouterSpecFluent.RedirectNested<N>,
    Nested<N> {
        RedirectConfigBuilder builder;

        RedirectNestedImpl(RedirectConfig item) {
            this.builder = new RedirectConfigBuilder(this, item);
        }

        RedirectNestedImpl() {
            this.builder = new RedirectConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)EgressRouterSpecFluentImpl.this.withRedirect(this.builder.build());
        }

        @Override
        public N endRedirect() {
            return this.and();
        }
    }

    class NetworkInterfaceNestedImpl<N>
    extends EgressRouterInterfaceFluentImpl<EgressRouterSpecFluent.NetworkInterfaceNested<N>>
    implements EgressRouterSpecFluent.NetworkInterfaceNested<N>,
    Nested<N> {
        EgressRouterInterfaceBuilder builder;

        NetworkInterfaceNestedImpl(EgressRouterInterface item) {
            this.builder = new EgressRouterInterfaceBuilder(this, item);
        }

        NetworkInterfaceNestedImpl() {
            this.builder = new EgressRouterInterfaceBuilder(this);
        }

        @Override
        public N and() {
            return (N)EgressRouterSpecFluentImpl.this.withNetworkInterface(this.builder.build());
        }

        @Override
        public N endNetworkInterface() {
            return this.and();
        }
    }

    class AddressesNestedImpl<N>
    extends EgressRouterAddressFluentImpl<EgressRouterSpecFluent.AddressesNested<N>>
    implements EgressRouterSpecFluent.AddressesNested<N>,
    Nested<N> {
        EgressRouterAddressBuilder builder;
        Integer index;

        AddressesNestedImpl(Integer index, EgressRouterAddress item) {
            this.index = index;
            this.builder = new EgressRouterAddressBuilder(this, item);
        }

        AddressesNestedImpl() {
            this.index = -1;
            this.builder = new EgressRouterAddressBuilder(this);
        }

        @Override
        public N and() {
            return (N)EgressRouterSpecFluentImpl.this.setToAddresses(this.index, this.builder.build());
        }

        @Override
        public N endAddress() {
            return this.and();
        }
    }
}

