/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.alibabacloud.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.alibabacloud.v1.MachinePool;
import io.fabric8.openshift.api.model.installer.alibabacloud.v1.MachinePoolBuilder;
import io.fabric8.openshift.api.model.installer.alibabacloud.v1.MachinePoolFluentImpl;
import io.fabric8.openshift.api.model.installer.alibabacloud.v1.Platform;
import io.fabric8.openshift.api.model.installer.alibabacloud.v1.PlatformFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PlatformFluentImpl<A extends PlatformFluent<A>>
extends BaseFluent<A>
implements PlatformFluent<A> {
    private MachinePoolBuilder defaultMachinePlatform;
    private String privateZoneID;
    private String region;
    private String resourceGroupID;
    private Map<String, String> tags;
    private String vpcID;
    private List<String> vswitchIDs = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public PlatformFluentImpl() {
    }

    public PlatformFluentImpl(Platform instance) {
        this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
        this.withPrivateZoneID(instance.getPrivateZoneID());
        this.withRegion(instance.getRegion());
        this.withResourceGroupID(instance.getResourceGroupID());
        this.withTags(instance.getTags());
        this.withVpcID(instance.getVpcID());
        this.withVswitchIDs(instance.getVswitchIDs());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public MachinePool getDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    @Override
    public MachinePool buildDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    @Override
    public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
        this._visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
        if (defaultMachinePlatform != null) {
            this.defaultMachinePlatform = new MachinePoolBuilder(defaultMachinePlatform);
            this._visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null;
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
        return new DefaultMachinePlatformNestedImpl();
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
        return new DefaultMachinePlatformNestedImpl(item);
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform());
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform() != null ? this.getDefaultMachinePlatform() : new MachinePoolBuilder().build());
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform() != null ? this.getDefaultMachinePlatform() : item);
    }

    @Override
    public String getPrivateZoneID() {
        return this.privateZoneID;
    }

    @Override
    public A withPrivateZoneID(String privateZoneID) {
        this.privateZoneID = privateZoneID;
        return (A)this;
    }

    @Override
    public Boolean hasPrivateZoneID() {
        return this.privateZoneID != null;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    @Override
    public Boolean hasRegion() {
        return this.region != null;
    }

    @Override
    public String getResourceGroupID() {
        return this.resourceGroupID;
    }

    @Override
    public A withResourceGroupID(String resourceGroupID) {
        this.resourceGroupID = resourceGroupID;
        return (A)this;
    }

    @Override
    public Boolean hasResourceGroupID() {
        return this.resourceGroupID != null;
    }

    @Override
    public A addToTags(String key, String value) {
        if (this.tags == null && key != null && value != null) {
            this.tags = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.tags.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToTags(Map<String, String> map) {
        if (this.tags == null && map != null) {
            this.tags = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.tags.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromTags(String key) {
        if (this.tags == null) {
            return (A)this;
        }
        if (key != null && this.tags != null) {
            this.tags.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromTags(Map<String, String> map) {
        if (this.tags == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.tags == null) continue;
                this.tags.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    public <K, V> A withTags(Map<String, String> tags) {
        this.tags = tags == null ? null : new LinkedHashMap<String, String>(tags);
        return (A)this;
    }

    @Override
    public Boolean hasTags() {
        return this.tags != null;
    }

    @Override
    public String getVpcID() {
        return this.vpcID;
    }

    @Override
    public A withVpcID(String vpcID) {
        this.vpcID = vpcID;
        return (A)this;
    }

    @Override
    public Boolean hasVpcID() {
        return this.vpcID != null;
    }

    @Override
    public A addToVswitchIDs(Integer index, String item) {
        if (this.vswitchIDs == null) {
            this.vswitchIDs = new ArrayList<String>();
        }
        this.vswitchIDs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVswitchIDs(Integer index, String item) {
        if (this.vswitchIDs == null) {
            this.vswitchIDs = new ArrayList<String>();
        }
        this.vswitchIDs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVswitchIDs(String ... items) {
        if (this.vswitchIDs == null) {
            this.vswitchIDs = new ArrayList<String>();
        }
        for (String item : items) {
            this.vswitchIDs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVswitchIDs(Collection<String> items) {
        if (this.vswitchIDs == null) {
            this.vswitchIDs = new ArrayList<String>();
        }
        for (String item : items) {
            this.vswitchIDs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVswitchIDs(String ... items) {
        for (String item : items) {
            if (this.vswitchIDs == null) continue;
            this.vswitchIDs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVswitchIDs(Collection<String> items) {
        for (String item : items) {
            if (this.vswitchIDs == null) continue;
            this.vswitchIDs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getVswitchIDs() {
        return this.vswitchIDs;
    }

    @Override
    public String getVswitchID(Integer index) {
        return this.vswitchIDs.get(index);
    }

    @Override
    public String getFirstVswitchID() {
        return this.vswitchIDs.get(0);
    }

    @Override
    public String getLastVswitchID() {
        return this.vswitchIDs.get(this.vswitchIDs.size() - 1);
    }

    @Override
    public String getMatchingVswitchID(Predicate<String> predicate) {
        for (String item : this.vswitchIDs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVswitchID(Predicate<String> predicate) {
        for (String item : this.vswitchIDs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVswitchIDs(List<String> vswitchIDs) {
        if (vswitchIDs != null) {
            this.vswitchIDs = new ArrayList<String>();
            for (String item : vswitchIDs) {
                this.addToVswitchIDs(item);
            }
        } else {
            this.vswitchIDs = null;
        }
        return (A)this;
    }

    @Override
    public A withVswitchIDs(String ... vswitchIDs) {
        if (this.vswitchIDs != null) {
            this.vswitchIDs.clear();
        }
        if (vswitchIDs != null) {
            for (String item : vswitchIDs) {
                this.addToVswitchIDs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVswitchIDs() {
        return this.vswitchIDs != null && !this.vswitchIDs.isEmpty();
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlatformFluentImpl that = (PlatformFluentImpl)o;
        if (this.defaultMachinePlatform != null ? !this.defaultMachinePlatform.equals(that.defaultMachinePlatform) : that.defaultMachinePlatform != null) {
            return false;
        }
        if (this.privateZoneID != null ? !this.privateZoneID.equals(that.privateZoneID) : that.privateZoneID != null) {
            return false;
        }
        if (this.region != null ? !this.region.equals(that.region) : that.region != null) {
            return false;
        }
        if (this.resourceGroupID != null ? !this.resourceGroupID.equals(that.resourceGroupID) : that.resourceGroupID != null) {
            return false;
        }
        if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) {
            return false;
        }
        if (this.vpcID != null ? !this.vpcID.equals(that.vpcID) : that.vpcID != null) {
            return false;
        }
        if (this.vswitchIDs != null ? !this.vswitchIDs.equals(that.vswitchIDs) : that.vswitchIDs != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.defaultMachinePlatform, this.privateZoneID, this.region, this.resourceGroupID, this.tags, this.vpcID, this.vswitchIDs, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.defaultMachinePlatform != null) {
            sb.append("defaultMachinePlatform:");
            sb.append(this.defaultMachinePlatform + ",");
        }
        if (this.privateZoneID != null) {
            sb.append("privateZoneID:");
            sb.append(this.privateZoneID + ",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region + ",");
        }
        if (this.resourceGroupID != null) {
            sb.append("resourceGroupID:");
            sb.append(this.resourceGroupID + ",");
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            sb.append("tags:");
            sb.append(this.tags + ",");
        }
        if (this.vpcID != null) {
            sb.append("vpcID:");
            sb.append(this.vpcID + ",");
        }
        if (this.vswitchIDs != null && !this.vswitchIDs.isEmpty()) {
            sb.append("vswitchIDs:");
            sb.append(this.vswitchIDs + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class DefaultMachinePlatformNestedImpl<N>
    extends MachinePoolFluentImpl<PlatformFluent.DefaultMachinePlatformNested<N>>
    implements PlatformFluent.DefaultMachinePlatformNested<N>,
    Nested<N> {
        MachinePoolBuilder builder;

        DefaultMachinePlatformNestedImpl(MachinePool item) {
            this.builder = new MachinePoolBuilder(this, item);
        }

        DefaultMachinePlatformNestedImpl() {
            this.builder = new MachinePoolBuilder(this);
        }

        @Override
        public N and() {
            return (N)PlatformFluentImpl.this.withDefaultMachinePlatform(this.builder.build());
        }

        @Override
        public N endDefaultMachinePlatform() {
            return this.and();
        }
    }
}

