/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.APIServerEncryption;
import io.fabric8.openshift.api.model.APIServerEncryptionBuilder;
import io.fabric8.openshift.api.model.APIServerEncryptionFluentImpl;
import io.fabric8.openshift.api.model.APIServerServingCerts;
import io.fabric8.openshift.api.model.APIServerServingCertsBuilder;
import io.fabric8.openshift.api.model.APIServerServingCertsFluentImpl;
import io.fabric8.openshift.api.model.APIServerSpec;
import io.fabric8.openshift.api.model.APIServerSpecFluent;
import io.fabric8.openshift.api.model.Audit;
import io.fabric8.openshift.api.model.AuditBuilder;
import io.fabric8.openshift.api.model.AuditFluentImpl;
import io.fabric8.openshift.api.model.ConfigMapNameReference;
import io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder;
import io.fabric8.openshift.api.model.ConfigMapNameReferenceFluentImpl;
import io.fabric8.openshift.api.model.TLSSecurityProfile;
import io.fabric8.openshift.api.model.TLSSecurityProfileBuilder;
import io.fabric8.openshift.api.model.TLSSecurityProfileFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class APIServerSpecFluentImpl<A extends APIServerSpecFluent<A>>
extends BaseFluent<A>
implements APIServerSpecFluent<A> {
    private List<String> additionalCORSAllowedOrigins = new ArrayList<String>();
    private AuditBuilder audit;
    private ConfigMapNameReferenceBuilder clientCA;
    private APIServerEncryptionBuilder encryption;
    private APIServerServingCertsBuilder servingCerts;
    private TLSSecurityProfileBuilder tlsSecurityProfile;
    private Map<String, Object> additionalProperties;

    public APIServerSpecFluentImpl() {
    }

    public APIServerSpecFluentImpl(APIServerSpec instance) {
        this.withAdditionalCORSAllowedOrigins(instance.getAdditionalCORSAllowedOrigins());
        this.withAudit(instance.getAudit());
        this.withClientCA(instance.getClientCA());
        this.withEncryption(instance.getEncryption());
        this.withServingCerts(instance.getServingCerts());
        this.withTlsSecurityProfile(instance.getTlsSecurityProfile());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToAdditionalCORSAllowedOrigins(Integer index, String item) {
        if (this.additionalCORSAllowedOrigins == null) {
            this.additionalCORSAllowedOrigins = new ArrayList<String>();
        }
        this.additionalCORSAllowedOrigins.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAdditionalCORSAllowedOrigins(Integer index, String item) {
        if (this.additionalCORSAllowedOrigins == null) {
            this.additionalCORSAllowedOrigins = new ArrayList<String>();
        }
        this.additionalCORSAllowedOrigins.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAdditionalCORSAllowedOrigins(String ... items) {
        if (this.additionalCORSAllowedOrigins == null) {
            this.additionalCORSAllowedOrigins = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalCORSAllowedOrigins.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAdditionalCORSAllowedOrigins(Collection<String> items) {
        if (this.additionalCORSAllowedOrigins == null) {
            this.additionalCORSAllowedOrigins = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalCORSAllowedOrigins.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalCORSAllowedOrigins(String ... items) {
        for (String item : items) {
            if (this.additionalCORSAllowedOrigins == null) continue;
            this.additionalCORSAllowedOrigins.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAdditionalCORSAllowedOrigins(Collection<String> items) {
        for (String item : items) {
            if (this.additionalCORSAllowedOrigins == null) continue;
            this.additionalCORSAllowedOrigins.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAdditionalCORSAllowedOrigins() {
        return this.additionalCORSAllowedOrigins;
    }

    @Override
    public String getAdditionalCORSAllowedOrigin(Integer index) {
        return this.additionalCORSAllowedOrigins.get(index);
    }

    @Override
    public String getFirstAdditionalCORSAllowedOrigin() {
        return this.additionalCORSAllowedOrigins.get(0);
    }

    @Override
    public String getLastAdditionalCORSAllowedOrigin() {
        return this.additionalCORSAllowedOrigins.get(this.additionalCORSAllowedOrigins.size() - 1);
    }

    @Override
    public String getMatchingAdditionalCORSAllowedOrigin(Predicate<String> predicate) {
        for (String item : this.additionalCORSAllowedOrigins) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAdditionalCORSAllowedOrigin(Predicate<String> predicate) {
        for (String item : this.additionalCORSAllowedOrigins) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAdditionalCORSAllowedOrigins(List<String> additionalCORSAllowedOrigins) {
        if (additionalCORSAllowedOrigins != null) {
            this.additionalCORSAllowedOrigins = new ArrayList<String>();
            for (String item : additionalCORSAllowedOrigins) {
                this.addToAdditionalCORSAllowedOrigins(item);
            }
        } else {
            this.additionalCORSAllowedOrigins = null;
        }
        return (A)this;
    }

    @Override
    public A withAdditionalCORSAllowedOrigins(String ... additionalCORSAllowedOrigins) {
        if (this.additionalCORSAllowedOrigins != null) {
            this.additionalCORSAllowedOrigins.clear();
        }
        if (additionalCORSAllowedOrigins != null) {
            for (String item : additionalCORSAllowedOrigins) {
                this.addToAdditionalCORSAllowedOrigins(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalCORSAllowedOrigins() {
        return this.additionalCORSAllowedOrigins != null && !this.additionalCORSAllowedOrigins.isEmpty();
    }

    @Override
    @Deprecated
    public Audit getAudit() {
        return this.audit != null ? this.audit.build() : null;
    }

    @Override
    public Audit buildAudit() {
        return this.audit != null ? this.audit.build() : null;
    }

    @Override
    public A withAudit(Audit audit) {
        this._visitables.get("audit").remove(this.audit);
        if (audit != null) {
            this.audit = new AuditBuilder(audit);
            this._visitables.get("audit").add(this.audit);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAudit() {
        return this.audit != null;
    }

    @Override
    public APIServerSpecFluent.AuditNested<A> withNewAudit() {
        return new AuditNestedImpl();
    }

    @Override
    public APIServerSpecFluent.AuditNested<A> withNewAuditLike(Audit item) {
        return new AuditNestedImpl(item);
    }

    @Override
    public APIServerSpecFluent.AuditNested<A> editAudit() {
        return this.withNewAuditLike(this.getAudit());
    }

    @Override
    public APIServerSpecFluent.AuditNested<A> editOrNewAudit() {
        return this.withNewAuditLike(this.getAudit() != null ? this.getAudit() : new AuditBuilder().build());
    }

    @Override
    public APIServerSpecFluent.AuditNested<A> editOrNewAuditLike(Audit item) {
        return this.withNewAuditLike(this.getAudit() != null ? this.getAudit() : item);
    }

    @Override
    @Deprecated
    public ConfigMapNameReference getClientCA() {
        return this.clientCA != null ? this.clientCA.build() : null;
    }

    @Override
    public ConfigMapNameReference buildClientCA() {
        return this.clientCA != null ? this.clientCA.build() : null;
    }

    @Override
    public A withClientCA(ConfigMapNameReference clientCA) {
        this._visitables.get("clientCA").remove(this.clientCA);
        if (clientCA != null) {
            this.clientCA = new ConfigMapNameReferenceBuilder(clientCA);
            this._visitables.get("clientCA").add(this.clientCA);
        }
        return (A)this;
    }

    @Override
    public Boolean hasClientCA() {
        return this.clientCA != null;
    }

    @Override
    public A withNewClientCA(String name) {
        return this.withClientCA(new ConfigMapNameReference(name));
    }

    @Override
    public APIServerSpecFluent.ClientCANested<A> withNewClientCA() {
        return new ClientCANestedImpl();
    }

    @Override
    public APIServerSpecFluent.ClientCANested<A> withNewClientCALike(ConfigMapNameReference item) {
        return new ClientCANestedImpl(item);
    }

    @Override
    public APIServerSpecFluent.ClientCANested<A> editClientCA() {
        return this.withNewClientCALike(this.getClientCA());
    }

    @Override
    public APIServerSpecFluent.ClientCANested<A> editOrNewClientCA() {
        return this.withNewClientCALike(this.getClientCA() != null ? this.getClientCA() : new ConfigMapNameReferenceBuilder().build());
    }

    @Override
    public APIServerSpecFluent.ClientCANested<A> editOrNewClientCALike(ConfigMapNameReference item) {
        return this.withNewClientCALike(this.getClientCA() != null ? this.getClientCA() : item);
    }

    @Override
    @Deprecated
    public APIServerEncryption getEncryption() {
        return this.encryption != null ? this.encryption.build() : null;
    }

    @Override
    public APIServerEncryption buildEncryption() {
        return this.encryption != null ? this.encryption.build() : null;
    }

    @Override
    public A withEncryption(APIServerEncryption encryption) {
        this._visitables.get("encryption").remove(this.encryption);
        if (encryption != null) {
            this.encryption = new APIServerEncryptionBuilder(encryption);
            this._visitables.get("encryption").add(this.encryption);
        }
        return (A)this;
    }

    @Override
    public Boolean hasEncryption() {
        return this.encryption != null;
    }

    @Override
    public A withNewEncryption(String type) {
        return this.withEncryption(new APIServerEncryption(type));
    }

    @Override
    public APIServerSpecFluent.EncryptionNested<A> withNewEncryption() {
        return new EncryptionNestedImpl();
    }

    @Override
    public APIServerSpecFluent.EncryptionNested<A> withNewEncryptionLike(APIServerEncryption item) {
        return new EncryptionNestedImpl(item);
    }

    @Override
    public APIServerSpecFluent.EncryptionNested<A> editEncryption() {
        return this.withNewEncryptionLike(this.getEncryption());
    }

    @Override
    public APIServerSpecFluent.EncryptionNested<A> editOrNewEncryption() {
        return this.withNewEncryptionLike(this.getEncryption() != null ? this.getEncryption() : new APIServerEncryptionBuilder().build());
    }

    @Override
    public APIServerSpecFluent.EncryptionNested<A> editOrNewEncryptionLike(APIServerEncryption item) {
        return this.withNewEncryptionLike(this.getEncryption() != null ? this.getEncryption() : item);
    }

    @Override
    @Deprecated
    public APIServerServingCerts getServingCerts() {
        return this.servingCerts != null ? this.servingCerts.build() : null;
    }

    @Override
    public APIServerServingCerts buildServingCerts() {
        return this.servingCerts != null ? this.servingCerts.build() : null;
    }

    @Override
    public A withServingCerts(APIServerServingCerts servingCerts) {
        this._visitables.get("servingCerts").remove(this.servingCerts);
        if (servingCerts != null) {
            this.servingCerts = new APIServerServingCertsBuilder(servingCerts);
            this._visitables.get("servingCerts").add(this.servingCerts);
        }
        return (A)this;
    }

    @Override
    public Boolean hasServingCerts() {
        return this.servingCerts != null;
    }

    @Override
    public APIServerSpecFluent.ServingCertsNested<A> withNewServingCerts() {
        return new ServingCertsNestedImpl();
    }

    @Override
    public APIServerSpecFluent.ServingCertsNested<A> withNewServingCertsLike(APIServerServingCerts item) {
        return new ServingCertsNestedImpl(item);
    }

    @Override
    public APIServerSpecFluent.ServingCertsNested<A> editServingCerts() {
        return this.withNewServingCertsLike(this.getServingCerts());
    }

    @Override
    public APIServerSpecFluent.ServingCertsNested<A> editOrNewServingCerts() {
        return this.withNewServingCertsLike(this.getServingCerts() != null ? this.getServingCerts() : new APIServerServingCertsBuilder().build());
    }

    @Override
    public APIServerSpecFluent.ServingCertsNested<A> editOrNewServingCertsLike(APIServerServingCerts item) {
        return this.withNewServingCertsLike(this.getServingCerts() != null ? this.getServingCerts() : item);
    }

    @Override
    @Deprecated
    public TLSSecurityProfile getTlsSecurityProfile() {
        return this.tlsSecurityProfile != null ? this.tlsSecurityProfile.build() : null;
    }

    @Override
    public TLSSecurityProfile buildTlsSecurityProfile() {
        return this.tlsSecurityProfile != null ? this.tlsSecurityProfile.build() : null;
    }

    @Override
    public A withTlsSecurityProfile(TLSSecurityProfile tlsSecurityProfile) {
        this._visitables.get("tlsSecurityProfile").remove(this.tlsSecurityProfile);
        if (tlsSecurityProfile != null) {
            this.tlsSecurityProfile = new TLSSecurityProfileBuilder(tlsSecurityProfile);
            this._visitables.get("tlsSecurityProfile").add(this.tlsSecurityProfile);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTlsSecurityProfile() {
        return this.tlsSecurityProfile != null;
    }

    @Override
    public APIServerSpecFluent.TlsSecurityProfileNested<A> withNewTlsSecurityProfile() {
        return new TlsSecurityProfileNestedImpl();
    }

    @Override
    public APIServerSpecFluent.TlsSecurityProfileNested<A> withNewTlsSecurityProfileLike(TLSSecurityProfile item) {
        return new TlsSecurityProfileNestedImpl(item);
    }

    @Override
    public APIServerSpecFluent.TlsSecurityProfileNested<A> editTlsSecurityProfile() {
        return this.withNewTlsSecurityProfileLike(this.getTlsSecurityProfile());
    }

    @Override
    public APIServerSpecFluent.TlsSecurityProfileNested<A> editOrNewTlsSecurityProfile() {
        return this.withNewTlsSecurityProfileLike(this.getTlsSecurityProfile() != null ? this.getTlsSecurityProfile() : new TLSSecurityProfileBuilder().build());
    }

    @Override
    public APIServerSpecFluent.TlsSecurityProfileNested<A> editOrNewTlsSecurityProfileLike(TLSSecurityProfile item) {
        return this.withNewTlsSecurityProfileLike(this.getTlsSecurityProfile() != null ? this.getTlsSecurityProfile() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIServerSpecFluentImpl that = (APIServerSpecFluentImpl)o;
        if (this.additionalCORSAllowedOrigins != null ? !this.additionalCORSAllowedOrigins.equals(that.additionalCORSAllowedOrigins) : that.additionalCORSAllowedOrigins != null) {
            return false;
        }
        if (this.audit != null ? !this.audit.equals(that.audit) : that.audit != null) {
            return false;
        }
        if (this.clientCA != null ? !this.clientCA.equals(that.clientCA) : that.clientCA != null) {
            return false;
        }
        if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) {
            return false;
        }
        if (this.servingCerts != null ? !this.servingCerts.equals(that.servingCerts) : that.servingCerts != null) {
            return false;
        }
        if (this.tlsSecurityProfile != null ? !this.tlsSecurityProfile.equals(that.tlsSecurityProfile) : that.tlsSecurityProfile != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.additionalCORSAllowedOrigins, this.audit, this.clientCA, this.encryption, this.servingCerts, this.tlsSecurityProfile, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.additionalCORSAllowedOrigins != null && !this.additionalCORSAllowedOrigins.isEmpty()) {
            sb.append("additionalCORSAllowedOrigins:");
            sb.append(this.additionalCORSAllowedOrigins + ",");
        }
        if (this.audit != null) {
            sb.append("audit:");
            sb.append(this.audit + ",");
        }
        if (this.clientCA != null) {
            sb.append("clientCA:");
            sb.append(this.clientCA + ",");
        }
        if (this.encryption != null) {
            sb.append("encryption:");
            sb.append(this.encryption + ",");
        }
        if (this.servingCerts != null) {
            sb.append("servingCerts:");
            sb.append(this.servingCerts + ",");
        }
        if (this.tlsSecurityProfile != null) {
            sb.append("tlsSecurityProfile:");
            sb.append(this.tlsSecurityProfile + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class TlsSecurityProfileNestedImpl<N>
    extends TLSSecurityProfileFluentImpl<APIServerSpecFluent.TlsSecurityProfileNested<N>>
    implements APIServerSpecFluent.TlsSecurityProfileNested<N>,
    Nested<N> {
        TLSSecurityProfileBuilder builder;

        TlsSecurityProfileNestedImpl(TLSSecurityProfile item) {
            this.builder = new TLSSecurityProfileBuilder(this, item);
        }

        TlsSecurityProfileNestedImpl() {
            this.builder = new TLSSecurityProfileBuilder(this);
        }

        @Override
        public N and() {
            return (N)APIServerSpecFluentImpl.this.withTlsSecurityProfile(this.builder.build());
        }

        @Override
        public N endTlsSecurityProfile() {
            return this.and();
        }
    }

    class ServingCertsNestedImpl<N>
    extends APIServerServingCertsFluentImpl<APIServerSpecFluent.ServingCertsNested<N>>
    implements APIServerSpecFluent.ServingCertsNested<N>,
    Nested<N> {
        APIServerServingCertsBuilder builder;

        ServingCertsNestedImpl(APIServerServingCerts item) {
            this.builder = new APIServerServingCertsBuilder(this, item);
        }

        ServingCertsNestedImpl() {
            this.builder = new APIServerServingCertsBuilder(this);
        }

        @Override
        public N and() {
            return (N)APIServerSpecFluentImpl.this.withServingCerts(this.builder.build());
        }

        @Override
        public N endServingCerts() {
            return this.and();
        }
    }

    class EncryptionNestedImpl<N>
    extends APIServerEncryptionFluentImpl<APIServerSpecFluent.EncryptionNested<N>>
    implements APIServerSpecFluent.EncryptionNested<N>,
    Nested<N> {
        APIServerEncryptionBuilder builder;

        EncryptionNestedImpl(APIServerEncryption item) {
            this.builder = new APIServerEncryptionBuilder(this, item);
        }

        EncryptionNestedImpl() {
            this.builder = new APIServerEncryptionBuilder(this);
        }

        @Override
        public N and() {
            return (N)APIServerSpecFluentImpl.this.withEncryption(this.builder.build());
        }

        @Override
        public N endEncryption() {
            return this.and();
        }
    }

    class ClientCANestedImpl<N>
    extends ConfigMapNameReferenceFluentImpl<APIServerSpecFluent.ClientCANested<N>>
    implements APIServerSpecFluent.ClientCANested<N>,
    Nested<N> {
        ConfigMapNameReferenceBuilder builder;

        ClientCANestedImpl(ConfigMapNameReference item) {
            this.builder = new ConfigMapNameReferenceBuilder(this, item);
        }

        ClientCANestedImpl() {
            this.builder = new ConfigMapNameReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)APIServerSpecFluentImpl.this.withClientCA(this.builder.build());
        }

        @Override
        public N endClientCA() {
            return this.and();
        }
    }

    class AuditNestedImpl<N>
    extends AuditFluentImpl<APIServerSpecFluent.AuditNested<N>>
    implements APIServerSpecFluent.AuditNested<N>,
    Nested<N> {
        AuditBuilder builder;

        AuditNestedImpl(Audit item) {
            this.builder = new AuditBuilder(this, item);
        }

        AuditNestedImpl() {
            this.builder = new AuditBuilder(this);
        }

        @Override
        public N and() {
            return (N)APIServerSpecFluentImpl.this.withAudit(this.builder.build());
        }

        @Override
        public N endAudit() {
            return this.and();
        }
    }
}

