/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ObjectMetricSource;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ObjectMetricSourceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ObjectMetricSourceFluentImpl<A extends ObjectMetricSourceFluent<A>>
extends BaseFluent<A>
implements ObjectMetricSourceFluent<A> {
    private Quantity averageValue;
    private String metricName;
    private LabelSelectorBuilder selector;
    private CrossVersionObjectReferenceBuilder target;
    private Quantity targetValue;
    private Map<String, Object> additionalProperties;

    public ObjectMetricSourceFluentImpl() {
    }

    public ObjectMetricSourceFluentImpl(ObjectMetricSource instance) {
        this.withAverageValue(instance.getAverageValue());
        this.withMetricName(instance.getMetricName());
        this.withSelector(instance.getSelector());
        this.withTarget(instance.getTarget());
        this.withTargetValue(instance.getTargetValue());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Quantity getAverageValue() {
        return this.averageValue;
    }

    @Override
    public A withAverageValue(Quantity averageValue) {
        this.averageValue = averageValue;
        return (A)this;
    }

    @Override
    public Boolean hasAverageValue() {
        return this.averageValue != null;
    }

    @Override
    public A withNewAverageValue(String amount, String format) {
        return this.withAverageValue(new Quantity(amount, format));
    }

    @Override
    public A withNewAverageValue(String amount) {
        return this.withAverageValue(new Quantity(amount));
    }

    @Override
    public String getMetricName() {
        return this.metricName;
    }

    @Override
    public A withMetricName(String metricName) {
        this.metricName = metricName;
        return (A)this;
    }

    @Override
    public Boolean hasMetricName() {
        return this.metricName != null;
    }

    @Override
    @Deprecated
    public LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(LabelSelector selector) {
        this._visitables.get("selector").remove(this.selector);
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public ObjectMetricSourceFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public ObjectMetricSourceFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public ObjectMetricSourceFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public ObjectMetricSourceFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public ObjectMetricSourceFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    @Deprecated
    public CrossVersionObjectReference getTarget() {
        return this.target != null ? this.target.build() : null;
    }

    @Override
    public CrossVersionObjectReference buildTarget() {
        return this.target != null ? this.target.build() : null;
    }

    @Override
    public A withTarget(CrossVersionObjectReference target) {
        this._visitables.get("target").remove(this.target);
        if (target != null) {
            this.target = new CrossVersionObjectReferenceBuilder(target);
            this._visitables.get("target").add(this.target);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTarget() {
        return this.target != null;
    }

    @Override
    public A withNewTarget(String apiVersion, String kind, String name) {
        return this.withTarget(new CrossVersionObjectReference(apiVersion, kind, name));
    }

    @Override
    public ObjectMetricSourceFluent.TargetNested<A> withNewTarget() {
        return new TargetNestedImpl();
    }

    @Override
    public ObjectMetricSourceFluent.TargetNested<A> withNewTargetLike(CrossVersionObjectReference item) {
        return new TargetNestedImpl(item);
    }

    @Override
    public ObjectMetricSourceFluent.TargetNested<A> editTarget() {
        return this.withNewTargetLike(this.getTarget());
    }

    @Override
    public ObjectMetricSourceFluent.TargetNested<A> editOrNewTarget() {
        return this.withNewTargetLike(this.getTarget() != null ? this.getTarget() : new CrossVersionObjectReferenceBuilder().build());
    }

    @Override
    public ObjectMetricSourceFluent.TargetNested<A> editOrNewTargetLike(CrossVersionObjectReference item) {
        return this.withNewTargetLike(this.getTarget() != null ? this.getTarget() : item);
    }

    @Override
    public Quantity getTargetValue() {
        return this.targetValue;
    }

    @Override
    public A withTargetValue(Quantity targetValue) {
        this.targetValue = targetValue;
        return (A)this;
    }

    @Override
    public Boolean hasTargetValue() {
        return this.targetValue != null;
    }

    @Override
    public A withNewTargetValue(String amount, String format) {
        return this.withTargetValue(new Quantity(amount, format));
    }

    @Override
    public A withNewTargetValue(String amount) {
        return this.withTargetValue(new Quantity(amount));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectMetricSourceFluentImpl that = (ObjectMetricSourceFluentImpl)o;
        if (this.averageValue != null ? !this.averageValue.equals(that.averageValue) : that.averageValue != null) {
            return false;
        }
        if (this.metricName != null ? !this.metricName.equals(that.metricName) : that.metricName != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.target != null ? !this.target.equals(that.target) : that.target != null) {
            return false;
        }
        if (this.targetValue != null ? !this.targetValue.equals(that.targetValue) : that.targetValue != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.averageValue, this.metricName, this.selector, this.target, this.targetValue, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.averageValue != null) {
            sb.append("averageValue:");
            sb.append(this.averageValue + ",");
        }
        if (this.metricName != null) {
            sb.append("metricName:");
            sb.append(this.metricName + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.target != null) {
            sb.append("target:");
            sb.append(this.target + ",");
        }
        if (this.targetValue != null) {
            sb.append("targetValue:");
            sb.append(this.targetValue + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class TargetNestedImpl<N>
    extends CrossVersionObjectReferenceFluentImpl<ObjectMetricSourceFluent.TargetNested<N>>
    implements ObjectMetricSourceFluent.TargetNested<N>,
    Nested<N> {
        CrossVersionObjectReferenceBuilder builder;

        TargetNestedImpl(CrossVersionObjectReference item) {
            this.builder = new CrossVersionObjectReferenceBuilder(this, item);
        }

        TargetNestedImpl() {
            this.builder = new CrossVersionObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ObjectMetricSourceFluentImpl.this.withTarget(this.builder.build());
        }

        @Override
        public N endTarget() {
            return this.and();
        }
    }

    class SelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<ObjectMetricSourceFluent.SelectorNested<N>>
    implements ObjectMetricSourceFluent.SelectorNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;

        SelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)ObjectMetricSourceFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }
}

