/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ContainerState;
import io.fabric8.kubernetes.api.model.ContainerStateBuilder;
import io.fabric8.kubernetes.api.model.ContainerStateFluentImpl;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.ContainerStatusFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ContainerStatusFluentImpl<A extends ContainerStatusFluent<A>>
extends BaseFluent<A>
implements ContainerStatusFluent<A> {
    private String containerID;
    private String image;
    private String imageID;
    private ContainerStateBuilder lastState;
    private String name;
    private Boolean ready;
    private Integer restartCount;
    private Boolean started;
    private ContainerStateBuilder state;
    private Map<String, Object> additionalProperties;

    public ContainerStatusFluentImpl() {
    }

    public ContainerStatusFluentImpl(ContainerStatus instance) {
        this.withContainerID(instance.getContainerID());
        this.withImage(instance.getImage());
        this.withImageID(instance.getImageID());
        this.withLastState(instance.getLastState());
        this.withName(instance.getName());
        this.withReady(instance.getReady());
        this.withRestartCount(instance.getRestartCount());
        this.withStarted(instance.getStarted());
        this.withState(instance.getState());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getContainerID() {
        return this.containerID;
    }

    @Override
    public A withContainerID(String containerID) {
        this.containerID = containerID;
        return (A)this;
    }

    @Override
    public Boolean hasContainerID() {
        return this.containerID != null;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public String getImageID() {
        return this.imageID;
    }

    @Override
    public A withImageID(String imageID) {
        this.imageID = imageID;
        return (A)this;
    }

    @Override
    public Boolean hasImageID() {
        return this.imageID != null;
    }

    @Override
    @Deprecated
    public ContainerState getLastState() {
        return this.lastState != null ? this.lastState.build() : null;
    }

    @Override
    public ContainerState buildLastState() {
        return this.lastState != null ? this.lastState.build() : null;
    }

    @Override
    public A withLastState(ContainerState lastState) {
        this._visitables.get("lastState").remove(this.lastState);
        if (lastState != null) {
            this.lastState = new ContainerStateBuilder(lastState);
            this._visitables.get("lastState").add(this.lastState);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLastState() {
        return this.lastState != null;
    }

    @Override
    public ContainerStatusFluent.LastStateNested<A> withNewLastState() {
        return new LastStateNestedImpl();
    }

    @Override
    public ContainerStatusFluent.LastStateNested<A> withNewLastStateLike(ContainerState item) {
        return new LastStateNestedImpl(item);
    }

    @Override
    public ContainerStatusFluent.LastStateNested<A> editLastState() {
        return this.withNewLastStateLike(this.getLastState());
    }

    @Override
    public ContainerStatusFluent.LastStateNested<A> editOrNewLastState() {
        return this.withNewLastStateLike(this.getLastState() != null ? this.getLastState() : new ContainerStateBuilder().build());
    }

    @Override
    public ContainerStatusFluent.LastStateNested<A> editOrNewLastStateLike(ContainerState item) {
        return this.withNewLastStateLike(this.getLastState() != null ? this.getLastState() : item);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public Boolean getReady() {
        return this.ready;
    }

    @Override
    public A withReady(Boolean ready) {
        this.ready = ready;
        return (A)this;
    }

    @Override
    public Boolean hasReady() {
        return this.ready != null;
    }

    @Override
    public Integer getRestartCount() {
        return this.restartCount;
    }

    @Override
    public A withRestartCount(Integer restartCount) {
        this.restartCount = restartCount;
        return (A)this;
    }

    @Override
    public Boolean hasRestartCount() {
        return this.restartCount != null;
    }

    @Override
    public Boolean getStarted() {
        return this.started;
    }

    @Override
    public A withStarted(Boolean started) {
        this.started = started;
        return (A)this;
    }

    @Override
    public Boolean hasStarted() {
        return this.started != null;
    }

    @Override
    @Deprecated
    public ContainerState getState() {
        return this.state != null ? this.state.build() : null;
    }

    @Override
    public ContainerState buildState() {
        return this.state != null ? this.state.build() : null;
    }

    @Override
    public A withState(ContainerState state) {
        this._visitables.get("state").remove(this.state);
        if (state != null) {
            this.state = new ContainerStateBuilder(state);
            this._visitables.get("state").add(this.state);
        }
        return (A)this;
    }

    @Override
    public Boolean hasState() {
        return this.state != null;
    }

    @Override
    public ContainerStatusFluent.StateNested<A> withNewState() {
        return new StateNestedImpl();
    }

    @Override
    public ContainerStatusFluent.StateNested<A> withNewStateLike(ContainerState item) {
        return new StateNestedImpl(item);
    }

    @Override
    public ContainerStatusFluent.StateNested<A> editState() {
        return this.withNewStateLike(this.getState());
    }

    @Override
    public ContainerStatusFluent.StateNested<A> editOrNewState() {
        return this.withNewStateLike(this.getState() != null ? this.getState() : new ContainerStateBuilder().build());
    }

    @Override
    public ContainerStatusFluent.StateNested<A> editOrNewStateLike(ContainerState item) {
        return this.withNewStateLike(this.getState() != null ? this.getState() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerStatusFluentImpl that = (ContainerStatusFluentImpl)o;
        if (this.containerID != null ? !this.containerID.equals(that.containerID) : that.containerID != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.imageID != null ? !this.imageID.equals(that.imageID) : that.imageID != null) {
            return false;
        }
        if (this.lastState != null ? !this.lastState.equals(that.lastState) : that.lastState != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.ready != null ? !this.ready.equals(that.ready) : that.ready != null) {
            return false;
        }
        if (this.restartCount != null ? !this.restartCount.equals(that.restartCount) : that.restartCount != null) {
            return false;
        }
        if (this.started != null ? !this.started.equals(that.started) : that.started != null) {
            return false;
        }
        if (this.state != null ? !this.state.equals(that.state) : that.state != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.containerID, this.image, this.imageID, this.lastState, this.name, this.ready, this.restartCount, this.started, this.state, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.containerID != null) {
            sb.append("containerID:");
            sb.append(this.containerID + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.imageID != null) {
            sb.append("imageID:");
            sb.append(this.imageID + ",");
        }
        if (this.lastState != null) {
            sb.append("lastState:");
            sb.append(this.lastState + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.ready != null) {
            sb.append("ready:");
            sb.append(this.ready + ",");
        }
        if (this.restartCount != null) {
            sb.append("restartCount:");
            sb.append(this.restartCount + ",");
        }
        if (this.started != null) {
            sb.append("started:");
            sb.append(this.started + ",");
        }
        if (this.state != null) {
            sb.append("state:");
            sb.append(this.state + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withReady() {
        return this.withReady(true);
    }

    @Override
    public A withStarted() {
        return this.withStarted(true);
    }

    class StateNestedImpl<N>
    extends ContainerStateFluentImpl<ContainerStatusFluent.StateNested<N>>
    implements ContainerStatusFluent.StateNested<N>,
    Nested<N> {
        ContainerStateBuilder builder;

        StateNestedImpl(ContainerState item) {
            this.builder = new ContainerStateBuilder(this, item);
        }

        StateNestedImpl() {
            this.builder = new ContainerStateBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerStatusFluentImpl.this.withState(this.builder.build());
        }

        @Override
        public N endState() {
            return this.and();
        }
    }

    class LastStateNestedImpl<N>
    extends ContainerStateFluentImpl<ContainerStatusFluent.LastStateNested<N>>
    implements ContainerStatusFluent.LastStateNested<N>,
    Nested<N> {
        ContainerStateBuilder builder;

        LastStateNestedImpl(ContainerState item) {
            this.builder = new ContainerStateBuilder(this, item);
        }

        LastStateNestedImpl() {
            this.builder = new ContainerStateBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerStatusFluentImpl.this.withLastState(this.builder.build());
        }

        @Override
        public N endLastState() {
            return this.and();
        }
    }
}

