/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v6_0.dsl.internal.authorization;

import io.fabric8.kubernetes.api.builder.v6_0.TypedVisitor;
import io.fabric8.kubernetes.api.builder.v6_0.Visitor;
import io.fabric8.kubernetes.api.model.v6_0.ObjectReference;
import io.fabric8.kubernetes.api.model.v6_0.ObjectReferenceBuilder;
import io.fabric8.kubernetes.clnt.v6_0.Client;
import io.fabric8.kubernetes.clnt.v6_0.dsl.Resource;
import io.fabric8.kubernetes.clnt.v6_0.dsl.internal.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v6_0.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.clnt.v6_0.dsl.internal.OperationContext;
import io.fabric8.openshift.api.model.v6_0.RoleBinding;
import io.fabric8.openshift.api.model.v6_0.RoleBindingBuilder;
import io.fabric8.openshift.api.model.v6_0.RoleBindingFluent;
import io.fabric8.openshift.api.model.v6_0.RoleBindingList;
import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;

public class RoleBindingOperationsImpl
extends HasMetadataOperation<RoleBinding, RoleBindingList, Resource<RoleBinding>> {
    public static final String SERVICE_ACCOUNT = "ServiceAccount";
    public static final String USER = "User";
    public static final String GROUP = "Group";

    public RoleBindingOperationsImpl(Client client) {
        this(HasMetadataOperationsImpl.defaultContext(client));
    }

    public RoleBindingOperationsImpl(OperationContext context) {
        super(context.withApiGroupName("authorization.openshift.io").withPlural("rolebindings"), RoleBinding.class, RoleBindingList.class);
    }

    @Override
    public RoleBindingOperationsImpl newInstance(OperationContext context) {
        return new RoleBindingOperationsImpl(context);
    }

    @Override
    protected RoleBinding handleCreate(RoleBinding resource) throws InterruptedException, IOException {
        return super.handleCreate(this.enrichRoleBinding(resource));
    }

    @Override
    protected RoleBinding modifyItemForReplaceOrPatch(Supplier<RoleBinding> current, RoleBinding binding) {
        return this.enrichRoleBinding(binding);
    }

    private RoleBinding enrichRoleBinding(RoleBinding binding) {
        RoleBindingBuilder builder = new RoleBindingBuilder(binding);
        if (binding.getUserNames() != null && !binding.getUserNames().isEmpty() || binding.getGroupNames() != null && !binding.getGroupNames().isEmpty()) {
            this.enrichFromUsersAndGroups(builder, binding.getUserNames(), binding.getGroupNames());
        } else {
            this.enrichFromSubjects(builder, binding.getSubjects());
            this.enrichSubjectsNamespace(builder);
        }
        return builder.build();
    }

    private void enrichSubjectsNamespace(RoleBindingBuilder builder) {
        builder.accept(new Visitor[]{new TypedVisitor<ObjectReferenceBuilder>(){

            @Override
            public void visit(ObjectReferenceBuilder o) {
                if (o.getKind() != null && o.getKind().equals(RoleBindingOperationsImpl.SERVICE_ACCOUNT) && (o.getNamespace() == null || o.getNamespace().isEmpty())) {
                    o.withNamespace(RoleBindingOperationsImpl.this.getNamespace());
                }
            }
        }});
    }

    private void enrichFromUsersAndGroups(RoleBindingBuilder builder, List<String> userNames, List<String> groupNames) {
        builder.withSubjects(new ObjectReference[0]);
        if (userNames != null) {
            for (String userName : userNames) {
                String[] splitUserName;
                if (userName.startsWith("system:serviceaccount:") && (splitUserName = userName.split(":")).length == 4) {
                    ((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)builder.addNewSubject().withKind(SERVICE_ACCOUNT)).withNamespace(splitUserName[2])).withName(splitUserName[3])).endSubject();
                    continue;
                }
                ((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)builder.addNewSubject().withKind(USER)).withName(userName)).endSubject();
            }
        }
        if (groupNames != null) {
            for (String groupName : groupNames) {
                ((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)builder.addNewSubject().withKind(GROUP)).withName(groupName)).endSubject();
            }
        }
    }

    private void enrichFromSubjects(RoleBindingBuilder builder, List<ObjectReference> subjects) {
        for (ObjectReference ref : subjects) {
            switch (ref.getKind()) {
                case "User": {
                    builder.addToUserNames(ref.getName());
                    break;
                }
                case "ServiceAccount": {
                    String namespace = ref.getNamespace();
                    if (namespace == null || namespace.isEmpty()) {
                        namespace = this.getNamespace();
                    }
                    builder.addToUserNames("system:serviceaccount:" + namespace + ":" + ref.getName());
                    break;
                }
                case "Group": {
                    builder.addToGroupNames(ref.getName());
                }
            }
        }
    }
}

